/*
 * Decompiled with CFR 0.152.
 */
package org.alov.tm;

import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.lang.reflect.Method;
import java.util.Vector;
import org.alov.map.Carte;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.Layer;
import org.alov.map.LayerRaster;
import org.alov.map.LayerVector;
import org.alov.map.LayerZoomify;
import org.alov.map.Renderer;
import org.alov.map.StatusListener;
import org.alov.map.Symbol;
import org.alov.map.Utils2D;
import org.alov.util.AlovMapException;
import org.alov.util.SimpleTimer;
import org.alov.util.TimerListener;
import org.alov.util.XmlElement;

public class TransparencyControl
extends Scrollbar
implements CarteHostListener,
StatusListener,
TimerListener {
    private Carte map;
    private SimpleTimer timer = null;
    private int setAlphaValue = 255;
    private Layer setAlphaTo = null;
    private boolean dontChangeValue = false;

    public TransparencyControl() throws AlovMapException {
        super(0, 255, 40, 0, 295);
        if (!Utils2D.have2d()) {
            throw new AlovMapException("Can't init TransparencyControl. It requires Java 1.3 or higher");
        }
    }

    public void setParameters(CarteHost host, XmlElement layout) {
        this.map = host.getMapByName(layout);
        this.setOrientation(0);
        this.setBlockIncrement(25);
        this.setValues(255, 40, 0, 295);
        this.enableEvents(304L);
        this.map.statusListeners.addElement(this);
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    private void setAlpha(Layer layer, int alpha) {
        if (alpha > 255) {
            alpha = 255;
        } else if (alpha < 0) {
            alpha = 0;
        }
        if (layer instanceof LayerZoomify) {
            ((LayerZoomify)layer).applyRasterFilters(alpha);
        }
        if (layer instanceof LayerVector) {
            LayerVector layerVector = (LayerVector)layer;
            Symbol.setTransparency(layerVector.symbol, alpha);
            Vector renderers = layerVector.renderers;
            int count = renderers.size();
            for (int i = 0; i < count; ++i) {
                Renderer renderer = (Renderer)renderers.elementAt(i);
                int symbolCount = renderer.getSymbolCount();
                for (int j = 0; j < symbolCount; ++j) {
                    Symbol symbol = renderer.getSymbol(j);
                    Symbol.setTransparency(symbol, alpha);
                }
            }
        } else if (layer instanceof LayerRaster) {
            ((LayerRaster)layer).applyRasterFilters(alpha);
        }
        this.map.updateMap();
        this.dontChangeValue = true;
        this.map.broadcastMessage(107, null);
        this.dontChangeValue = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processAdjustmentEvent(AdjustmentEvent e) {
        super.processAdjustmentEvent(e);
        if (e.getAdjustmentType() == 601) {
            return;
        }
        TransparencyControl transparencyControl = this;
        synchronized (transparencyControl) {
            this.setAlphaValue = 255 - e.getValue();
            this.setAlphaTo = this.map.getActiveLayer();
        }
    }

    public void notifyStatus(int code, Object obj) {
        if (code == 107) {
            if (this.dontChangeValue) {
                return;
            }
            Layer layer = this.map.getActiveLayer();
            int alpha = 255;
            if (layer != null) {
                if (layer instanceof LayerZoomify) {
                    alpha = ((LayerZoomify)layer).transparency;
                    if (alpha < 0) {
                        alpha = 255;
                    }
                } else if (layer instanceof LayerVector) {
                    Symbol symbol = ((LayerVector)layer).symbol;
                    try {
                        Method method = symbol.fillColor.getClass().getMethod("getAlpha", null);
                        Integer alphaInt = (Integer)method.invoke((Object)symbol.fillColor, null);
                        alpha = alphaInt;
                    }
                    catch (Throwable e) {}
                } else if (layer instanceof LayerRaster && (alpha = ((LayerRaster)layer).transparency) < 0) {
                    alpha = 255;
                }
            }
            int transparency = 255 - alpha;
            this.setValue(transparency);
        }
    }

    public void afterProjectLoaded(boolean bSuccess) {
        this.timer = new SimpleTimer(2000L, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timerTick() {
        int alpha;
        Layer layer;
        TransparencyControl transparencyControl = this;
        synchronized (transparencyControl) {
            layer = this.setAlphaTo;
            alpha = this.setAlphaValue;
            this.setAlphaTo = null;
        }
        if (layer != null) {
            this.setAlpha(layer, alpha);
        }
    }
}

