/*
 * Decompiled with CFR 0.152.
 */
package org.alov.tm;

import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.StringTokenizer;
import javax.swing.JEditorPane;
import org.alov.map.Carte;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.CarteListener;
import org.alov.map.FloatPoint;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.MapUtils;
import org.alov.map.RecordsArray;
import org.alov.map.StatusListener;
import org.alov.map.StreamCounter;
import org.alov.util.Log;
import org.alov.util.SimpleTimer;
import org.alov.util.Strings;
import org.alov.util.TimerListener;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

public class RolloverInfo
extends Panel
implements CarteHostListener,
CarteListener,
StatusListener,
TimerListener {
    private SimpleTimer st = null;
    private boolean active = false;
    private Carte map = null;
    private CarteHost host = null;
    private int counter = 0;
    private Label urlLabel = null;
    private JEditorPane jedtPane = null;
    private boolean lastError = false;
    private boolean ready = false;
    private String lastURL = null;
    private int tickBeforeShow = 2;
    private int tickBeforeHide = 10;
    private Point panelOffset = new Point(10, 10);
    private Container parent = null;
    private int xPos;
    private int yPos;
    private int wPos;
    private int hPos = -1;
    private String servletURL = "mapserv";
    final String URL_LABEL = "URL_LABEL";
    final String URL_EDITORPANE = "URL_EDITORPANE";
    final String TIMER_TICK = "TimerTick";
    final String TICK_BEFORE_SHOW = "TickBeforeShow";
    final String TICK_BEFORE_HIDE = "TickBeforeHide";
    final String X_PNL_OFFSET = "XPanelOffset";
    final String Y_PNL_OFFSET = "YPanelOffset";
    final String _REMOVED_TAG = "content-type";

    public RolloverInfo() {
        this.setItVisible(false);
    }

    private boolean setTextToPanel(Point CursorPoint) {
        if (null != this.map) {
            Layer activeLayer = this.map.getActiveLayer();
            if ((null != this.urlLabel || null != this.jedtPane) && activeLayer != null && !Strings.isNullOrBlank(activeLayer.linkTips) && activeLayer.isVisibleNow(this.map)) {
                String sURL;
                FloatPoint pt1 = this.map.screenToMap(new Point(CursorPoint.x + 2, CursorPoint.y + 2));
                FloatPoint pt2 = this.map.screenToMap(new Point(CursorPoint.x - 4, CursorPoint.y - 4));
                FloatRectangle rect = new FloatRectangle(pt2.x, pt1.y, pt1.x, pt2.y);
                RecordsArray selection = activeLayer.findWithinRect(rect, true);
                if (MapUtils.isNotEmptyRecs(selection) && !Strings.isNullOrBlank(sURL = activeLayer.getWebLink(activeLayer.linkTips, selection, null, rect, null))) {
                    if (!sURL.equalsIgnoreCase(this.lastURL)) {
                        this.lastURL = sURL;
                        Font fnt = null;
                        FontMetrics fm = null;
                        if (null != this.urlLabel) {
                            fnt = this.urlLabel.getFont();
                            fm = this.urlLabel.getFontMetrics(fnt);
                            this.urlLabel.setSize(fm.stringWidth(sURL), fm.getHeight());
                            this.urlLabel.setText(sURL);
                        }
                        if (null != this.jedtPane) {
                            this.jedtPane.setContentType("text/html");
                            this.jedtPane.setEditable(false);
                            String remoteUrl = sURL;
                            String buffer = null;
                            try {
                                MapUtils.servletURL = this.servletURL;
                                buffer = RolloverInfo.loadPage(activeLayer, remoteUrl);
                                if (!Strings.isNullOrBlank(buffer)) {
                                    boolean bufferChanged = false;
                                    String blc = buffer.toLowerCase();
                                    StringBuffer sb = new StringBuffer(blc);
                                    StringBuffer sbText = new StringBuffer(buffer);
                                    int minIndex = blc.indexOf("<head>");
                                    int i = blc.indexOf("content-type", minIndex);
                                    for (int maxIndex = blc.indexOf("</head>"); minIndex < i && maxIndex > i; maxIndex -= "content-type".length()) {
                                        sb.delete(i, i + "content-type".length()).toString();
                                        sbText.delete(i, i + "content-type".length()).toString();
                                        i = sb.toString().indexOf("content-type", minIndex);
                                        bufferChanged = true;
                                    }
                                    if (bufferChanged) {
                                        buffer = sbText.toString();
                                    }
                                } else {
                                    Log.addMessage(311, this.map.getName(), null, "Page not found: " + sURL);
                                    this.lastError = true;
                                    return false;
                                }
                                this.jedtPane.setText(buffer);
                            }
                            catch (Exception e) {
                                Log.addMessage(311, this.map.getName(), null, e.getMessage());
                                this.lastError = true;
                                return false;
                            }
                            this.lastError = false;
                            return true;
                        }
                    } else {
                        return !this.lastError;
                    }
                }
            }
        }
        return false;
    }

    public void setParameters(CarteHost host, XmlElement layout) {
        this.host = host;
        this.setItVisible(false);
        this.map = host.getMapByName(layout);
        this.map.mapListeners.addElement(this);
        this.map.statusListeners.addElement(this);
        this.tickBeforeShow = XmlUtils.getInt("TickBeforeShow", layout, 2);
        this.tickBeforeHide = XmlUtils.getInt("TickBeforeHide", layout, 10);
        this.panelOffset.x = XmlUtils.getInt("XPanelOffset", layout, 10);
        this.panelOffset.y = XmlUtils.getInt("YPanelOffset", layout, 10);
        int timerTick = XmlUtils.getInt("TimerTick", layout, 500);
        String s = XmlUtils.getString("bounds", layout, null);
        try {
            StringTokenizer tok = new StringTokenizer(s, ",");
            this.xPos = Integer.valueOf(tok.nextToken());
            this.yPos = Integer.valueOf(tok.nextToken());
            this.wPos = Integer.valueOf(tok.nextToken());
            this.hPos = Integer.valueOf(tok.nextToken());
        }
        catch (Exception e) {
            this.hPos = -1;
        }
        this.st = new SimpleTimer(timerTick, this);
    }

    public void stop() {
        this.active = false;
    }

    public void mouseMapPressed(MouseEvent e) {
    }

    public void mouseMapReleased(FloatRectangle selRect, MouseEvent e) {
    }

    public void mouseMapMoved(MouseEvent e) {
        this.setItVisible(false);
        if (this.active && this.map.getTool() == 5 || this.map.getTool() == 6) {
            Point pntOrg = e.getPoint();
            if (this.parent instanceof Frame) {
                Point pScrn = this.map.getLocationOnScreen();
                this.xPos = pScrn.x + pntOrg.x + 10;
                this.yPos = pScrn.y + pntOrg.y + 10;
                if (this.hPos > 0) {
                    this.parent.setBounds(this.xPos, this.yPos, this.wPos, this.hPos);
                } else {
                    this.parent.setBounds(this.xPos, this.yPos, 300, 200);
                }
            } else {
                this.setLocation(new Point(pntOrg.x + 10, pntOrg.y + 10));
            }
            this.ready = this.setTextToPanel(pntOrg);
            this.counter = 0;
        }
    }

    public void afterMapDraw(Graphics g) {
    }

    public void timerTick() {
        if (this.ready) {
            if (this.isItVisible()) {
                if (++this.counter > this.tickBeforeHide) {
                    this.setItVisible(false);
                    this.ready = false;
                }
            } else if (++this.counter > this.tickBeforeShow) {
                this.setItVisible(true);
                this.counter = 0;
            }
        }
    }

    public void notifyStatus(int code, Object obj) {
        this.servletURL = MapUtils.getRealPath(this.map.getParameter("servlet", "mapserv"));
    }

    public void afterProjectLoaded(boolean bSuccess) {
        this.urlLabel = (Label)MapUtils.findComp(this, "URL_LABEL");
        this.jedtPane = (JEditorPane)MapUtils.findComp(this, "URL_EDITORPANE");
        this.active = null != this.urlLabel || null != this.jedtPane;
        this.parent = this.getParent();
        this.setItVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadPage(Layer layer, String url) throws Exception {
        StreamCounter is = layer != null && layer.provider != null ? layer.provider.openURL(url) : MapUtils.openURL(url);
        Toolkit t = Toolkit.getDefaultToolkit();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(8192);
        try {
            int howmany;
            Object bytes = null;
            byte[] buf = new byte[8192];
            while ((howmany = ((InputStream)is).read(buf)) > 0) {
                bos.write(buf, 0, howmany);
            }
            ((InputStream)is).close();
            if (0 < bos.size()) {
                String string = bos.toString();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            bos.close();
        }
    }

    private void setItVisible(boolean visible) {
        if (this.parent != null) {
            if (this.parent instanceof Frame) {
                if (visible) {
                    ((Frame)this.parent).show();
                    ((Frame)this.parent).toFront();
                } else {
                    ((Frame)this.parent).hide();
                }
            } else {
                this.setVisible(visible);
            }
        }
    }

    private boolean isItVisible() {
        if (this.parent != null && this.parent instanceof Frame) {
            return this.parent.isVisible();
        }
        return this.isVisible();
    }
}

