/*
 * Decompiled with CFR 0.152.
 */
package org.alov.tm;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.StringTokenizer;
import java.util.Vector;
import org.alov.map.MapUtils;

public class MsgBox
extends Dialog
implements WindowListener,
ActionListener {
    private static final String BOXTITLE = "Message";
    public static final int DIALOG_RES_OK = 1;
    public static final int DIALOG_RES_CANCEL = 0;
    public static final int DIALOG_RES_YES = 2;
    public static final int DIALOG_RES_NO = 3;
    public static final int DIALOG_BTN_YESNO = 3;
    public static final int DIALOG_BTN_OK = 4;
    public static final int DIALOG_BTN_OKCANCEL = 12;
    public static final int DIALOG_BTN_YESNOCANCEL = 11;
    private static final String _CMD_BTN_OK = "ok";
    private static final String _CMD_BTN_CANCEL = "cancel";
    private static final String _CMD_BTN_YES = "yes";
    private static final String _CMD_BTN_NO = "no";
    int dialog_result;
    int max_width = 0;

    public MsgBox(Frame f, int buttons, String msg) {
        super(f, BOXTITLE, true);
        Button btn;
        this.setFont(MapUtils.defaultPlainFont);
        Vector v = this.splitString(msg);
        this.setResizable(false);
        this.addWindowListener(this);
        Panel b = new Panel(new FlowLayout(1));
        if ((buttons & 1) > 0) {
            btn = new Button("Yes");
            btn.setActionCommand(_CMD_BTN_YES);
            btn.addActionListener(this);
            b.add(btn);
        }
        if ((buttons & 2) > 0) {
            btn = new Button("No");
            btn.setActionCommand(_CMD_BTN_NO);
            btn.addActionListener(this);
            b.add(btn);
        }
        if ((buttons & 4) > 0) {
            btn = new Button("OK");
            btn.setActionCommand(_CMD_BTN_OK);
            btn.addActionListener(this);
            b.add(btn);
        }
        if ((buttons & 8) > 0) {
            btn = new Button("Cancel");
            btn.setActionCommand(_CMD_BTN_CANCEL);
            btn.addActionListener(this);
            b.add(btn);
        }
        Panel l = new Panel(new GridLayout(v.size(), 1, 0, 0));
        for (int i = 0; i < v.size(); ++i) {
            l.add((Component)v.elementAt(i));
        }
        this.add((Component)l, "Center");
        this.add((Component)b, "South");
        this.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2);
    }

    private Vector splitString(String s) {
        if (s == null) {
            s = "";
        }
        FontMetrics fm = this.getFontMetrics(this.getFont());
        this.max_width = 0;
        Vector<Label> res = new Vector<Label>();
        StringTokenizer tok = new StringTokenizer(s, "\t\n\r");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            token.trim();
            if (token.length() <= 0) continue;
            int w = fm.stringWidth(token);
            if (w > this.max_width) {
                this.max_width = w;
            }
            res.addElement(new Label(token, 1));
        }
        return res;
    }

    public int showDlg() {
        this.show();
        return this.dialog_result;
    }

    public void windowClosing(WindowEvent e) {
        this.dialog_result = 0;
        ((Component)this).setVisible(false);
    }

    public void windowOpened(WindowEvent e) {
        this.transferFocus();
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        String c = e.getActionCommand();
        if (c == _CMD_BTN_OK) {
            this.dialog_result = 1;
            ((Component)this).setVisible(false);
        }
        if (c == _CMD_BTN_CANCEL) {
            this.dialog_result = 0;
            ((Component)this).setVisible(false);
        }
        if (c == _CMD_BTN_YES) {
            this.dialog_result = 2;
            ((Component)this).setVisible(false);
        }
        if (c == _CMD_BTN_NO) {
            this.dialog_result = 3;
            ((Component)this).setVisible(false);
        }
    }
}

