/*
 * Decompiled with CFR 0.152.
 */
package org.alov.tm;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.net.URL;
import org.alov.map.MapUtils;
import org.alov.viewer.LightGrid;

public class LightGrid_MacNet
extends LightGrid {
    private int colWidth1 = 60;
    int colWidth2 = 120;
    private static final Color textColor = new Color(11, 3, 108);
    private static final Color gridColor = new Color(217, 217, 253);
    private Font captionFont = new Font("SansSerif", 1, 14);
    private Font gridFont = new Font("SansSerif", 0, 12);
    private Image imageOnMap = null;
    private Image imageLink = null;

    public LightGrid_MacNet() {
        try {
            this.imageOnMap = Toolkit.getDefaultToolkit().getImage(new URL(MapUtils.getRealPath("images/macnet_onmap.gif")));
            this.imageLink = Toolkit.getDefaultToolkit().getImage(new URL(MapUtils.getRealPath("images/macnet_link.gif")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void drawCell2(Rectangle rect, Graphics g, String s, byte mode, int row, int column) {
        if (row == 0) {
            g.setColor(textColor);
            if (s != null) {
                g.setFont(this.captionFont);
                g.drawString(s, rect.x + 1, rect.y + 20);
            }
        } else if (column == 0) {
            g.setColor(textColor);
            if (s != null) {
                g.setFont(this.gridFont);
                g.drawString(s, rect.x + 4, rect.y + 12);
            }
        } else {
            Image image = null;
            int pos = 0;
            if (column == 1) {
                image = this.imageOnMap;
            } else if (column == 2) {
                image = this.imageLink;
                pos = 1;
            }
            if (image == null) {
                return;
            }
            g.drawImage(image, rect.x + pos, rect.y, this);
        }
        g.setColor(gridColor);
        int y = rect.y + rect.height - 1;
        g.drawLine(rect.x, y, rect.x + rect.width, y);
    }

    public void setBounds(int x, int y, int w, int h) {
        this.beginUpdate();
        this.setColumnWidth(0, w - this.colWidth1 - this.colWidth2 - 24);
        this.setColumnWidth(1, this.colWidth1);
        this.setColumnWidth(2, this.colWidth2);
        super.setBounds(x, y, w, h);
        this.endUpdate();
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        boolean fin;
        boolean bl = fin = (infoflags & 0x20) != 0;
        if (fin) {
            this.updateAll();
        }
        return !fin;
    }
}

