/*
 * Decompiled with CFR 0.152.
 */
package org.alov.tm;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import org.alov.map.Carte;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.StatusListener;
import org.alov.util.Strings;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

public class ImagePanel
extends Panel
implements CarteHostListener,
StatusListener {
    private Image imgBack = null;
    private boolean isTiled = false;
    private String thematicMaps = null;
    private Carte map;
    private CarteHost host;
    private static final String _THEME = "theme";
    private static final String _TILED = "tiled";

    public Image getImage() {
        return this.imgBack;
    }

    public void setImage(Image backgroundImage) {
        if (null != this.imgBack) {
            this.imgBack = null;
        }
        this.imgBack = backgroundImage;
    }

    public void paint(Graphics g) {
        if (null != this.imgBack && null != g) {
            Dimension dimPanel = this.getSize();
            if (this.isTiled) {
                int imageWidth = Math.abs(this.imgBack.getWidth(this));
                int imageHeight = Math.abs(this.imgBack.getHeight(this));
                if (imageWidth > 1 || imageHeight > 1) {
                    for (int yCurrent = 0; yCurrent < dimPanel.height; yCurrent += imageHeight) {
                        for (int xCurrent = 0; xCurrent < dimPanel.width; xCurrent += imageWidth) {
                            g.drawImage(this.imgBack, xCurrent, yCurrent, this);
                        }
                    }
                }
            } else {
                g.drawImage(this.imgBack, 0, 0, dimPanel.width, dimPanel.height, this);
            }
        }
        super.paint(g);
    }

    public void setParameters(CarteHost host, XmlElement layout) {
        String sImage = XmlUtils.getString("image", layout, null);
        if (sImage != null) {
            this.imgBack = host.getImage(sImage);
        }
        this.thematicMaps = XmlUtils.getString(_THEME, layout, null);
        this.isTiled = XmlUtils.getBoolean(_TILED, layout, false);
        this.map = host.getMapByName(layout);
        this.map.statusListeners.addElement(this);
        this.host = host;
    }

    public void stop() {
    }

    public void notifyStatus(int code, Object obj) {
        String currentThematicMap;
        if (code == 106 && !Strings.isNullOrBlank(this.thematicMaps) && !Strings.isNullOrBlank(currentThematicMap = this.map.getThematicMap())) {
            this.setVisible(this.thematicMaps.indexOf(currentThematicMap) >= 0);
            this.host.refreshLayout();
        }
    }

    public void afterProjectLoaded(boolean bSuccess) {
    }
}

