/*
 * Decompiled with CFR 0.152.
 */
package org.alov.tm;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import org.alov.map.Carte;
import org.alov.map.CarteAttribute;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.LayerVector;
import org.alov.map.MapUtils;
import org.alov.map.Record;
import org.alov.map.RecordsArray;
import org.alov.map.StatusListener;
import org.alov.tm.LightGrid_MacNet;
import org.alov.util.XmlElement;
import org.alov.viewer.GridCellEventListener;

public class FrameRes_MacNet
extends Frame
implements ActionListener,
GridCellEventListener,
CarteHostListener,
CarteAttribute,
StatusListener {
    protected Carte map = null;
    protected LayerVector layer;
    private LightGrid_MacNet sg = null;
    private static final Color backColor2 = new Color(232, 232, 252);

    public FrameRes_MacNet() {
        TopPanel topPanel = new TopPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)topPanel, "North");
        this.sg = new LightGrid_MacNet();
        this.add((Component)this.sg, "Center");
        this.sg.setBackground(backColor2);
    }

    public void actionPerformed(ActionEvent evt) {
        Object o = evt.getSource();
        if (o instanceof Component) {
            // empty if block
        }
    }

    public void gridCellClicked(Point cell, InputEvent cause) {
        String webLink;
        Record rec;
        if (cell == null) {
            return;
        }
        String s = this.sg.getCell(this.sg.colCount - 1, this.sg.currRow);
        if (cell.x == 1) {
            this.map.selectObjectsById(this.layer.getName(), s);
        } else if (cell.x == 2 && (rec = this.layer.findById(s)) != null && (webLink = this.map.getProject().getWebLink(this.layer, rec)) != null && webLink.length() > 0) {
            this.map.showURL(webLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadToGrid(LayerVector lyr, RecordsArray records) {
        if (this.sg == null) {
            return;
        }
        int fieldCount = lyr.getFieldCount();
        int recCount = records.size();
        this.layer = lyr;
        this.sg.beginUpdate();
        this.sg.setDimension(1, 1, 17);
        this.sg.endUpdate();
        this.sg.beginUpdate();
        this.sg.setDimension(4, recCount + 1, 17);
        int defHeight = 20;
        Graphics g = this.sg.getGraphics();
        if (g != null) {
            try {
                FontMetrics fm = g.getFontMetrics();
                defHeight = fm.getHeight() + 2;
            }
            finally {
                g.dispose();
            }
        }
        boolean fieldCountVis = false;
        this.sg.setCell(0, 0, "Description");
        this.sg.setCell(1, 0, "On Map");
        this.sg.setCell(2, 0, "Visit Macnet");
        this.sg.setCell(3, 0, "");
        this.sg.setColumnWidth(3, 0);
        this.sg.colWidth2 = lyr.linkMain != null || this.map.getProject().linkMain != null ? 120 : 0;
        this.sg.setRowHeight(0, 30);
        for (int i = 0; i < recCount; ++i) {
            Object o;
            Record rec = records.getRecord(i);
            boolean k = false;
            String desc = "";
            if (this.layer.fi_description >= 0 && (o = rec.getField(this.layer.fi_description)) != null) {
                desc = o.toString();
            }
            this.sg.setCell(0, i + 1, desc);
            this.sg.setRowHeight(i + 1, 19);
            this.sg.setCell(3, i + 1, String.valueOf(lyr.getId(rec)));
        }
        this.sg.endUpdate();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int w = d.width / 2;
        this.setBounds(10, 10, w + 10 > d.width ? d.width - 10 : (w < 300 ? 300 : w), 300);
        this.gridCellClicked(null, null);
    }

    private void setBtn(String sName) {
        MapUtils.addActionListener(this, this, sName);
        Component b = MapUtils.findComp(this, sName);
        if (b != null && b instanceof Button) {
            ((Button)b).setLabel(this.map.getResource(((Button)b).getLabel()));
        }
    }

    public void setParameters(CarteHost host, XmlElement layout) {
        this.map = host.getMapByName(layout);
        this.map.statusListeners.addElement(this);
    }

    public void stop() {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void showAttributes(LayerVector lyr, RecordsArray records) {
        if (lyr != null && MapUtils.isNotEmptyRecs(records)) {
            this.loadToGrid(lyr, records);
            this.show();
            this.requestFocus();
        }
    }

    public void afterProjectLoaded(boolean bSuccess) {
        if (bSuccess) {
            this.setTitle(this.map.getResource("Attribute Data"));
            this.sg = (LightGrid_MacNet)MapUtils.findComp(this, "lightgrid");
            if (this.sg != null) {
                this.sg.setGridCellEventListener(this);
            }
            this.addWindowListener(new WindowEventHandler());
            this.pack();
        }
    }

    public void notifyStatus(int code, Object obj) {
    }

    void hideForm() {
        ((Component)this).setVisible(false);
    }

    class TopPanel
    extends Panel
    implements ActionListener {
        private FrameRes_MacNet parent = null;
        private Image imageCaption = null;
        private Image imageClose = null;
        private Image imageBack = null;
        private Panel pnlClose = null;
        private final Color backColor1 = new Color(235, 239, 213);

        TopPanel() {
            try {
                this.imageCaption = Toolkit.getDefaultToolkit().getImage(new URL(MapUtils.getRealPath("images/macnet_caption.gif")));
                this.imageClose = Toolkit.getDefaultToolkit().getImage(new URL(MapUtils.getRealPath("images/macnet_close.gif")));
                this.imageBack = Toolkit.getDefaultToolkit().getImage(new URL(MapUtils.getRealPath("images/macnet_edge.gif")));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.pnlClose = new Panel(){

                public void setBackground(Color color) {
                    super.setBackground(color);
                    this.setCursor(Cursor.getPredefinedCursor(12));
                    this.enableEvents(16L);
                }

                public void paint(Graphics g) {
                    g.drawImage(TopPanel.this.imageClose, 0, 0, this);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(120, 30);
                }

                public void processMouseEvent(MouseEvent e) {
                    if (e.getID() == 500) {
                        FrameRes_MacNet.this.hideForm();
                    }
                }
            };
            this.pnlClose.setBackground(this.backColor1);
            this.setBackground(this.backColor1);
            this.setLayout(new BorderLayout());
            this.add((Component)this.pnlClose, "East");
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
        }

        public void paint(Graphics g) {
            super.paint(g);
            Dimension size = this.getSize();
            g.drawImage(this.imageBack, 0, 0, size.width, size.height, 0, 0, this.imageBack.getWidth(null), this.imageBack.getHeight(null), null);
            g.drawImage(this.imageCaption, 0, 0, this);
        }

        public Dimension getPreferredSize() {
            return new Dimension(100, 30);
        }

        public Dimension getMinimumSize() {
            return new Dimension(100, 30);
        }
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        public void windowClosing(WindowEvent evt) {
            ((Component)FrameRes_MacNet.this).setVisible(false);
        }
    }
}

