/*
 * Decompiled with CFR 0.152.
 */
package org.alov.tm;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.alov.map.Carte;
import org.alov.map.Layer;
import org.alov.map.MapUtils;
import org.alov.map.Project;
import org.alov.util.Log;
import org.alov.util.Strings;

class FramePass
extends Frame
implements ActionListener,
KeyListener {
    Button btnApply;
    Button btnClose;
    TextField tfSetAll = new TextField(15);
    Checkbox cbTryForAll = new Checkbox("Try this password for all datasets");
    Label lbl1;
    Label lbl2;
    Label lbl3;
    Label lbl4;
    Label lbl5;
    Panel buttonsPanel = new Panel();
    Panel mainPanel = new Panel();
    Panel tfPanel = new Panel();
    ScrollPane sp = new ScrollPane();
    String _copyright;
    private Carte map;

    public FramePass(Carte map) {
        super(map.getResource("Copyright and Passwords"));
        int h;
        this._copyright = map.getResource("Copyright and Password");
        this.btnApply = new Button(map.getResource("Apply"));
        this.btnClose = new Button(map.getResource("Cancel"));
        this.lbl4 = new Label(map.getResource("Set all passwords to"));
        this.lbl1 = new Label(map.getResource("Enter password(s) and click APPLY"));
        this.lbl2 = new Label(map.getResource("Click 'Copyright and Password' button to view copyright information and obtain password"));
        this.lbl3 = new Label(map.getResource("Layers with incorrect or blank passwords will remain disabled"));
        this.lbl5 = new Label(map.getResource("! - Incorrect password(s)"));
        this.addWindowListener(new WindowEventHandler());
        this.map = map;
        this.mainPanel.setLayout(null);
        this.tfPanel.setLayout(null);
        boolean hasPass = false;
        int y = this.setComponents(false);
        this.buttonsPanel.setLayout(null);
        this.buttonsPanel.add(this.lbl1);
        this.buttonsPanel.add(this.lbl2);
        this.buttonsPanel.add(this.lbl3);
        this.buttonsPanel.add(this.lbl5);
        this.btnApply.addActionListener(this);
        this.btnClose.addActionListener(this);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int w = 640;
        int n = h = y > 200 ? 330 : y + 130;
        if (y > 50) {
            this.buttonsPanel.add(this.lbl4);
            this.lbl4.setBounds(434, 20, 120, 15);
            this.buttonsPanel.add(this.tfSetAll);
            this.tfSetAll.setEchoChar('*');
            this.tfSetAll.setBounds(560, 20, 100, 17);
        }
        this.cbTryForAll.setState(true);
        this.buttonsPanel.add(this.cbTryForAll);
        this.cbTryForAll.setBounds(460, 2, 200, 15);
        this.buttonsPanel.add(this.btnApply);
        this.buttonsPanel.add(this.btnClose);
        this.lbl5.setBounds(4, 2, 200, 15);
        this.lbl5.setForeground(Color.red);
        this.lbl1.setBounds(4, 20, 250, 15);
        this.lbl2.setBounds(4, 37, 490, 15);
        this.lbl3.setBounds(4, 53, 450, 15);
        int w2 = 60;
        this.btnApply.setBounds(w - w2 * 2, 50, w2, 20);
        this.btnClose.setBounds(w - w2, 50, w2, 20);
        this.buttonsPanel.setBounds(0, h - 80, w, 70);
        this.mainPanel.setBounds(0, 0, w - 100, y);
        this.sp.add(this.mainPanel);
        this.mainPanel.add(this.tfPanel);
        this.tfPanel.setBounds(160, 0, 102, y);
        this.add((Component)this.sp, "Center");
        this.add((Component)this.buttonsPanel, "South");
        this.pack();
        this.setBounds((d.width - w) / 2, (d.height - h) / 2, w + 30, h);
        this.setResizable(false);
    }

    private int setComponents(boolean bRepaint) {
        Component lbl = null;
        Component lbl_i = null;
        Component tf = null;
        Component btnCp = null;
        Project prj = this.map.getProject();
        String layerIds = "";
        int layerCount = prj.getLayerCount();
        int y = 2;
        boolean bIp = false;
        for (int i = 0; i < layerCount; ++i) {
            Layer lyr = prj.getLayerByIndex(i);
            if (bRepaint) {
                lbl = (Label)MapUtils.findComp(this.mainPanel, "m" + lyr.datasetId);
                tf = (TextField)MapUtils.findComp(this.tfPanel, "t" + lyr.datasetId);
                btnCp = (Button)MapUtils.findComp(this.mainPanel, "b" + lyr.datasetId);
                lbl_i = (Label)MapUtils.findComp(this.mainPanel, "l" + lyr.datasetId);
            }
            if (!lyr.isPassResolved() && layerIds.indexOf(lyr.datasetId) < 0) {
                layerIds = layerIds + lyr.datasetId + ",";
                if (!bRepaint) {
                    lyr.metadata.passFirstTime = false;
                    lbl = new Label(lyr.datasetId + "  " + lyr.getName());
                    lbl.setName("m" + lyr.datasetId);
                    this.mainPanel.add(lbl);
                    lbl_i = new Label("!");
                    lbl_i.setName("l" + lyr.datasetId);
                    lbl_i.setForeground(Color.red);
                    this.mainPanel.add(lbl_i);
                    btnCp = new Button(this._copyright);
                    btnCp.setName("b" + lyr.datasetId);
                    ((Button)btnCp).addActionListener(this);
                    this.mainPanel.add(btnCp);
                    tf = new TextField(15);
                    tf.setName("t" + lyr.datasetId);
                    ((TextField)tf).setEchoChar('*');
                    tf.addKeyListener(this);
                    this.tfPanel.add(tf);
                }
                lbl_i.setVisible(!((TextComponent)tf).getText().equals(""));
                bIp = bIp || lbl_i.isVisible();
                btnCp.setBounds(4, y, 150, 15);
                tf.setBounds(1, y + 2, 99, 17);
                lbl_i.setBounds(265, y, 350, 25);
                lbl.setBounds(270, y, 350, 25);
                y += 27;
                continue;
            }
            if (!bRepaint || lbl == null || !lyr.isPassResolved()) continue;
            lbl.setVisible(false);
            lbl_i.setVisible(false);
            tf.setVisible(false);
            btnCp.setVisible(false);
        }
        this.lbl5.setVisible(bIp);
        return y;
    }

    void setFocusToFirstVisibleTextExit() {
        int cnt = this.tfPanel.getComponentCount();
        for (int i = 0; i < cnt; ++i) {
            Component c2 = this.tfPanel.getComponent(i);
            if (!(c2 instanceof TextField) || !c2.isVisible()) continue;
            c2.requestFocus();
            break;
        }
    }

    void setUnresolvedInvisibleInLegend() {
        if (Log.debugLevel == 0) {
            Project prj = this.map.getProject();
            int layerCount = prj.getLayerCount();
            for (int i = 0; i < layerCount; ++i) {
                Layer lyr = prj.getLayerByIndex(i);
                lyr.legendVisible = lyr.legendVisible && lyr.isPassResolved();
            }
            this.map.broadcastMessage(110, null);
        }
    }

    public void keyPressed(KeyEvent evt) {
        int key = evt.getKeyCode();
        if (key == 10) {
            this.actionPerformed(new ActionEvent(this.btnApply, 1001, null));
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent evt) {
        Object o = evt.getSource();
        if (o == this.btnApply) {
            boolean b = false;
            Project prj = this.map.getProject();
            String passAll = this.tfSetAll.getText().trim();
            String lyrList = "";
            String passList = "";
            String defaultPassword = Strings.isNullOrBlank(passAll) ? null : passAll;
            int totLayers = 0;
            boolean totResolv = false;
            int cnt = this.tfPanel.getComponentCount();
            for (int i = 0; i < cnt; ++i) {
                String pass;
                Component c2 = this.tfPanel.getComponent(i);
                if (!(c2 instanceof TextField) || !c2.isVisible()) continue;
                String datasetId = c2.getName().substring(1);
                Layer lyr = prj.getLayerByDsId(datasetId);
                String string = pass = passAll.length() == 0 ? ((TextField)c2).getText() : passAll;
                if (pass.length() > 0) {
                    lyr.metadata.put(303, pass);
                    this.map.getProject().datasetPasswords.put(datasetId, pass);
                    TextField tf = (TextField)MapUtils.findComp(this.tfPanel, "t" + lyr.datasetId);
                    if (tf != null) {
                        tf.setText(pass);
                    }
                    if (defaultPassword == null) {
                        defaultPassword = pass;
                    }
                }
                ++totLayers;
            }
            if (this.cbTryForAll.getState()) {
                this.map.getProject().defaultPassword = defaultPassword;
            }
            this.map.extentChanged();
            this.dispose();
        } else if (o == this.btnClose) {
            this.dispose();
            this.setUnresolvedInvisibleInLegend();
        } else {
            String s = ((Component)o).getName();
            if (s.startsWith("b")) {
                this.map.showURL("http://www.timemap.net/clearinghouse/html/search_results_detail.php?datasetid=" + s.substring(1));
            }
        }
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        public void windowClosing(WindowEvent evt) {
            FramePass.this.dispose();
            FramePass.this.setUnresolvedInvisibleInLegend();
        }

        public void windowOpened(WindowEvent e) {
            FramePass.this.setFocusToFirstVisibleTextExit();
        }
    }
}

