/*
 * Decompiled with CFR 0.152.
 */
package org.alov.tm;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.alov.map.Carte;
import org.alov.map.CarteAttribute;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.LayerVector;
import org.alov.map.MapUtils;
import org.alov.map.RecordsArray;
import org.alov.map.StatusListener;
import org.alov.util.XmlElement;
import org.alov.viewer.FrameAlign;

public class FrameMessage
extends FrameAlign
implements ActionListener,
CarteAttribute,
CarteHostListener,
StatusListener {
    private static final String BTN_CLOSE = "btn_close";
    public final int DEFAULT_DIALOG_WIDTH = 300;
    public final int DEFAULT_DIALOG_HEIGHT = 150;
    private WindowEventHandler wind_handler;
    private boolean boundsAreSet = false;
    private Carte map = null;

    public void show() {
        if (!this.boundsAreSet) {
            int height;
            int width;
            this.boundsAreSet = true;
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            if (this.bounds != null) {
                width = this.bounds.width;
                height = this.bounds.height;
            } else {
                width = 300;
                height = 150;
            }
            this.setBounds((screenSize.width - width) / 2, (screenSize.height - height) / 2, width, height);
            this.setResizable(false);
        }
        super.show();
        this.requestFocus();
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        String sName = ((Component)o).getName();
        if (sName.equalsIgnoreCase(BTN_CLOSE)) {
            ((Component)this).setVisible(false);
        }
    }

    public void setParameters(CarteHost host, XmlElement layout) {
        if (null != host && null != layout) {
            this.map = host.getMapByName(layout);
            if (this.map == null) {
                return;
            }
            this.map.statusListeners.addElement(this);
        }
    }

    public void stop() {
        ((Component)this).setVisible(false);
    }

    public void notifyStatus(int code, Object obj) {
    }

    public void afterProjectLoaded(boolean bSuccess) {
        ((Component)this).setVisible(false);
        if (bSuccess) {
            MapUtils.addActionListener(this, this, BTN_CLOSE);
            this.wind_handler = new WindowEventHandler();
            this.addWindowListener(this.wind_handler);
            if (null != this.map) {
                this.setTitle(this.map.getResource("Message"));
            }
        }
    }

    public void showAttributes(LayerVector lyr, RecordsArray records) {
        if (!MapUtils.isNotEmptyRecs(records)) {
            this.show();
        }
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        private void closeWindow() {
            ((Component)FrameMessage.this).setVisible(false);
        }

        public void windowClosing(WindowEvent evt) {
            this.closeWindow();
        }
    }
}

