/*
 * Decompiled with CFR 0.152.
 */
package org.alov.tm;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import org.alov.map.Layer;
import org.alov.tm.DynamicAddButton;

class FrameDynamic
extends Frame
implements ActionListener {
    private Vector checkboxes = new Vector();
    private Vector layers = null;
    private Object lock = new Object();
    private Button btnOK = new Button("OK");
    private Button btnAll = new Button("Mark All");
    private DynamicAddButton addButton = null;

    FrameDynamic(Vector layers, DynamicAddButton btn) {
        this.addButton = btn;
        this.setTitle("Select layers to load");
        this.layers = layers;
        int count = layers.size();
        GridLayout gl = new GridLayout(count + 1, 1);
        this.setLayout(gl);
        for (int i = 0; i < count; ++i) {
            Layer layer = (Layer)layers.elementAt(i);
            Checkbox cb = new Checkbox(layer.getName());
            this.checkboxes.addElement(cb);
            this.add(cb);
        }
        Panel pnlOK = new Panel();
        if (count > 1) {
            pnlOK.add(this.btnAll);
            this.btnAll.addActionListener(this);
        }
        pnlOK.add(this.btnOK);
        this.add(pnlOK);
        this.btnOK.addActionListener(this);
        this.pack();
        Dimension size = this.getSize();
        size.width += 20;
        if (size.width < 200) {
            size.width = 200;
        }
        size.height += 20;
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screen.width - size.width) / 2, (screen.height - size.height) / 2, size.width, size.height);
        this.addWindowListener(new WindowEventHandler());
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.btnOK) {
            Vector result = new Vector();
            int count = this.checkboxes.size();
            for (int i = 0; i < count; ++i) {
                Checkbox cb = (Checkbox)this.checkboxes.elementAt(i);
                if (!cb.getState()) continue;
                result.addElement(this.layers.elementAt(i));
            }
            this.addButton.layersAccepted(result);
            this.dispose();
        } else if (o == this.btnAll) {
            int count = this.checkboxes.size();
            for (int i = 0; i < count; ++i) {
                Checkbox cb = (Checkbox)this.checkboxes.elementAt(i);
                cb.setState(true);
            }
        }
    }

    private class WindowEventHandler
    extends WindowAdapter {
        private WindowEventHandler() {
        }

        public void windowClosing(WindowEvent evt) {
            FrameDynamic.this.dispose();
        }
    }
}

