/*
 * Decompiled with CFR 0.152.
 */
package org.alov.tm;

import java.awt.Button;
import java.awt.Color;
import java.awt.Label;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.util.Vector;
import org.alov.map.Carte;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.Layer;
import org.alov.map.Project;
import org.alov.map.StatusListener;
import org.alov.tm.FrameDynamic;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

public class DynamicAddButton
extends Button
implements StatusListener,
CarteHostListener {
    private static final String PAR_ACTIVECOLOR = "ActiveColor";
    private CarteHost host = null;
    private boolean acceptAll = false;
    private Vector layersToAsk = new Vector();
    private Vector autoAllow = new Vector();
    private Vector autoDeny = new Vector();
    private Color activeColor = Color.green;
    private boolean searchAlways = true;
    private Label lbl_dyn_status = null;
    private String dyn_status_text = null;
    private int iCountPos = -1;
    private FrameDynamic frameDynamic = null;

    public DynamicAddButton() {
        super("+Layers");
    }

    void layersAccepted(Vector layers) {
        Carte map = this.host.getMap();
        if (map == null) {
            return;
        }
        int count = this.layersToAsk.size();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                Layer layer = (Layer)this.layersToAsk.elementAt(i);
                if (layers.indexOf(layer) < 0) continue;
                this.autoAllow.addElement(layer.datasetId);
            }
            this.layersToAsk.removeAllElements();
            Project project = map.getProject();
            count = layers.size();
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    Layer layer = (Layer)layers.elementAt(i);
                    project.layers.addElement(layer);
                    layer.setParentMap(map);
                    boolean test = layer.isSomethingVisible(null);
                }
                map.broadcastMessage(111, null);
                map.extentChanged();
            }
        }
    }

    protected void processActionEvent(ActionEvent e) {
        this.setBackground(SystemColor.control);
        int count = this.layersToAsk.size();
        if (count > 0) {
            if (this.frameDynamic == null || !this.frameDynamic.isVisible()) {
                this.frameDynamic = new FrameDynamic(this.layersToAsk, this);
            }
            this.frameDynamic.show();
        } else if (!this.searchAlways) {
            Carte map = this.host.getMap();
            map.getProject().forceSearchForDynamic = true;
            map.extentChanged();
        }
        super.processActionEvent(e);
    }

    public void notifyStatus(int code, Object obj) {
        if (code == 117) {
            Carte map = this.host.getMap();
            if (map == null) {
                return;
            }
            Project project = map.getProject();
            Vector layers = project.dynamicLayers;
            int count = layers == null ? 0 : layers.size();
            boolean layersAdded = false;
            boolean layersAckNeeded = false;
            this.layersToAsk.removeAllElements();
            for (int i = 0; i < count; ++i) {
                Layer layer = (Layer)layers.elementAt(i);
                if (project.getLayerByDsId(layer.datasetId) != null || this.autoDeny.indexOf(layer.datasetId) >= 0) continue;
                if (this.acceptAll || this.autoAllow.indexOf(layer.datasetId) >= 0) {
                    project.layers.addElement(layer);
                    layer.setParentMap(map);
                    layersAdded = true;
                    continue;
                }
                this.layersToAsk.addElement(layer);
                layersAckNeeded = true;
            }
            if (layersAdded) {
                map.broadcastMessage(111, null);
            }
            if (this.lbl_dyn_status != null && this.iCountPos >= 0) {
                this.lbl_dyn_status.setText(this.dyn_status_text.substring(0, this.iCountPos) + this.layersToAsk.size() + this.dyn_status_text.substring(this.iCountPos + 7));
                this.lbl_dyn_status.setVisible(true);
            }
            if (layersAckNeeded) {
                this.setBackground(this.activeColor);
                if (!this.searchAlways) {
                    ActionEvent e = new ActionEvent(this, 0, "ProxyCallback");
                    this.processActionEvent(e);
                }
            } else {
                this.setBackground(SystemColor.control);
                if (this.lbl_dyn_status != null) {
                    this.lbl_dyn_status.setVisible(false);
                }
            }
        }
    }

    public void afterProjectLoaded(boolean bSuccess) {
        Project prj = this.host.getMap().getProject();
        this.acceptAll = prj.isDynamic_AcceptAll;
        this.searchAlways = prj.isDynamic_SearchAlways;
        this.lbl_dyn_status = (Label)this.host.findComponent("dyn_status_label");
        if (this.lbl_dyn_status != null && this.dyn_status_text == null) {
            this.dyn_status_text = this.lbl_dyn_status.getText();
            this.iCountPos = this.dyn_status_text.indexOf("[COUNT]");
            this.lbl_dyn_status.setText("");
        }
        this.setVisible(prj.isDynamic);
    }

    public void setParameters(CarteHost host, XmlElement layout) {
        this.host = host;
        Carte map = host.getMap();
        if (map != null) {
            map.statusListeners.addElement(this);
        }
        this.activeColor = XmlUtils.getColor(PAR_ACTIVECOLOR, layout, this.activeColor);
        this.setLabel(XmlUtils.getString("caption", layout, "+Layers"));
    }

    public void stop() {
    }
}

