/*
 * Decompiled with CFR 0.152.
 */
package org.alov.tm;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.util.Vector;
import org.alov.tm.Series;
import org.alov.tm.TimeBar;

class Chart
extends Panel {
    Vector seriesList = new Vector();
    Color colorLabels = Color.black;
    Color colorRules = Color.gray;
    Color colorBackground = Color.white;
    TimeBar picker = null;
    boolean doubleBuffering = true;
    int marginLeft = 40;
    int marginRight = 10;
    double dateLeft = 0.0;
    double dateRight = 0.0;
    boolean datesNotSet = true;

    Chart() {
    }

    public synchronized void setDates(double left, double right) {
        this.datesNotSet = false;
        this.dateLeft = left;
        this.dateRight = right;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint() {
        Graphics g = this.getGraphics();
        if (g != null) {
            try {
                this.paint(g);
            }
            finally {
                g.dispose();
            }
        }
    }

    public synchronized void paint(Graphics gOriginal) {
        Graphics g;
        int count = this.seriesList.size();
        double ymax = 0.0;
        double xmax = 0.0;
        double ymin = 0.0;
        double xmin = 0.0;
        boolean empty = true;
        for (int i = 0; i < count; ++i) {
            Series sr = (Series)this.seriesList.elementAt(i);
            if (sr.count <= 0) continue;
            if (empty) {
                xmin = sr.xmin;
                xmax = sr.xmax;
                ymin = sr.ymin;
                ymax = sr.ymax;
                empty = false;
                continue;
            }
            if (sr.xmin < xmin) {
                xmin = sr.xmin;
            } else if (sr.xmax > xmax) {
                xmax = sr.xmax;
            }
            if (sr.ymin < ymin) {
                ymin = sr.ymin;
                continue;
            }
            if (!(sr.ymax > ymax)) continue;
            ymax = sr.ymax;
        }
        Dimension size = this.getSize();
        if (empty) {
            gOriginal.setColor(this.getBackground());
            gOriginal.fillRect(0, 0, size.width, size.height);
            gOriginal.setColor(this.colorLabels);
            gOriginal.drawString("Switch on layer to see timegraph", 10, 10);
            return;
        }
        if (this.picker != null) {
            this.marginLeft = size.width - this.picker.getScaleWidth();
            this.marginRight = 1;
        }
        int areaWidth = size.width - this.marginLeft - this.marginRight;
        int areaHeight = size.height - 2;
        int areaX = this.marginLeft;
        int areaY = 1;
        double sy = (double)(areaHeight - 1) / (ymax - ymin);
        double oy = ymax;
        if (this.datesNotSet) {
            this.dateLeft = xmin;
            this.dateRight = xmax;
        }
        if (this.dateRight <= this.dateLeft) {
            return;
        }
        Image image = null;
        if (this.doubleBuffering) {
            image = this.createImage(size.width, size.height);
            g = image.getGraphics();
        } else {
            g = gOriginal;
        }
        if (g != null) {
            double sx = (double)areaWidth / (this.dateRight - this.dateLeft);
            double ox = this.dateLeft;
            g.setColor(this.getBackground());
            g.fillRect(0, 0, size.width, size.height);
            g.setColor(this.colorRules);
            g.drawRect(areaX - 1, areaY - 1, areaWidth + 1, areaHeight + 1);
            FontMetrics fm = g.getFontMetrics();
            int fontHeight = fm.getHeight();
            int ascent = fm.getAscent();
            int labelCount = areaHeight / fontHeight;
            if (labelCount > 0) {
                double delta = (ymax - ymin) / (double)labelCount;
                double current = ymin + delta / 2.0;
                int i = 0;
                while (i < labelCount) {
                    int val = (int)current;
                    int y = areaY + (int)(((double)(-val) + oy) * sy);
                    String s = String.valueOf(val);
                    int textWidth = fm.stringWidth(s);
                    g.setColor(this.colorLabels);
                    g.drawString(s, this.marginLeft - textWidth - 2, y + ascent / 2);
                    g.setColor(this.colorRules);
                    g.drawLine(areaX, y, areaX + areaWidth, y);
                    ++i;
                    current += delta;
                }
            }
            int maxX = areaX + areaWidth;
            g.clipRect(areaX, areaY, areaWidth, areaHeight);
            boolean drawLegend = false;
            for (int i = 0; i < count; ++i) {
                Series sr = (Series)this.seriesList.elementAt(i);
                Color color1 = sr.color;
                Color color2 = sr.color2;
                Color color3 = sr.color3;
                int srType = sr.type;
                int ptcount = sr.count;
                if (ptcount <= 0) continue;
                if (srType == 1) {
                    g.setColor(color1);
                }
                int prevX = 0;
                int prevY = 0;
                int prevY2 = 0;
                boolean somethingWasDrawn = false;
                for (int j = 0; j < ptcount; ++j) {
                    int x = areaX + (int)((sr.x[j] - ox) * sx);
                    int y = areaY + (int)((-sr.y[j] + oy) * sy);
                    int y2 = areaY + (int)((-sr.y2[j] + oy) * sy);
                    if (j > 0 && (prevX >= 0 && prevX < maxX || x >= 0 && x < maxX)) {
                        if (srType == 1) {
                            g.drawLine(prevX, prevY, x, y);
                        } else {
                            drawLegend = true;
                            g.setColor(color1);
                            int spacing = (x - prevX) / 4;
                            int w = x - (prevX += spacing);
                            int h = areaY + areaHeight - prevY;
                            g.fillRect(prevX, prevY, w, h);
                            if (prevY2 < areaY + areaHeight - 1) {
                                g.setColor(color3);
                                g.fillRect(prevX, prevY2, w, h);
                            }
                            g.setColor(color2);
                            g.drawRect(prevX, prevY, w, h);
                        }
                        somethingWasDrawn = true;
                    }
                    prevX = x;
                    prevY = y;
                    prevY2 = y2;
                }
            }
            g.setClip(0, 0, size.width, size.height);
            if (drawLegend) {
                g.setColor(Color.red);
                g.fillRect(1, 10, 10, 10);
                g.setColor(Color.green);
                g.fillRect(1, 20, 10, 10);
                g.setColor(Color.black);
                g.drawString("Start", 12, 20);
                g.drawString("End", 12, 30);
            }
            if (this.doubleBuffering) {
                g.dispose();
                gOriginal.drawImage(image, 0, 0, null);
            }
        }
        if (image != null) {
            image.flush();
        }
    }
}

