/*
 * Decompiled with CFR 0.152.
 */
package org.alov.tm;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.alov.map.Carte;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.DisplayContext;
import org.alov.map.FlashMaker;
import org.alov.map.FlashMakerFactory;
import org.alov.map.FlashMakerListener;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.LayerVector;
import org.alov.map.MapUtils;
import org.alov.map.Project;
import org.alov.map.Renderer;
import org.alov.map.StatusListener;
import org.alov.tm.MsgBox;
import org.alov.tm.TimeBar;
import org.alov.util.ExDate;
import org.alov.util.Strings;
import org.alov.util.TimeInterval;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;
import org.alov.viewer.FrameAlign;

public class AnimationFrame
extends FrameAlign
implements ActionListener,
ItemListener,
FocusListener,
Runnable,
CarteHostListener,
StatusListener {
    private static final String BTN_REWIND = "btn_rewind";
    private static final String BTN_BACK = "btn_back";
    private static final String BTN_FORWARD = "btn_forward";
    private static final String BTN_PLAY = "btn_play";
    private static final String BTN_PAUSE = "btn_pause";
    private static final String BTN_CLOSE = "btn_close";
    private static final String BTN_SELFILE = "btn_selfile";
    private static final String BTN_SWF = "btn_swf";
    private static final String BTN_SWFSTART = "btn_swfstart";
    private static final String LBL_ORIG_START = "lbl_orig_start";
    private static final String LBL_ORIG_END = "lbl_orig_end";
    private static final String LBL_TIME_DETAIL = "lbl_time_detail";
    private static final String LBL_CUR_START = "lbl_cur_start";
    private static final String LBL_TIME_SPAN = "lbl_time_span";
    private static final String LBL_STEP = "lbl_step";
    private static final String LBL_FILE = "lbl_file";
    private static final String PNL_FILE = "swf_file";
    private static final String PNL_SWF = "swf_panel";
    private static final String LBL_TITLE = "lbl_title";
    private static final String LBL_BOUNDS = "lbl_bounds";
    private static final String LBL_MSPF = "lbl_mspf";
    private static final String LBL_AL = "lbl_al";
    private static final String LBL_ALV = "lbl_alv";
    private static final String LBL_FC = "lbl_fc";
    private static final String LBL_FCV = "lbl_fcv";
    private static final String LBL_STATUS = "lbl_status";
    private static final String LBL_PROGRESS = "lbl_progress";
    private static final String TF_ORIG_START = "tf_orig_start";
    private static final String TF_ORIG_END = "tf_orig_end";
    private static final String TF_TIME_DETAIL = "tf_time_detail";
    private static final String TF_CUR_START = "tf_cur_start";
    private static final String TF_TIME_SPAN = "tf_time_span";
    private static final String TF_STEP = "tf_step";
    private static final String TF_TITLE = "tf_title";
    private static final String TF_FILE = "tf_file";
    private static final String TF_MSPF = "tf_mspf";
    private static final String CH_BOUNDS = "ch_bounds";
    private static final String CB_COUNTER = "cb_counter";
    private static final String CB_TITLE = "cb_title";
    private static final String TD_YEAR = "Year";
    private static final String TD_MONTH = "Month";
    private static final String TD_DAY = "Day";
    private static final String TD_HOUR = "Hour";
    private static final String TD_MINUTE = "Minute";
    private static final String TD_SECOND = "Second";
    private static final String TB_START = "Start";
    private static final String TB_END = "End";
    private static final String TB_BOTH = "Both";
    private static final String[] TD_TEXT = new String[]{"Year", "Month", "Day", "Hour", "Minute", "Second"};
    private static long frameDelay = 1000L;
    protected Carte map = null;
    private CarteHost host = null;
    protected LayerVector layer;
    private static AnimationFrame instance = null;
    private static final int START = 0;
    private static final int END = 1;
    private static final int BOTH = 2;
    private double dateStart = 0.0;
    private double dateEnd = 0.0;
    private int timeDetail = 0;
    private boolean counterEnabled = true;
    private boolean titleEnabled = false;
    private String Title = "";
    private String fileName = "";
    private int mspf = 1000;
    private int fr_count = 0;
    private double movie_length = 0.0;
    private int bounds_motion = 2;
    private double currentStart = 0.0;
    private double timeSpan = 0.0;
    private double timeSpanOriginal = 0.0;
    private double step = 0.0;
    private String servletURL = null;
    private String datePickerName = "datepicker";
    private TimeBar datePicker = null;
    private String show_swf = "SWF v";
    private String hide_swf = "SWF ^";
    private TimeInterval startupArea;
    private TimeInterval startupInterval;
    private WindowEventHandler wind_handler;
    private Component focused = null;
    private static final String _WARN_FOR_APPLICATION = " To generate SWF animations you need either\n1) a Flash-enabled version of the TMJava.\nAdd 'flash' package to JAR file or request JAR with such package.\n2) Verify that JAR file contains BrowserLauncher class,\ndefine TMJava server URL as a parameter 'server' for 'AnimationFrame' in the layout file.";
    private static final String _WARN_FOR_APPLET = " To generate SWF animations for standalone applet\n you need to define TMJava server URL\n as a parameter 'server' for 'AnimationFrame' in the layout file.";
    private boolean boundsAreSet = false;
    private boolean running = false;
    private boolean terminate = false;

    public AnimationFrame() {
        instance = this;
    }

    public static void showFrame() {
        if (instance != null) {
            instance.setVisible(true);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        Object o = evt.getSource();
        if (o instanceof Component) {
            String sName;
            if (this.focused != null) {
                this.focusLost(new FocusEvent(this.focused, 1005, true));
            }
            if (BTN_CLOSE.equalsIgnoreCase(sName = ((Component)o).getName())) {
                this.wind_handler.closeWindow();
            } else if (BTN_REWIND.equalsIgnoreCase(sName)) {
                this.rewind();
            } else if (BTN_BACK.equalsIgnoreCase(sName)) {
                this.stepBack();
            } else if (BTN_FORWARD.equalsIgnoreCase(sName)) {
                this.stepForward();
            } else if (BTN_PLAY.equalsIgnoreCase(sName)) {
                this.startAnimation();
            } else if (BTN_PAUSE.equalsIgnoreCase(sName)) {
                this.stopAnimation();
            } else if (BTN_SWF.equalsIgnoreCase(sName)) {
                this.toggleSWFpanel();
            } else if (BTN_SWFSTART.equalsIgnoreCase(sName)) {
                String sWarnMessage = null;
                if (this.host.isApplication()) {
                    if (!FlashMakerFactory.getFactory().isPackagePresent() && Strings.isNullOrBlank(this.servletURL)) {
                        sWarnMessage = _WARN_FOR_APPLICATION;
                    }
                } else if (MapUtils.isRunFromDisk && Strings.isNullOrBlank(this.servletURL)) {
                    sWarnMessage = _WARN_FOR_APPLET;
                }
                if (!Strings.isNullOrBlank(sWarnMessage)) {
                    MsgBox box = new MsgBox((Frame)this, 4, sWarnMessage);
                    box.showDlg();
                    return;
                }
                this.sendSWFrequest(this.createFlashMakerListener());
            } else if (BTN_SELFILE.equalsIgnoreCase(sName)) {
                this.selectFileName();
            }
        }
    }

    private void selectFileName() {
        FileDialog fd = new FileDialog((Frame)this, this.map.getResource("Save"), 1);
        fd.setModal(true);
        fd.show();
        this.fileName = fd.getDirectory() + fd.getFile();
        this.showData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createSWFfile(Project p, DisplayContext context, Vector layers, Hashtable parms, int w, int h, FlashMakerListener listener) {
        String fileName = (String)parms.get("file");
        String s = (String)parms.get("html");
        if (Strings.isNullOrBlank(fileName)) {
            return;
        }
        InputStream file = null;
        try {
            FlashMaker maker = FlashMakerFactory.getFactory().getMaker(0);
            if (maker != null) {
                maker.addListener(listener);
                file = maker.makeFlash(p, context, layers, parms, w, h);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        try {
            BufferedInputStream bis = new BufferedInputStream(file);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(fileName));
            int size = bis.available();
            byte[] buf = new byte[size];
            bis.read(buf, 0, size);
            bos.write(buf, 0, size);
            bos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String fn2 = fileName;
        s = Strings.extractDir(fileName);
        if (!s.equals(fileName)) {
            fn2 = fileName.substring(s.length());
        }
        fileName = Strings.changeSuffix(fileName, ".htm");
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            PrintWriter wr = new PrintWriter(fos);
            try {
                wr.println("<HTML><BODY><EMBED src=\"" + fn2 + "\"");
                wr.println(" WIDTH=100% HEIGHT=100% ");
                wr.println("TYPE=\"application/x-shockwave-flash\">");
                wr.println("</EMBED></BODY></HTML>");
                wr.flush();
            }
            finally {
                fos.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private FlashMakerListener createFlashMakerListener() {
        LocalFlashMakerListener listener = new LocalFlashMakerListener();
        Component comp = MapUtils.findComp(this, LBL_STATUS);
        if (comp != null && comp instanceof Label) {
            listener.statusLabel = (Label)comp;
        }
        if ((comp = MapUtils.findComp(this, LBL_PROGRESS)) != null && comp instanceof Label) {
            listener.progressLabel = (Label)comp;
        }
        return listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createSWFfile(Hashtable parms) {
        parms.put("mpf", new Integer(this.mspf));
        parms.put("span", new Double(this.timeSpan / this.getDetails()));
        parms.put("step", new Double(this.step / this.getDetails()));
        parms.put("units", new Integer(this.timeDetail));
        parms.put("motion", new Integer(this.bounds_motion));
        parms.put("file", this.fileName);
        parms.put("html", "yes");
        String surl = "file:/" + this.fileName;
        TimeInterval time = new TimeInterval(new ExDate(this.dateStart), new ExDate(this.dateEnd));
        this.map.setTimeInterval(time);
        Project p = this.map.getProject();
        Vector<Layer> layers = new Vector<Layer>();
        for (int i = 0; i < p.renderers.size(); ++i) {
            Vector v = (Vector)p.renderers.elementAt(i);
            for (int j = 0; j < v.size(); ++j) {
                Renderer rend = (Renderer)v.elementAt(j);
                Layer lyr = rend.getLayer();
                if (lyr.isKeyMap || layers.indexOf(lyr) != -1) continue;
                layers.addElement(lyr);
            }
        }
        Dimension d = this.map.getSize();
        Image bim = this.createImage(1, 1);
        this.map.drawTo = bim.getGraphics();
        try {
            FlashMakerListener listener = this.createFlashMakerListener();
            AnimationFrame.createSWFfile(p, this.map, layers, parms, d.width, d.height, listener);
        }
        finally {
            this.map.drawTo = null;
            bim = null;
        }
        surl = Strings.changeSuffix(surl, ".htm");
        return surl;
    }

    private void sendSWFrequest(FlashMakerListener listener) {
        boolean bl = this.titleEnabled = !Strings.isNullOrBlank(this.Title);
        if (Strings.isNullOrBlank(this.fileName)) {
            this.fileName = MapUtils.codeBase + "unnamed.swf";
        }
        if (this.fileName.startsWith("file:/")) {
            this.fileName = this.fileName.substring("file:/".length());
        }
        this.fileName = Strings.changeSuffix(this.fileName, ".swf");
        this.showData();
        String surl = this.fileName;
        Hashtable<String, String> parms = new Hashtable<String, String>();
        parms.put("counter", this.counterEnabled ? "yes" : "no");
        if (this.titleEnabled) {
            parms.put("title", this.Title);
        }
        if (this.host.isApplication() && FlashMakerFactory.getFactory().isPackagePresent()) {
            surl = this.createSWFfile(parms);
        } else {
            parms.put("mpf", String.valueOf(this.mspf));
            parms.put("span", this.formatDouble(this.timeSpan / this.getDetails()));
            parms.put("step", this.formatDouble(this.step / this.getDetails()));
            parms.put("units", String.valueOf(this.timeDetail));
            parms.put("motion", String.valueOf(this.bounds_motion));
            Dimension d = this.map.getSize();
            parms.put("width", String.valueOf(d.width));
            parms.put("height", String.valueOf(d.height));
            parms.put("time", ExDate.toString(this.dateStart) + "," + ExDate.toString(this.dateEnd));
            FloatRectangle bbox = this.map.getExtent();
            parms.put("bbox", bbox.x + "," + bbox.y + "," + bbox.x2 + "," + bbox.y2);
            Project p = this.map.getProject();
            String s = "";
            for (int i = 0; i < p.renderers.size(); ++i) {
                Vector v = (Vector)p.renderers.elementAt(i);
                for (int j = 0; j < v.size(); ++j) {
                    Renderer rend = (Renderer)v.elementAt(j);
                    Layer lyr = rend.getLayer();
                    if (lyr.isKeyMap || s.indexOf(lyr.id + ',') != -1) continue;
                    s = s + lyr.id + ',';
                }
            }
            s = s.substring(0, s.length() - 1);
            parms.put("layers", s.toString());
            surl = this.SWFrequestURL(parms);
            listener.statusChanged("Wait for reply from server please...", false);
        }
        this.host.showURL(surl, null);
        listener.statusChanged("", false);
    }

    private String SWFrequestURL(Hashtable parms) {
        String _pid = this.map.getParameter("pid", null);
        if (_pid == null) {
            return "";
        }
        int i = (_pid = Strings.extractFileName(_pid)).indexOf(46);
        if (i > 0) {
            _pid = _pid.substring(0, i);
        }
        String s = MapUtils.codeBase;
        if (!Strings.isNullOrBlank(this.servletURL)) {
            s = MapUtils.getRealPath(this.servletURL);
        }
        s = s + _pid + ".wms?request=GetSWF&s=1";
        Enumeration e = parms.keys();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            String val = (String)parms.get(k);
            s = s + "&" + k + "=" + val;
        }
        return s;
    }

    private void toggleSWFpanel() {
        boolean v = false;
        Component component = MapUtils.findComp(this, PNL_SWF);
        if (component != null) {
            v = !component.isVisible();
            Rectangle d = component.getBounds();
            Dimension d2 = this.getSize();
            d2.height = d2.height + (v ? 1 : -1) * d.height;
            ((Component)this).setSize(d2);
            component.setVisible(v);
        }
        if ((component = MapUtils.findComp(this, BTN_SWF)) != null) {
            String s = v ? this.hide_swf : this.show_swf;
            ((Button)component).setLabel(s);
        }
    }

    public void setParameters(CarteHost host, XmlElement layout) {
        this.map = host.getMapByName(layout);
        this.host = host;
        this.datePickerName = XmlUtils.getString("picker", layout, this.datePickerName);
        this.map.statusListeners.addElement(this);
        this.counterEnabled = XmlUtils.getBoolean("counterE", layout, true);
        this.titleEnabled = XmlUtils.getBoolean("titleE", layout, true);
        this.show_swf = XmlUtils.getString("swf_btn_caption_visible", layout, this.show_swf);
        this.hide_swf = XmlUtils.getString("swf_btn_caption_hidden", layout, this.hide_swf);
        this.servletURL = XmlUtils.getString("server", layout, null);
    }

    public void stop() {
        this.setVisible(false);
        this.dispose();
    }

    private static Dimension getControlsSize(Container container) {
        int width = 0;
        int height = 0;
        Component[] components = container.getComponents();
        for (int i = 0; i < components.length; ++i) {
            int y2;
            int x2;
            Component component = components[i];
            Rectangle bounds = component.getBounds();
            if (component instanceof Container) {
                Dimension dim = AnimationFrame.getControlsSize((Container)component);
                x2 = bounds.x + dim.width;
                y2 = bounds.y + dim.height;
            } else {
                x2 = bounds.x + bounds.width;
                y2 = bounds.y + bounds.height;
            }
            if (x2 > width) {
                width = x2;
            }
            if (y2 <= height) continue;
            height = y2;
        }
        Dimension dim = new Dimension(width, height);
        return dim;
    }

    public void show() {
        if (!this.boundsAreSet) {
            int height;
            int width;
            this.boundsAreSet = true;
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            if (this.bounds != null) {
                width = this.bounds.width;
                height = this.bounds.height;
            } else {
                width = 570;
                height = 120;
            }
            this.setBounds((screenSize.width - width) / 2, 50, width, height);
            this.setResizable(false);
        }
        super.show();
        this.requestFocus();
    }

    public void focusGained(FocusEvent e) {
        this.focused = e.getComponent();
    }

    public void focusLost(FocusEvent e) {
        if (!(e.getSource() instanceof Component)) {
            return;
        }
        Component source = (Component)e.getSource();
        String s = source instanceof TextComponent ? ((TextComponent)source).getText() : null;
        String name = source.getName();
        if (TF_FILE.equalsIgnoreCase(name)) {
            this.fileName = s;
        } else if (TF_TITLE.equalsIgnoreCase(name)) {
            this.Title = s;
        } else if (TF_ORIG_START.equalsIgnoreCase(name)) {
            try {
                ExDate date = ExDate.parseString(s);
                this.dateStart = date.getDays();
            }
            catch (Exception ex) {}
        } else if (TF_ORIG_END.equalsIgnoreCase(name)) {
            try {
                ExDate date = ExDate.parseString(s);
                this.dateEnd = date.getDays();
            }
            catch (Exception ex) {}
        } else if (TF_CUR_START.equalsIgnoreCase(name)) {
            try {
                ExDate date = ExDate.parseString(s);
                this.currentStart = date.getDays();
            }
            catch (Exception ex) {}
        } else if (TF_TIME_SPAN.equalsIgnoreCase(name)) {
            double d = MapUtils.toDouble(s);
            this.timeSpanOriginal = this.timeSpan = d * this.getDetails();
        } else if (TF_STEP.equalsIgnoreCase(name)) {
            double d = MapUtils.toDouble(s);
            this.step = d * this.getDetails();
        } else if (TF_MSPF.equalsIgnoreCase(name)) {
            double d = MapUtils.toDouble(s);
            this.mspf = (int)d;
        } else {
            return;
        }
        this.showData();
    }

    public void itemStateChanged(ItemEvent e) {
        Component source = (Component)e.getSource();
        if (CB_COUNTER.equalsIgnoreCase(source.getName())) {
            boolean bl = this.counterEnabled = e.getStateChange() == 1;
        }
        if (CB_TITLE.equalsIgnoreCase(source.getName())) {
            boolean bl = this.titleEnabled = e.getStateChange() == 1;
        }
        if (e.getStateChange() == 1) {
            String item = (String)e.getItem();
            if (TF_TIME_DETAIL.equalsIgnoreCase(source.getName())) {
                if (TD_YEAR.equalsIgnoreCase(item)) {
                    this.timeDetail = 0;
                } else if (TD_MONTH.equalsIgnoreCase(item)) {
                    this.timeDetail = 1;
                } else if (TD_DAY.equalsIgnoreCase(item)) {
                    this.timeDetail = 2;
                } else if (TD_HOUR.equalsIgnoreCase(item)) {
                    this.timeDetail = 3;
                } else if (TD_MINUTE.equalsIgnoreCase(item)) {
                    this.timeDetail = 4;
                } else if (TD_SECOND.equalsIgnoreCase(item)) {
                    this.timeDetail = 5;
                } else {
                    return;
                }
            }
            if (CH_BOUNDS.equalsIgnoreCase(source.getName())) {
                if (TB_START.equalsIgnoreCase(item)) {
                    this.bounds_motion = 0;
                } else if (TB_END.equalsIgnoreCase(item)) {
                    this.bounds_motion = 1;
                } else if (TB_BOTH.equalsIgnoreCase(item)) {
                    this.bounds_motion = 2;
                } else {
                    return;
                }
            }
            this.showData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean proceed = true;
        while (proceed) {
            try {
                Thread.currentThread();
                Thread.sleep(frameDelay);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!this.terminate) {
                try {
                    this.stepForward();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            AnimationFrame animationFrame = this;
            synchronized (animationFrame) {
                if (this.terminate) {
                    this.running = false;
                    proceed = false;
                }
            }
        }
    }

    private synchronized void startAnimation() {
        this.terminate = false;
        if (!this.running) {
            this.running = true;
            new Thread(this).start();
        }
    }

    private void stopAnimation() {
        this.terminate = true;
        if (this.datePicker != null) {
            double d1 = this.startupArea.date1().getDays();
            double d2 = this.startupArea.date2().getDays();
            this.datePicker.setScale(d1, d2 - d1);
        }
    }

    private void setMapTime() {
        Component component = MapUtils.findComp(this, TF_CUR_START);
        if (component != null) {
            ((TextField)component).setText(ExDate.toString(this.currentStart));
        }
        if (this.datePicker != null) {
            this.datePicker.setScale(this.dateStart, this.dateEnd - this.dateStart);
            this.datePicker.setCurrent(new ExDate(this.currentStart), new ExDate(this.currentStart + this.timeSpan), false);
            this.datePicker.updateSlider();
        }
    }

    private synchronized void rewind() {
        this.currentStart = this.dateStart;
        this.setMapTime();
    }

    private synchronized void stepBack() {
        if (this.bounds_motion == 1) {
            this.timeSpan = this.timeSpan - this.step < 0.0 ? this.timeSpanOriginal : (this.timeSpan -= this.step);
        } else {
            double d = this.currentStart - this.step;
            if (d < this.dateStart) {
                d = this.dateStart;
            }
            this.currentStart = d;
        }
        this.setMapTime();
    }

    private synchronized void stepForward() {
        if (this.bounds_motion == 1) {
            double d2 = this.currentStart + this.timeSpan + this.step;
            this.timeSpan = d2 > this.dateEnd ? this.timeSpanOriginal : (this.timeSpan += this.step);
        } else {
            double d = this.currentStart + this.step;
            if (d > this.dateEnd - this.step) {
                d = this.dateStart;
            }
            this.currentStart = d;
        }
        this.setMapTime();
    }

    private void initializeForm() {
        if (this.datePicker != null) {
            TimeInterval full = this.datePicker.getVisibleArea();
            TimeInterval bar = this.datePicker.getTimeInterval(true);
            this.startupArea = this.datePicker.getVisibleArea();
            this.startupInterval = new TimeInterval(bar.date1(), bar.date2());
            this.dateStart = full.date1().getDays();
            this.dateEnd = full.date2().getDays();
            double rate = full.getLength(2) / bar.getLength(2);
            this.step = rate < 5.0 ? (this.timeSpan = (this.dateEnd - this.dateStart) / 10.0) : (this.timeSpan = this.startupInterval.getLength(2));
            while (this.timeDetail < 5 && this.timeSpan / this.getDetails() < 1.0) {
                ++this.timeDetail;
            }
            this.currentStart = this.dateStart;
            this.showData();
        }
    }

    private void verifyValues() {
        double date2;
        Project p = this.map.getProject();
        double date1 = p.startDate.getDays();
        if (this.dateStart < date1 || this.dateStart == Double.NaN) {
            this.dateStart = date1;
        }
        if (this.dateEnd > (date2 = p.endDate.getDays()) || this.dateEnd == Double.NaN) {
            this.dateEnd = date2;
        }
        if (this.dateStart > this.dateEnd) {
            this.dateStart = date1;
            this.dateEnd = date2;
        }
        if (this.currentStart < this.dateStart || Double.isNaN(this.currentStart)) {
            this.currentStart = this.dateStart;
        }
        if (this.currentStart > this.dateEnd) {
            this.currentStart = this.dateEnd;
        }
        if (this.timeSpan <= 0.0) {
            this.timeSpan = 10.0 * this.getDetails();
        }
        if (this.step <= 0.0) {
            this.step = 10.0 * this.getDetails();
        }
        if (this.timeSpan > this.dateEnd - this.dateStart) {
            this.timeSpan = this.dateEnd - this.dateStart;
        }
    }

    private void showData() {
        Choice choice;
        this.verifyValues();
        Component component = MapUtils.findComp(this, TF_TITLE);
        if (component != null) {
            ((TextField)component).setText(this.Title);
        }
        if ((component = MapUtils.findComp(this, CB_COUNTER)) != null) {
            ((Checkbox)component).setState(this.counterEnabled);
        }
        if ((component = MapUtils.findComp(this, CB_TITLE)) != null) {
            ((Checkbox)component).setState(this.titleEnabled);
        }
        if ((component = MapUtils.findComp(this, TF_ORIG_START)) != null) {
            ((TextField)component).setText(ExDate.toString(this.dateStart, this.timeDetail));
        }
        if ((component = MapUtils.findComp(this, TF_ORIG_END)) != null) {
            ((TextField)component).setText(ExDate.toString(this.dateEnd, this.timeDetail));
        }
        if ((component = MapUtils.findComp(this, TF_CUR_START)) != null) {
            ((TextField)component).setText(ExDate.toString(this.currentStart, this.timeDetail));
        }
        if ((component = MapUtils.findComp(this, TF_TIME_SPAN)) != null) {
            ((TextField)component).setText(this.formatDouble(this.timeSpan / this.getDetails()));
        }
        if ((component = MapUtils.findComp(this, TF_STEP)) != null) {
            ((TextField)component).setText(this.formatDouble(this.step / this.getDetails()));
        }
        if ((component = MapUtils.findComp(this, TF_TIME_DETAIL)) != null) {
            choice = (Choice)component;
            if (this.timeDetail < 0 || this.timeDetail >= choice.getItemCount()) {
                this.timeDetail = 0;
            }
            choice.select(this.timeDetail);
        }
        if ((component = MapUtils.findComp(this, CH_BOUNDS)) != null) {
            choice = (Choice)component;
            if (this.bounds_motion < 0 || this.bounds_motion >= choice.getItemCount()) {
                this.bounds_motion = 0;
            }
            choice.select(this.bounds_motion);
        }
        if ((component = MapUtils.findComp(this, TF_MSPF)) != null) {
            ((TextField)component).setText(String.valueOf(this.mspf));
        }
        if ((component = MapUtils.findComp(this, TF_FILE)) != null) {
            ((TextField)component).setText(this.fileName);
        }
        if ((component = MapUtils.findComp(this, LBL_FCV)) != null) {
            if (this.bounds_motion == 0) {
                this.fr_count = (int)(this.timeSpan / this.step);
            } else {
                double val = (this.dateEnd - this.dateStart - this.timeSpan) / this.step;
                this.fr_count = (int)val;
                if (val - (double)this.fr_count > 0.0) {
                    ++this.fr_count;
                }
            }
            ((Label)component).setText(String.valueOf(this.fr_count));
        }
        if ((component = MapUtils.findComp(this, LBL_ALV)) != null) {
            this.movie_length = (double)(this.fr_count * this.mspf) / 1000.0;
            ((Label)component).setText(String.valueOf(this.movie_length) + " secs");
        }
    }

    private double getDetails() {
        double[] details = new double[]{365.25, 30.4375, 1.0, 0.041666666666666664, 6.944444444444444E-4, 1.1574074074074073E-5};
        return details[this.timeDetail];
    }

    private String formatDouble(double d) {
        d = (double)Math.round(d * 100.0) / 100.0;
        return String.valueOf(d);
    }

    public void afterProjectLoaded(boolean bSuccess) {
        this.datePicker = (TimeBar)this.host.findComponent(this.datePickerName);
        Project project = this.map.getProject();
        MapUtils.addActionListener(this, this, BTN_CLOSE);
        if (bSuccess && project.isTimeEnabled && this.datePicker != null) {
            this.setTitle(this.map.getResource("Time Animation"));
            MapUtils.addActionListener(this, this, BTN_REWIND);
            MapUtils.addActionListener(this, this, BTN_BACK);
            MapUtils.addActionListener(this, this, BTN_FORWARD);
            MapUtils.addActionListener(this, this, BTN_PLAY);
            MapUtils.addActionListener(this, this, BTN_PAUSE);
            MapUtils.addActionListener(this, this, BTN_SWF);
            MapUtils.addActionListener(this, this, BTN_SWFSTART);
            MapUtils.addActionListener(this, this, BTN_SELFILE);
            Component component = MapUtils.findComp(this, BTN_SWF);
            if (component != null) {
                ((Button)component).setLabel(this.show_swf);
            }
            if ((component = MapUtils.findComp(this, CB_COUNTER)) != null) {
                ((Checkbox)component).setLabel(this.map.getResource("cb_Counter"));
                ((Checkbox)component).addItemListener(this);
            }
            if ((component = MapUtils.findComp(this, CB_TITLE)) != null) {
                ((Checkbox)component).setLabel(this.map.getResource("cb_Title"));
                ((Checkbox)component).addItemListener(this);
            }
            if ((component = MapUtils.findComp(this, PNL_FILE)) != null) {
                boolean b = this.host.isApplication();
                ((Panel)component).setVisible(b);
                Component c = MapUtils.findComp(this, PNL_SWF);
                if (b && c != null) {
                    Dimension d = c.getSize();
                    d.height += component.getSize().height;
                    c.setSize(d);
                }
            }
            if ((component = MapUtils.findComp(this, LBL_TITLE)) != null) {
                ((Label)component).setAlignment(2);
            }
            if ((component = MapUtils.findComp(this, LBL_FILE)) != null) {
                ((Label)component).setAlignment(2);
            }
            if ((component = MapUtils.findComp(this, LBL_ORIG_START)) != null) {
                ((Label)component).setAlignment(2);
            }
            if ((component = MapUtils.findComp(this, LBL_ORIG_END)) != null) {
                ((Label)component).setAlignment(2);
            }
            if ((component = MapUtils.findComp(this, LBL_TIME_DETAIL)) != null) {
                ((Label)component).setAlignment(2);
            }
            if ((component = MapUtils.findComp(this, LBL_CUR_START)) != null) {
                ((Label)component).setAlignment(2);
            }
            if ((component = MapUtils.findComp(this, LBL_TIME_SPAN)) != null) {
                ((Label)component).setAlignment(2);
            }
            if ((component = MapUtils.findComp(this, LBL_STEP)) != null) {
                ((Label)component).setAlignment(2);
            }
            if ((component = MapUtils.findComp(this, LBL_BOUNDS)) != null) {
                ((Label)component).setAlignment(2);
            }
            if ((component = MapUtils.findComp(this, LBL_MSPF)) != null) {
                ((Label)component).setAlignment(2);
            }
            if ((component = MapUtils.findComp(this, LBL_FC)) != null) {
                ((Label)component).setAlignment(2);
            }
            if ((component = MapUtils.findComp(this, LBL_AL)) != null) {
                ((Label)component).setAlignment(2);
            }
            if ((component = MapUtils.findComp(this, TF_TITLE)) != null) {
                ((TextComponent)component).addFocusListener(this);
            }
            if ((component = MapUtils.findComp(this, TF_FILE)) != null) {
                ((TextComponent)component).addFocusListener(this);
            }
            if ((component = MapUtils.findComp(this, TF_ORIG_START)) != null) {
                ((TextComponent)component).addFocusListener(this);
            }
            if ((component = MapUtils.findComp(this, TF_ORIG_END)) != null) {
                ((TextComponent)component).addFocusListener(this);
            }
            if ((component = MapUtils.findComp(this, TF_CUR_START)) != null) {
                ((TextComponent)component).addFocusListener(this);
            }
            if ((component = MapUtils.findComp(this, TF_TIME_SPAN)) != null) {
                ((TextComponent)component).addFocusListener(this);
            }
            if ((component = MapUtils.findComp(this, TF_STEP)) != null) {
                ((TextComponent)component).addFocusListener(this);
            }
            if ((component = MapUtils.findComp(this, TF_MSPF)) != null) {
                ((TextComponent)component).addFocusListener(this);
            }
            if ((component = MapUtils.findComp(this, TF_TIME_DETAIL)) != null) {
                Choice detail = (Choice)component;
                detail.add(TD_YEAR);
                detail.add(TD_MONTH);
                detail.add(TD_DAY);
                detail.add(TD_HOUR);
                detail.add(TD_MINUTE);
                detail.add(TD_SECOND);
                detail.addItemListener(this);
            }
            if ((component = MapUtils.findComp(this, CH_BOUNDS)) != null) {
                Choice detail = (Choice)component;
                detail.add(TB_START);
                detail.add(TB_END);
                detail.add(TB_BOTH);
                detail.addItemListener(this);
            }
            this.initializeForm();
            this.wind_handler = new WindowEventHandler();
            this.addWindowListener(this.wind_handler);
            this.pack();
        }
    }

    public void setVisible(boolean b) {
        if (b) {
            this.initializeForm();
        }
        super.setVisible(b);
    }

    public void notifyStatus(int code, Object obj) {
    }

    private class LocalFlashMakerListener
    implements FlashMakerListener {
        private Label statusLabel = null;
        private Label progressLabel = null;

        private LocalFlashMakerListener() {
        }

        public void statusChanged(String status, boolean progressAvailable) {
            if (this.statusLabel != null) {
                this.statusLabel.setText(status);
                if (this.progressLabel != null) {
                    this.progressLabel.setVisible(progressAvailable);
                }
                this.statusLabel.repaint();
            }
        }

        public void progressChanged(int position, int maximum) {
            if (this.progressLabel != null) {
                this.progressLabel.setText(MessageFormat.format("{0,number,percent} complete", new Float((float)position / (float)maximum)));
                this.progressLabel.repaint();
            }
        }
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        private void closeWindow() {
            AnimationFrame.this.stopAnimation();
            if (AnimationFrame.this.datePicker != null) {
                AnimationFrame.this.datePicker.setCurrent(AnimationFrame.this.startupInterval.date1(), AnimationFrame.this.startupInterval.date2(), false);
                AnimationFrame.this.datePicker.updateSlider();
            }
            AnimationFrame.this.setVisible(false);
        }

        public void windowClosing(WindowEvent evt) {
            this.closeWindow();
        }
    }
}

