/*
 * Decompiled with CFR 0.152.
 */
package org.alov.ogcfilter;

import java.util.Vector;
import org.alov.ogcfilter.Filter;
import org.alov.ogcfilter.FilterException;
import org.alov.ogcfilter.OgcOperation;
import org.alov.util.XmlElement;

public class LogicalOperation
extends OgcOperation {
    public Vector operations = new Vector();

    public LogicalOperation(int type) {
        this.type = type;
        this.name = OgcOperation.getOperationName(type);
    }

    public LogicalOperation(XmlElement root, String name, int type) throws FilterException {
        this.name = name;
        this.type = type;
        Vector children = root.getChildren();
        if (children != null) {
            for (int i = 0; i < children.size(); ++i) {
                XmlElement xmlOperation = (XmlElement)children.get(i);
                String tagName = xmlOperation.getNodeName();
                if (!OgcOperation.isOperation(tagName)) continue;
                OgcOperation operation = Filter.createOperation(xmlOperation);
                this.operations.add(operation);
            }
        }
        switch (type) {
            case 102: {
                if (this.operations.size() == 1) break;
                throw new FilterException("NOT operation requires one argument");
            }
            case 100: 
            case 101: {
                if (this.operations.size() >= 2) break;
                throw new FilterException("Logical operation requires at least two arguments");
            }
            default: {
                throw new FilterException("The specified operation type does not correspond to a logical operation. Please refer to developers.");
            }
        }
    }

    public StringBuffer constructSQL() throws FilterException {
        StringBuffer result = new StringBuffer("(");
        switch (this.type) {
            case 102: {
                if (this.operations.size() > 1) {
                    throw new FilterException("Logical operation NOT must contain one suboperation only");
                }
                result.append("NOT ");
                result.append(((OgcOperation)this.operations.get(0)).constructSQL());
                break;
            }
            case 100: 
            case 101: {
                if (this.operations.size() < 2) {
                    throw new FilterException("Logical operation '" + this.name + "' must contain at least two suboperations");
                }
                result.append(((OgcOperation)this.operations.get(0)).constructSQL());
                for (int i = 1; i < this.operations.size(); ++i) {
                    result.append(this.type == 100 ? " AND " : " OR ");
                    result.append(((OgcOperation)this.operations.get(i)).constructSQL());
                }
                break;
            }
            default: {
                throw new FilterException("The specified operation type does not correspond to a logical operation. Please refer to developers.");
            }
        }
        result.append(")");
        return result;
    }

    public XmlElement getXml() {
        XmlElement root = new XmlElement(this.name);
        for (int i = 0; i < this.operations.size(); ++i) {
            root.addChild(((OgcOperation)this.operations.get(i)).getXml());
        }
        return root;
    }
}

