/*
 * Decompiled with CFR 0.152.
 */
package org.alov.ogcfilter;

import java.util.Vector;
import org.alov.ogcfilter.Expression;
import org.alov.ogcfilter.FilterException;
import org.alov.ogcfilter.OgcOperation;
import org.alov.util.Strings;
import org.alov.util.XmlElement;

public class ComparisonOperation
extends OgcOperation {
    public char wildCard = '\u0000';
    public char singleChar = '\u0000';
    public char escapeChar = '\u0000';
    public Expression firstExpression = null;
    public Expression secondExpression = null;
    public Expression lowerBound = null;
    public Expression upperBound = null;

    public ComparisonOperation(int type) {
        this.type = type;
        this.name = OgcOperation.getOperationName(type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ComparisonOperation(XmlElement root, String name, int type) throws FilterException {
        this.name = name;
        this.type = type;
        switch (type) {
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: {
                Vector children = root.getChildren();
                if (children == null) return;
                if (children.size() != 2) {
                    throw new FilterException("Binary comparison operation must have two expressions");
                }
                this.firstExpression = new Expression((XmlElement)children.get(0));
                this.secondExpression = new Expression((XmlElement)children.get(1));
                return;
            }
            case 206: {
                Vector children = root.getChildren();
                String INVALID_LIKE = "Invalid PropertyIsLike operation: ";
                if (children == null) throw new FilterException("Invalid PropertyIsLike operation: missing elements");
                if (children.size() != 2) {
                    throw new FilterException("PropertyIsLike comparison operation must have propertyName and Literal");
                }
                Expression ex1 = new Expression((XmlElement)children.get(0));
                Expression ex2 = new Expression((XmlElement)children.get(1));
                if (ex1.propertyName != null) {
                    this.firstExpression = ex1;
                } else {
                    if (ex2.propertyName == null) throw new FilterException("PropertyIsLike comparison operation must have propertyName");
                    this.firstExpression = ex2;
                }
                if (ex1.literal != null) {
                    this.secondExpression = ex1;
                } else {
                    if (ex2.literal == null) throw new FilterException("PropertyIsLike comparison operation must have Literal");
                    this.secondExpression = ex2;
                }
                String attr = root.getAttributeValue("wildCard");
                if (Strings.isNullOrBlank(attr)) {
                    throw new FilterException("Invalid PropertyIsLike operation: missing wildCard attribute");
                }
                this.wildCard = attr.charAt(0);
                attr = root.getAttributeValue("singleChar");
                if (Strings.isNullOrBlank(attr)) {
                    throw new FilterException("Invalid PropertyIsLike operation: missing singleChar attribute");
                }
                this.singleChar = attr.charAt(0);
                attr = root.getAttributeValue("escape");
                if (Strings.isNullOrBlank(attr)) throw new FilterException("Invalid PropertyIsLike operation: missing escape attribute");
                this.escapeChar = attr.charAt(0);
                return;
            }
            case 207: {
                Vector children = root.getChildren();
                if (children == null) return;
                if (children.size() != 1) {
                    throw new FilterException("PropertyIsNull comparison operation must have propertyName OR Literal");
                }
                Expression expr = new Expression((XmlElement)children.get(0));
                if (expr.propertyName == null && expr.literal == null) throw new FilterException("PropertyIsNull comparison operation must have propertyName OR Literal");
                this.firstExpression = expr;
                return;
            }
            case 208: {
                Vector children;
                Vector xmlBetween = root.getChildren();
                if (xmlBetween == null) {
                    throw new FilterException("Invalid PropertyIsBetween: missing elements");
                }
                XmlElement xmlBound = root.getFirstElementByName("LowerBoundary");
                if (xmlBound != null) {
                    children = xmlBound.getChildren();
                    if (children == null || children.size() != 1) throw new FilterException("Invalid lowerBoundary");
                    this.lowerBound = new Expression((XmlElement)children.get(0));
                }
                xmlBetween.remove(xmlBound);
                xmlBound = root.getFirstElementByName("UpperBoundary");
                if (xmlBound != null) {
                    children = xmlBound.getChildren();
                    if (children == null || children.size() != 1) throw new FilterException("Invalid upperBoundary");
                    this.upperBound = new Expression((XmlElement)children.get(0));
                }
                xmlBetween.remove(xmlBound);
                if (xmlBetween.size() != 1) throw new FilterException("Invalid PropertyIsBetween: missing expression element");
                this.firstExpression = new Expression((XmlElement)xmlBetween.get(0));
                return;
            }
            default: {
                throw new FilterException("The specified operation type does not correspond to a comparison operation. Please refer to developers.");
            }
        }
    }

    private StringBuffer binaryOpToSQL() throws FilterException {
        StringBuffer result = new StringBuffer();
        result.append(this.firstExpression.constructSQL());
        switch (this.type) {
            case 200: 
            case 201: {
                result.append(" = ");
                break;
            }
            case 202: {
                result.append(" < ");
                break;
            }
            case 203: {
                result.append(" > ");
                break;
            }
            case 204: {
                result.append(" <= ");
                break;
            }
            case 205: {
                result.append(" >= ");
                break;
            }
            default: {
                throw new FilterException("The specified operation is not a binary operation. Please refer to developers.");
            }
        }
        result.append(this.secondExpression.constructSQL());
        return result;
    }

    public StringBuffer constructSQL() throws FilterException {
        StringBuffer result = new StringBuffer("(");
        switch (this.type) {
            case 201: {
                result.append("NOT(");
                result.append(this.binaryOpToSQL());
                result.append(")");
                break;
            }
            case 200: 
            case 202: 
            case 203: 
            case 204: 
            case 205: {
                result.append(this.binaryOpToSQL());
                break;
            }
            case 206: {
                boolean escapeMode = false;
                String likeExpr = this.secondExpression.literal;
                int length = likeExpr.length();
                result.append(this.firstExpression.propertyName);
                result.append(" LIKE '");
                for (int i = 0; i < length; ++i) {
                    char likeChar = likeExpr.charAt(i);
                    if (escapeMode) {
                        if (likeChar == '\'') {
                            result.append("'");
                        } else if (likeChar == '\\') {
                            result.append("\\\\");
                        } else {
                            result.append(likeChar);
                        }
                        escapeMode = false;
                        continue;
                    }
                    if (likeChar == this.escapeChar) {
                        escapeMode = true;
                        continue;
                    }
                    if (likeChar == this.wildCard) {
                        result.append('%');
                        continue;
                    }
                    if (likeChar == this.singleChar) {
                        result.append('_');
                        continue;
                    }
                    if (likeChar == '\'') {
                        result.append("$'$");
                        continue;
                    }
                    if (likeChar == '%') {
                        result.append("$%$");
                        continue;
                    }
                    if (likeChar == '\\') {
                        result.append("\\\\");
                        continue;
                    }
                    result.append(likeChar);
                }
                result.append("'");
                break;
            }
            case 207: {
                if (!Strings.isNullOrBlank(this.firstExpression.propertyName)) {
                    result.append(this.firstExpression.propertyName);
                    result.append(" IS NULL");
                    break;
                }
                if (Strings.isNullOrBlank(this.firstExpression.literal)) {
                    result.append("True");
                    break;
                }
                result.append("False");
                break;
            }
            case 208: {
                if (this.lowerBound == null || this.upperBound == null) {
                    throw new FilterException("Operation must contain boundaries");
                }
                StringBuffer sbExpr = this.firstExpression.constructSQL();
                result.append(this.lowerBound.constructSQL()).append(" <= ").append(sbExpr).append(" AND ").append(sbExpr).append(" <= ").append(this.upperBound.constructSQL());
                break;
            }
        }
        result.append(")");
        return result;
    }

    public XmlElement getXml() {
        XmlElement root = new XmlElement(this.name);
        if (this.escapeChar != '\u0000') {
            root.addAttribute("escape", String.valueOf(this.escapeChar));
        }
        if (this.wildCard != '\u0000') {
            root.addAttribute("wildCard", String.valueOf(this.wildCard));
        }
        if (this.singleChar != '\u0000') {
            root.addAttribute("singleChar", String.valueOf(this.singleChar));
        }
        if (this.firstExpression != null) {
            root.addChild(this.firstExpression.getXml());
        }
        if (this.secondExpression != null) {
            root.addChild(this.secondExpression.getXml());
        }
        if (this.lowerBound != null) {
            XmlElement xmlLowBound = new XmlElement("LowerBoundary");
            xmlLowBound.addChild(this.lowerBound.getXml());
            root.addChild(xmlLowBound);
        }
        if (this.upperBound != null) {
            XmlElement xmlUpBound = new XmlElement("UpperBoundary");
            xmlUpBound.addChild(this.upperBound.getXml());
            root.addChild(xmlUpBound);
        }
        return root;
    }
}

