/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Vector;
import org.alov.map.Brackets;
import org.alov.map.ConstValue;
import org.alov.map.FieldRef;
import org.alov.map.Operation;
import org.alov.map.ParsedExpression;
import org.alov.map.Record;
import org.alov.map.Value;

class ValueParser {
    private static final String _INVALID_OPERATION2 = "Invalid operation";

    ValueParser() {
    }

    private static Value applyOperation(Value val1, Operation op, Value val2, Record rec) {
        Object result;
        Object obj1 = null;
        Object obj2 = null;
        Operation currentOp = op;
        if (13 == currentOp.op || 14 == currentOp.op) {
            boolean b = false;
            try {
                b = null != val2.getValue(rec);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            if (13 == currentOp.op) {
                val2.invert = !val2.invert;
            }
            return val2;
        }
        try {
            obj1 = val1.getValue(rec);
            obj2 = val2.getValue(rec);
        }
        catch (Exception e) {
            // empty catch block
        }
        int opcode = currentOp.op;
        String _INVALID_OPERATION = "Invalid operation. " + obj1 + "," + obj2 + "," + opcode;
        if (obj1 == null || obj2 == null) {
            boolean b;
            switch (opcode) {
                case 10: 
                case 12: {
                    b = obj1 == null && obj2 == null;
                    break;
                }
                case 11: {
                    b = obj1 != null || obj2 != null;
                    break;
                }
                default: {
                    b = false;
                    System.out.println(_INVALID_OPERATION);
                }
            }
            result = new Boolean(b);
        } else if (obj1 instanceof Boolean) {
            boolean b1 = (Boolean)obj1;
            boolean b2 = (Boolean)obj2;
            switch (opcode) {
                case 4: {
                    b1 = b1 || b2;
                    break;
                }
                case 5: {
                    b1 = b1 && b2;
                    break;
                }
                case 10: 
                case 12: {
                    b1 = b1 == b2;
                    break;
                }
                case 11: {
                    b1 = b1 != b2;
                    break;
                }
                default: {
                    b1 = false;
                    System.out.println(_INVALID_OPERATION);
                }
            }
            result = new Boolean(b1);
        } else if (obj1 instanceof Number) {
            double d1 = ((Number)obj1).doubleValue();
            double d2 = ((Number)obj2).doubleValue();
            switch (opcode) {
                case 0: {
                    d1 += d2;
                    break;
                }
                case 1: {
                    d1 -= d2;
                    break;
                }
                case 2: {
                    d1 *= d2;
                    break;
                }
                case 3: {
                    d1 /= d2;
                    break;
                }
                default: {
                    boolean b;
                    switch (opcode) {
                        case 6: {
                            b = d1 < d2;
                            break;
                        }
                        case 8: {
                            b = d1 <= d2;
                            break;
                        }
                        case 7: {
                            b = d1 > d2;
                            break;
                        }
                        case 9: {
                            b = d1 >= d2;
                            break;
                        }
                        case 10: 
                        case 12: {
                            b = d1 == d2;
                            break;
                        }
                        case 11: {
                            b = d1 != d2;
                            break;
                        }
                        default: {
                            b = false;
                            System.out.println(_INVALID_OPERATION);
                        }
                    }
                    return new ConstValue(new Boolean(b));
                }
            }
            result = new Double(d1);
        } else if (obj1 instanceof String) {
            String s1 = obj1.toString();
            String s2 = obj2.toString();
            switch (opcode) {
                case 0: {
                    s1 = s1 + s2;
                    break;
                }
                default: {
                    boolean b;
                    block29 : switch (opcode) {
                        case 6: {
                            b = s1.compareTo(s2) < 0;
                            break;
                        }
                        case 8: {
                            b = s1.compareTo(s2) <= 0;
                            break;
                        }
                        case 7: {
                            b = s1.compareTo(s2) > 0;
                            break;
                        }
                        case 9: {
                            b = s1.compareTo(s2) >= 0;
                            break;
                        }
                        case 10: {
                            b = s1.compareTo(s2) == 0;
                            break;
                        }
                        case 12: {
                            int m = 0;
                            if (s2.charAt(0) == '%') {
                                m = 1;
                                s2 = s2.substring(1);
                            }
                            if (s2.charAt(s2.length() - 1) == '%') {
                                m += 2;
                                s2 = s2.substring(0, s2.length() - 1);
                            }
                            s1 = s1.toUpperCase();
                            s2 = s2.toUpperCase();
                            switch (m) {
                                case 1: {
                                    b = s1.endsWith(s2);
                                    break block29;
                                }
                                case 2: {
                                    b = s1.startsWith(s2);
                                    break block29;
                                }
                            }
                            b = s1.indexOf(s2) >= 0;
                            break;
                        }
                        case 11: {
                            b = s1.compareTo(s2) != 0;
                            break;
                        }
                        default: {
                            b = false;
                            System.out.println(_INVALID_OPERATION);
                        }
                    }
                    return new ConstValue(new Boolean(b));
                }
            }
            result = s1;
        } else {
            System.out.println(_INVALID_OPERATION);
            result = new Boolean(false);
        }
        return new ConstValue(result);
    }

    static Value calculate(Vector expr, Record rec) throws Exception {
        Value currentVal = null;
        Operation currentOp = null;
        int count = expr.size();
        for (int i = 0; i < count; ++i) {
            Object o = expr.elementAt(i);
            if (o instanceof Operation) {
                currentOp = (Operation)o;
                continue;
            }
            Value val = (Value)o;
            if (currentVal == null && currentOp != null) {
                currentVal = new ConstValue(new Double(0.0));
            }
            currentVal = currentVal == null ? val : ValueParser.applyOperation(currentVal, currentOp, val, rec);
        }
        return currentVal;
    }

    static ParsedExpression parse(String s) throws IOException {
        ParsedExpression expr = ValueParser.parse(s, null);
        return expr;
    }

    private static ParsedExpression parse(String s, Hashtable refs) throws IOException {
        if (refs == null) {
            refs = new Hashtable<String, FieldRef>();
        }
        Vector<Serializable> resultVector = new Vector<Serializable>();
        StringReader reader = new StringReader(s);
        boolean stop = false;
        boolean dontReadChar = false;
        int intChar = 0;
        while (!stop) {
            char ch;
            if (!dontReadChar) {
                intChar = reader.read();
            } else {
                dontReadChar = false;
            }
            if (intChar < 0) {
                stop = true;
                ch = ' ';
            } else {
                ch = (char)intChar;
            }
            if (ch == '+' || ch == '-' || ch == '/' || ch == '*') {
                int opcode = 0;
                switch (ch) {
                    case '+': {
                        opcode = 0;
                        break;
                    }
                    case '-': {
                        opcode = 1;
                        break;
                    }
                    case '/': {
                        opcode = 3;
                        break;
                    }
                    case '*': {
                        opcode = 2;
                    }
                }
                Operation operation = new Operation();
                operation.op = opcode;
                resultVector.addElement(operation);
                continue;
            }
            if (ch == '=') {
                Operation op = new Operation();
                op.op = 10;
                resultVector.addElement(op);
                continue;
            }
            if (ch == '<') {
                int opcode = 6;
                intChar = reader.read();
                if (intChar >= 0) {
                    ch = (char)intChar;
                    if (ch == '=') {
                        opcode = 8;
                    } else if (ch == '>') {
                        opcode = 11;
                    } else {
                        dontReadChar = true;
                    }
                } else {
                    dontReadChar = true;
                }
                Operation operation = new Operation();
                operation.op = opcode;
                resultVector.addElement(operation);
                continue;
            }
            if (ch == '>') {
                int opcode = 7;
                intChar = reader.read();
                if (intChar >= 0) {
                    ch = (char)intChar;
                    if (ch == '=') {
                        opcode = 9;
                    } else {
                        dontReadChar = true;
                    }
                } else {
                    dontReadChar = true;
                }
                Operation operation = new Operation();
                operation.op = opcode;
                resultVector.addElement(operation);
                continue;
            }
            if (Character.isLetter(ch)) {
                Operation op;
                String name;
                dontReadChar = true;
                StringBuffer buf = new StringBuffer();
                while (Character.isLetter(ch) || Character.isDigit(ch) || ch == '_') {
                    buf.append(ch);
                    intChar = reader.read();
                    if (intChar < 0) break;
                    ch = (char)intChar;
                }
                if ("or".equalsIgnoreCase(name = buf.toString())) {
                    op = new Operation();
                    op.op = 4;
                    resultVector.addElement(op);
                    continue;
                }
                if ("and".equalsIgnoreCase(name)) {
                    op = new Operation();
                    op.op = 5;
                    resultVector.addElement(op);
                    continue;
                }
                if ("null".equalsIgnoreCase(name)) {
                    resultVector.addElement(new ConstValue(null));
                    continue;
                }
                if ("like".equalsIgnoreCase(name)) {
                    op = new Operation();
                    op.op = 12;
                    resultVector.addElement(op);
                    continue;
                }
                if ("not".equalsIgnoreCase(name)) {
                    op = new Operation();
                    op.op = 13;
                    resultVector.addElement(op);
                    continue;
                }
                FieldRef ref = (FieldRef)refs.get(name);
                if (ref == null) {
                    ref = new FieldRef();
                    ref.fieldName = buf.toString();
                    refs.put(name, ref);
                }
                resultVector.addElement(ref);
                continue;
            }
            if (ch == '\'') {
                boolean backSlash = false;
                StringBuffer buf = new StringBuffer();
                while (true) {
                    if ((intChar = reader.read()) < 0) {
                        dontReadChar = true;
                        break;
                    }
                    ch = (char)intChar;
                    if (backSlash) {
                        buf.append(ch);
                        backSlash = false;
                        continue;
                    }
                    if (ch == '\'') break;
                    if (ch == '\\') {
                        backSlash = true;
                        continue;
                    }
                    buf.append(ch);
                }
                resultVector.addElement(new ConstValue(buf.toString()));
                continue;
            }
            if (ch == '(') {
                int recursion = 1;
                StringBuffer buf = new StringBuffer();
                while (true) {
                    if ((intChar = reader.read()) < 0) {
                        dontReadChar = true;
                        break;
                    }
                    ch = (char)intChar;
                    if (ch == ')' && --recursion == 0) break;
                    buf.append(ch);
                    if (ch != 40) continue;
                    ++recursion;
                }
                ParsedExpression expr2 = ValueParser.parse(buf.toString(), refs);
                Brackets brackets = new Brackets(expr2.expr);
                resultVector.addElement(brackets);
                continue;
            }
            if (!Character.isDigit(ch)) continue;
            dontReadChar = true;
            StringBuffer buf = new StringBuffer();
            buf.append(ch);
            boolean wasPoint = false;
            while ((intChar = reader.read()) >= 0 && (Character.isDigit(ch = (char)intChar) || ch == '.' && !wasPoint)) {
                buf.append(ch);
                if (ch != 46) continue;
                wasPoint = true;
            }
            resultVector.addElement(new ConstValue(Double.valueOf(buf.toString())));
        }
        if (resultVector.size() > 0) {
            Object o = resultVector.elementAt(0);
            if (o instanceof Operation) {
                Operation op = (Operation)o;
                if (op.op == 0 || op.op == 1) {
                    resultVector.insertElementAt(new ConstValue(new Double(0.0)), 0);
                }
            }
            ParsedExpression expr = new ParsedExpression();
            expr.expr = ValueParser.preprocess(resultVector);
            expr.fieldRefs = refs;
            return expr;
        }
        return null;
    }

    private static Vector preprocess(Vector expr) {
        int i;
        int count = expr.size();
        if (count <= 2) {
            return expr;
        }
        Vector<Serializable> result = new Vector<Serializable>();
        int written = -1;
        int priority = -1;
        boolean first = true;
        boolean searching = false;
        int firstValueIndex = -1;
        int lastValueIndex = -1;
        for (i = 0; i < count; ++i) {
            Object obj = expr.elementAt(i);
            if (obj instanceof Operation) {
                Operation op = (Operation)obj;
                int opPriority = Operation.PRIORITIES[op.op];
                if (searching) {
                    if (opPriority > priority) continue;
                    Vector internalExpr = new Vector(lastValueIndex - firstValueIndex + 1);
                    for (int j = firstValueIndex; j <= lastValueIndex; ++j) {
                        internalExpr.addElement(expr.elementAt(j));
                    }
                    internalExpr = ValueParser.preprocess(internalExpr);
                    Brackets brackets = new Brackets(internalExpr);
                    result.addElement(brackets);
                    result.addElement(op);
                    written = i;
                    searching = false;
                    continue;
                }
                if (first) {
                    priority = opPriority;
                    first = false;
                }
                if (opPriority > priority) {
                    searching = true;
                    continue;
                }
                for (int j = written + 1; j <= i; ++j) {
                    result.addElement((Serializable)expr.elementAt(j));
                }
                written = i;
                continue;
            }
            if (!searching) {
                firstValueIndex = i;
                continue;
            }
            lastValueIndex = i;
        }
        if (searching) {
            Vector internalExpr = new Vector(count - firstValueIndex);
            for (int i2 = firstValueIndex; i2 < count; ++i2) {
                internalExpr.addElement(expr.elementAt(i2));
            }
            internalExpr = ValueParser.preprocess(internalExpr);
            Brackets brackets = new Brackets(internalExpr);
            result.addElement(brackets);
        } else {
            for (i = written + 1; i < count; ++i) {
                result.addElement((Serializable)expr.elementAt(i));
            }
        }
        return result;
    }
}

