/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import org.alov.map.MapUtils;
import org.alov.map.Projection;
import org.alov.map.Shape;
import org.alov.map.Symbol;

public class Utils2D {
    private static boolean have2d;
    private Graphics graphics;
    private static Method setStroke;
    private static Method setPaint;
    private static Method setComposite;
    private static Method setTransform;
    private static Method getStroke;
    private static Method getPaint;
    private static Method getComposite;
    private static Method getTransform;
    private static Method setRenderingHint;
    private static Method rotate;
    private static Method createCustomCursor;
    private static Class graphics2dClass;
    private static Class renderingHintsClass;
    private static Object[] oneArgument;
    private static Method deriveFont;

    private Utils2D() {
    }

    public static boolean have2d() {
        return have2d;
    }

    static void setRenderingHint(Graphics g, String hintName, String hintValue) {
        if (setRenderingHint == null || renderingHintsClass == null) {
            return;
        }
        try {
            Object hintKey = renderingHintsClass.getField(hintName).get(null);
            Object hintValueObject = renderingHintsClass.getField(hintValue).get(null);
            setRenderingHint.invoke((Object)g, hintKey, hintValueObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static synchronized void setStroke(Graphics g, Object stroke) {
        if (setStroke == null) {
            return;
        }
        Utils2D.oneArgument[0] = stroke;
        try {
            setStroke.invoke((Object)g, oneArgument);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static synchronized void setComposite(Graphics g, Object composite) {
        if (setComposite == null) {
            return;
        }
        Utils2D.oneArgument[0] = composite;
        try {
            setComposite.invoke((Object)g, oneArgument);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized void setTransform(Graphics g, Object composite) {
        if (setTransform == null) {
            return;
        }
        Utils2D.oneArgument[0] = composite;
        try {
            setTransform.invoke((Object)g, oneArgument);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static synchronized void setPaint(Graphics g, Object paint) {
        if (setPaint == null) {
            return;
        }
        Utils2D.oneArgument[0] = paint;
        try {
            setPaint.invoke((Object)g, oneArgument);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Object getStroke(Graphics g) {
        if (getStroke == null) {
            return null;
        }
        try {
            return getStroke.invoke((Object)g, null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Object getComposite(Graphics g) {
        if (getComposite == null) {
            return null;
        }
        try {
            return getComposite.invoke((Object)g, null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object getTransform(Graphics g) {
        if (getTransform == null) {
            return null;
        }
        try {
            return getTransform.invoke((Object)g, null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Object getPaint(Graphics g) {
        if (getPaint == null) {
            return null;
        }
        try {
            return getPaint.invoke((Object)g, null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static void drawStringRotated(Graphics g, String s, int x, int y, double rx, double ry, double angle) {
        Object trans = null;
        if (angle != 0.0) {
            trans = Utils2D.getTransform(g);
            AffineTransform rot = AffineTransform.getRotateInstance(rx, ry, angle);
            Utils2D.setTransform(g, rot);
        }
        g.drawString(s, x, y);
        if (trans != null) {
            Utils2D.setTransform(g, trans);
        }
    }

    public static void rotateGraphics(Graphics g, double x, double y, double angle) {
        if (have2d) {
            Utils2D.do_rotate(g, x, y, angle);
        }
    }

    private static void do_rotate(Graphics g, double x, double y, double angle) {
        if (rotate != null) {
            try {
                Object trans = Utils2D.getTransform(g);
                rotate.invoke(trans, new Double(angle), new Double(x), new Double(y));
                Utils2D.setTransform(g, trans);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    static void polygon(Graphics g, int[] xCoords, int[] yCoords, int ptCount, Symbol sym) {
        Object oldStroke = Utils2D.getStroke(g);
        Object oldPaint = Utils2D.getPaint(g);
        Object oldComposite = Utils2D.getComposite(g);
        if (sym.fill) {
            if (sym.g2dPaint != null) {
                Utils2D.setPaint(g, sym.g2dPaint);
            } else {
                g.setColor(sym.fillColor);
            }
            if (sym.g2dPaintComposite != null) {
                Utils2D.setComposite(g, sym.g2dPaintComposite);
            }
            g.fillPolygon(xCoords, yCoords, ptCount);
        }
        if (sym.outline) {
            if (sym.g2dStrokeComposite != null) {
                Utils2D.setComposite(g, sym.g2dStrokeComposite);
            }
            if (MapUtils.isNotEmpty(sym.g2dStroke)) {
                int cnt = sym.g2dStroke.size();
                for (int i = 0; i < cnt; ++i) {
                    Utils2D.setStroke(g, sym.g2dStroke.elementAt(i));
                    g.setColor((Color)sym.g2dStrokeColours.elementAt(i));
                    g.drawPolygon(xCoords, yCoords, ptCount);
                }
            } else {
                g.setColor(sym.outlineColor);
                g.drawPolygon(xCoords, yCoords, ptCount);
            }
        }
        Utils2D.setStroke(g, oldStroke);
        Utils2D.setPaint(g, oldPaint);
        Utils2D.setComposite(g, oldComposite);
    }

    static void line(Graphics g, int[] xCoords, int[] yCoords, int ptCount, Symbol sym) {
        if (sym.outline) {
            Object oldStroke = null;
            Object oldComposite = null;
            if (sym.g2dStrokeComposite != null) {
                oldComposite = Utils2D.getComposite(g);
                Utils2D.setComposite(g, sym.g2dStrokeComposite);
            }
            if (MapUtils.isNotEmpty(sym.g2dStroke)) {
                oldStroke = Utils2D.getStroke(g);
                for (int i = 0; i < sym.g2dStroke.size(); ++i) {
                    Utils2D.setStroke(g, sym.g2dStroke.elementAt(i));
                    g.setColor((Color)sym.g2dStrokeColours.elementAt(i));
                    g.drawPolyline(xCoords, yCoords, ptCount);
                }
            } else {
                g.setColor(sym.outlineColor);
                g.drawPolyline(xCoords, yCoords, ptCount);
            }
            Utils2D.setStroke(g, oldStroke);
            Utils2D.setComposite(g, oldComposite);
        }
    }

    static void textAlongLine(Graphics g, Shape shp, String text, Projection prj, Symbol sym, Dimension extent) {
        Utils2D.textAlongLine(g, shp, text, prj, sym, extent, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void textAlongLine(Graphics g, Shape shp, String text, Projection prj, Symbol sym, Dimension extent, boolean checkBounds) {
        int startLetter;
        int deltaLetter;
        int charSize;
        if (text == null || shp == null || shp.xCoords == null) {
            return;
        }
        double[] xCoords = shp.xCoords;
        int ptCount = xCoords.length;
        if (ptCount < 2) {
            return;
        }
        int textLength = text.length();
        if (textLength <= 0) {
            return;
        }
        char[] ch = new char[textLength];
        int[] lx = new int[textLength];
        int[] ly = new int[textLength];
        double[] angles = new double[textLength];
        float[] centerX = new float[textLength];
        float[] centerY = new float[textLength];
        int lindex = 0;
        int maxX = extent.width;
        int maxY = extent.height;
        double[] yCoords = shp.yCoords;
        int[] xs = new int[ptCount];
        int[] ys = new int[ptCount];
        for (int i = 0; i < ptCount; ++i) {
            int x = (int)((xCoords[i] + prj.shift.x) * prj.zoom);
            int y = (int)((-yCoords[i] + prj.shift.y) * prj.zoom);
            xs[i] = x;
            ys[i] = y;
        }
        FontMetrics fm = g.getFontMetrics();
        int charHeight = fm.getAscent() + fm.getLeading();
        char[] chars = new char[textLength];
        int[] charWidths = new int[textLength];
        int maxCharWidth = 0;
        for (int i = 0; i < textLength; ++i) {
            int cw;
            chars[i] = text.charAt(i);
            charWidths[i] = cw = fm.charWidth(chars[i]);
            if (maxCharWidth >= cw) continue;
            maxCharWidth = cw;
        }
        int n = charSize = charHeight > maxCharWidth ? charHeight : maxCharWidth;
        if (charSize <= 0) {
            return;
        }
        int e_ind = 0;
        int y_add = 0;
        double t_len = 0.0;
        double s_p = 0.0;
        for (int i = 0; i < ptCount - 1; ++i) {
            t_len += Math.sqrt((xs[i + 1] - xs[i]) * (xs[i + 1] - xs[i]) + (ys[i + 1] - ys[i]) * (ys[i + 1] - ys[i]));
        }
        switch (sym.position) {
            case 0: 
            case 4: 
            case 8: {
                s_p = (t_len - (double)(textLength * charSize)) / 2.0;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                s_p = t_len - (double)((textLength + 1) * charSize);
            }
        }
        if (s_p > 0.0 || !checkBounds) {
            for (int i = 0; i < ptCount - 1; ++i) {
                double e_len = Math.sqrt((xs[i + 1] - xs[i]) * (xs[i + 1] - xs[i]) + (ys[i + 1] - ys[i]) * (ys[i + 1] - ys[i]));
                if (s_p > e_len) {
                    s_p -= e_len;
                    continue;
                }
                e_ind = i;
                if (e_len == 0.0) continue;
                double k = s_p / e_len;
                int n2 = i;
                xs[n2] = (int)((double)xs[n2] + (double)(xs[i + 1] - xs[i]) * k);
                int n3 = i;
                ys[n3] = (int)((double)ys[n3] + (double)(ys[i + 1] - ys[i]) * k);
                break;
            }
        }
        switch (sym.position) {
            case 1: 
            case 7: 
            case 8: {
                y_add = -charHeight / 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                y_add = charHeight / 2;
            }
        }
        if (xs[e_ind] > xs[e_ind + 1]) {
            deltaLetter = -1;
            startLetter = textLength - 1;
        } else {
            deltaLetter = 1;
            startLetter = 0;
        }
        int curLetter = startLetter;
        Color c1 = sym.outline ? sym.outlineColor : null;
        Color c2 = sym.fillColor;
        Object oldTransform = Utils2D.getTransform(g);
        try {
            boolean output = false;
            float segCharCount = 0.0f;
            float segmentRemainder = 0.0f;
            for (int i = e_ind; i < ptCount - 1; ++i) {
                float dy1;
                float dx1;
                int x0 = xs[i];
                int y0 = ys[i];
                float dx = xs[i + 1] - x0;
                float dy = ys[i + 1] - y0;
                float nx = Math.abs(dx) / (float)charSize;
                float ny = Math.abs(dy) / (float)charSize;
                segCharCount = segmentRemainder;
                if (nx > ny) {
                    dx1 = dx / nx;
                    dy1 = dy / nx;
                    segCharCount += nx;
                } else {
                    dx1 = dx / ny;
                    dy1 = dy / ny;
                    segCharCount += ny;
                }
                double angle = Math.atan2(yCoords[i] - yCoords[i + 1], xCoords[i + 1] - xCoords[i]);
                int nSegCharCount = (int)segCharCount;
                float prevRemainder = segmentRemainder;
                segmentRemainder = segCharCount - (float)nSegCharCount;
                for (int j = 0; j < nSegCharCount; ++j) {
                    float x = (float)x0 + dx1 * ((float)j + 0.5f - prevRemainder);
                    float y = (float)y0 + (float)y_add + dy1 * ((float)j + 0.5f - prevRemainder);
                    if (!checkBounds || x > 0.0f && (maxX == 0 || x < (float)maxX) && y > 0.0f && (maxY == 0 || y < (float)maxY)) {
                        if (!output) {
                            curLetter = startLetter;
                            output = true;
                        }
                        centerX[lindex] = x;
                        centerY[lindex] = y;
                        lx[lindex] = (int)(x - (float)(charWidths[curLetter] / 2));
                        ly[lindex] = (int)((double)y + (double)charHeight * 0.3);
                        ch[lindex] = chars[curLetter];
                        angles[lindex] = angle;
                        if ((curLetter += deltaLetter) >= textLength) {
                            curLetter = 0;
                        } else if (curLetter < 0) {
                            curLetter = textLength - 1;
                        }
                        if (++lindex < textLength) continue;
                        for (int k = 0; k < lindex; ++k) {
                            AffineTransform transform = new AffineTransform();
                            if (deltaLetter < 0) {
                                transform.scale(-1.0, -1.0);
                                transform.translate(-centerX[k] * 2.0f, -centerY[k] * 2.0f);
                            }
                            transform.rotate(angles[k], centerX[k], centerY[k]);
                            Utils2D.setTransform(g, transform);
                            if (c1 != null) {
                                g.setColor(c1);
                                g.drawChars(ch, k, 1, lx[k] + 1, ly[k] + 1);
                            }
                            g.setColor(c2);
                            g.drawChars(ch, k, 1, lx[k], ly[k]);
                        }
                        return;
                    }
                    output = false;
                }
            }
        }
        finally {
            Utils2D.setTransform(g, oldTransform);
        }
    }

    public static Cursor createCursor(Image img, String name) throws Exception {
        Cursor cr = null;
        if (img != null) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            Point hotSpot = new Point(1, 1);
            cr = (Cursor)createCustomCursor.invoke((Object)tk, img, hotSpot, name);
        }
        return cr;
    }

    public static Font createTTF(Font font, int style, float size) throws Exception {
        Font fontRes = null;
        if (font != null) {
            fontRes = (Font)deriveFont.invoke((Object)font, new Integer(style), new Float(size));
        }
        return fontRes;
    }

    static {
        int verS;
        have2d = false;
        setStroke = null;
        setPaint = null;
        setComposite = null;
        setTransform = null;
        getStroke = null;
        getPaint = null;
        getComposite = null;
        getTransform = null;
        setRenderingHint = null;
        rotate = null;
        createCustomCursor = null;
        graphics2dClass = null;
        renderingHintsClass = null;
        oneArgument = new Object[1];
        deriveFont = null;
        String sV = System.getProperty("java.version");
        System.out.println("Java v." + sV);
        StringTokenizer st = new StringTokenizer(sV, ".");
        int verM = st.hasMoreTokens() ? Integer.parseInt(st.nextToken()) : 1;
        int n = verS = st.hasMoreTokens() ? Integer.parseInt(st.nextToken()) : 3;
        if (verM > 1 || verS > 2) {
            try {
                graphics2dClass = Class.forName("java.awt.Graphics2D");
                renderingHintsClass = Class.forName("java.awt.RenderingHints");
                Class<?> paintClass = Class.forName("java.awt.Paint");
                Class<?> strokeClass = Class.forName("java.awt.Stroke");
                Class<?> compositeClass = Class.forName("java.awt.Composite");
                Class<?> transformClass = Class.forName("java.awt.geom.AffineTransform");
                Class[] args = new Class[]{strokeClass};
                setStroke = graphics2dClass.getMethod("setStroke", args);
                args[0] = paintClass;
                setPaint = graphics2dClass.getMethod("setPaint", args);
                args[0] = compositeClass;
                setComposite = graphics2dClass.getMethod("setComposite", args);
                args[0] = transformClass;
                setTransform = graphics2dClass.getMethod("setTransform", args);
                getStroke = graphics2dClass.getMethod("getStroke", null);
                getPaint = graphics2dClass.getMethod("getPaint", null);
                getComposite = graphics2dClass.getMethod("getComposite", null);
                getTransform = graphics2dClass.getMethod("getTransform", null);
                Class<?> renderingHintKey = Class.forName("java.awt.RenderingHints$Key");
                setRenderingHint = graphics2dClass.getMethod("setRenderingHint", renderingHintKey, new Object().getClass());
                Method[] methods = transformClass.getMethods();
                int count = methods.length;
                for (int i = 0; i < count; ++i) {
                    Class<?>[] params;
                    Method m = methods[i];
                    if (!"rotate".equals(m.getName()) || (params = m.getParameterTypes()) == null || params.length != 3) continue;
                    rotate = m;
                    break;
                }
                Class<?> toolkit = Class.forName("java.awt.Toolkit");
                Class<?> image = Class.forName("java.awt.Image");
                createCustomCursor = toolkit.getMethod("createCustomCursor", image, new Point().getClass(), new String().getClass());
                Class<?> fontClass = Class.forName("java.awt.Font");
                deriveFont = fontClass.getMethod("deriveFont", Integer.TYPE, Float.TYPE);
                have2d = true;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

