/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Vector;
import org.alov.map.Carte;
import org.alov.map.FilterExpression;
import org.alov.map.Layer;
import org.alov.map.Load2D;
import org.alov.map.MapUtils;
import org.alov.map.Shape;
import org.alov.util.Log;
import org.alov.util.Strings;

public class Symbol
implements Serializable {
    public int style = 0;
    public boolean drawMarker = false;
    public boolean fill;
    public boolean outline;
    public Color fillColor;
    public Color outlineColor;
    public int size = 0;
    public int minSize;
    public int maxSize;
    public boolean useZoom = false;
    public int step = 20;
    public int align = 2;
    public int position = 1;
    public int xOffset = 0;
    public int yOffset = 0;
    public boolean legendVisible = true;
    public boolean visible = true;
    public Object value = null;
    public String valueStr;
    public String label;
    public String imageUrl = null;
    public String fontName = null;
    public Font font = null;
    public int fontStyle = 0;
    public String charMarker = null;
    public Dimension sampleSize = new Dimension(0, 0);
    public Font sampleFont = null;
    public String rotationFieldName = null;
    public String sizeFieldName = null;
    protected int rotationFieldIndex = -1;
    protected int sizeFieldIndex = -1;
    protected float factor = 1.0f;
    public float rotation = 0.0f;
    public transient Image image = null;
    public transient Image imageOriginal = null;
    public boolean imageAnimated = false;
    public int imageAnimationDelay = 1000;
    public double offsetMin = 0.0;
    public double offsetMax = 0.0;
    protected Shape symbolShape = null;
    int SymType;
    Rectangle textureAnchor = null;
    String textureUrl = null;
    transient Object g2dPaint = null;
    transient Vector g2dStroke = null;
    transient Vector g2dStrokeColours = null;
    transient Object g2dPaintComposite = null;
    transient Object g2dStrokeComposite = null;

    public Symbol() {
        this(Color.white, Color.black, true, true, 1);
    }

    public Symbol(Color fillColor, Color outlineColor, boolean bFill, boolean bLine, int size) {
        this.fillColor = fillColor;
        this.outlineColor = outlineColor;
        this.fill = bFill;
        this.outline = bLine;
        this.size = size;
    }

    public void setValue(String strValue, int type, Layer layer) throws Exception {
        if (layer != null && type < 0) {
            this.value = new FilterExpression(strValue, layer);
            if (this.label == null) {
                this.label = this.valueStr;
            }
        } else if (type > 0) {
            this.value = Strings.strToObject(strValue, type);
        }
    }

    public Color getColor(String strValue) throws Exception {
        return (Color)Strings.strToObject(strValue, 1004);
    }

    protected void prepare(Layer layer) throws Exception {
        this.rotationFieldIndex = layer.getFieldIndex(this.rotationFieldName);
        this.sizeFieldIndex = layer.getFieldIndex(this.sizeFieldName);
        if (this.rotationFieldName != null && this.rotationFieldIndex < 0) {
            throw new Exception("  Symbol: " + this.label + "  " + this.rotationFieldName);
        }
        if (this.sizeFieldName != null && this.sizeFieldIndex < 0) {
            throw new Exception("  Symbol: " + this.label + "  " + this.sizeFieldName);
        }
    }

    protected void loadSymbolImages(Layer layer) {
        block12: {
            if (this.imageUrl != null) {
                try {
                    this.imageOriginal = this.image = MapUtils.loadImage2(layer, this.imageUrl);
                    try {
                        Method method = this.fillColor.getClass().getMethod("getAlpha", null);
                        Integer alphaInt = (Integer)method.invoke((Object)this.fillColor, null);
                        int alpha = alphaInt;
                        if (alpha < 255) {
                            this.image = MapUtils.makeColorTransparent(this.imageOriginal, null, 255 - alpha);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    if (layer != null && layer.parentMap instanceof Carte) {
                        Log.addMessage(306, "Map", layer, "Can't load raster image " + this.imageUrl + "  " + e.getMessage());
                    }
                    System.out.println("Can't load image " + this.imageUrl);
                    e.printStackTrace();
                }
            }
            if (this.textureUrl != null) {
                try {
                    Image imageTexture = MapUtils.loadImage2(layer, this.textureUrl);
                    int imgWidth = imageTexture.getWidth(null);
                    int imgHeight = imageTexture.getHeight(null);
                    if (this.textureAnchor == null) {
                        this.textureAnchor = imgWidth > 0 && imgHeight > 0 ? new Rectangle(0, 0, imgWidth - 1, imgHeight - 1) : new Rectangle(0, 0, 8, 8);
                    }
                    this.g2dPaint = Load2D.getTexturePaint(imageTexture, imgWidth, imgHeight, this.textureAnchor);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (layer == null) break block12;
                    Log.addMessage(306, "Map", layer, "Can't load raster image " + this.textureUrl + "  " + e.getMessage());
                }
            }
        }
    }

    public static void setTransparency(Symbol symbol, int alpha) {
        try {
            Class<?> colorClass = symbol.outlineColor.getClass();
            Class<Integer> intClass = Integer.TYPE;
            Constructor<?> colorConstructor = colorClass.getConstructor(intClass, intClass, intClass, intClass);
            Color color = symbol.outlineColor;
            symbol.outlineColor = (Color)colorConstructor.newInstance(new Integer(color.getRed()), new Integer(color.getGreen()), new Integer(color.getBlue()), new Integer(alpha));
            color = symbol.fillColor;
            symbol.fillColor = (Color)colorConstructor.newInstance(new Integer(color.getRed()), new Integer(color.getGreen()), new Integer(color.getBlue()), new Integer(alpha));
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (symbol.image != null) {
            try {
                symbol.image = MapUtils.makeColorTransparent(symbol.imageOriginal, null, 255 - alpha);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (symbol.g2dPaint != null) {
            symbol.g2dPaintComposite = Load2D.getAlphaComposite(null, (float)alpha / 255.0f);
        }
        if (symbol.g2dPaint != null || symbol.g2dStroke != null) {
            symbol.g2dStrokeComposite = Load2D.getAlphaComposite(null, (float)alpha / 255.0f);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.loadSymbolImages(null);
    }
}

