/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.util.Vector;
import org.alov.map.SLD_Const;
import org.alov.map.SLD_CssParam;
import org.alov.map.SLD_Fill;
import org.alov.map.SLD_Loader;
import org.alov.map.SLD_Symbolizer;
import org.alov.map.Symbol;
import org.alov.ogcfilter.Expression;
import org.alov.util.AlovMapException;
import org.alov.util.XmlElement;

class SLD_TextSymbolizer
implements SLD_Const,
SLD_Symbolizer {
    static final int PL_UNKNOWN = -1;
    static final int PL_POINT = 0;
    static final int PL_LINE = 1;
    String geometry = null;
    Expression label = null;
    Vector font = new Vector();
    boolean halo = false;
    SLD_Fill fill = null;
    SLD_Fill halo_fill = null;
    int pl_type = -1;
    Expression apX = null;
    Expression apY = null;
    Expression dX = null;
    Expression dY = null;
    Expression rotation = null;
    Expression offset = null;

    SLD_TextSymbolizer(XmlElement root) throws AlovMapException {
        this.geometry = SLD_Loader.loadGeometry(root);
        this.label = SLD_Loader.loadExpression("Label", root);
        XmlElement el = root.getFirstElementByName("Font");
        if (el != null) {
            Vector v = el.getElementsByTagName("CssParameter");
            for (int i = 0; i < v.size(); ++i) {
                this.font.addElement(new SLD_CssParam((XmlElement)v.elementAt(i)));
            }
        }
        if ((this.halo = (el = root.getFirstElementByName("Halo")) != null) && (el = el.getFirstElementByName("Fill")) != null) {
            this.halo_fill = new SLD_Fill(el);
        }
        if ((el = root.getFirstElementByName("Fill")) != null) {
            this.fill = new SLD_Fill(el);
        }
        if ((el = root.getFirstElementByName("LabelPlacement")) != null) {
            XmlElement el2 = el.getFirstElementByName("PointPlacement");
            if (el2 != null) {
                el = el2.getFirstElementByName("AnchorPoint");
                if (el != null) {
                    this.apX = SLD_Loader.loadExpression("AnchorPointX", el);
                    this.apY = SLD_Loader.loadExpression("AnchorPointY", el);
                }
                if ((el = el2.getFirstElementByName("Displacement")) != null) {
                    this.dX = SLD_Loader.loadExpression("DisplacementX", el);
                    this.dY = SLD_Loader.loadExpression("DisplacementY", el);
                }
                if ((el = el2.getFirstElementByName("Rotation")) != null) {
                    this.rotation = SLD_Loader.loadExpression("Rotation", el2);
                }
            } else {
                el2 = el.getFirstElementByName("LinePlacement");
                if (el2 != null) {
                    el = el2.getFirstElementByName("PerpendicularOffset");
                    if (el != null) {
                        this.offset = SLD_Loader.loadExpression("PerpendicularOffset", el2);
                    }
                } else {
                    throw new AlovMapException(312, "Invalid label placement");
                }
            }
        }
    }

    public Symbol transform() {
        Symbol sym = new Symbol();
        boolean bl = sym.fill = this.fill != null;
        if (sym.fill) {
            sym.fillColor = this.fill.getFillColor();
        }
        sym.outline = this.halo;
        if (this.halo_fill != null) {
            sym.outlineColor = this.halo_fill.getFillColor();
        }
        sym.align = this.pl_type == 1 ? 1 : 0;
        if (this.apX != null && this.apY != null) {
            float a_x = 0.0f;
            float a_y = 0.5f;
            try {
                a_x = Float.valueOf(this.apX.literal).floatValue();
                a_y = Float.valueOf(this.apY.literal).floatValue();
            }
            catch (Exception e) {
                // empty catch block
            }
            a_x = Math.round(a_x - 0.5f) + 1;
            a_y = Math.round(a_y - 0.5f) + 1;
            int[][] snail = new int[][]{{7, 8, 1}, {6, 0, 2}, {5, 4, 3}};
            sym.position = snail[(int)a_x][(int)a_y];
        }
        this.setFont(sym);
        return sym;
    }

    void setFont(Symbol sym) {
        for (int i = 0; i < this.font.size(); ++i) {
            String s;
            SLD_CssParam par = (SLD_CssParam)this.font.elementAt(i);
            if (par.name.equalsIgnoreCase("font-family")) {
                sym.fontName = par.value.literal;
                continue;
            }
            if (par.name.equalsIgnoreCase("font-size")) {
                try {
                    sym.size = Double.valueOf(par.value.literal).intValue();
                }
                catch (Exception e) {
                    sym.size = 10;
                }
                continue;
            }
            if (par.name.equalsIgnoreCase("font-style")) {
                s = par.value.literal;
                if (!s.equalsIgnoreCase("italic") && !s.equalsIgnoreCase("oblique")) continue;
                sym.fontStyle |= 2;
                continue;
            }
            if (!par.name.equalsIgnoreCase("font-weight") || !(s = par.value.literal).equalsIgnoreCase("bold")) continue;
            sym.fontStyle |= 1;
        }
    }
}

