/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import org.alov.map.DisplayContext;
import org.alov.map.FieldDef;
import org.alov.map.FilterExpression;
import org.alov.map.FilterTime;
import org.alov.map.FloatPoint;
import org.alov.map.Layer;
import org.alov.map.LayerVector;
import org.alov.map.MapUtils;
import org.alov.map.Projection;
import org.alov.map.Record;
import org.alov.map.Renderer;
import org.alov.map.Shape;
import org.alov.map.Symbol;
import org.alov.util.ExDate;
import org.alov.util.Strings;
import org.alov.util.TimeInterval;

public class RendererGrad
extends Renderer {
    public int fieldIndex;
    public String fieldName;
    public boolean drawDefault = false;

    public RendererGrad(Layer lyr) {
        super(lyr);
    }

    public boolean isDynamic() {
        int symCount = this.symbols != null ? this.symbols.length : 0;
        for (int i = 0; i < symCount; ++i) {
            if (!this.symbols[i].imageAnimated) continue;
            return true;
        }
        return false;
    }

    public void paintRecord(Record rec, boolean selected, DisplayContext dc) {
        Symbol sym = null;
        Symbol[] syms = this.symbols;
        int count = syms.length;
        if (this.fieldIndex < 0) {
            for (int i = 0; i < count; ++i) {
                Symbol s = syms[i];
                if (s.value == null) continue;
                if (s.value.equals("")) {
                    sym = s;
                } else if (s.value instanceof FilterExpression) {
                    if (!((FilterExpression)s.value).checkRecord(rec)) continue;
                    sym = s;
                } else {
                    double dateMax;
                    if (!(s.value instanceof FilterTime)) continue;
                    TimeInterval ti = new TimeInterval(dc.getTimeInterval().date1(), dc.getTimeInterval().date2());
                    double dateMin = s.offsetMin >= 0.0 ? ti.date1().getDays() + s.offsetMin : ti.date2().getDays() + s.offsetMin;
                    double d = dateMax = s.offsetMax > 0.0 ? ti.date1().getDays() + s.offsetMax : ti.date2().getDays() + s.offsetMax;
                    if (dateMin > dateMax) {
                        double dTemp = dateMax;
                        dateMax = dateMin;
                        dateMin = dTemp;
                    }
                    ti.setDate1(new ExDate(dateMin));
                    ti.setDate2(new ExDate(dateMax));
                    ((FilterTime)s.value).setTimeInterval(ti);
                    if (!((FilterTime)s.value).checkRecord(rec)) continue;
                    sym = s;
                }
                break;
            }
        } else {
            Object o = this.layer.getFieldValue(rec, this.fieldIndex);
            for (int i = 0; i < count; ++i) {
                Symbol s = syms[i];
                int res = MapUtils.compare(o, s.value);
                if (res != this.equal) continue;
                if (sym == null || MapUtils.compare(s.value, sym.value) == this.equal) {
                    sym = s;
                }
                if (this.equal == 0) break;
            }
            if (this.equal < 0 && sym == null) {
                sym = syms[count - 1];
            }
        }
        if (sym == null && this.drawDefault) {
            sym = ((LayerVector)this.layer).symbol;
        }
        if (sym != null && sym.visible) {
            if (selected) {
                Symbol symSel;
                sym = symSel = ((LayerVector)this.layer).selectedSymbol;
            }
            if (sym.sizeFieldIndex >= 0) {
                Object o = this.layer.getFieldValue(rec, sym.sizeFieldIndex);
                sym.size = (int)((float)Strings.objToInt(o, sym.size) * sym.factor);
            }
            if (sym.rotationFieldIndex >= 0) {
                Object o = this.layer.getFieldValue(rec, sym.rotationFieldIndex);
                sym.rotation = (float)(MapUtils.toDoubleDef(o, sym.rotation) / 180.0 * Math.PI);
            }
            if (sym.drawMarker) {
                Projection prj = dc.getProjection();
                FloatPoint centre = rec.getRecordExtent().getCentre();
                int x = (int)((centre.x + prj.shift.x) * prj.zoom);
                int y = (int)((-centre.y + prj.shift.y) * prj.zoom);
                Shape.drawPoint(dc.getDrawToGraphics(), sym, x, y);
            } else {
                this.defaultPaintRecord(rec, sym, dc);
            }
        }
    }

    protected void prepare() throws Exception {
        FieldDef def = this.layer.getFieldDef_(this.layer.getFieldIndex(this.fieldName));
        this.prepareSymbols(def);
        int n = this.fieldIndex = def == null ? -1 : def.index;
        if (this.fieldIndex < 0 && this.fieldName != null) {
            throw new Exception("  Renderer: " + this.name + "  " + this.fieldName);
        }
        if (this.symbols == null || this.symbols.length == 0) {
            throw new Exception("  Renderer: " + this.name + "  " + "No Symbols");
        }
        int count = this.symbols.length;
        int kk1 = this.equal > 0 ? 1 : 0;
        int kk2 = this.equal < 0 ? 1 : 0;
        int kk3 = 0;
        kk1 = 0;
        kk3 = -1;
        if (this.equal != 2) {
            for (int i = 0; i < count; ++i) {
                String s = this.symbols[i].label;
                if (s != null) continue;
                if (this.equal == 0) {
                    s = "" + this.symbols[i].value;
                } else if (count >= 2) {
                    s = i == 0 ? "... " + this.symbols[i + kk1].value : (i < count - 1 ? this.symbols[i + kk3].value + " ... " + this.symbols[i + kk3 + 1].value : this.symbols[i - kk2].value + " ...");
                }
                this.symbols[i].label = s;
            }
        }
        this.isPrepared = true;
    }
}

