/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Color;
import org.alov.map.DisplayContext;
import org.alov.map.FieldDef;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.Projection;
import org.alov.map.Record;
import org.alov.map.Renderer;
import org.alov.map.Shape;
import org.alov.map.Symbol;

public class RendererDot
extends Renderer {
    public int fieldIndex;
    public String fieldName;
    public float dotSize;

    public RendererDot(Layer lyr) {
        super(lyr);
    }

    public void paintRecord(Record rec, boolean selected, DisplayContext dc) {
        if (this.fieldIndex >= 0) {
            int i;
            double fieldValue = this.layer.getFieldDouble(rec, this.fieldIndex);
            int QuantityDotsInShape = (int)(fieldValue / (double)this.dotSize);
            double[] xCoords = new double[QuantityDotsInShape];
            double[] yCoords = new double[QuantityDotsInShape];
            int cnt = rec.getShapeCount();
            for (i = 0; i < QuantityDotsInShape; ++i) {
                boolean isPointInShape = false;
                double rand_x = 0.0;
                double rand_y = 0.0;
                while (!isPointInShape) {
                    FloatRectangle recExt = rec.getRecordExtent();
                    rand_x = (recExt.x2 - recExt.x) * Math.random() + recExt.x;
                    rand_y = (recExt.y2 - recExt.y) * Math.random() + recExt.y;
                    for (int j = 0; j < cnt && !isPointInShape; ++j) {
                        if (!Shape.containsPoint(rec.getShape(j), rand_x, rand_y)) continue;
                        isPointInShape = true;
                    }
                }
                xCoords[i] = rand_x;
                yCoords[i] = rand_y;
            }
            for (i = 0; i < QuantityDotsInShape; ++i) {
                Projection prj = dc.getProjection();
                int x = (int)((xCoords[i] + prj.shift.x) * prj.zoom);
                int y = (int)((-yCoords[i] + prj.shift.y) * prj.zoom);
                Shape.drawPoint(dc.getDrawToGraphics(), this.symbols[0], x, y);
            }
        }
    }

    protected void prepare() throws Exception {
        FieldDef def = this.layer.getFieldDef_(this.layer.getFieldIndex(this.fieldName));
        int n = this.fieldIndex = def == null ? -1 : def.index;
        if (this.fieldIndex < 0 && this.fieldName != null) {
            throw new Exception("  Renderer: " + this.name + "  " + this.fieldName);
        }
        if (this.symbols == null) {
            this.symbols = new Symbol[1];
            this.symbols[0] = new Symbol(Color.black, Color.black, true, false, 3);
        }
        this.symbols[0].drawMarker = true;
        this.isPrepared = true;
    }
}

