/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import org.alov.map.FloatRectangle;
import org.alov.map.Shape;
import org.alov.util.ExDate;
import org.alov.util.Readers;

public class Record
implements Serializable {
    public int index = -1;
    private FloatRectangle extent = null;
    private Shape[] shapes = null;
    private Object[] fields = null;
    public boolean isNotSent = true;
    public boolean isDownloading = false;
    public ExDate dateLow = null;
    public ExDate dateHigh = null;
    public boolean dateInvalid = false;

    public Record() {
    }

    public Record(int fieldCount) {
        if (fieldCount > 0) {
            this.fields = new Object[fieldCount];
        }
    }

    public Object getField(int index) {
        return index < 0 || index >= this.fields.length ? null : this.fields[index];
    }

    public void setField(int index, Object val) {
        this.fields[index] = val;
    }

    public static int readFromStream(Record rec, DataInputStream is, boolean fixHoles, boolean isWKB) throws IOException {
        if (isWKB) {
            return Record.readFromWkb(rec, is, fixHoles);
        }
        int figureType = is.read();
        int pntTotals = 0;
        if (figureType == 255) {
            Shape shp = rec.newShape(1);
            shp.setVertex(0, is.readFloat(), is.readFloat());
            figureType = 1;
        } else if (figureType == 254) {
            Shape shp = rec.newShape(4);
            float xmin = is.readFloat();
            float ymin = is.readFloat();
            float xmax = is.readFloat();
            float ymax = is.readFloat();
            shp.xCoords[0] = xmin;
            shp.yCoords[0] = ymin;
            shp.xCoords[1] = xmin;
            shp.yCoords[1] = ymax;
            shp.xCoords[2] = xmax;
            shp.yCoords[2] = ymax;
            shp.xCoords[3] = xmax;
            shp.yCoords[3] = ymin;
            figureType = 4;
        } else {
            ++figureType;
            boolean isHasHole = false;
            int compression = Readers.readInt(is);
            int shpCount = Readers.readInt(is);
            rec.initShapes(shpCount);
            switch (compression) {
                case 1: {
                    for (int i = 0; i < shpCount; ++i) {
                        Shape shp = new Shape();
                        int pointCount = Readers.readInt(is);
                        pntTotals += pointCount;
                        shp.xCoords = new double[pointCount];
                        shp.yCoords = new double[pointCount];
                        float px = Readers.readFloat(is);
                        float py = Readers.readFloat(is);
                        float scaleX = Readers.readFloat(is);
                        float scaleY = Readers.readFloat(is);
                        for (int j = 0; j < pointCount; ++j) {
                            shp.xCoords[j] = (float)Readers.readShort(is) * scaleX + px;
                            shp.yCoords[j] = (float)Readers.readShort(is) * scaleY + py;
                        }
                        rec.setShape(i, shp);
                        if (!fixHoles) continue;
                        isHasHole = isHasHole || figureType == 3 && Shape.isClockWise(shp);
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < shpCount; ++i) {
                        Shape shp = new Shape();
                        int pointCount = Readers.readInt(is);
                        pntTotals += pointCount;
                        shp.xCoords = new double[pointCount];
                        shp.yCoords = new double[pointCount];
                        for (int j = 0; j < pointCount; ++j) {
                            shp.xCoords[j] = Readers.readDouble(is);
                            shp.yCoords[j] = Readers.readDouble(is);
                        }
                        rec.setShape(i, shp);
                        if (!fixHoles) continue;
                        isHasHole = isHasHole || figureType == 3 && Shape.isClockWise(shp);
                    }
                    break;
                }
                default: {
                    for (int i = 0; i < shpCount; ++i) {
                        Shape shp = new Shape();
                        int pointCount = Readers.readInt(is);
                        pntTotals += pointCount;
                        shp.xCoords = new double[pointCount];
                        shp.yCoords = new double[pointCount];
                        for (int j = 0; j < pointCount; ++j) {
                            shp.xCoords[j] = Readers.readFloat(is);
                            shp.yCoords[j] = Readers.readFloat(is);
                        }
                        rec.setShape(i, shp);
                        if (!fixHoles) continue;
                        isHasHole = isHasHole || figureType == 3 && Shape.isClockWise(shp);
                    }
                }
            }
            if (isHasHole) {
                Record.addDoughnutShape(rec, pntTotals);
            }
        }
        return figureType;
    }

    private static int readInt(DataInputStream is, byte byteOrder) throws IOException {
        return byteOrder == 1 ? Readers.readInt(is) : is.readInt();
    }

    private static double readDouble(DataInputStream is, byte byteOrder) throws IOException {
        return byteOrder == 1 ? Readers.readDouble(is) : is.readDouble();
    }

    private static Shape readWkbLineString(DataInputStream is, byte byteOrder) throws IOException {
        int numPoints = Record.readInt(is, byteOrder);
        Shape shp = new Shape();
        shp.xCoords = new double[numPoints];
        shp.yCoords = new double[numPoints];
        if (byteOrder == 1) {
            for (int i = 0; i < numPoints; ++i) {
                shp.xCoords[i] = Readers.readDouble(is);
                shp.yCoords[i] = Readers.readDouble(is);
            }
        } else {
            for (int i = 0; i < numPoints; ++i) {
                shp.xCoords[i] = is.readDouble();
                shp.yCoords[i] = is.readDouble();
            }
        }
        return shp;
    }

    private static int readFromWkb(Record rec, DataInputStream is, boolean fixHoles) throws IOException {
        boolean wkbPoint = true;
        int wkbLineString = 2;
        int wkbPolygon = 3;
        int wkbMultiPoint = 4;
        int wkbMultiLineString = 5;
        int wkbMultiPolygon = 6;
        int wkbGeometryCollection = 7;
        int linearRing = 101;
        boolean isHasHole = false;
        int figureType = 0;
        int pntTotals = 0;
        byte byteOrder = is.readByte();
        int wkbType = Record.readInt(is, byteOrder);
        switch (wkbType) {
            case 1: {
                figureType = 1;
                double x = Record.readDouble(is, byteOrder);
                double y = Record.readDouble(is, byteOrder);
                rec.initShapes(1);
                Shape shp = new Shape();
                shp.setVertex(0, x, y);
                rec.setShape(0, shp);
                break;
            }
            case 2: {
                figureType = 2;
                rec.initShapes(1);
                Shape shp = Record.readWkbLineString(is, byteOrder);
                pntTotals += shp.xCoords.length;
                rec.setShape(0, shp);
                break;
            }
            case 3: {
                figureType = 3;
                int numRings = Record.readInt(is, byteOrder);
                rec.initShapes(numRings);
                for (int r = 0; r < numRings; ++r) {
                    Shape shp = Record.readWkbLineString(is, byteOrder);
                    pntTotals += shp.xCoords.length;
                    rec.setShape(r, shp);
                    if (!fixHoles) continue;
                    isHasHole = isHasHole || Shape.isClockWise(shp);
                }
                break;
            }
            case 4: {
                figureType = 1;
                int num_wkbPoints = Record.readInt(is, byteOrder);
                rec.initShapes(num_wkbPoints);
                for (int i = 0; i < num_wkbPoints; ++i) {
                    byte p_byteOrder = is.readByte();
                    int p_wkbType = Record.readInt(is, p_byteOrder);
                    if (p_wkbType != 1) {
                        throw new IOException("wkbMultiPoint can contain wkbPoints only");
                    }
                    Shape shp = new Shape();
                    shp.setVertex(0, Record.readDouble(is, p_byteOrder), Record.readDouble(is, p_byteOrder));
                    rec.setShape(i, shp);
                }
                break;
            }
            case 5: {
                figureType = 2;
                int shpCount = Record.readInt(is, byteOrder);
                rec.initShapes(shpCount);
                for (int i = 0; i < shpCount; ++i) {
                    byte byteOrder2 = is.readByte();
                    int wkbType2 = Record.readInt(is, byteOrder);
                    Shape shp = Record.readWkbLineString(is, byteOrder2);
                    if (wkbType2 != 2) {
                        throw new IOException("wkbMultiLineString can contain readWkbLineString only");
                    }
                    rec.setShape(i, shp);
                }
                break;
            }
            default: {
                throw new IOException("Unsupported wkbType: " + wkbType);
            }
        }
        if (isHasHole) {
            Record.addDoughnutShape(rec, pntTotals);
        }
        return figureType;
    }

    public void setRecordExtent(FloatRectangle ext) {
        this.extent = ext;
    }

    public FloatRectangle getRecordExtent() {
        if (this.extent == null) {
            FloatRectangle recExt = new FloatRectangle();
            int count = this.getShapeCount();
            double xmax = Double.NEGATIVE_INFINITY;
            double ymax = Double.NEGATIVE_INFINITY;
            double xmin = Double.POSITIVE_INFINITY;
            double ymin = Double.POSITIVE_INFINITY;
            for (int i = 0; i < count; ++i) {
                Shape shp = this.getShape(i);
                FloatRectangle r = Shape.calculateExtent(shp);
                if (r == null) continue;
                if (r.x < xmin) {
                    xmin = r.x;
                }
                if (r.x2 > xmax) {
                    xmax = r.x2;
                }
                if (r.y < ymin) {
                    ymin = r.y;
                }
                if (!(r.y2 > ymax)) continue;
                ymax = r.y2;
            }
            recExt.x = xmin;
            recExt.y = ymin;
            recExt.x2 = xmax;
            recExt.y2 = ymax;
            this.extent = recExt;
        }
        return this.extent;
    }

    public int getShapeCount() {
        return this.shapes == null ? 0 : this.shapes.length;
    }

    public Shape getShape(int ind) {
        return ind >= 0 && ind < this.getShapeCount() ? this.shapes[ind] : null;
    }

    public void setShape(int ind, Shape shp) {
        if (ind >= 0 && ind < this.getShapeCount()) {
            this.shapes[ind] = shp;
        }
    }

    public Shape newShape(int verticesNumber) {
        Shape shp = new Shape();
        shp.xCoords = new double[verticesNumber];
        shp.yCoords = new double[verticesNumber];
        int shpCount = this.getShapeCount();
        if (shpCount == 0) {
            this.shapes = new Shape[1];
        } else {
            Shape[] shapes_prev = this.shapes;
            this.shapes = new Shape[shpCount + 1];
            for (int i = 0; i < shpCount; ++i) {
                this.shapes[i + 1] = shapes_prev[i];
            }
        }
        this.shapes[0] = shp;
        return shp;
    }

    public void initShapes(int shapesNumber) {
        this.clearShapes();
        this.shapes = new Shape[shapesNumber];
    }

    public static void addDoughnutShape(Record rec, int pntTotals) {
        int shpCount = rec.getShapeCount();
        if (shpCount > 1) {
            pntTotals += shpCount - 1;
        }
        Shape one_shp = rec.newShape(pntTotals);
        one_shp.typeFill = 1;
        int cp = 0;
        double lastX = 0.0;
        double lastY = 0.0;
        ++shpCount;
        for (int i = 1; i < shpCount; ++i) {
            Shape shp = rec.getShape(i);
            shp.typeFill = (byte)2;
            int pointCount = shp.xCoords.length;
            for (int j = 0; j < pointCount; ++j) {
                one_shp.xCoords[j + cp] = shp.xCoords[j];
                one_shp.yCoords[j + cp] = shp.yCoords[j];
            }
            if (i == 1) {
                lastX = shp.xCoords[cp + pointCount - 1];
                lastY = shp.yCoords[cp + pointCount - 1];
            } else {
                one_shp.xCoords[cp + pointCount] = lastX;
                one_shp.yCoords[cp + pointCount] = lastY;
                ++cp;
            }
            cp += pointCount;
        }
    }

    public static Shape getDoughnutShape(Record rec) {
        int pntTotals = 0;
        int shpCount = rec.getShapeCount();
        if (shpCount > 1) {
            int notNullcount = 0;
            for (int i = 0; i < shpCount; ++i) {
                Shape s = rec.getShape(i);
                if (s.xCoords == null || s.yCoords == null) continue;
                ++notNullcount;
                pntTotals += s.xCoords.length;
            }
            pntTotals += notNullcount - 1;
        }
        if (pntTotals <= 0) {
            return null;
        }
        Shape one_shp = new Shape();
        one_shp.xCoords = new double[pntTotals];
        one_shp.yCoords = new double[pntTotals];
        one_shp.typeFill = 1;
        int cp = 0;
        double lastX = 0.0;
        double lastY = 0.0;
        boolean isFirst = true;
        for (int i = 0; i < shpCount; ++i) {
            Shape shp = rec.getShape(i);
            shp.typeFill = (byte)2;
            if (shp.xCoords == null && shp.yCoords == null) continue;
            int pointCount = shp.xCoords.length;
            for (int j = 0; j < pointCount; ++j) {
                one_shp.xCoords[j + cp] = shp.xCoords[j];
                one_shp.yCoords[j + cp] = shp.yCoords[j];
            }
            if (isFirst) {
                lastX = shp.xCoords[cp + pointCount - 1];
                lastY = shp.yCoords[cp + pointCount - 1];
                isFirst = false;
            } else {
                one_shp.xCoords[cp + pointCount] = lastX;
                one_shp.yCoords[cp + pointCount] = lastY;
                ++cp;
            }
            cp += pointCount;
        }
        return one_shp;
    }

    public void setFieldValues(Object[] data) {
        this.fields = data;
    }

    public Object[] getFieldValues() {
        return this.fields;
    }

    protected void finalize() {
        this.clearShapes();
        if (this.fields != null) {
            for (int j = 0; j < this.fields.length; ++j) {
                this.fields[j] = null;
            }
            this.fields = null;
        }
        this.extent = null;
    }

    public void clearShapes() {
        int count2 = this.getShapeCount();
        for (int j = 0; j < count2; ++j) {
            Shape shp = this.getShape(j);
            shp.xCoords = null;
            shp.yCoords = null;
            Object var3_3 = null;
        }
        this.shapes = null;
    }
}

