/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.io.Serializable;
import java.util.Vector;
import org.alov.map.Layer;

public class RadioGroup
implements Serializable {
    public String name = "";
    private Vector layers = new Vector();
    private Layer[] levels = null;
    private int count = 0;

    RadioGroup(String name, int levelNum) {
        this.name = name;
        this.levels = new Layer[levelNum];
    }

    public void addLayer(Layer layer) {
        this.layers.addElement(layer);
        layer.radioGroup = this;
        if (layer.isVisible()) {
            this.layerVisibleChanged(layer, true);
        }
    }

    public int size() {
        return this.layers.size();
    }

    public void layerVisibleChanged(Layer layer, boolean visible) {
        if (visible) {
            for (int i = 0; i < this.count; ++i) {
                if (this.levels[i] != layer) continue;
                return;
            }
            int saveCount = this.count;
            for (int i = this.count - this.levels.length; i >= 0; --i) {
                this.levels[i].setVisible(false);
                --saveCount;
            }
            this.count = saveCount;
            this.levels[this.count] = layer;
            ++this.count;
        } else {
            for (int i = 0; i < this.count; ++i) {
                if (this.levels[i] != layer) continue;
                if (i != this.count - 1) {
                    System.arraycopy(this.levels, i + 1, this.levels, i, this.count - i - 1);
                }
                --this.count;
                break;
            }
        }
    }

    public boolean isLayerLevel(Layer layer, int level) {
        if (level > 0 && level <= this.count) {
            return this.levels[level - 1] == layer;
        }
        return false;
    }
}

