/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.alov.data.DataProviderFile;
import org.alov.map.Carte;
import org.alov.map.ComplexFigure;
import org.alov.map.DataStorageCompact;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.LayerRaster;
import org.alov.map.LayerVector;
import org.alov.map.LayerZoomify;
import org.alov.map.MapUtils;
import org.alov.map.Project;
import org.alov.map.ProxyLocal;
import org.alov.map.ProxyRequest;
import org.alov.map.Record;
import org.alov.map.RecordsArray;
import org.alov.map.StreamCounter;
import org.alov.util.AlovMapException;
import org.alov.util.Readers;
import org.alov.util.Strings;

public class ProxyServer
extends ProxyLocal {
    public String servletURL = "";
    private String maxsidkb = "";
    private String additionalParams = "";
    private String lastQueryProjStr = "";
    private static final int version = 20060708;
    private int requestNo = 0;
    private boolean bHandshake = false;
    private FloatRectangle previousRect = null;

    void setProjectURLServer() {
        this.projectURL = this.servletURL + '?' + "pid" + '=' + this.projectId + '&' + "rq" + '=' + "GetProject";
    }

    void processGeoResponse(ProxyLocal.GeoReqParams params) throws Exception {
        if (this.sessionUser != 0 && this.sessionMagic != 0) {
            params.getReq.append("&id=").append(this.sessionUser).append("&m=").append(this.sessionMagic);
        }
        if (!Strings.isNullOrBlank(this.maxsidkb) && params.hasImage) {
            params.getReq.append('&').append("maxsidsize").append('=').append(this.maxsidkb);
        }
        this.map.broadcastMessage(10, "");
        params.url = new URL(params.getReq.toString());
        this.map.broadcastMessage(0, "");
        try {
            params.input = params.url.openStream();
            if (params.input == null) {
                throw new AlovMapException(202, "Server busy or inaccessible");
            }
            params.counter = new StreamCounter(params.input, 1024, null);
        }
        catch (Exception e) {
            this.bHandshake = false;
            this.addStatusInfo(202, null, e.getMessage());
            this.map.broadcastMessage(-6, "");
            throw e;
        }
        params.errorCode = Readers.readInt(params.counter);
        if (params.errorCode == 0) {
            Layer lyr;
            int j;
            String datasetId;
            int sizePacket = Readers.readInt(params.counter);
            params.counter.setCounter(sizePacket, "");
            ZipInputStream zip = new ZipInputStream(params.counter);
            ZipEntry zipEntry = zip.getNextEntry();
            StreamCounter counter2 = new StreamCounter(zip, 1024, this.map);
            DataInputStream is = new DataInputStream(counter2);
            int servletVersion = is.readInt();
            if (servletVersion != 20060708) {
                this.map.broadcastMessage(-9, "");
                this.addStatusInfo(206, null, "Versions mismatch: server - " + servletVersion + " client - " + 20060708);
                return;
            }
            this.sessionUser = is.readInt();
            this.sessionMagic = is.readInt();
            this.bHandshake = false;
            params.layerCount = is.readInt();
            boolean hasMeta = is.readBoolean();
            if (hasMeta) {
                String sFirstId = datasetId = is.readUTF();
                for (j = 0; j < params.layerCount; ++j) {
                    params.errorCode = Readers.readInt(is);
                    lyr = params.project.getLayerByDsId(datasetId);
                    if (lyr != null) {
                        if (params.errorCode != 0) {
                            if (params.errorCode == 221) {
                                lyr.metadata.passResolved = false;
                                lyr.metadata.delElement(303);
                            } else {
                                lyr.metadata.loadFailed = true;
                                this.map.broadcastMessage(-8, lyr.getName());
                            }
                            this.addStatusInfo(params.errorCode, lyr, is.readUTF());
                        } else {
                            String sWarning;
                            String password = lyr.metadata.getVal(303);
                            if (!Strings.isNullOrBlank(password)) {
                                params.project.datasetPasswords.put(datasetId, password);
                            }
                            if (!Strings.isNullOrBlank(sWarning = is.readUTF())) {
                                this.addStatusInfo(0, lyr, "WARNING#" + sWarning);
                            }
                            boolean isVector = is.readBoolean();
                            if (lyr instanceof LayerVector && !isVector) {
                                sWarning = "Layer defined as vector but it is raster in fact";
                                sWarning = "Dataset is assumed to be vector because it is not specified as raster.If the dataset is raster it must be defined in the MapSpace as <type>image</type>";
                            } else if (lyr instanceof LayerRaster && isVector) {
                                sWarning = "Layer defined as raster but it is vector in fact";
                                sWarning = "Dataset is assumed to be raster because it is specified as raster.But it is vector in fact. If the dataset is vector it must be defined in the MapSpace without <type>image</type>";
                            } else {
                                sWarning = null;
                            }
                            if (sWarning != null) {
                                lyr.metadata.loadFailed = true;
                                this.map.broadcastMessage(-8, lyr.getName());
                                this.addStatusInfo(205, lyr, sWarning);
                                return;
                            }
                            try {
                                lyr.readMetadata_(is);
                                lyr.metadata.forceEmptyLoad = false;
                                lyr.metadata.forceLoad = false;
                                params.project.setSameLayers(lyr, this);
                                params.project.sortRenderersByLevels();
                            }
                            catch (Exception e) {
                                lyr.metadata.loadFailed = true;
                                this.map.broadcastMessage(-8, lyr.getName());
                                this.addStatusInfo(0, lyr, "Can't read metadata. " + e.getMessage());
                            }
                        }
                    } else {
                        this.addStatusInfo(205, null, datasetId);
                    }
                    datasetId = is.readUTF();
                    if (datasetId.equals(sFirstId)) break;
                }
            }
            for (j = 0; j < params.layerCount; ++j) {
                datasetId = is.readUTF();
                params.errorCode = Readers.readInt(is);
                lyr = params.project.getLayerByDsId(datasetId);
                if (lyr != null) {
                    if (params.errorCode != 0) {
                        lyr.metadata.networkActivity = false;
                        if (lyr.serverType == 23 && params.errorCode == 218) {
                            this.map.host.showURL(is.readUTF(), "_self");
                            return;
                        }
                        boolean bl = lyr.metadata.loadFailed = params.errorCode == 205;
                        if (params.errorCode == 221) {
                            this.map.broadcastMessage(11, "");
                        } else {
                            this.map.broadcastMessage(-8, lyr.getName());
                        }
                        this.addStatusInfo(params.errorCode, lyr, is.readUTF());
                        continue;
                    }
                    sizePacket = Readers.readInt(is);
                    counter2.setCounter(sizePacket, "[ " + lyr.getName() + ']');
                    if (sizePacket > 0) {
                        this.map.broadcastMessage(2, lyr.getName());
                        try {
                            this.receiveData(is, lyr, sizePacket);
                            if (lyr.serverType != 23 && lyr instanceof LayerVector) {
                                int count3 = params.project.getLayerCount();
                                for (int kk = 0; kk < count3; ++kk) {
                                    Layer lyrD = params.project.getLayerByIndex(kk);
                                    if (!lyrD.datasetId.equals(lyr.datasetId) || params.rect == null) continue;
                                    lyrD.loadedExtent.combineRect(params.rect);
                                }
                            }
                            if (lyr instanceof LayerZoomify && lyr.isLoadComplete()) {
                                ((LayerZoomify)lyr).loadZoomifyImages(params.rect);
                            }
                        }
                        catch (Exception e) {
                            lyr.metadata.loadFailed = true;
                            this.map.broadcastMessage(-8, lyr.getName());
                            this.addStatusInfo(0, lyr, e.getMessage());
                        }
                    }
                    lyr.metadata.forceClearCache = false;
                    lyr.metadata.networkActivity = false;
                    this.map.broadcastMessage(11, "");
                    continue;
                }
                this.addStatusInfo(205, null, datasetId);
            }
            sizePacket = (int)counter2.getReceived();
            is.close();
            counter2.close();
            params.counter.close();
            this.map.broadcastMessage(14, "");
        } else if (params.errorCode == 215) {
            this.addStatusInfo(215, null, "Server busy");
            params.counter.close();
            this.map.broadcastMessage(-7, "");
        } else if (params.errorCode == 222) {
            this.bHandshake = false;
            this.restoreSession(params);
        } else {
            DataInputStream is = new DataInputStream(params.counter);
            this.addStatusInfo(params.errorCode, null, is.readUTF());
            is.close();
            params.counter.close();
            this.map.broadcastMessage(-5, "");
        }
    }

    private int restoreSession(ProxyLocal.GeoReqParams params) throws Exception {
        this.sessionUser = 0;
        this.sessionMagic = 0;
        Project prj = this.map.getProject();
        int count = prj.getLayerCount();
        for (int i = 0; i < count; ++i) {
            Layer lyr = prj.getLayerByIndex(i);
            lyr.metadata.memsize = 0;
            lyr.clear(false);
        }
        this.map.extentChanged();
        return 0;
    }

    int processGeoRequest(ProxyLocal.GeoReqParams params) throws Exception {
        Layer lyr;
        if (this.sessionUser == 0 && this.sessionMagic == 0 && this.bHandshake) {
            return -1;
        }
        if (params.project.isDynamic && (params.project.forceSearchForDynamic || !params.rect.equals(this.previousRect) && params.project.isDynamic_SearchAlways)) {
            DataInputStream is;
            params.project.forceSearchForDynamic = false;
            int count2 = params.project.getLayerCount();
            int k2 = 0;
            while (k2 < count2) {
                lyr = params.project.getLayerByIndex(k2);
                if (lyr.removeOutOfExtent && (lyr.isOutOfRange(this.map) != 0 || lyr.isOutOfExtent(this.map))) {
                    params.project.layers.removeElementAt(k2);
                    this.addStatusInfo(0, lyr, "Removed");
                    this.map.broadcastMessage(116, null);
                    params.lyrList = params.lyrList + lyr.datasetId + ',';
                    lyr.clear(true);
                    lyr = null;
                    --count2;
                    continue;
                }
                ++k2;
            }
            this.bHandshake = true;
            params.getReq.append(this.servletURL).append('?').append("rq").append('=').append("GetDs").append('&').append("bbox").append('=').append(params.rect.x).append(',').append(params.rect.y).append(',').append(params.rect.x2).append(',').append(params.rect.y2).append("&z=").append(this.map.getDistance(null));
            if (!Strings.isNullOrBlank(params.lyrList)) {
                params.lyrList = params.lyrList.substring(0, params.lyrList.length() - 1);
                params.getReq.append('&').append("l").append('=').append(params.lyrList);
                params.lyrList = "";
            }
            if (params.project.isDynamic_LayerVisible) {
                params.getReq.append("&visible=ON");
            }
            if (this.sessionUser != 0 && this.sessionMagic != 0) {
                params.getReq.append("&id=").append(this.sessionUser).append("&m=").append(this.sessionMagic);
            }
            if (params.project.sDynamoAdd.length() > 0) {
                params.getReq.append("&d=").append(params.project.sDynamoAdd);
            }
            if (params.project.isTimeMap) {
                params.getReq.append("&tm=ON");
            }
            try {
                params.input = new URL(params.getReq.toString()).openStream();
                if (params.input == null) {
                    throw new AlovMapException(202, "Server busy or inaccessible");
                }
            }
            catch (Exception e) {
                this.bHandshake = false;
                this.addStatusInfo(202, null, e.getMessage());
                this.map.broadcastMessage(-6, "");
                throw e;
            }
            this.bHandshake = false;
            params.errorCode = Readers.readInt(params.input);
            if (params.errorCode == 0) {
                is = new DataInputStream(params.input);
                this.sessionUser = is.readInt();
                this.sessionMagic = is.readInt();
                Project prj = new Project();
                try {
                    prj.load(is, this);
                }
                catch (Exception e) {
                    // empty catch block
                }
                is.close();
                this.map.broadcastMessage(14, "");
                this.previousRect = new FloatRectangle(params.rect);
                params.project.dynamicLayers = prj.layers;
                int count = params.project.dynamicLayers.size();
                if (params.project.dynamicLayers != null && count > 0) {
                    int count3 = params.project.getLayerCount() + count;
                    for (int i = 0; i < count; ++i) {
                        Layer layer = (Layer)params.project.dynamicLayers.elementAt(i);
                        if (Strings.isNullOrBlank(layer.datasetId)) continue;
                        String password = (String)params.project.datasetPasswords.get(layer.datasetId);
                        if (password == null && !layer.metadata.passResolved) {
                            password = params.project.defaultPassword;
                        }
                        if (password != null) {
                            layer.metadata.put(303, password);
                            layer.metadata.passResolved = false;
                        }
                        layer.drawOrder = count3 - params.project.iDynamic_OrderOfLayers;
                    }
                }
                this.map.broadcastMessage(params.project.isDynamic_AddDialogue ? 117 : 111, null);
            } else if (params.errorCode == 215) {
                this.addStatusInfo(215, null, "Server busy");
                this.map.broadcastMessage(-7, "");
            } else {
                is = new DataInputStream(params.input);
                this.addStatusInfo(params.errorCode, null, is.readUTF());
                is.close();
                this.map.broadcastMessage(-5, "");
            }
        }
        params.layerCount = params.project.getLayerCount();
        StringBuffer passwordParameters = new StringBuffer();
        for (int i = 0; i < params.layerCount; ++i) {
            boolean dontNeedToResolvePassword;
            Layer layer = lyr = params.req.layerId != null ? params.project.getLayerById(params.req.layerId) : params.project.getLayerByIndex(i);
            if (lyr == null) {
                params.req.layerId = null;
                lyr = params.project.getLayerByIndex(i);
            }
            String password = lyr.metadata.getVal(303);
            boolean isLoadComplete = lyr.isLoadComplete();
            boolean isSomethingVisible = lyr.isSomethingVisible(this.map) || lyr.metadata.forceLoad;
            lyr.metadata.forceEmptyLoad = lyr.metadata.forceEmptyLoad && !isSomethingVisible;
            boolean bl = dontNeedToResolvePassword = (lyr.isPassResolved() || Strings.isNullOrBlank(password)) && !lyr.metadata.forceEmptyLoad && !isSomethingVisible;
            if (lyr instanceof LayerZoomify && isLoadComplete && isSomethingVisible) {
                ((LayerZoomify)lyr).loadZoomifyImages(params.rect);
            }
            if (this.map.loadedExtent != null && (isLoadComplete || lyr.metadata.loadFailed || dontNeedToResolvePassword || lyr.isGeocoding)) {
                if (params.req.layerId == null) continue;
                break;
            }
            if (!lyr.isDataOnServer) {
                super.loadDirect(params, lyr);
            } else {
                ComplexFigure remainder = lyr.loadedExtent.rectSubtract(params.rect);
                FloatRectangle remExt = remainder.getExtent();
                if (params.newRect == null) {
                    params.newRect = remExt;
                } else {
                    params.newRect.union(remExt);
                }
                if (remExt != null && params.lyrList.indexOf(lyr.datasetId + ',') < 0) {
                    params.lyrList = params.lyrList + lyr.datasetId + ',';
                    if (!lyr.isPassResolved() && !Strings.isNullOrBlank(password)) {
                        passwordParameters.append("&pwd_").append(lyr.datasetId).append("=").append(URLEncoder.encode(password));
                        lyr.metadata.passResolved = true;
                    }
                    if (lyr instanceof LayerVector && !Strings.isNullOrBlank(((LayerVector)lyr).serverFilter)) {
                        passwordParameters.append("&flt_").append(lyr.datasetId).append("=").append(URLEncoder.encode(((LayerVector)lyr).serverFilter));
                    }
                    params.getMode = lyr.isFullLoad ? params.getMode + '0' : (lyr.metadata.forceEmptyLoad ? params.getMode + '3' : (lyr.metadata.cachesize > 0 && lyr.metadata.memsize > lyr.metadata.cachesize ? params.getMode + '2' : params.getMode + '1'));
                    params.getMode = params.getMode + ",";
                    ++params.k;
                    lyr.metadata.networkActivity = true;
                    boolean bl2 = params.hasImage = params.hasImage || lyr instanceof LayerRaster;
                }
            }
            if (params.req.layerId != null) break;
        }
        params.layerCount = params.k;
        if (params.layerCount == 0 || this.sessionUser == 0 && this.sessionMagic == 0 && this.bHandshake) {
            return -1;
        }
        this.bHandshake = true;
        params.lyrList = params.lyrList.substring(0, params.lyrList.length() - 1);
        params.getMode = params.getMode.substring(0, params.getMode.length() - 1);
        params.getReq.setLength(0);
        params.getReq.append(this.servletURL).append('?').append("rq").append('=').append("GetMap").append('&').append("bbox").append('=').append(params.newRect.x).append(',').append(params.newRect.y).append(',').append(params.newRect.x2).append(',').append(params.newRect.y2).append('&').append("l").append('=').append(params.lyrList).append('&').append("gm").append('=').append(params.getMode).append(Strings.isNullOrBlank(this.additionalParams) ? "" : '&' + this.additionalParams);
        params.getReq.append(passwordParameters.toString());
        if (params.project.geoProjection != null) {
            String queryStr = URLEncoder.encode(params.project.geoProjection);
            if (this.lastQueryProjStr.equals(queryStr)) {
                queryStr = "sa";
            } else {
                this.lastQueryProjStr = queryStr;
            }
            params.getReq.append('&').append("projection").append('=').append(queryStr);
        }
        return 0;
    }

    public void setupProxy(Carte map) {
        this.servletURL = MapUtils.getRealPath(map.getParameter("servlet", "mapserv"));
        this.additionalParams = map.getParameter("external", "");
        super.setupProxy(map);
        this.maxsidkb = map.getParameter("maxsidsize", "");
    }

    void loadProjectServer(InputStream is) throws Exception {
        if (is == null) {
            throw new AlovMapException(202, "Server busy or inaccessible");
        }
        int errorCode = Readers.readInt(is);
        if (errorCode == 215) {
            throw new AlovMapException(215, "Server busy");
        }
        if (errorCode != 0) {
            DataInputStream dis = new DataInputStream(is);
            throw new AlovMapException(errorCode, dis.readUTF());
        }
    }

    int searchQuery(ProxyLocal.GeoReqParams params) {
        Layer lyr = params.project.getLayerById(params.req.layerId);
        if (lyr != null && lyr.isPassResolved()) {
            params.getReq.append(this.servletURL).append('?').append("rq").append('=').append("GetMap").append('&').append("q").append('=').append(URLEncoder.encode(params.req.query)).append(Strings.isNullOrBlank(this.additionalParams) ? "" : '&' + this.additionalParams).append('&').append("l").append('=');
            if (lyr.isGeocoding) {
                lyr.clear(false);
                params.getReq.append(lyr.datasetId.substring(7)).append('&').append("t").append('=').append("geocode").append('&').append("gm").append("=0");
            } else {
                params.getReq.append(lyr.datasetId);
                if (params.req.type == 34) {
                    params.getReq.append('&').append("t").append("=query").append('&').append("gm").append("=0");
                } else if (params.req.type == 35) {
                    params.getReq.append('&').append("t").append("=query").append('&').append("gm").append('=').append(lyr.isFullLoad ? (char)'0' : '1');
                } else if (params.req.type <= 32) {
                    if (params.req.type < 32) {
                        params.getReq.append('&').append("t").append("=id");
                    }
                    params.getReq.append('&').append("gm").append('=').append(lyr.isFullLoad ? (char)'0' : '1');
                }
            }
        } else {
            return -1;
        }
        params.k = 1;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveData(DataInputStream is, Layer lyr, int sizePacket) throws Exception {
        Project project = this.map.getProject();
        if (lyr instanceof LayerRaster) {
            LayerRaster lyrr = (LayerRaster)lyr;
            int imgW = Readers.readInt(is);
            if (lyrr.imgWidth <= 0) {
                lyrr.imgWidth = imgW;
            }
            int imgH = Readers.readInt(is);
            if (lyrr.imgHeight <= 0) {
                lyrr.imgHeight = imgH;
            }
            double minX = is.readDouble();
            double minY = is.readDouble();
            double maxX = is.readDouble();
            double maxY = is.readDouble();
            int iLoadCompletely = is.read();
            lyr.setLoadComplete(iLoadCompletely != 0);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(sizePacket - 32);
            try {
                int tot = sizePacket - 32;
                for (int m = 0; m < tot; ++m) {
                    bos.write(is.read());
                }
                lyrr.setImage(bos.toByteArray());
            }
            finally {
                bos.close();
            }
            lyrr.setLayerExtent(new FloatRectangle(minX, minY, maxX, maxY));
            project.setSameLayers(lyr, this);
            this.addStatusInfo(0, lyr, "Download image. " + (sizePacket - 32) + " bytes" + (lyr.isLoadComplete() ? ". COMPLETE" : ""));
            FloatRectangle ext = lyr.getLayerExtent();
            this.map.addExtent(ext);
            if (this.map.getLastExtent().intersects(ext)) {
                this.map.updateMap();
            }
        } else {
            int recCountSent = Readers.readInt(is);
            if (recCountSent < 0 && lyr instanceof LayerZoomify) {
                String zoomifyXml = is.readUTF();
                DataProviderFile dpf = (DataProviderFile)((LayerZoomify)lyr).provider;
                dpf.loadZoomify(zoomifyXml);
                this.addStatusInfo(0, lyr, "Download Zoomify image config " + zoomifyXml);
                project.setSameLayers(lyr, this);
                FloatRectangle ext = lyr.getLayerExtent();
                this.map.addExtent(ext);
                if (this.map.getLastExtent().intersects(ext)) {
                    this.map.updateMap();
                }
            } else {
                if (lyr.serverType == 23 || lyr.metadata.cachesize > 0 && lyr.metadata.memsize > lyr.metadata.cachesize) {
                    project.clearSameLayers(lyr);
                }
                boolean isWKB = "1".equals(lyr.metadata.getVal(313));
                String prevId = "";
                boolean first = true;
                int recCount = 0;
                int figureType = 0;
                DataStorageCompact dataStorage = new DataStorageCompact();
                dataStorage.fieldOriginalCount = lyr.dataStorage.fieldOriginalCount;
                dataStorage.assignFields(lyr.dataStorage.getFields());
                try {
                    dataStorage.openDataStorageSave(true);
                    for (int kk = 0; kk < recCountSent; ++kk) {
                        String id = is.readUTF();
                        if (first && id.equals(prevId)) {
                            first = false;
                            this.addStatusInfo(0, lyr, "WARNING#115");
                        }
                        prevId = id;
                        Record rec = lyr.newRecord(-1);
                        try {
                            figureType = Record.readFromStream(rec, is, true, isWKB);
                            if (lyr.isObjectType(-1)) {
                                lyr.dataStorage.setObjectType(figureType);
                                project.setSameLayers(lyr, this);
                            }
                        }
                        catch (Exception e) {
                            throw new Exception("Data packet contains damaged data. Can't read geo data \n Record id=" + id + "    " + e.getMessage());
                        }
                        block20: for (int i = 0; i < lyr.dataStorage.fieldOriginalCount; ++i) {
                            int k = 0;
                            switch (lyr.getFieldDef((int)i).type) {
                                case -7: 
                                case -6: {
                                    rec.setField(i, new Byte(is.readByte()));
                                    k = 1;
                                    continue block20;
                                }
                                case 5: {
                                    rec.setField(i, new Short(is.readShort()));
                                    k = 2;
                                    continue block20;
                                }
                                case 4: {
                                    rec.setField(i, new Integer(is.readInt()));
                                    k = 4;
                                    continue block20;
                                }
                                case -5: {
                                    rec.setField(i, new Long(is.readLong()));
                                    k = 8;
                                    continue block20;
                                }
                                case 2: 
                                case 3: 
                                case 6: 
                                case 7: {
                                    rec.setField(i, new Float(is.readFloat()));
                                    k = 4;
                                    continue block20;
                                }
                                case 8: {
                                    rec.setField(i, new Double(is.readDouble()));
                                    k = 8;
                                    continue block20;
                                }
                                case -1: 
                                case 1: 
                                case 12: {
                                    String s = new String(is.readUTF());
                                    k = s.length();
                                    rec.setField(i, s);
                                    continue block20;
                                }
                                case 91: 
                                case 92: 
                                case 93: {
                                    rec.setField(i, new Date(is.readLong()));
                                    k = 8;
                                    continue block20;
                                }
                                default: {
                                    rec.setField(i, "");
                                }
                            }
                        }
                        lyr.addRecord(rec);
                        ++recCount;
                    }
                }
                finally {
                    dataStorage.closeDataStorageSave();
                }
                is.readUTF();
                lyr.setLoadComplete(is.read() != 0);
                if (recCount > 0) {
                    lyr.dataStorage.unionStorages(dataStorage);
                    FloatRectangle ext = lyr.getLayerExtent();
                    this.map.addExtent(ext);
                    if (this.map.getLastExtent().intersects(ext)) {
                        this.map.updateMap();
                    }
                }
                lyr.metadata.memsize += sizePacket;
                this.addStatusInfo(0, lyr, "Download " + recCount + '/' + recCountSent + " records. " + sizePacket + " bytes" + (lyr.isLoadComplete() ? ". COMPLETE" : ""));
            }
        }
    }

    static String getParam(String url, String param, String def) {
        try {
            StringTokenizer st = new StringTokenizer(url, "&");
            while (st.hasMoreTokens()) {
                String ss = st.nextToken();
                int k = ss.indexOf(61);
                if (k <= 0 || k >= ss.length() - 1 || !ss.substring(0, k).equalsIgnoreCase(param)) continue;
                return ss.substring(k + 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return def;
    }

    private void doAttribRequest(ProxyRequest req) throws Exception {
        String link;
        if (req.layerId == null) {
            return;
        }
        Project project = this.map.getProject();
        Layer layer = project.getLayerById(req.layerId);
        if (layer == null || !layer.canSearch) {
            return;
        }
        String sUrl = null;
        RecordsArray records = null;
        if (req.type == 32 || req.type == 35) {
            link = layer.linkSearch != null ? layer.linkSearch : project.linkSearch;
        } else {
            records = layer.getSelection();
            if (layer instanceof LayerVector && (req.type == 30 || MapUtils.isNotEmptyRecs(records) && records.size() > 1)) {
                LayerVector lyr = (LayerVector)layer;
                String string = link = lyr.linkInfo != null ? lyr.linkInfo : project.linkInfo;
                if (link != null) {
                    StringBuffer sQuery = new StringBuffer();
                    int selectionSize = records.size();
                    if (lyr.serverType == 23) {
                        // empty if block
                    }
                    if (selectionSize > 255) {
                        selectionSize = 255;
                    }
                    for (int i = 0; i < selectionSize; ++i) {
                        Record rec = records.getRecord(i, 1);
                        sQuery.append(lyr.getId(rec)).append(',');
                    }
                    req.query = sQuery.toString().substring(0, sQuery.length() - 1);
                }
            } else {
                link = layer.linkMain != null ? layer.linkMain : project.linkMain;
            }
        }
        sUrl = layer.getWebLink(link, records, req.query, req.extent, "id=" + this.sessionUser + "&m=" + this.sessionMagic);
        if (sUrl != null) {
            this.map.showURL(sUrl);
        } else if (layer instanceof LayerVector) {
            if (this.map.supressAttributeFrame) {
                return;
            }
            LayerVector lyr2 = (LayerVector)layer;
            if (req.type == 32 || req.type == 35) {
                if (!layer.isLoadComplete() && layer.isDataOnServer && layer.serverType != 23) {
                    this.doGeoRequest(req);
                }
                if ((records = req.type == 32 ? lyr2.findBySearchField(req.query) : lyr2.findByExpression(req.query)) == null || records.size() == 0) {
                    this.map.broadcastMessage(114, "");
                } else {
                    this.map.broadcastMessage(115, String.valueOf(records.size()));
                }
            }
            if (records != null && records.size() == 1 && this.zoomToOneResult && req.type == 32) {
                this.map.selectObjects(lyr2, records);
            } else {
                this.map.host.showAttributes(lyr2, records);
            }
        }
    }

    public Layer hasPasswords() {
        Project prj = this.map.getProject();
        Layer lyrPass = null;
        int layerCount = prj.getLayerCount();
        int k = 0;
        String lyrList = "";
        for (int i = 0; i < layerCount; ++i) {
            Layer lyr = prj.getLayerByIndex(i);
            if (!lyr.isDataOnServer || lyrList.indexOf(lyr.datasetId + ',') >= 0) continue;
            lyrList = lyrList + lyr.datasetId + ",";
            ++k;
        }
        if (k > 0) {
            lyrList = lyrList.substring(0, lyrList.length() - 1);
            StringBuffer getReq = new StringBuffer();
            getReq.append(this.servletURL).append('?').append("rq").append("=GetPass").append('&').append("l").append('=').append(lyrList);
            try {
                URL url = new URL(getReq.toString());
                InputStream input = url.openStream();
                DataInputStream dis = new DataInputStream(input);
                int errorCode = Readers.readInt(dis);
                lyrPass = null;
                if (errorCode == 215) {
                    this.addStatusInfo(215, null, "Can't load copyright info. Server busy");
                } else if (errorCode != 0) {
                    this.addStatusInfo(errorCode, null, "Can't load copyright info. " + dis.readUTF());
                } else {
                    while ((k = Readers.readInt(dis)) >= 1) {
                        String datasetId = dis.readUTF();
                        lyrPass = prj.getLayerByDsId(datasetId);
                        if (lyrPass != null) {
                            lyrPass.metadata.passResolved = false;
                            lyrPass.metadata.put(8, dis.readUTF());
                            lyrPass.metadata.put(24, dis.readUTF());
                            continue;
                        }
                        dis.readUTF();
                        dis.readUTF();
                    }
                }
            }
            catch (Exception e) {
                this.addStatusInfo(202, null, "Can't load copyright info. " + e.getMessage());
            }
        }
        return lyrPass;
    }
}

