/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Color;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.LayerRaster;
import org.alov.map.LayerSetup;
import org.alov.map.LayerVector;
import org.alov.map.LayerZoomify;
import org.alov.map.Loader;
import org.alov.map.LoaderTM;
import org.alov.map.LoaderTM3;
import org.alov.map.RadioGroup;
import org.alov.map.Record;
import org.alov.map.Renderer;
import org.alov.util.Const;
import org.alov.util.ExDate;
import org.alov.util.Strings;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

public class Project
implements Const,
Serializable {
    public String name;
    public String language = "en";
    public int MapUnits;
    public String geoProjection = null;
    public int ZoomUnits;
    public Vector layers = new Vector();
    public Vector radioGroups = new Vector();
    public Hashtable domains = new Hashtable();
    public Hashtable themes = new Hashtable();
    public Hashtable themesLayer = new Hashtable();
    public String domainsNames = "";
    public String themesNames = "";
    public FloatRectangle maxExtent = null;
    protected boolean isAnimatedZoom = false;
    public String startExtentName = null;
    public String startTheme = null;
    public String startLayer = null;
    public double zmin;
    public double zmax;
    public Color mapBackground;
    public boolean moveBeyondProject = false;
    public boolean hasKeyMap = false;
    public Color keyMapOutline;
    public Color keyMapBackground;
    public String keyMapTheme = "unnamed";
    public String linkSearch = null;
    public String linkInfo = null;
    public String linkMain = null;
    public boolean isDynamic = true;
    public boolean isDynamic_LayerVisible = true;
    public boolean isDynamic_RemoveOutOfExtent = true;
    public int iDynamic_OrderOfLayers = 0;
    public boolean isDynamic_AddDialogue = false;
    public boolean isTimeMap = false;
    public boolean isDynamic_SearchAlways = true;
    public boolean isDynamic_AcceptAll = false;
    public String sDynamoAdd = "";
    public boolean forceSearchForDynamic = false;
    public Vector dynamicLayers = null;
    public Hashtable datasetPasswords = new Hashtable();
    public String defaultPassword = null;
    public Vector renderers = new Vector();
    public int rendererDynamicCount = 0;
    public int animationDelay = 1000;
    boolean isLoaded = false;
    boolean isCompactStorage = false;
    public boolean isTimeEnabled = false;
    public ExDate startDate;
    public ExDate endDate;

    public String getWebLink(Layer lyr, Record rec) {
        return lyr.getWebLink(lyr.linkMain != null ? lyr.linkMain : this.linkMain, rec, null, null, null);
    }

    public void sortRenderersByLevels() {
        int i;
        Hashtable<Integer, Vector<Renderer>> levels = new Hashtable<Integer, Vector<Renderer>>();
        Vector<Renderer> dynamicRenderers = new Vector<Renderer>();
        int layerCount = this.getLayerCount();
        for (int i2 = 0; i2 < layerCount; ++i2) {
            Layer lyr = (Layer)this.layers.elementAt(i2);
            Vector rends = lyr.renderers;
            int rendCount = rends.size();
            for (int j = 0; j < rendCount; ++j) {
                Renderer rend = (Renderer)rends.elementAt(j);
                if (rend.isDynamic()) {
                    dynamicRenderers.addElement(rend);
                    continue;
                }
                Integer lvl = new Integer(rend.getLevel());
                Vector<Renderer> rnds = (Vector<Renderer>)levels.get(lvl);
                if (rnds == null) {
                    rnds = new Vector<Renderer>();
                    levels.put(lvl, rnds);
                }
                rnds.addElement(rend);
            }
        }
        Enumeration enm = levels.keys();
        int lvlCount = 0;
        while (enm.hasMoreElements()) {
            enm.nextElement();
            ++lvlCount;
        }
        Integer[] lvls = new Integer[lvlCount];
        enm = levels.keys();
        for (int i3 = 0; i3 < lvlCount; ++i3) {
            lvls[i3] = (Integer)enm.nextElement();
        }
        boolean ok = false;
        while (!ok) {
            ok = true;
            for (int i4 = 0; i4 < lvlCount - 1; ++i4) {
                if (lvls[i4] <= lvls[i4 + 1]) continue;
                Integer t = lvls[i4];
                lvls[i4] = lvls[i4 + 1];
                lvls[i4 + 1] = t;
                ok = false;
            }
        }
        int cnt = this.renderers.size();
        for (i = 0; i < cnt; ++i) {
            ((Vector)this.renderers.elementAt(i)).removeAllElements();
        }
        this.renderers.removeAllElements();
        for (i = 0; i < lvlCount; ++i) {
            this.renderers.addElement(levels.get(lvls[i]));
        }
        if (dynamicRenderers.size() > 0) {
            this.renderers.addElement(dynamicRenderers);
            this.rendererDynamicCount = 1;
        }
    }

    public int getLayerCount() {
        return this.layers == null ? 0 : this.layers.size();
    }

    public Layer getLayerById(String id) {
        int count = this.getLayerCount();
        for (int i = 0; i < count; ++i) {
            Layer lyr = (Layer)this.layers.elementAt(i);
            if (!lyr.id.equals(id)) continue;
            return lyr;
        }
        return null;
    }

    public Layer getLayerByDsId(String datasetId) {
        if (!Strings.isNullOrBlank(datasetId)) {
            int count = this.getLayerCount();
            for (int i = 0; i < count; ++i) {
                Layer lyr = (Layer)this.layers.elementAt(i);
                if (!lyr.datasetId.equals(datasetId)) continue;
                return lyr;
            }
        }
        return null;
    }

    public Layer getLayerByName(String name) {
        int count = this.getLayerCount();
        if (name != null) {
            for (int i = 0; i < count; ++i) {
                Layer lyr = (Layer)this.layers.elementAt(i);
                if (!name.equalsIgnoreCase(lyr.getName())) continue;
                return lyr;
            }
        }
        return null;
    }

    public Layer getLayerByIndex(int id) {
        return (Layer)this.layers.elementAt(id);
    }

    public RadioGroup getRadioGroupByName(String name) {
        if (name != null) {
            int count = this.radioGroups.size();
            for (int i = 0; i < count; ++i) {
                RadioGroup rg = (RadioGroup)this.radioGroups.elementAt(i);
                if (!name.equalsIgnoreCase(rg.name)) continue;
                return rg;
            }
        }
        return null;
    }

    public XmlElement load(InputStream is, LayerSetup layerSetup) throws Exception {
        XmlElement root = XmlUtils.parseStream(is, "");
        if (root == null || root.getNodeName().equalsIgnoreCase("project")) {
            Loader.parseProject(this, root, layerSetup);
        } else {
            int nVersion = XmlUtils.getElInt("TMSVersion", root, 2);
            int nFormat = XmlUtils.getElInt("TMSFormat", root, 2);
            if (nVersion == 3 || nFormat == 3) {
                LoaderTM3.parseProject(this, root, layerSetup);
            } else {
                LoaderTM.parseProject(this, root, layerSetup);
            }
        }
        int count = this.getLayerCount();
        for (int i = 0; i < count; ++i) {
            Layer lyr = this.getLayerByIndex(i);
            lyr.setDepend(this);
        }
        layerSetup.addStatusInfo(0, null, "end parse " + count);
        this.isLoaded = true;
        return root;
    }

    public void kill() {
        this.isLoaded = false;
        int count = this.layers.size();
        for (int i = 0; i < count; ++i) {
            Layer lyr = this.getLayerByIndex(i);
            lyr.clear(true);
            Object var3_3 = null;
        }
        this.renderers.removeAllElements();
        this.layers.removeAllElements();
        this.layers = null;
        this.domains = null;
        this.themes = null;
        this.themesLayer = null;
    }

    void clearSameLayers(Layer lyr) {
        lyr.clear(false);
        int count3 = this.getLayerCount();
        for (int kk = 0; kk < count3; ++kk) {
            Layer lyrD = this.getLayerByIndex(kk);
            if (!lyrD.datasetId.equals(lyr.datasetId) || lyrD.id.equals(lyr.id)) continue;
            lyrD.clear(false);
        }
    }

    public void setSameLayers(Layer lyr, LayerSetup lyrSetup) {
        block18: {
            block17: {
                String sClassName = lyr.getClass().getName();
                if (!(lyr instanceof LayerVector)) break block17;
                int count3 = this.getLayerCount();
                for (int kk = 0; kk < count3; ++kk) {
                    Layer lyrD = this.getLayerByIndex(kk);
                    if (!lyrD.datasetId.equals(lyr.datasetId) || !sClassName.equals(lyrD.getClass().getName()) || lyrD.id.equals(lyr.id)) continue;
                    LayerVector l1 = (LayerVector)lyr;
                    LayerVector l2 = (LayerVector)lyrD;
                    l2.fi_description = l1.fi_description;
                    l2.fi_id = l1.fi_id;
                    if (l2.linkMain == null) {
                        l2.linkMain = l1.linkMain;
                    }
                    if (l2.linkSearch == null) {
                        l2.linkSearch = l1.linkSearch;
                    }
                    if (l2.linkInfo == null) {
                        l2.linkInfo = l1.linkInfo;
                    }
                    if (l2.linkTips == null) {
                        l2.linkTips = l1.linkTips;
                    }
                    l2.dateType = l1.dateType;
                    l2.f_dateLow = l1.f_dateLow;
                    l2.f_dateHigh = l1.f_dateHigh;
                    if (lyr instanceof LayerZoomify && lyrD instanceof LayerZoomify) {
                        LayerZoomify l3 = (LayerZoomify)l1;
                        ((LayerZoomify)l2).setDimensions(l3.geoWidth, l3.geoHeight, l3.imageWidth, l3.imageHeight, l3.tileSize, l3.levelCount);
                    }
                    try {
                        lyrD.prepareLayer();
                        continue;
                    }
                    catch (Exception e) {
                        lyrD.metadata.loadFailed = true;
                        lyrSetup.addStatusInfo(0, lyrD, e.getMessage());
                    }
                }
                break block18;
            }
            if (!(lyr instanceof LayerRaster)) break block18;
            int count3 = this.getLayerCount();
            for (int kk = 0; kk < count3; ++kk) {
                Layer lyrD = this.getLayerByIndex(kk);
                if (!lyrD.datasetId.equals(lyr.datasetId) || lyrD.id.equals(lyr.id)) continue;
                LayerRaster l1 = (LayerRaster)lyr;
                LayerRaster l2 = (LayerRaster)lyrD;
                if (l1.resolutionLevel > 0 || l2.resolutionLevel > 0) continue;
                if (l2.linkMain == null) {
                    l2.linkMain = l1.linkMain;
                }
                if (l2.linkSearch == null) {
                    l2.linkSearch = l1.linkSearch;
                }
                if (l2.linkTips == null) {
                    l2.linkTips = l1.linkTips;
                }
                if (l1.getImageSrc() != null) {
                    l2.setImage(l1.getImageSrc());
                } else {
                    l2.setRaster(l1.getImage());
                }
                if (!l1.isDataOnServer || l2.notPrepared) {
                    try {
                        lyrD.prepareLayer();
                    }
                    catch (Exception e) {
                        lyrD.metadata.loadFailed = true;
                        lyrSetup.addStatusInfo(0, lyrD, e.getMessage());
                    }
                }
                l2.layerExtent = l1.layerExtent;
            }
        }
    }

    public void saveToRawFile(String fileName) {
        try {
            FileOutputStream out = new FileOutputStream(fileName);
            GZIPOutputStream zip = new GZIPOutputStream(out);
            ObjectOutputStream objOut = new ObjectOutputStream(zip);
            objOut.writeObject(this);
            objOut.close();
            zip.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Project loadFromRawFile(InputStream input) throws IOException, ClassNotFoundException {
        GZIPInputStream zip = new GZIPInputStream(input);
        ObjectInputStream objInput = new ObjectInputStream(zip);
        Project prj = (Project)objInput.readObject();
        zip.close();
        return prj;
    }
}

