/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.alov.map.FieldRef;
import org.alov.map.Layer;
import org.alov.map.Record;
import org.alov.map.ValueParser;

class ParsedExpression
implements Serializable {
    Vector expr;
    Hashtable fieldRefs;
    FieldRef[] cachedRefs;

    ParsedExpression() {
    }

    protected boolean isTrue(Record rec) throws Exception {
        boolean result = false;
        Object obj = ValueParser.calculate(this.expr, rec).getValue(rec);
        if (null != obj && obj instanceof Boolean) {
            result = (Boolean)obj;
        }
        return result;
    }

    protected void resolveFields(Layer lyr) throws Exception {
        if (this.fieldRefs != null) {
            Enumeration enm = this.fieldRefs.elements();
            Vector<FieldRef> refs = new Vector<FieldRef>();
            while (enm.hasMoreElements()) {
                FieldRef ref = (FieldRef)enm.nextElement();
                String name = ref.fieldName;
                int index = lyr.getFieldIndex(name);
                if (index < 0) {
                    throw new Exception("Field " + name + " not found in layer: " + lyr.getName());
                }
                lyr.getFieldDef((int)index).isUsedInFilterOrRenderer = true;
                ref.fieldIndex = index;
                refs.addElement(ref);
            }
            int count = refs.size();
            this.cachedRefs = new FieldRef[count];
            for (int i = 0; i < count; ++i) {
                this.cachedRefs[i] = (FieldRef)refs.elementAt(i);
            }
        } else {
            this.cachedRefs = new FieldRef[0];
        }
    }
}

