/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

class MathRec {
    double dx;
    double dy;
    double b;
    double k;
    double A;
    double B;
    double C;

    MathRec(double a1x, double a1y, double a2x, double a2y) {
        this.dx = a2x - a1x;
        this.dy = a2y - a1y;
        if (this.dy == 0.0) {
            this.k = 0.0;
        } else if (this.dx != 0.0) {
            this.k = this.dy / this.dx;
        } else {
            this.k = 1.0E21;
            if (this.dy < 0.0) {
                this.k = -this.k;
            }
        }
        this.b = a1y - this.k * a1x;
    }

    MathRec(int x1, int y1, int x2, int y2) {
        if (x2 == x1) {
            this.A = 1.0;
            this.B = 0.0;
            this.C = -x1;
        } else {
            double K = (y2 - y1) / (x2 - x1);
            double L = (double)y1 - K * (double)x1;
            this.A = -K;
            this.B = 1.0;
            this.C = -L;
        }
    }
}

