/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.RGBImageFilter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.alov.map.Carte;
import org.alov.map.CarteHost;
import org.alov.map.FloatPoint;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.Load2D;
import org.alov.map.Record;
import org.alov.map.RecordsArray;
import org.alov.map.Shape;
import org.alov.map.StreamCounter;
import org.alov.map.Utils2D;
import org.alov.util.Const;
import org.alov.util.Readers;
import org.alov.util.Strings;
import org.alov.util.Utils;
import org.alov.viewer.ImageButton;

public class MapUtils
implements Const {
    static int TotalImageSize = 0;
    private static final String _AUTHORIZ = "Authorization";
    public static Font defaultBoldFont = null;
    public static Font defaultPlainFont = null;
    public static String codeBase = null;
    public static String projectBase = null;
    public static boolean isRunFromDisk = false;
    public static boolean isApplication = false;
    public static boolean isServerSide = false;
    public static boolean isTipsActive = false;
    public static String language = null;
    public static FloatRectangle predefExtent = null;
    public static String predefTheme = null;
    public static String servletURL = "mapserv";
    public static String predefExtentName = null;
    private static ImageObserver imageObserver = null;
    public static boolean showCounter = false;
    private static byte SLD_Enabled = 0;
    private static byte MIF_Enabled = 0;
    public static int MAX_IMAGE_SIZE = 10240000;
    private static final String DEGREE_SIGN = "\u00b0";
    private static final double EARTH_RADIUS_KM = 6378.137;
    private static final double Degree = 57.29577951308232;
    private static Hashtable images;
    private static Hashtable imgUrls;
    private static Object zero;
    private static int requestedImages;

    private MapUtils() {
    }

    protected static boolean isSLD_Enabled() {
        if (SLD_Enabled == 0) {
            SLD_Enabled = 1;
            try {
                Class<?> sld = Class.forName("org.alov.map.SLD");
                sld = Class.forName("org.alov.map.SLD_Loader");
                SLD_Enabled = (byte)2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return SLD_Enabled == 2;
    }

    public static boolean isMIF_Enabled() {
        if (MIF_Enabled == 0) {
            MIF_Enabled = 1;
            try {
                Class<?> sld = Class.forName("org.alov.data.Mif");
                MIF_Enabled = (byte)2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return MIF_Enabled == 2;
    }

    public static int compare(Object o1, Object o2) {
        if (o1.equals(o2)) {
            return 0;
        }
        if (o1 instanceof Number) {
            if (((Number)o1).doubleValue() >= ((Number)o2).doubleValue()) {
                return 1;
            }
            return -1;
        }
        if (o1 instanceof String) {
            return ((String)o1).compareTo((String)o2);
        }
        if (o1 instanceof Date) {
            if (((Date)o2).before((Date)o1)) {
                return 1;
            }
            return -1;
        }
        return -2;
    }

    public static StreamCounter openURL(String baseUrl) throws IOException {
        return MapUtils.openURL(baseUrl, null, null);
    }

    public static StreamCounter openURL(String baseUrl, String sAuthorization, Layer lyr) throws IOException {
        if (baseUrl != null && codeBase != null && baseUrl.indexOf("://") < 0 && baseUrl.indexOf("file:/") < 0) {
            try {
                String s = Strings.getAbsPath(projectBase, baseUrl);
                return MapUtils.openURL_(s, sAuthorization, lyr);
            }
            catch (Exception e) {
                return MapUtils.openURL_(codeBase + baseUrl, sAuthorization, lyr);
            }
        }
        return MapUtils.openURL_(baseUrl, sAuthorization, lyr);
    }

    private static StreamCounter openURL_(String baseUrl, String sAuthorization, Layer lyr) throws IOException {
        StreamCounter sc;
        InputStream is;
        long size = 0L;
        if (baseUrl.startsWith("file:/") && isServerSide) {
            File f = new File(Strings.decode(baseUrl.substring("file:/".length())));
            is = new FileInputStream(f);
            size = f.length();
        } else {
            boolean loadViaServlet = false;
            if (!MapUtils.isUrlInCodeBase(baseUrl)) {
                baseUrl = "?rq=GetImage&rd=" + baseUrl;
                baseUrl = MapUtils.getRealPath(servletURL) + baseUrl;
                loadViaServlet = true;
            }
            URL url = (baseUrl = baseUrl.replace('\\', '/')).startsWith("file:/") ? new URL(baseUrl) : new URL(Strings.setObj(baseUrl, ' ', "%20"));
            URLConnection uc = url.openConnection();
            if (!Strings.isNullOrBlank(sAuthorization)) {
                uc.setRequestProperty(_AUTHORIZ, sAuthorization);
                is = uc.getInputStream();
            } else {
                is = url.openStream();
            }
            if (lyr != null && lyr.getMap() instanceof Carte && showCounter) {
                size = uc.getContentLength();
            }
            if (loadViaServlet) {
                Readers.readInt(is);
                Readers.readInt(is);
            }
        }
        if (lyr != null && size > 5000L && lyr.getMap() instanceof Carte) {
            sc = new StreamCounter(is, 1024, (Carte)lyr.getMap());
            sc.setCounter(size, "[ " + lyr.getName() + ']');
        } else {
            sc = new StreamCounter(is, 1024, null);
        }
        sc.url = baseUrl;
        return sc;
    }

    private static int getUByte(byte a) {
        return a & 0xFF;
    }

    private static int getUWord(byte a, byte b) {
        return a & 0xFF | (b & 0xFF) << 8;
    }

    private static boolean checkImageSize(byte[] bytes) throws Exception {
        Dimension d = MapUtils.getImageSize(bytes);
        long is = d.width * d.height;
        if (Utils.isJava14) {
            long free = Utils.getFreeMemorySpace();
            boolean b = (float)(is *= 4L) / (float)free * 100.0f <= 50.0f;
            return b;
        }
        return is < (long)MAX_IMAGE_SIZE;
    }

    static Dimension getImageSize(byte[] bytes) throws Exception {
        String id87 = "GIF87a";
        String id89 = "GIF89a";
        String idPNG = "PNG\r\n";
        boolean gif89 = false;
        boolean png = false;
        int screenWidth = 0;
        int screenHeight = 0;
        String id = new String(bytes, 0, 6);
        if (id.equals("GIF87a")) {
            gif89 = false;
        } else if (id.equals("GIF89a")) {
            gif89 = true;
        } else if (id.substring(1).equals("PNG\r\n")) {
            png = true;
        } else {
            int M_SOF0 = 192;
            int M_SOF1 = 193;
            int M_SOF2 = 194;
            int M_SOF3 = 195;
            int M_SOF5 = 197;
            int M_SOF6 = 198;
            int M_SOF7 = 199;
            int M_SOF9 = 201;
            int M_SOF10 = 202;
            int M_SOF11 = 203;
            int M_SOF13 = 205;
            int M_SOF14 = 206;
            int M_SOF15 = 207;
            int M_SOI = 216;
            int M_EOI = 217;
            int M_SOS = 218;
            int M_APP14 = 238;
            if (MapUtils.getUByte(bytes[0]) != 255 || MapUtils.getUByte(bytes[1]) != 216) {
                throw new Exception("Unknown image format");
            }
            boolean type = true;
            int p = 2;
            int end = bytes.length;
            while (p < end) {
                if (MapUtils.getUByte(bytes[p]) == 255) {
                    int _id = MapUtils.getUByte(bytes[p + 1]);
                    int len = MapUtils.getUWord(bytes[p + 3], bytes[p + 2]);
                    switch (_id) {
                        case 217: {
                            return null;
                        }
                        case 192: 
                        case 193: 
                        case 194: 
                        case 195: 
                        case 197: 
                        case 198: 
                        case 199: 
                        case 201: 
                        case 202: 
                        case 203: 
                        case 205: 
                        case 206: 
                        case 207: {
                            type = false;
                            screenHeight = MapUtils.getUWord(bytes[p + 6], bytes[p + 5]);
                            screenWidth = MapUtils.getUWord(bytes[p + 8], bytes[p + 7]);
                            return new Dimension(screenWidth, screenHeight);
                        }
                    }
                    p += len + 2;
                    continue;
                }
                ++p;
            }
            return null;
        }
        if (png) {
            screenWidth = (bytes[19] & 0xFF) + 256 * (bytes[18] & 0xFF);
            screenHeight = (bytes[23] & 0xFF) + 256 * (bytes[22] & 0xFF);
        } else {
            screenWidth = (bytes[6] & 0xFF) + 256 * (bytes[7] & 0xFF);
            screenHeight = (bytes[8] & 0xFF) + 256 * (bytes[9] & 0xFF);
        }
        return new Dimension(screenWidth, screenHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadImageToByteArray(Layer layer, String url) throws Exception {
        byte[] bytes = null;
        StreamCounter is = layer != null && layer.provider != null ? layer.provider.openURL(url) : MapUtils.openURL(url);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(8192);
        try {
            int howmany;
            byte[] buf = new byte[8192];
            while ((howmany = ((InputStream)is).read(buf)) > 0) {
                bos.write(buf, 0, howmany);
            }
            ((InputStream)is).close();
            byte[] byArray = bytes = bos.toByteArray();
            return byArray;
        }
        finally {
            bos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image loadImage2(Layer layer, String url) throws Exception {
        StreamCounter is = layer != null && layer.provider != null ? layer.provider.openURL(url) : MapUtils.openURL(url);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(8192);
        try {
            Image image;
            int howmany;
            byte[] bytes = null;
            byte[] buf = new byte[8192];
            while ((howmany = ((InputStream)is).read(buf)) > 0) {
                bos.write(buf, 0, howmany);
            }
            ((InputStream)is).close();
            bytes = bos.toByteArray();
            if (!isApplication && !MapUtils.checkImageSize(bytes)) {
                if (Utils.isJava14) {
                    throw new Exception("\nImage exceeding threshold size (would use 50% of available memory)");
                }
                throw new Exception("\nImage is too large. Maximum width*height value is " + MAX_IMAGE_SIZE);
            }
            Image image2 = image = MapUtils.createImageFromBytes(bytes);
            return image2;
        }
        finally {
            bos.close();
        }
    }

    public static Image createImageFromBytes(byte[] bytes) throws Exception {
        if (bytes != null) {
            Toolkit t = Toolkit.getDefaultToolkit();
            Image image = t.createImage(bytes);
            return MapUtils.prepareImage(t, image);
        }
        return null;
    }

    private static Image prepareImage(Toolkit t, Image image) throws Exception {
        int checkResult;
        t.prepareImage(image, 1000, 1000, imageObserver);
        int imageW = -1;
        int imageH = -1;
        int k = 0;
        while (((imageW = image.getHeight(imageObserver)) < 0 || (imageH = image.getWidth(imageObserver)) < 0) && k < 10) {
            try {
                ++k;
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        for (k = 0; k < 100 && ((checkResult = t.checkImage(image, imageW, imageH, imageObserver)) & 0x20) == 0; ++k) {
            if ((checkResult & 0x10) != 0) {
                if ((checkResult & 4) != 0) break;
            }
            Thread.sleep(100L);
        }
        return image;
    }

    public static ImageObserver getGlobalImageObserver() {
        return imageObserver;
    }

    public static void setGlobalImageObserver(ImageObserver io) {
        imageObserver = io;
    }

    public static int setUnits(String units, int def) {
        if (units == null) {
            return def;
        }
        if (units.equalsIgnoreCase("meters")) {
            return 1;
        }
        if (units.equalsIgnoreCase("degrees")) {
            return 0;
        }
        if (units.equalsIgnoreCase("km")) {
            return 2;
        }
        if (units.equalsIgnoreCase("feet")) {
            return 4;
        }
        if (units.equalsIgnoreCase("miles")) {
            return 5;
        }
        if (units.equalsIgnoreCase("inches")) {
            return 3;
        }
        if (units.equalsIgnoreCase("m")) {
            return 1;
        }
        if (units.equalsIgnoreCase("km")) {
            return 2;
        }
        if (units.equalsIgnoreCase("ft")) {
            return 4;
        }
        if (units.equalsIgnoreCase("mi")) {
            return 5;
        }
        if (units.equalsIgnoreCase("nmi")) {
            return 6;
        }
        if (units.equalsIgnoreCase("in")) {
            return 3;
        }
        return def;
    }

    public static String formatDistance(double val, int srcUnits, int destUnits, int unitsFormat, String unitName) {
        StringBuffer s = new StringBuffer();
        val = MapUtils.convertDistance(val, srcUnits, destUnits);
        s.append(Strings.doubleToStr(val, unitsFormat));
        s.append(" ");
        s.append(unitName);
        return s.toString();
    }

    public static double convertDistance(double val, int srcUnits, int destUnits) {
        switch (srcUnits) {
            case 1: {
                val *= (double)39.37f;
                break;
            }
            case 0: 
            case 2: {
                val = val * 1000.0 * (double)39.37f;
                break;
            }
            case 4: {
                val *= 12.0;
                break;
            }
            case 5: {
                val *= 63360.0;
                break;
            }
            case 6: {
                val *= 72913.2421875;
            }
        }
        switch (destUnits) {
            case 1: {
                val /= (double)39.37f;
                break;
            }
            case 0: 
            case 2: {
                val = val / 1000.0 / (double)39.37f;
                break;
            }
            case 4: {
                val /= 12.0;
                break;
            }
            case 5: {
                val /= 63360.0;
                break;
            }
            case 6: {
                val /= 72913.2421875;
            }
        }
        return val;
    }

    public static String formatDegree(double deg, boolean isLatitude, boolean isHemis) {
        char s;
        if (isHemis) {
            if (isLatitude) {
                char c = s = deg > 0.0 && deg < 180.0 ? (char)'E' : 'W';
                if (Math.abs(deg) > 180.0) {
                    deg = 360.0 - Math.abs(deg);
                }
            } else {
                s = deg > 0.0 ? (char)'N' : 'S';
            }
            deg = Math.abs(deg);
        } else {
            s = ' ';
        }
        double min = Math.abs((deg - (double)((int)deg)) * 60.0);
        int sec = (int)Math.round((min - (double)((int)min)) * 60.0);
        return (int)deg + DEGREE_SIGN + (int)min + '\'' + sec + "'' " + s;
    }

    public static double getDistance(FloatPoint from, FloatPoint to, int units) {
        if (units == 0) {
            return MapUtils.lengthDegrees(from.x, from.y, to.x, to.y);
        }
        double dx = to.x - from.x;
        double dy = to.y - from.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    private static double lengthDegrees(double b1, double a1, double b2, double a2) {
        double value;
        if ((value = Math.acos(Math.cos(a1 *= Math.PI / 180) * Math.cos(b1 *= Math.PI / 180) * Math.cos(a2 *= Math.PI / 180) * Math.cos(b2 *= Math.PI / 180) + Math.cos(a1) * Math.sin(b1) * Math.cos(a2) * Math.sin(b2) + Math.sin(a1) * Math.sin(a2)) * 6378.137) == Double.NaN) {
            value = 0.0;
        }
        return value;
    }

    public static double getDistance(FloatRectangle ext, int MapUnits, int ZoomUnits) {
        if (ext == null) {
            return 0.0;
        }
        double pz = 0.0;
        double factor = 1.0;
        switch (MapUnits) {
            case 0: {
                double ycenter = Math.abs(ext.y2 - (ext.y2 - ext.y) / 2.0);
                if (ycenter >= 90.0) {
                    ycenter = 89.99999237060547;
                }
                factor = Math.cos(ycenter * Math.PI / 180.0) * (double)68.8f * 63360.0;
                break;
            }
            case 1: {
                factor = 39.37f;
                break;
            }
            case 2: {
                factor = 39370.0;
                break;
            }
            case 4: {
                factor = 12.0;
                break;
            }
            case 5: {
                factor = 63360.0;
                break;
            }
            case 6: {
                factor = 72913.2421875;
            }
        }
        pz = Math.abs(ext.x2 - ext.x) * factor;
        switch (ZoomUnits) {
            case 1: {
                pz = pz * (double)2.54f / 100.0;
                break;
            }
            case 2: {
                pz = pz * (double)2.54f / 100000.0;
                break;
            }
            case 4: {
                pz /= 12.0;
                break;
            }
            case 5: {
                pz /= 63360.0;
                break;
            }
            case 6: {
                pz /= 72913.2421875;
            }
        }
        return pz;
    }

    public static double toMapUnits(double distance, FloatRectangle ext, int MapUnits, int ZoomUnits) {
        if (distance <= 0.0) {
            return 0.0;
        }
        double pz = 0.0;
        double factor = 1.0;
        double ycenter = 0.0;
        switch (ZoomUnits) {
            case 1: {
                pz = distance * 100.0 / (double)2.54f;
                break;
            }
            case 2: {
                pz = distance * 100000.0 / (double)2.54f;
                break;
            }
            case 4: {
                pz = distance * 12.0;
                break;
            }
            case 5: {
                pz = distance * 63360.0;
            }
            case 6: {
                pz = distance * 72913.2421875;
            }
        }
        switch (MapUnits) {
            case 0: {
                if (ext != null && (ycenter = Math.abs(ext.y2 - (ext.y2 - ext.y) / 2.0)) >= 90.0) {
                    ycenter = 89.99999237060547;
                }
                factor = Math.cos(ycenter * Math.PI / 180.0) * (double)68.8f * 63360.0;
                break;
            }
            case 1: {
                factor = 39.37f;
                break;
            }
            case 2: {
                factor = 39370.0;
                break;
            }
            case 4: {
                factor = 12.0;
                break;
            }
            case 5: {
                factor = 63360.0;
                break;
            }
            case 6: {
                factor = 72913.2421875;
            }
        }
        return pz / factor;
    }

    public static double toDouble(Object s) {
        return MapUtils.toDoubleDef(s, 0.0);
    }

    public static double toDoubleDef(Object obj, double def) {
        try {
            if (obj == null) {
                return def;
            }
            if (obj instanceof Number) {
                return ((Number)obj).doubleValue();
            }
            return Double.valueOf((String)obj);
        }
        catch (Exception e) {
            return def;
        }
    }

    public static String getRealPath(String url) {
        if (codeBase != null && url != null && url.indexOf("http://") != 0 && url.indexOf("file:/") < 0 && url.indexOf("javascript:") < 0) {
            if (url.indexOf(":\\") == 1) {
                return "file:/" + url;
            }
            if (url.indexOf("\\") == 0) {
                return "file://" + url.substring(2);
            }
            return codeBase + url;
        }
        return url;
    }

    private static boolean isUrlInCodeBase(String url) {
        if (codeBase != null && url != null && codeBase.indexOf("file:/") < 0 && url.indexOf(":\\") != 1 && (url.indexOf("http://") == 0 || url.indexOf("file:/") == 0)) {
            return url.toLowerCase().startsWith(codeBase.toLowerCase()) && url.indexOf("?rq=GetImage&rd=") < 0;
        }
        return true;
    }

    public static Component findComp(Container cont, String sName) {
        int cnt = cont.getComponentCount();
        for (int i = 0; i < cnt; ++i) {
            Component c2 = cont.getComponent(i);
            if (sName.equalsIgnoreCase(c2.getName())) {
                return c2;
            }
            if (!(c2 instanceof Container) || (c2 = MapUtils.findComp((Container)c2, sName)) == null) continue;
            return c2;
        }
        return null;
    }

    public static boolean isNotEmpty(Vector v) {
        return v != null && v.size() > 0;
    }

    public static boolean isNotEmptyRecs(RecordsArray v) {
        return v != null && v.size() > 0;
    }

    public static void addActionListener(ActionListener l, Container container, String sName) {
        Component bb = MapUtils.findComp(container, sName);
        if (bb != null && l != null) {
            if (bb instanceof Button) {
                ((Button)bb).addActionListener(l);
            } else if (bb instanceof ImageButton) {
                ((ImageButton)bb).addActionListener(l);
            }
        }
    }

    public static void addActionListener(ActionListener l, Container container) {
        int cnt = container.getComponentCount();
        for (int i = 0; i < cnt; ++i) {
            Component c2 = container.getComponent(i);
            if (c2 instanceof Button) {
                ((Button)c2).addActionListener(l);
                continue;
            }
            if (c2 instanceof ImageButton) {
                ((ImageButton)c2).addActionListener(l);
                continue;
            }
            if (!(c2 instanceof Container)) continue;
            MapUtils.addActionListener(l, (Container)c2);
        }
    }

    private static double Hav(double X) {
        return (1.0 - Math.cos(X)) / 2.0;
    }

    static double sphericalPolyArea(double[] Lat, double[] Lon) {
        double HalfPi = 1.5707963267948966;
        int N = Lat.length - 1;
        double Lam2 = 0.0;
        double Beta2 = 0.0;
        double CosB2 = 0.0;
        double Sum = 0.0;
        for (int J = 0; J <= N; ++J) {
            double CosB1;
            double Beta1;
            double Lam1;
            int K = J + 1;
            if (J == 0) {
                Lam1 = Lon[J];
                Beta1 = Lat[J];
                Lam2 = Lon[J + 1];
                Beta2 = Lat[J + 1];
                CosB1 = Math.cos(Beta1);
                CosB2 = Math.cos(Beta2);
            } else {
                K = (J + 1) % (N + 1);
                Lam1 = Lam2;
                Beta1 = Beta2;
                Lam2 = Lon[K];
                Beta2 = Lat[K];
                CosB1 = CosB2;
                CosB2 = Math.cos(Beta2);
            }
            if (Lam1 == Lam2) continue;
            double HavA = MapUtils.Hav(Beta2 - Beta1) + CosB1 * CosB2 * MapUtils.Hav(Lam2 - Lam1);
            double A = 2.0 * Math.asin(Math.sqrt(HavA));
            double B = 1.5707963267948966 - Beta2;
            double C = 1.5707963267948966 - Beta1;
            double S = 0.5 * (A + B + C);
            double T = Math.tan(S / 2.0) * Math.tan((S - A) / 2.0) * Math.tan((S - B) / 2.0) * Math.tan((S - C) / 2.0);
            double Excess = Math.abs(4.0 * Math.atan(Math.sqrt(Math.abs(T)))) * 57.29577951308232;
            if (Lam2 < Lam1) {
                Excess = -Excess;
            }
            Sum += Excess;
        }
        return Math.abs(Sum);
    }

    public static double getAreaSqKm(Record rec) {
        double SqMi = 273218.4;
        double SqKm = 707632.4;
        double sum = 0.0;
        int shapeCount = rec.getShapeCount();
        for (int i = 0; i < shapeCount; ++i) {
            Shape shape = rec.getShape(i);
            int pointCount = shape.xCoords.length;
            if (pointCount <= 2) continue;
            double[] lat = new double[pointCount];
            double[] lon = new double[pointCount];
            for (int j = 0; j < pointCount; ++j) {
                lat[j] = shape.yCoords[j] / 57.29577951308232;
                lon[j] = shape.xCoords[j] / 57.29577951308232;
            }
            double area = MapUtils.sphericalPolyArea(lat, lon) * 707632.4;
            sum += area;
        }
        return sum;
    }

    public static Vector wrapString(Graphics g, String s, int wMax) {
        Vector<String> splitted = new Vector<String>();
        if (g == null) {
            splitted.addElement(s);
            return splitted;
        }
        FontMetrics fm = g.getFontMetrics();
        StringTokenizer tok = new StringTokenizer(s, " \t\n\r", true);
        String nextString = "";
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (token.indexOf(10) == 0) {
                splitted.addElement(nextString);
                nextString = "";
                continue;
            }
            String testString = nextString;
            int width = fm.stringWidth(testString = testString + token);
            if (width < wMax || nextString.length() <= 0) {
                nextString = testString;
                continue;
            }
            splitted.addElement(nextString);
            nextString = token;
        }
        if (nextString.length() >= 0) {
            splitted.addElement(nextString);
        }
        return splitted;
    }

    public static int getCurrentFontHeight(Graphics g) {
        return g != null ? g.getFontMetrics().getHeight() : defaultBoldFont.getSize();
    }

    public static int textHeight(String s, Graphics g, int w, boolean wrap) {
        int fontHeight = MapUtils.getCurrentFontHeight(g);
        if (wrap && s != null) {
            Vector wrapped = MapUtils.wrapString(g, s, w);
            return fontHeight * wrapped.size();
        }
        return fontHeight;
    }

    public static Dimension getTextDimension(String s, Graphics g, int w, boolean wrap) {
        int fontHeight = MapUtils.getCurrentFontHeight(g);
        if (wrap && s != null) {
            Vector wrapped = MapUtils.wrapString(g, s, w);
            int maxWidth = 0;
            if (g != null) {
                FontMetrics fm = g.getFontMetrics();
                for (int i = 0; i < wrapped.size(); ++i) {
                    maxWidth = Math.max(maxWidth, fm.stringWidth((String)wrapped.elementAt(i)));
                }
            } else {
                int sz = defaultBoldFont.getSize();
                for (int i = 0; i < wrapped.size(); ++i) {
                    maxWidth = Math.max(maxWidth, ((String)wrapped.elementAt(i)).length() * sz);
                }
            }
            return new Dimension(maxWidth, fontHeight * wrapped.size());
        }
        return new Dimension(g != null ? g.getFontMetrics().stringWidth(s) : defaultBoldFont.getSize(), fontHeight);
    }

    public static void drawString(Graphics g, String s, int x, int y, int width, int height, boolean wrap) {
        if (s == null) {
            return;
        }
        try {
            int th = g.getFontMetrics().getHeight();
            if (wrap) {
                Vector splitted = MapUtils.wrapString(g, s, width);
                int count = splitted.size();
                if (height > count * th) {
                    y += (height - count * th) / 2;
                }
                for (int i = 0; i < count; ++i) {
                    y += th;
                    String s2 = (String)splitted.elementAt(i);
                    if (s2 == null) continue;
                    g.drawString(s2, x, y);
                }
            } else {
                if (height > th) {
                    y += (height - th) / 2;
                }
                g.drawString(s, x, y + th);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getImageUrl(Image img) {
        Hashtable hashtable = images;
        synchronized (hashtable) {
            return (String)imgUrls.get(img);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void imageAborted(String url) {
        Hashtable hashtable = images;
        synchronized (hashtable) {
            images.put(url, zero);
        }
    }

    public static Font createAndVerifyFont(String fontName, int fontStyle, int fontSize, String test) {
        Font font = null;
        try {
            if (Utils2D.have2d() && Strings.checkSuffix(fontName, ".ttf")) {
                StreamCounter is = MapUtils.openURL(fontName);
                font = Font.createFont(0, is);
                font = Utils2D.createTTF(font, fontStyle, fontSize);
            } else {
                font = new Font(fontName, fontStyle, fontSize);
            }
            if (Utils2D.have2d() && Load2D.isInvalidFont(font, test)) {
                font = null;
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        return font;
    }

    static void rotate_coords(int[] x, int[] y, int x0, int y0, float angle) {
        if (angle != 0.0f) {
            int c = x.length;
            for (int i = 0; i < c; ++i) {
                int xc = x[i] - x0;
                int yc = y[i] - y0;
                float l = (float)Math.sqrt(xc * xc + yc * yc);
                float a = (float)Math.atan2(yc, xc) + angle;
                x[i] = (int)Math.round((double)l * Math.cos(a)) + x0;
                y[i] = (int)Math.round((double)l * Math.sin(a)) + y0;
            }
        }
    }

    public static String parameterArgument(CarteHost host, String s) {
        int end;
        int start;
        if (host == null) {
            return s;
        }
        int last = -1;
        while ((start = s.indexOf("[", last)) > last && (end = s.indexOf("]", last)) != -1) {
            String paramName = s.substring(start + 1, end);
            String paramValue = host.getParameter(paramName, null);
            last = start;
            if (paramValue == null) continue;
            s = s.substring(0, start) + paramValue + s.substring(end + 1);
        }
        return s;
    }

    public static double sqr(double value) {
        return value * value;
    }

    static boolean intersectCircle(FloatPoint org, FloatPoint dst, FloatPoint center, double r) {
        return MapUtils.intersectCircle(new FloatPoint(org.x - center.x, org.y - center.y), new FloatPoint(dst.x - center.x, dst.y - center.y), r);
    }

    static boolean intersectCircle(FloatPoint org, FloatPoint dst, double r) {
        double b;
        double r2 = MapUtils.sqr(r);
        double orgX2 = MapUtils.sqr(org.x);
        double orgY2 = MapUtils.sqr(org.y);
        double dx = dst.x - org.x;
        double dy = dst.y - org.y;
        if (0.0 == dx) {
            if (0.0 == dy) {
                return orgX2 + orgY2 <= r2;
            }
            if (Math.abs(org.x) <= r) {
                double y = Math.sqrt(r2 - orgX2);
                return 1.0 >= y / Math.abs(dy);
            }
            return false;
        }
        double k = dy / dx;
        double k2 = MapUtils.sqr(k);
        double D = r2 * (k2 + 1.0) - (b = org.y - k * org.x) * b;
        if (0.0 > D) {
            return false;
        }
        double x1 = (-k * b + Math.sqrt(D)) / (k2 + 1.0);
        double x2 = (-k * b - Math.sqrt(D)) / (k2 + 1.0);
        double y1 = k * x1 + b;
        double y2 = k * x2 + b;
        return Math.abs((x1 - org.x) / dx - 0.5) <= 0.5 || Math.abs((x2 - org.x) / dx - 0.5) <= 0.5 || orgX2 + orgY2 <= r2 || MapUtils.sqr(dst.x) + MapUtils.sqr(dst.y) <= r2;
    }

    static boolean intersectShape(FloatPoint org, FloatPoint dst, Shape shape) {
        if (null == org || null == dst || null == shape) {
            return false;
        }
        double[] xc = shape.xCoords;
        double[] yc = shape.yCoords;
        int pointCount = xc.length;
        double dx = dst.x - org.x;
        double dy = dst.y - org.y;
        double k = Double.POSITIVE_INFINITY;
        if (0.0 == dx) {
            if (0.0 == dy) {
                return Shape.containsPoint(shape, org.x, org.y);
            }
        } else {
            k = dy / dx;
        }
        double b = org.y - k * org.x;
        double x1 = xc[pointCount - 1];
        double y1 = yc[pointCount - 1];
        FloatPoint intersectPoint = new FloatPoint(0.0, 0.0);
        for (int i = 0; i < pointCount; ++i) {
            boolean result;
            double x2 = xc[i];
            double y2 = yc[i];
            double dx1 = x2 - x1;
            double dy1 = y2 - y1;
            double k1 = 0.0 != dx1 ? dy1 / dx1 : Double.POSITIVE_INFINITY;
            double b1 = y1 - k1 * x1;
            boolean bl = result = 0.0 == dx1 && 0.0 == dy1 ? MapUtils.intersectPoint(x1, y1, org.x, dx, org.y, dy, k, b, intersectPoint) : MapUtils.intersectsSegments(org.x, dx, org.y, dy, k, b, x1, x2 - x1, y1, y2 - y1, k1, b1, intersectPoint);
            if (result) {
                return true;
            }
            x1 = x2;
            y1 = y2;
        }
        return false;
    }

    public static boolean shapeContainsShape(Shape container, Shape shape) {
        int ccount = shape.xCoords.length - 1;
        for (int i = 0; i < ccount; ++i) {
            if (!MapUtils.intersectShape(new FloatPoint(shape.xCoords[i], shape.xCoords[i]), new FloatPoint(shape.xCoords[i + 1], shape.xCoords[i + 1]), container)) continue;
            return false;
        }
        return Shape.containsPoint(container, shape.xCoords[0], shape.xCoords[0]);
    }

    static boolean intersectsLines(double k1, double b1, double k2, double b2, FloatPoint intersectPoint) {
        if (null != intersectPoint) {
            if (k1 == k2) {
                intersectPoint.x = 0.0;
                intersectPoint.y = b1;
                return b1 == b2;
            }
            intersectPoint.x = -(b1 - b2) / (k1 - k2);
            intersectPoint.y = Double.POSITIVE_INFINITY == k1 ? k1 * intersectPoint.x + b1 : k2 * intersectPoint.x + b2;
            return true;
        }
        return false;
    }

    static boolean intersectPoint(double xp, double yp, double x, double dx, double y, double dy, double k, double b, FloatPoint intersectPoint) {
        if (null != intersectPoint) {
            intersectPoint.x = xp;
            intersectPoint.y = k * intersectPoint.x + b;
            return 1.0E-5 >= Math.abs(yp - intersectPoint.y) && (0.0 != dx ? 1.0 >= Math.abs(2.0 * (intersectPoint.x - x) / dx - 1.0) : 1.0 >= Math.abs(2.0 * (intersectPoint.y - y) / dy - 1.0));
        }
        return false;
    }

    static boolean intersectsSegments(double x1, double dx1, double y1, double dy1, double k1, double b1, double x2, double dx2, double y2, double dy2, double k2, double b2, FloatPoint intersectPoint) {
        return null != intersectPoint ? MapUtils.intersectsLines(k1, b1, k2, b2, intersectPoint) && (0.0 != dx1 ? 1.0 >= Math.abs(2.0 * (intersectPoint.x - x1) / dx1 - 1.0) : 1.0 >= Math.abs(2.0 * (intersectPoint.y - y1) / dy1 - 1.0)) && (0.0 != dx2 ? 1.0 >= Math.abs(2.0 * (intersectPoint.x - x2) / dx2 - 1.0) : 1.0 >= Math.abs(2.0 * (intersectPoint.y - y2) / dy2 - 1.0)) : false;
    }

    public static boolean intersectSegments(FloatPoint org1, FloatPoint dest1, FloatPoint org2, FloatPoint dest2, FloatPoint intersectPoint) {
        double dx1 = dest1.x - org1.x;
        double dy1 = dest1.y - org1.y;
        double dx2 = dest2.x - org2.x;
        double dy2 = dest2.y - org2.y;
        double k1 = dy1 / dx1;
        double k2 = dy2 / dx2;
        return MapUtils.intersectsSegments(org1.x, dx1, org1.y, dy1, k1, org1.y - k1 * org1.x, org2.x, dx2, org2.y, dy2, k2, org2.y - k2 * org2.x, intersectPoint);
    }

    public static Image makeColorTransparent(Image im, final Color color, int transparency) throws Exception {
        final int alpha = 255 - (transparency & 0xFF);
        RGBImageFilter filter = new RGBImageFilter(){
            public boolean changeColor;
            public int markerRGB;
            public int alphaSet;
            {
                this.changeColor = color != null;
                this.markerRGB = this.changeColor ? color.getRGB() | 0xFF000000 : 0;
                this.alphaSet = (alpha & 0xFF) << 24;
            }

            public final int filterRGB(int x, int y, int rgb) {
                if ((rgb & 0xFF000000) == 0) {
                    return rgb;
                }
                if (this.changeColor && (rgb | 0xFF000000) == this.markerRGB) {
                    return 0xFFFFFF & rgb;
                }
                return this.alphaSet + (0xFFFFFF & rgb);
            }
        };
        FilteredImageSource ip = new FilteredImageSource(im.getSource(), filter);
        Toolkit t = Toolkit.getDefaultToolkit();
        return MapUtils.prepareImage(t, t.createImage(ip));
    }

    public static String getPropAsString(Properties prop, char delim) {
        if (prop == null) {
            return null;
        }
        StringBuffer str = new StringBuffer();
        Enumeration<?> names = prop.propertyNames();
        while (names.hasMoreElements()) {
            String s = names.nextElement().toString();
            str.append(s).append('=').append(prop.getProperty(s)).append(delim);
        }
        return str.toString().substring(0, str.length() - 1);
    }

    protected static FloatPoint roundToSphere(double x, double y, double rad) {
        double k = 0.95;
        double temp = x * x + y * y;
        while (temp > rad * rad) {
            x = k * x;
            y = k * y;
            temp = x * x + y * y;
        }
        return new FloatPoint(x, y);
    }

    static {
        try {
            defaultBoldFont = new Font("SansSerif", 1, 12);
            defaultPlainFont = new Font("SansSerif", 0, 11);
        }
        catch (Exception e) {
            System.out.println("Headless environment !" + System.getProperty("java.awt.headless"));
        }
        images = new Hashtable();
        imgUrls = new Hashtable();
        zero = new Object();
        requestedImages = 0;
    }
}

