/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.alov.map.Domain;
import org.alov.map.FieldDef;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.LayerRaster;
import org.alov.map.LayerSetup;
import org.alov.map.LayerVector;
import org.alov.map.LayerZoomify;
import org.alov.map.Load2D;
import org.alov.map.MapUtils;
import org.alov.map.Project;
import org.alov.map.RadioGroup;
import org.alov.map.Renderer;
import org.alov.map.RendererChart;
import org.alov.map.RendererDef;
import org.alov.map.RendererDot;
import org.alov.map.RendererGrad;
import org.alov.map.RendererLabel;
import org.alov.map.Shape;
import org.alov.map.Symbol;
import org.alov.map.Utils2D;
import org.alov.util.AlovMapException;
import org.alov.util.Const;
import org.alov.util.ExData;
import org.alov.util.ExDate;
import org.alov.util.Strings;
import org.alov.util.XmlConst;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

class Loader
implements Const,
XmlConst {
    static LayerSetup layerSetup;

    private Loader() {
    }

    static void parseProject(Project prj, XmlElement root, LayerSetup lyrSetup) throws Exception {
        String param;
        XmlElement el;
        int count;
        Vector nodes;
        layerSetup = lyrSetup;
        if (root == null || !root.getNodeName().equalsIgnoreCase("project")) {
            layerSetup.addStatusInfo(101, null, null);
            throw new AlovMapException(101, null);
        }
        boolean isDynAdd = XmlUtils.getBoolean("dynamic", root, false);
        MapUtils.showCounter = XmlUtils.getBoolean("counter", root, false);
        if (!isDynAdd) {
            int i;
            prj.name = XmlUtils.getLangString("name", root, "unnamed", prj.language);
            prj.zmin = XmlUtils.getFloat("zmin", root, -1.0f);
            prj.zmax = XmlUtils.getFloat("zmax", root, -1.0f);
            prj.mapBackground = XmlUtils.getColor("backcolor", root, Color.white);
            String units = XmlUtils.getString("mapunits", root, null);
            prj.MapUnits = MapUtils.setUnits(units, -1);
            units = XmlUtils.getString("zoomunits", root, null);
            prj.ZoomUnits = MapUtils.setUnits(units, 1);
            prj.isTimeEnabled = XmlUtils.getBoolean("usetime", root, false);
            prj.animationDelay = XmlUtils.getInt("animationdelay", root, 1000);
            prj.linkMain = root.getElValue("mainlink", root.getElValue("linkmask", null));
            prj.linkSearch = root.getElValue("searchlink", null);
            prj.linkInfo = root.getElValue("infolink", null);
            prj.isCompactStorage = XmlUtils.getBoolean("compact", root, false);
            nodes = root.getElementsByTagName("domain");
            count = nodes.size();
            String maxExtentName = "full";
            for (i = 0; i < count; ++i) {
                el = (XmlElement)nodes.elementAt(i);
                FloatRectangle ext = XmlUtils.getRect(el);
                String nom = XmlUtils.getLangString("name", el, "unnamed", prj.language);
                if (ext != null) {
                    Domain domain = new Domain();
                    domain.ext = ext;
                    domain.minDate = ExDate.parseString(XmlUtils.getString("tmin", el, "0"));
                    domain.maxDate = ExDate.parseString(XmlUtils.getString("tmax", el, "2006"));
                    domain.layerId = XmlUtils.getString("layer", el, null);
                    if (XmlUtils.getBoolean("full", el, false)) {
                        prj.startDate = domain.minDate;
                        prj.endDate = domain.maxDate;
                        if (MapUtils.predefExtent != null) {
                            domain.ext = MapUtils.predefExtent;
                        }
                        prj.maxExtent = domain.ext;
                        prj.moveBeyondProject = XmlUtils.getBoolean("movebeyond", el, false);
                        maxExtentName = nom;
                    }
                    if (XmlUtils.getBoolean("startup", el, false)) {
                        prj.startExtentName = nom;
                    }
                    prj.domains.put(nom, domain);
                    prj.domainsNames = prj.domainsNames + nom + "\n\r";
                    continue;
                }
                layerSetup.addStatusInfo(102, null, nom);
            }
            if (prj.maxExtent == null) {
                prj.maxExtent = MapUtils.predefExtent != null ? MapUtils.predefExtent : new FloatRectangle(0.0, 0.0, 0.0, 0.0);
                Domain domain = new Domain();
                domain.ext = prj.maxExtent;
                domain.minDate = new ExDate(0L, 1L, 1L);
                domain.maxDate = new ExDate(2006L, 1L, 1L);
                prj.domains.put("full", domain);
                prj.domainsNames = prj.domainsNames + "full\n\r";
                prj.startDate = domain.minDate;
                prj.endDate = domain.maxDate;
            }
            if (MapUtils.predefExtentName != null) {
                prj.startExtentName = MapUtils.predefExtentName;
            }
            if (prj.startExtentName == null) {
                prj.startExtentName = maxExtentName;
            }
            nodes = root.getElementsByTagName("map");
            count = nodes.size();
            for (i = 0; i < count; ++i) {
                el = (XmlElement)nodes.elementAt(i);
                String theme_id = XmlUtils.getString("index", el, null);
                String theme_name = XmlUtils.getLangString("name", el, "unnamed", prj.language);
                if (theme_id != null) {
                    prj.themes.put(theme_name, theme_id);
                    prj.themesNames = prj.themesNames + theme_name + "\n\r";
                    String layer_id = XmlUtils.getString("layer", el, null);
                    if (!Strings.isNullOrBlank(layer_id)) {
                        prj.themesLayer.put(theme_name, layer_id);
                    }
                    if (theme_id.equals(MapUtils.predefTheme)) {
                        MapUtils.predefTheme = theme_name;
                    }
                    if (i != 0 && !XmlUtils.getBoolean("startup", el, false)) continue;
                    prj.startTheme = theme_name;
                    continue;
                }
                layerSetup.addStatusInfo(103, null, theme_name);
            }
            if (prj.themes.size() == 0) {
                prj.themes.put("unnamed", "0");
                prj.startTheme = "unnamed";
                prj.themesNames = "unnamed\n\r";
            } else if (MapUtils.predefTheme != null) {
                prj.startTheme = MapUtils.predefTheme;
            }
            nodes = root.getElementsByTagName("keymap");
            count = nodes.size();
            if (count > 0) {
                el = (XmlElement)nodes.elementAt(0);
                prj.keyMapBackground = XmlUtils.getColor("backcolor", el, prj.mapBackground);
                prj.keyMapOutline = XmlUtils.getColor("outline", el, Color.red);
                prj.keyMapTheme = XmlUtils.getString("map", el, null);
            } else {
                prj.keyMapOutline = Color.red;
                prj.keyMapBackground = prj.mapBackground;
                prj.keyMapTheme = null;
            }
            el = root.getFirstElementByName("dynamic");
            boolean bl = prj.isDynamic = el != null;
            if (prj.isDynamic) {
                prj.isDynamic_LayerVisible = XmlUtils.getBoolean("visible", el, true);
                prj.isDynamic_RemoveOutOfExtent = !XmlUtils.getBoolean("retain", el, false);
                prj.iDynamic_OrderOfLayers = XmlUtils.getInt("order", el, 0);
                nodes = el.getElementsByTagName("meta");
                count = nodes.size();
                for (i = 0; i < count; ++i) {
                    el = (XmlElement)nodes.elementAt(i);
                    String id = XmlUtils.getString("id", el, null);
                    String val = XmlUtils.getString("content", el, null);
                    if (Strings.isNullOrBlank(val) || Strings.isNullOrBlank(id)) continue;
                    prj.sDynamoAdd = prj.sDynamoAdd + id + '@' + val + ',';
                }
                if (prj.sDynamoAdd.length() > 0) {
                    prj.sDynamoAdd = prj.sDynamoAdd.substring(0, prj.sDynamoAdd.length() - 1);
                }
            }
        }
        if ((el = root.getFirstElementByName("projection")) != null && !Strings.isNullOrBlank(param = XmlUtils.getString("name", el, null))) {
            Properties mapProjection = new Properties();
            ((Hashtable)mapProjection).put("name", param);
            if (param.indexOf("EPSG") < 0) {
                param = XmlUtils.getString("a", el, null);
                if (Strings.isNumeric(param)) {
                    ((Hashtable)mapProjection).put("a", param);
                }
                if (Strings.isNumeric(param = XmlUtils.getString("f", el, null))) {
                    ((Hashtable)mapProjection).put("f", param);
                }
                if (Strings.isNumeric(param = XmlUtils.getString("phi0", el, null))) {
                    ((Hashtable)mapProjection).put("phi0", param);
                }
                if (Strings.isNumeric(param = XmlUtils.getString("lambda0", el, null))) {
                    ((Hashtable)mapProjection).put("lambda0", param);
                }
                if (Strings.isNumeric(param = XmlUtils.getString("fe", el, null))) {
                    ((Hashtable)mapProjection).put("fe", param);
                }
                if (Strings.isNumeric(param = XmlUtils.getString("fn", el, null))) {
                    ((Hashtable)mapProjection).put("fn", param);
                }
                if (Strings.isNumeric(param = XmlUtils.getString("phi1", el, null))) {
                    ((Hashtable)mapProjection).put("phi1", param);
                }
                if (Strings.isNumeric(param = XmlUtils.getString("phi2", el, null))) {
                    ((Hashtable)mapProjection).put("phi2", param);
                }
                if (Strings.isNumeric(param = XmlUtils.getString("ef", el, null))) {
                    ((Hashtable)mapProjection).put("ef", param);
                }
                if (Strings.isNumeric(param = XmlUtils.getString("nf", el, null))) {
                    ((Hashtable)mapProjection).put("nf", param);
                }
                if (Strings.isNumeric(param = XmlUtils.getString("k0", el, null))) {
                    ((Hashtable)mapProjection).put("k0", param);
                }
                if (Strings.isNumeric(param = XmlUtils.getString("phi_f", el, null))) {
                    ((Hashtable)mapProjection).put("phi_f", param);
                }
                if (Strings.isNumeric(param = XmlUtils.getString("lambda_f", el, null))) {
                    ((Hashtable)mapProjection).put("lambda_f", param);
                }
            }
            prj.geoProjection = MapUtils.getPropAsString(mapProjection, ',');
        }
        nodes = root.getElementsByTagName("layer");
        count = nodes.size();
        for (int i = 0; i < count; ++i) {
            el = (XmlElement)nodes.elementAt(i);
            String nom = XmlUtils.getString("name", el, null);
            if (nom == null) {
                nom = XmlUtils.getLangString("label", el, "unnamed", prj.language);
            }
            Vector nodesDS = el.getElementsByTagName("dataset");
            int count2 = nodesDS.size();
            for (int j = 0; j < count2; ++j) {
                Layer mainLayer;
                boolean isAnimZoom;
                Layer lyr;
                String s1;
                XmlElement elDataset = (XmlElement)nodesDS.elementAt(j);
                if (elDataset == null) {
                    layerSetup.addStatusInfo(104, null, nom);
                    continue;
                }
                Properties connectionData = XmlUtils.getText("connection", elDataset);
                if (connectionData == null) {
                    connectionData = new Properties();
                }
                if ((s1 = XmlUtils.getString("type", elDataset, null)) != null) {
                    ((Hashtable)connectionData).put("type", s1);
                }
                if ((s1 = XmlUtils.getString("id", elDataset, null)) != null) {
                    if (XmlUtils.getBoolean("geocode", elDataset, false)) {
                        s1 = "geocode" + s1;
                    }
                    if (isDynAdd && prj.getLayerByDsId(s1) != null) continue;
                    if (MapUtils.isRunFromDisk) {
                        layerSetup.addStatusInfo(0, null, "WARNING#116  dataset id#" + s1);
                    } else {
                        ((Hashtable)connectionData).put("id", s1);
                        nom = s1 + ": " + nom;
                    }
                }
                if ((s1 = XmlUtils.getString("url", elDataset, null)) != null) {
                    ((Hashtable)connectionData).put("url", ExData.getURL(s1));
                    String s2 = ExData.getUser(s1);
                    if (s2 != null) {
                        ((Hashtable)connectionData).put("user", s2);
                    }
                    if ((s2 = ExData.getPass(s1)) != null) {
                        ((Hashtable)connectionData).put("pass", s2);
                    }
                }
                if (XmlUtils.getBoolean("direct", elDataset, true)) {
                    ((Hashtable)connectionData).put("direct", "yes");
                }
                try {
                    lyr = layerSetup.createLayer(connectionData);
                }
                catch (AlovMapException e) {
                    layerSetup.addStatusInfo(e.getCode(), null, nom + "  " + e.getMessage());
                    continue;
                }
                XmlElement elMetadata = elDataset.getFirstElementByName("metadata");
                if (elMetadata != null && lyr.metadata.isNotLoaded) {
                    lyr.metadata.loadMetadata(elMetadata);
                }
                if (isAnimZoom = XmlUtils.getBoolean("animatedzoom", el, false)) {
                    prj.isAnimatedZoom = true;
                }
                lyr.isAnimatedZoom = isAnimZoom;
                if (!Loader.loadLayer(prj, lyr, el)) continue;
                Layer layer = mainLayer = lyr instanceof LayerRaster && ((LayerRaster)lyr).resolutionLevel > 0 || lyr instanceof LayerZoomify ? null : prj.getLayerByDsId(lyr.datasetId);
                if (mainLayer != null && lyr.getClass().getName().equals(mainLayer.getClass().getName())) {
                    lyr.metadata = mainLayer.metadata;
                    lyr.dataStorage = mainLayer.dataStorage;
                } else {
                    lyr.metadata.cachesize = XmlUtils.getInt("cache", elDataset, 0);
                }
                if (lyr.id == null) {
                    lyr.id = prj.getLayerCount() + 1 + "-" + lyr.datasetId;
                }
                prj.layers.addElement(lyr);
                lyr.isFullLoad = lyr.isKeyMap || XmlUtils.getBoolean("full", elDataset, true);
                lyr.metadata.forceEmptyLoad = XmlUtils.getBoolean("forceload", elDataset, false);
                lyr.metadata.forceLoad = XmlUtils.getBoolean("forceloadall", elDataset, false);
                lyr.metadata.reloadTimeRange = XmlUtils.getInt("reloadtime", elDataset, 0);
                boolean bl = prj.hasKeyMap = prj.hasKeyMap || lyr.isKeyMap;
                if (XmlUtils.getBoolean("startup", el, false)) {
                    prj.startLayer = lyr.id;
                }
                if (!isDynAdd) continue;
                lyr.removeOutOfExtent = prj.isDynamic_RemoveOutOfExtent;
                lyr.drawOrder = prj.iDynamic_OrderOfLayers;
            }
        }
        count = prj.getLayerCount();
        if (count == 0) {
            layerSetup.addStatusInfo(109, null, prj.name);
            throw new AlovMapException(109, prj.name);
        }
        nodes = root.getElementsByTagName("radiogroup");
        count = nodes.size();
        for (int k = 0; k < count; ++k) {
            el = (XmlElement)nodes.elementAt(k);
            String name = XmlUtils.getString("name", el, null);
            int levels = XmlUtils.getInt("levels", el, 1);
            if (Strings.isNullOrBlank(name) || levels < 1 || prj.getRadioGroupByName(name) != null) {
                layerSetup.addStatusInfo(117, null, name);
                continue;
            }
            RadioGroup rg = new RadioGroup(name, levels);
            String dependent = XmlUtils.getString("dependent", el, null);
            if (!Strings.isNullOrBlank(dependent)) {
                StringTokenizer st = new StringTokenizer(dependent, " ,;");
                while (st.hasMoreTokens()) {
                    String layerId = st.nextToken();
                    Layer lyr = prj.getLayerById(layerId);
                    if (lyr == null) continue;
                    rg.addLayer(lyr);
                }
            }
            if (rg.size() > 1) {
                prj.radioGroups.addElement(rg);
                continue;
            }
            layerSetup.addStatusInfo(117, null, name);
        }
    }

    private static Shape loadMarkerShape(String coords) {
        Shape shp = null;
        StringTokenizer tok = new StringTokenizer(coords, " ,;");
        double[] tempArray = new double[1000];
        int cnt = 0;
        while (tok.hasMoreTokens()) {
            tempArray[cnt] = MapUtils.toDouble(tok.nextToken());
            ++cnt;
        }
        if (cnt > 0) {
            double[] tempArray2 = new double[cnt];
            System.arraycopy(tempArray, 0, tempArray2, 0, cnt);
            shp = new Shape(tempArray2);
        }
        tempArray = null;
        return shp;
    }

    private static boolean loadLayer(Project prj, Layer lyr, XmlElement el) {
        try {
            StringTokenizer st;
            String sep;
            lyr.id = XmlUtils.getString("name", el, null);
            if (lyr.id == null) {
                lyr.id = XmlUtils.getString("id", el, null);
            }
            lyr.setName(XmlUtils.getLangString("label", el, lyr.id, prj.language));
            if (lyr.getName() == null) {
                lyr.setName("unnamed#" + prj.getLayerCount() + 1);
            }
            layerSetup.addStatusInfo(0, lyr, "Parse");
            if (lyr.id != null && prj.getLayerById(lyr.id) != null) {
                layerSetup.addStatusInfo(106, lyr, lyr.id + " isn't unique");
                lyr.id = null;
            }
            lyr.metadata.passResolved = XmlUtils.getBoolean("password", el, true);
            lyr.metadata.passFirstTime = !prj.isDynamic;
            lyr.zmin = XmlUtils.getFloat("zmin", el, 0.0f);
            lyr.zmax = XmlUtils.getFloat("zmax", el, 0.0f);
            lyr.zoom_for_select = XmlUtils.getFloat("zoom", el, 0.0f);
            lyr.withinZoom = lyr.zmin != 0.0f || lyr.zmax != 0.0f;
            lyr.timeVarying = true;
            lyr.timeMin = ExDate.parseString(XmlUtils.getString("tmin", el, null));
            lyr.timeMax = ExDate.parseString(XmlUtils.getString("tmax", el, null));
            lyr.withinDate = lyr.timeMin != null || lyr.timeMax != null;
            lyr.visible_always = XmlUtils.getBoolean("alwaysvisible", el, false);
            lyr.setVisible(lyr.visible_always ? true : XmlUtils.getBoolean("visible", el, true));
            lyr.initiallyVisible = lyr.isVisible();
            lyr.isKeyMap = XmlUtils.getBoolean("keymap", el, false);
            lyr.legendVisible = XmlUtils.getBoolean("showlegend", el, true);
            lyr.legendExpanded = XmlUtils.getBoolean("legendexpanded", el, true);
            lyr.legendName = XmlUtils.getString("legend", el, null);
            lyr.legendWrapText = XmlUtils.getBoolean("WrapLayerTitles", el, false);
            String maps = XmlUtils.getString("map", el, "all");
            if (!maps.equalsIgnoreCase("all")) {
                StringTokenizer tok = new StringTokenizer(maps, " ,;");
                while (tok.hasMoreTokens()) {
                    String elt = tok.nextToken();
                    if (Strings.isNullOrBlank(elt = elt.trim()) || elt.equalsIgnoreCase("all")) continue;
                    lyr.themes.addElement(elt);
                }
            }
            lyr.legendObjectType = XmlUtils.getInt("LegType", el, 0);
            String coords = XmlUtils.getString("legendsymbolshape", el, null);
            if (!Strings.isNullOrBlank(coords)) {
                lyr.legendSymbolShape = Loader.loadMarkerShape(coords);
            }
            lyr.legendHideOutRange = XmlUtils.getBoolean("hidelegend_zoom", el, false);
            lyr.canSearch = XmlUtils.getBoolean("cansearch", el, true);
            lyr.canSelectByMouse = XmlUtils.getBoolean("canselect", el, true);
            lyr.linkMain = el.getElValue("linkmask", lyr.linkMain);
            lyr.linkMain = el.getElValue("mainlink", lyr.linkMain);
            lyr.drawOrder = XmlUtils.getInt("order", el, 0);
            String dependent = XmlUtils.getString("dependent", el, null);
            if (!Strings.isNullOrBlank(dependent)) {
                sep = dependent.indexOf(44) > 0 ? "," : " ,;";
                st = new StringTokenizer(dependent, sep);
                lyr.controlledLayers = new Hashtable();
                while (st.hasMoreTokens()) {
                    lyr.controlledLayers.put(st.nextToken(), "1");
                }
            }
            if (!Strings.isNullOrBlank(dependent = XmlUtils.getString("dependent_inverse", el, null))) {
                sep = dependent.indexOf(44) > 0 ? "," : " ,;";
                st = new StringTokenizer(dependent, sep);
                if (lyr.controlledLayers == null) {
                    lyr.controlledLayers = new Hashtable();
                }
                while (st.hasMoreTokens()) {
                    lyr.controlledLayers.put(st.nextToken(), "0");
                }
            }
            lyr.linkSearch = el.getElValue("searchlink", lyr.linkSearch);
            lyr.linkTips = el.getElValue("tipslink", lyr.linkTips);
            lyr.tipsMask = XmlUtils.getLangString("tipsmask", el, null, prj.language);
            if (lyr instanceof LayerVector) {
                if (lyr instanceof LayerZoomify) {
                    ((LayerZoomify)lyr).maxPixelSize = XmlUtils.getFloat("resolution", el, 2.0f);
                    ((LayerZoomify)lyr).transparency = XmlUtils.getInt("transparency", el, -1);
                    lyr.canSearch = false;
                }
                LayerVector lyrv = (LayerVector)lyr;
                lyrv.linkInfo = el.getElValue("infolink", lyrv.linkInfo);
                lyrv.localFilter = XmlUtils.getString("filter", el, lyrv.localFilter);
                lyrv.serverFilter = XmlUtils.getString("serverfilter", el, lyrv.serverFilter);
                Loader.loadSymbol(prj, lyrv.symbol, el.getFirstElementByName("symbol"), false);
                XmlElement elSym = el.getFirstElementByName("selsymbol");
                if (elSym != null) {
                    Loader.loadSymbol(prj, lyrv.selectedSymbol, elSym, false);
                } else {
                    lyrv.selectedSymbol.style = lyrv.symbol.style;
                    lyrv.selectedSymbol.size = lyrv.symbol.size;
                    lyrv.selectedSymbol.step = lyrv.symbol.step;
                }
                Vector nodes = el.getElementsByTagName("renderer");
                int count = nodes.size();
                if (count < 1 && lyr.renderers.size() < 1) {
                    lyr.renderers.addElement(lyr.createDefaultRenderer());
                } else {
                    for (int i = 0; i < count; ++i) {
                        XmlElement el2 = (XmlElement)nodes.elementAt(i);
                        String typeVal = XmlUtils.getString("type", el2, "default");
                        if (typeVal == null) continue;
                        Renderer rend = null;
                        if (typeVal.equalsIgnoreCase("label")) {
                            rend = new RendererLabel(lyr);
                        } else if (typeVal.equalsIgnoreCase("gradcolor")) {
                            rend = new RendererGrad(lyr);
                        } else if (typeVal.equalsIgnoreCase("gradmarker")) {
                            rend = new RendererGrad(lyr);
                            rend.drawMarker = true;
                        } else if (typeVal.equalsIgnoreCase("chart")) {
                            rend = new RendererChart(lyr);
                        } else if (typeVal.equalsIgnoreCase("dot")) {
                            rend = new RendererDot(lyr);
                        } else if (typeVal.equalsIgnoreCase("default")) {
                            rend = new RendererDef(lyr);
                        }
                        if (rend != null) {
                            if (!Loader.loadRenderer(prj, lyr, rend, el2)) continue;
                            if (rend.name == null) {
                                rend.name = String.valueOf(i);
                            }
                            lyr.renderers.addElement(rend);
                            continue;
                        }
                        layerSetup.addStatusInfo(107, lyr, "renderer#" + i + "  " + typeVal);
                    }
                }
            } else if (lyr instanceof LayerRaster) {
                ((LayerRaster)lyr).resolutionLevel = XmlUtils.getInt("resolution", el, 0);
                ((LayerRaster)lyr).transparentColor = XmlUtils.getColor("transparentColor", el, null);
                ((LayerRaster)lyr).transparency = XmlUtils.getInt("transparency", el, -1);
                Vector nodes = el.getElementsByTagName("renderer");
                int count = nodes.size();
                Renderer rend = lyr.createDefaultRenderer();
                if (count > 0) {
                    XmlElement el2 = (XmlElement)nodes.elementAt(0);
                    Loader.loadRenderer(prj, lyr, rend, el2);
                } else {
                    rend.name = XmlUtils.getString("name", el, "1");
                    rend.label = XmlUtils.getLangString("imagelabel", el, null, prj.language);
                    rend.legendVisible = rend.label != null;
                }
                lyr.renderers.addElement(rend);
            }
            return true;
        }
        catch (Exception e) {
            layerSetup.addStatusInfo(106, lyr, null);
            return false;
        }
    }

    private static boolean loadRenderer(Project prj, Layer lyr, Renderer rend, XmlElement el) {
        try {
            rend.name = XmlUtils.getString("name", el, null);
            rend.label = XmlUtils.getLangString("label", el, null, prj.language);
            rend.legendVisible = XmlUtils.getBoolean("showlegend", el, true);
            rend.allowToggle = XmlUtils.getBoolean("AllowOnOffInLegend", el, false);
            rend.enabled = XmlUtils.getBoolean("visible", el, true);
            rend.radioGroupLevel = XmlUtils.getInt("radiogrouplevel", el, 0);
            rend.zmin = XmlUtils.getFloat("zmin", el, 0.0f);
            rend.zmax = XmlUtils.getFloat("zmax", el, 0.0f);
            rend.withinZoom = rend.zmin != 0.0f || rend.zmax != 0.0f;
            String maps = XmlUtils.getString("map", el, "all");
            if (!maps.equalsIgnoreCase("all")) {
                String sep = maps.indexOf(44) > 0 ? "," : " ,;";
                StringTokenizer tok = new StringTokenizer(maps, sep);
                while (tok.hasMoreTokens()) {
                    String elt = tok.nextToken();
                    if (Strings.isNullOrBlank(elt = elt.trim()) || elt.equalsIgnoreCase("all")) continue;
                    rend.themes.addElement(elt);
                }
            }
            Vector nodes = el.getElementsByTagName("symbol");
            int symbolCount = nodes.size();
            rend.symbolsUnprepared = new Vector();
            boolean hasMarker = false;
            boolean isFontMaker = rend instanceof RendererLabel;
            if (symbolCount > 0) {
                for (int i = 0; i < symbolCount; ++i) {
                    XmlElement elSymbol = (XmlElement)nodes.elementAt(i);
                    Symbol sym = new Symbol();
                    Loader.loadSymbol(prj, sym, elSymbol, isFontMaker);
                    hasMarker = sym.drawMarker = sym.drawMarker || rend.drawMarker;
                    rend.symbolsUnprepared.addElement(sym);
                }
                rend.drawMarker = hasMarker;
            }
            if (rend instanceof RendererDef && rend.symbolsUnprepared.size() > 0) {
                rend.symbols = new Symbol[1];
                rend.symbols[0] = (Symbol)rend.symbolsUnprepared.elementAt(0);
            }
            if (rend instanceof RendererChart) {
                RendererChart rg = (RendererChart)rend;
                rg.width = XmlUtils.getInt("width", el, 0);
                rg.height = XmlUtils.getInt("height", el, 0);
                int chartsize = 0;
                if (rg.width > 0 && rg.height > 0) {
                    chartsize = rg.width;
                } else {
                    rg.height = rg.width = (chartsize = XmlUtils.getInt("size", el, 32));
                }
                String s = XmlUtils.getString("charttype", el, "pie");
                rg.type = s.equalsIgnoreCase("bar") ? 2 : 1;
                Color color = rg.outlineColor = XmlUtils.getBoolean("outlined", el, true) ? XmlUtils.getColor("outline", el, Color.black) : null;
                if (rg.type == 2) {
                    rg.normalization = XmlUtils.getFloat("normalization", el, 0.0f);
                } else {
                    rg.sizeFieldName = XmlUtils.getString("sizefield", el, null);
                    if (rg.sizeFieldName != null) {
                        rg.minSize = XmlUtils.getInt("minsize", el, 16);
                        rg.maxSize = XmlUtils.getInt("maxsize", el, 48);
                    }
                }
                nodes = el.getElementsByTagName("field");
                int count = nodes.size();
                rg.fieldsUnprepared = new Vector();
                if (count > 0) {
                    for (int i = 0; i < count; ++i) {
                        XmlElement fieldEl = (XmlElement)nodes.elementAt(i);
                        s = XmlUtils.getString("name", fieldEl, null);
                        if (s == null) continue;
                        FieldDef fi = new FieldDef();
                        fi.index = -1;
                        fi.name = s;
                        fi.color = XmlUtils.getColor("fill", fieldEl, Color.white);
                        fi.label = XmlUtils.getLangString("label", fieldEl, null, prj.language);
                        rg.fieldsUnprepared.addElement(fi);
                    }
                }
                if (rg.fieldsUnprepared.size() <= 0) {
                    layerSetup.addStatusInfo(108, lyr, "  Renderer: " + rend.name);
                    return false;
                }
                lyr.hasChart = true;
            } else if (rend instanceof RendererGrad) {
                RendererGrad rg2 = (RendererGrad)rend;
                rg2.fieldName = XmlUtils.getString("field", el, null);
                if (rg2.symbolsUnprepared.size() <= 0) {
                    layerSetup.addStatusInfo(108, lyr, "  Renderer: " + rend.name);
                    return false;
                }
                rg2.equal = Strings.strToInt(XmlUtils.getString("equal", el, null), 2);
                if (rg2.equal > 1) {
                    rg2.equal = XmlUtils.getBoolean("equal", el, false) ? 0 : 1;
                }
                rg2.drawDefault = XmlUtils.getBoolean("drawdefault", el, false);
            } else if (rend instanceof RendererDot) {
                RendererDot rg = (RendererDot)rend;
                rg.fieldName = XmlUtils.getString("field", el, null);
                rg.dotSize = XmlUtils.getFloat("dotsize", el, 10000.0f);
                if (rg.fieldName == null || rg.dotSize <= 0.0f) {
                    layerSetup.addStatusInfo(108, lyr, "  Renderer: " + rend.name);
                    return false;
                }
                rend.symbols = new Symbol[1];
                rend.symbols[0] = rg.symbolsUnprepared.size() < 1 ? new Symbol(Color.black, Color.black, true, false, 3) : (Symbol)rend.symbolsUnprepared.elementAt(0);
            } else if (rend instanceof RendererLabel) {
                RendererLabel rg3 = (RendererLabel)rend;
                rg3.labelFieldName = XmlUtils.getLangString("labelfield", el, null, prj.language);
                if (rg3.labelFieldName == null || rg3.symbolsUnprepared.size() <= 0) {
                    layerSetup.addStatusInfo(108, lyr, "  Renderer: " + rend.name);
                    return false;
                }
                rg3.houseNumberFieldNames = XmlUtils.getLangString("housenumberfields", el, null, prj.language);
                rg3.symbolFieldName = XmlUtils.getString("symbolfield", el, null);
                rg3.drawDefault = XmlUtils.getBoolean("drawdefault", el, false);
                rg3.equal = Strings.strToInt(XmlUtils.getString("equal", el, null), 2);
                if (rg3.equal > 1) {
                    rg3.equal = XmlUtils.getBoolean("equal", el, false) ? 0 : 1;
                }
                rg3.rotationFieldName = XmlUtils.getString("rotationfield", el, null);
                rg3.sizeFieldName = XmlUtils.getString("sizefield", el, null);
                rg3.notOverlap = !XmlUtils.getBoolean("overlap", el, false);
                rg3.streetDrawingMode = XmlUtils.getInt("streetdrawmode", el, rg3.streetDrawingMode);
            }
            return true;
        }
        catch (Exception e) {
            layerSetup.addStatusInfo(106, lyr, "  Renderer: " + rend.name);
            e.printStackTrace();
            return false;
        }
    }

    private static void loadSymbol(Project prj, Symbol symb, XmlElement el, boolean isFontMarker) {
        String coords;
        if (el == null) {
            return;
        }
        symb.size = XmlUtils.getInt("size", el, isFontMarker ? 12 : 1);
        if (symb.size > 100) {
            symb.size = 100;
        }
        symb.minSize = XmlUtils.getInt("minsize", el, 2);
        symb.maxSize = XmlUtils.getInt("maxsize", el, 25);
        symb.useZoom = XmlUtils.getBoolean("usezoom", el, false) && symb.minSize < symb.maxSize;
        symb.step = XmlUtils.getInt("step", el, 20);
        if (symb.step < 3) {
            symb.step = 3;
        } else if (symb.step > 50) {
            symb.step = 50;
        }
        symb.fill = XmlUtils.getBoolean("filled", el, true);
        if (symb.fill) {
            symb.fillColor = XmlUtils.getColor("fill", el, isFontMarker ? Color.black : Color.yellow);
        }
        symb.outline = XmlUtils.getBoolean("outlined", el, true);
        if (symb.outline) {
            symb.outlineColor = XmlUtils.getColor("outline", el, isFontMarker ? null : Color.black);
            symb.outline = symb.outlineColor != null;
        }
        symb.style = XmlUtils.getInt("style", el, 0);
        if (!isFontMarker && !Strings.isNullOrBlank(coords = XmlUtils.getString("symbolshape", el, null))) {
            symb.symbolShape = Loader.loadMarkerShape(coords);
            if (symb.symbolShape != null) {
                symb.style = 5;
            }
        }
        symb.fontStyle = XmlUtils.getInt("fontstyle", el, symb.style > 3 ? 0 : symb.style);
        symb.drawMarker = XmlUtils.getBoolean("marker", el, false);
        symb.label = XmlUtils.getLangString("label", el, null, prj.language);
        symb.valueStr = XmlUtils.getString("val", el, null);
        symb.imageUrl = XmlUtils.getString("image", el, null);
        symb.fontName = XmlUtils.getString("font", el, MapUtils.defaultPlainFont.getName());
        symb.legendVisible = XmlUtils.getBoolean("showlegend", el, true);
        symb.visible = XmlUtils.getBoolean("visible", el, true);
        symb.imageAnimated = XmlUtils.getBoolean("animated", el, false);
        symb.align = XmlUtils.getInt("align", el, -1);
        if (symb.align == -1) {
            symb.align = XmlUtils.getInt("labelstyle", el, 2);
        }
        symb.position = XmlUtils.getInt("position", el, 1);
        char ch = (char)XmlUtils.getElInt("CharIndex", el, 0);
        symb.charMarker = new Character(ch).toString();
        symb.offsetMin = Strings.time2DeltaExtDate(XmlUtils.getString("offsetmin", el, null));
        symb.offsetMax = Strings.time2DeltaExtDate(XmlUtils.getString("offsetmax", el, null));
        symb.rotation = XmlUtils.getFloat("rotation", el, 0.0f);
        symb.rotation = symb.rotation / 180.0f * (float)Math.PI;
        symb.xOffset = XmlUtils.getInt("xoffset", el, 0);
        symb.yOffset = XmlUtils.getInt("yoffset", el, 0);
        symb.factor = XmlUtils.getFloat("factor", el, 1.0f);
        symb.sizeFieldName = XmlUtils.getString("sizefield", el, null);
        symb.rotationFieldName = XmlUtils.getString("rotationfield", el, null);
        Loader.load2Dfeatures(el, symb);
    }

    static void load2Dfeatures(XmlElement el, Symbol symb) {
        Vector nodes;
        int count;
        XmlElement elPaint;
        if (!Utils2D.have2d()) {
            return;
        }
        XmlElement xmlElement = elPaint = Utils2D.have2d() ? el.getFirstElementByName("paint") : null;
        if (elPaint != null) {
            XmlElement elComposite;
            String type = XmlUtils.getElString("type", elPaint, XmlUtils.getString("type", elPaint, null));
            if (type != null) {
                symb.fill = true;
                if ("color".equalsIgnoreCase(type)) {
                    symb.g2dPaint = symb.fillColor;
                } else if ("texture".equalsIgnoreCase(type)) {
                    XmlElement elTexture = elPaint.getFirstElementByName("texture");
                    if (elTexture != null) {
                        FloatRectangle rect = XmlUtils.getRect(elTexture);
                        String imageUrl = XmlUtils.getString("image", elTexture, null);
                        if (rect == null) {
                            rect = new FloatRectangle(0.0, 0.0, 100.0, 100.0);
                        }
                        if (imageUrl != null) {
                            symb.textureAnchor = new Rectangle((int)rect.x, (int)rect.y, (int)(rect.x2 - rect.x), (int)(rect.y2 - rect.y));
                            symb.textureUrl = imageUrl;
                        }
                    }
                } else if ("gradient".equalsIgnoreCase(type)) {
                    XmlElement elGradient = elPaint.getFirstElementByName("gradient");
                    if (elGradient == null) {
                        elGradient = elPaint;
                    }
                    if (elGradient != null) {
                        float x1 = XmlUtils.getElFloat("x1", elGradient, XmlUtils.getFloat("x1", elGradient, 0.0f));
                        float y1 = XmlUtils.getElFloat("y1", elGradient, XmlUtils.getFloat("y1", elGradient, 0.0f));
                        float x2 = XmlUtils.getElFloat("x2", elGradient, XmlUtils.getFloat("x2", elGradient, 100.0f));
                        float y2 = XmlUtils.getElFloat("y2", elGradient, XmlUtils.getFloat("y2", elGradient, 100.0f));
                        Color color1 = XmlUtils.getElColor("color1", elGradient, XmlUtils.getColor("color1", elGradient, Color.white));
                        Color color2 = XmlUtils.getElColor("color2", elGradient, XmlUtils.getColor("color2", elGradient, Color.black));
                        boolean cyclic = XmlUtils.getElBoolean("cyclic", elGradient, XmlUtils.getBoolean("cyclic", elGradient, true));
                        symb.g2dPaint = Load2D.getGradientPaint(x1, y1, color1, x2, y2, color2, cyclic);
                    }
                }
            }
            if ((elComposite = elPaint.getFirstElementByName("composite")) != null) {
                symb.g2dPaintComposite = Load2D.getAlphaComposite(XmlUtils.getString("rule", elComposite, null), XmlUtils.getFloat("alpha", elComposite, 1.0f));
            }
        }
        if ((count = (nodes = el.getElementsByTagName("stroke")).size()) > 0) {
            symb.g2dStroke = new Vector();
            symb.g2dStrokeColours = new Vector();
            for (int kk = 0; kk < count; ++kk) {
                XmlElement elStroke = (XmlElement)nodes.elementAt(kk);
                float width = XmlUtils.getFloat("width", elStroke, 1.0f);
                String sCap = XmlUtils.getString("cap", elStroke, null);
                String sJoin = XmlUtils.getString("join", elStroke, null);
                float miterLimit = XmlUtils.getFloat("miterlimit", elStroke, 10.0f);
                float dashPhase = XmlUtils.getFloat("dashphase", elStroke, 0.0f);
                float[] finalDashPattern = null;
                String dashPattern = elStroke.getElValue("dashpattern", null, true);
                if (dashPattern != null) {
                    StringTokenizer tokenizer = new StringTokenizer(dashPattern, " ,\n\t\r;|");
                    Vector<Float> values = new Vector<Float>();
                    while (tokenizer.hasMoreTokens()) {
                        String s = tokenizer.nextToken();
                        try {
                            Float val = new Float(s);
                            values.addElement(val);
                        }
                        catch (NumberFormatException e) {}
                    }
                    int valueCount = values.size();
                    if (valueCount > 0) {
                        finalDashPattern = new float[valueCount];
                        for (int i = 0; i < valueCount; ++i) {
                            finalDashPattern[i] = ((Float)values.elementAt(i)).floatValue();
                        }
                    }
                }
                symb.g2dStroke.addElement(Load2D.getBasicStroke(width, sCap, sJoin, miterLimit, finalDashPattern, dashPhase));
                symb.g2dStrokeColours.addElement(XmlUtils.getColor("color", elStroke, symb.outlineColor));
                XmlElement elComposite = elStroke.getFirstElementByName("composite");
                if (elComposite == null) continue;
                symb.g2dStrokeComposite = Load2D.getAlphaComposite(XmlUtils.getString("rule", elComposite, null), XmlUtils.getFloat("alpha", elComposite, 1.0f));
            }
        }
    }
}

