/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Color;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.alov.map.Carte;
import org.alov.map.DataStorage;
import org.alov.map.DataStorageCompact;
import org.alov.map.DataStorageFast;
import org.alov.map.DisplayContext;
import org.alov.map.FieldDef;
import org.alov.map.FilterExpression;
import org.alov.map.FilterRecords;
import org.alov.map.FilterTime;
import org.alov.map.FloatPoint;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.MapUtils;
import org.alov.map.MathRec;
import org.alov.map.Projection;
import org.alov.map.Record;
import org.alov.map.RecordField;
import org.alov.map.RecordsArray;
import org.alov.map.Renderer;
import org.alov.map.Shape;
import org.alov.map.Symbol;
import org.alov.util.AlovMapException;
import org.alov.util.Log;
import org.alov.util.Strings;

public class LayerVector
extends Layer {
    public int fi_search = -1;
    public int fi_id = -1;
    public String f_dateLow = null;
    public String f_dateHigh = null;
    public int dateType = 0;
    public String f_id = null;
    public boolean f_id_istext = true;
    public String f_xmin;
    public String f_ymin;
    public String f_xmax;
    public String f_ymax;
    public String f_geoblob = null;
    public String f_x;
    public String f_y;
    public String f_description = null;
    public String tableName = null;
    public String selectSQL = null;
    public String linkInfo = null;
    public String localFilter = null;
    Boolean changed = Boolean.FALSE;
    public String serverFilter = null;
    public Symbol symbol = new Symbol(Color.yellow, Color.black, true, true, 4);
    public Symbol selectedSymbol = new Symbol(new Color(0, 255, 128), new Color(255, 0, 0), true, true, 6);
    private static final String _TRUE = "TRUE";

    public LayerVector() {
    }

    public LayerVector(boolean isCompactStorage) {
        this.dataStorage = isCompactStorage ? new DataStorageCompact() : new DataStorageFast();
    }

    public void paintRecords(Vector v, Renderer rend, boolean selected, DisplayContext dc, int step) {
        try {
            int count = v.size();
            FloatRectangle extent = dc.getLastExtent();
            Projection p = dc.getProjection();
            if (p == null) {
                return;
            }
            Object recs = null;
            rend.beforePaint(selected, dc);
            for (int i = 0; i < count; ++i) {
                Record rec = (Record)v.elementAt(i);
                FloatRectangle recExt = rec.getRecordExtent();
                if (extent == null || extent.intersects(recExt)) {
                    rend.paintRecord(rec, selected, dc);
                }
                if (step <= 0 || !dc.isStopPaint(step)) continue;
                return;
            }
            rend.afterPaint(selected, dc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public RecordsArray findBySearchField(String sSearch) {
        return this.findByExpression(this.getSearchExpression(sSearch));
    }

    public String getSearchExpression(String sSearch) {
        if (this.fi_search < 0) {
            this.fi_search = this.fi_description;
        }
        if (!this.canSearch || Strings.isNullOrBlank(sSearch) || this.fi_search < 0) {
            return null;
        }
        StringBuffer expr = new StringBuffer();
        expr.append(this.getFieldDef((int)this.fi_search).name).append(sSearch.charAt(0) == '%' || sSearch.charAt(sSearch.length() - 1) == '%' ? " like '" : "='").append(sSearch).append("'");
        return expr.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordsArray findByExpression(String expression) {
        if (Strings.isNullOrBlank(expression)) {
            return null;
        }
        if (expression.equalsIgnoreCase(_TRUE)) {
            expression = null;
        }
        RecordsArray recs = new RecordsArray(this.dataStorage);
        DataStorage dataStorage = this.dataStorage;
        synchronized (dataStorage) {
            this.dataStorage.openDataStorage(true);
            try {
                FilterExpression filter = new FilterExpression(expression, this);
                int count = this.dataStorage.size();
                for (int i = 0; i < count; ++i) {
                    Record rec = this.newRecord(i);
                    if (this.applyFilters(rec) && filter.checkRecord(rec)) {
                        this.dataStorage.readRecCoords(rec, null);
                        recs.addRecord(rec);
                    } else {
                        this.dataStorage.skipSpatial(i);
                    }
                    rec = null;
                }
                if (recs.size() == 0) {
                    recs = null;
                }
            }
            catch (Exception e) {
            }
            finally {
                this.dataStorage.closeDataStorage();
            }
        }
        return recs;
    }

    protected boolean applyFilters(Record rec) throws IOException {
        boolean isFilterOk = true;
        this.dataStorage.readRecAttribute(rec);
        if (this.filters != null) {
            Enumeration e = this.filters.elements();
            while (e.hasMoreElements()) {
                FilterRecords filter = (FilterRecords)e.nextElement();
                if (filter.checkRecord(rec)) continue;
                isFilterOk = false;
                break;
            }
        }
        return isFilterOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordsArray paintRecords2(Renderer rend, DisplayContext dc, int step) {
        boolean storeArray;
        int count = this.dataStorage.size();
        if (dc == null || dc.getProjection() == null || count == 0) {
            return null;
        }
        FloatRectangle extent = dc.getLastExtent();
        try {
            if (this.metadata.maxExtent.isZero() || extent.contains(this.metadata.maxExtent)) {
                extent = null;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        RecordsArray recsArray = null;
        boolean bl = storeArray = this.renderers.size() > 1 && extent != null;
        if (storeArray) {
            recsArray = new RecordsArray(this.dataStorage);
        }
        DataStorage dataStorage = this.dataStorage;
        synchronized (dataStorage) {
            this.dataStorage.openDataStorage(true);
            try {
                rend.beforePaint(false, dc);
                for (int i = 0; i < count; ++i) {
                    Record rec = this.newRecord(i);
                    if (this.dataStorage.readRecCoords(rec, extent)) {
                        if (this.applyFilters(rec)) {
                            if (storeArray) {
                                recsArray.addRecord(rec);
                            }
                            rend.paintRecord(rec, false, dc);
                        }
                    } else {
                        this.dataStorage.skipAttribute(i);
                    }
                    rec = null;
                }
                rend.afterPaint(false, dc);
            }
            catch (IOException e) {
            }
            finally {
                this.dataStorage.closeDataStorage();
            }
        }
        return recsArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintRecords3(RecordsArray recs, Renderer rend, boolean selected, DisplayContext dc, int step) {
        if (!MapUtils.isNotEmptyRecs(recs) || dc == null || dc.getProjection() == null) {
            return;
        }
        FloatRectangle extent = dc.getLastExtent();
        boolean kk = false;
        DataStorage dataStorage = this.dataStorage;
        synchronized (dataStorage) {
            this.dataStorage.openDataStorage(true);
            try {
                int count = recs.size();
                int prevRec = 0;
                int prevRecA = 0;
                int maxInd = this.dataStorage.size() - 1;
                rend.beforePaint(selected, dc);
                for (int i = 0; i < count; ++i) {
                    int k = recs.get(i);
                    this.dataStorage.skipSpatial2(k, prevRec);
                    prevRec = k < maxInd ? k + 1 : 0;
                    Record rec = this.newRecord(k);
                    if (this.dataStorage.readRecCoords(rec, extent)) {
                        this.dataStorage.skipAttribute2(k, prevRecA);
                        prevRecA = k < maxInd ? k + 1 : 0;
                        this.dataStorage.readRecAttribute(rec);
                        rend.paintRecord(rec, selected, dc);
                    } else {
                        this.dataStorage.skipAttribute(i);
                    }
                    rec = null;
                }
                rend.afterPaint(selected, dc);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                this.dataStorage.closeDataStorage();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordsArray findWithinRect(FloatRectangle rect, boolean isSingle) {
        if (this.dataStorage.size() == 0) {
            return null;
        }
        DataStorage dataStorage = this.dataStorage;
        synchronized (dataStorage) {
            RecordsArray recs = new RecordsArray(this.dataStorage);
            this.dataStorage.openDataStorage(true);
            try {
                double x1 = rect.x;
                double y1 = rect.y;
                double x2 = rect.x2;
                double y2 = rect.y2;
                MathRec m1 = new MathRec(x1, y1, x2, y2);
                MathRec m2 = new MathRec(x2, y1, x1, y2);
                if (this.isObjectType(1) && this.parentMap != null) {
                    FloatRectangle ext = this.parentMap.getLastExtent();
                    double dd = Math.abs(ext.x2 - ext.x) / 200.0;
                    x2 = rect.x2 + dd;
                    x1 = rect.x - dd;
                    dd = Math.abs(ext.y2 - ext.y) / 200.0;
                    y2 = rect.y2 + dd;
                    y1 = rect.y - dd;
                    rect = new FloatRectangle(x1, y1, x2, y2);
                }
                int count = this.dataStorage.size();
                for (int i = 0; i < count; ++i) {
                    Record rec = this.newRecord(i);
                    this.dataStorage.readRecCoords(rec, null);
                    int shpCount = rec.getShapeCount();
                    boolean found = false;
                    block9: for (int j = 0; j < shpCount && !found; ++j) {
                        Shape shp = rec.getShape(j);
                        if (shp.xCoords == null || shp.yCoords == null) continue;
                        double[] xc = shp.xCoords;
                        double[] yc = shp.yCoords;
                        if (this.isObjectType(1)) {
                            found = rect.contain(xc[0], yc[0]);
                            continue;
                        }
                        if (this.isObjectType(3)) {
                            found = Shape.containsPoint(shp, x1, y1);
                        }
                        for (int k = 1; k < xc.length && !found; ++k) {
                            double xx2 = xc[k];
                            double yy2 = yc[k];
                            if (rect.contain(xx2, yy2)) {
                                found = true;
                                continue block9;
                            }
                            double xx = xc[k - 1];
                            double yy = yc[k - 1];
                            if (!this.Intersects(xx, yy, xx2, yy2, x1, y1, x2, y2, m1) && !this.Intersects(xx, yy, xx2, yy2, x2, y1, x1, y2, m2)) continue;
                            found = true;
                            continue block9;
                        }
                    }
                    if (found) {
                        if (this.applyFilters(rec)) {
                            recs.addRecord(rec);
                            if (isSingle) {
                                break;
                            }
                        }
                    } else {
                        this.dataStorage.skipAttribute(i);
                    }
                    rec = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.dataStorage.closeDataStorage();
            }
            if (recs.size() == 0) {
                recs = null;
            }
            return recs;
        }
    }

    private boolean Intersects(double b1x, double b1y, double b2x, double b2y, double a1x, double a1y, double a2x, double a2y, MathRec m) {
        double iy;
        double ix;
        double k2;
        double dx2 = b2x - b1x;
        double dy2 = b2y - b1y;
        if (dy2 == 0.0) {
            k2 = 0.0;
        } else if (dx2 != 0.0) {
            k2 = dy2 / dx2;
        } else {
            k2 = 1.0E21;
            if (dy2 < 0.0) {
                k2 = -k2;
            }
        }
        if (m.k == k2) {
            return false;
        }
        double _b2 = b1y - k2 * b1x;
        if (Math.abs(m.k) < Math.abs(k2)) {
            ix = m.dx == 0.0 ? a1x : (dx2 == 0.0 ? b1x : (_b2 - m.b) / (m.k - k2));
            iy = m.dx == 0.0 ? k2 * ix + _b2 : m.k * ix + m.b;
        } else {
            ix = dx2 == 0.0 ? b1x : (m.dx == 0.0 ? a1x : (m.b - _b2) / (k2 - m.k));
            iy = m.dx == 0.0 ? k2 * ix + _b2 : m.k * ix + m.b;
        }
        return this.Between(a1x, a2x, ix) && this.Between(a1y, a2y, iy) && this.Between(b1x, b2x, ix) && this.Between(b1y, b2y, iy);
    }

    private boolean Between(double x, double y, double z) {
        if (x >= y && z <= x && z >= y) {
            return true;
        }
        return x <= y && z >= x && z <= y;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordsArray findContainShape(Shape shape, boolean isContain, boolean isSingle) {
        if (null == shape || 0 == shape.xCoords.length || 0 == shape.yCoords.length || this.isObjectType(-1)) {
            return null;
        }
        RecordsArray resultRecs = new RecordsArray(this.dataStorage);
        DataStorage dataStorage = this.dataStorage;
        synchronized (dataStorage) {
            block18: {
                this.dataStorage.openDataStorage(true);
                try {
                    FloatRectangle bounds = Shape.calculateExtent(shape);
                    int recCount = this.dataStorage.size();
                    if (0 >= recCount) break block18;
                    boolean found = false;
                    double[] xc = shape.xCoords;
                    double[] yc = shape.yCoords;
                    int pointCount = shape.xCoords.length;
                    for (int i = 0; i < recCount; ++i) {
                        Record rec = this.newRecord(i);
                        if (this.dataStorage.readRecCoords(rec, bounds)) {
                            found = isContain;
                            int shpCount = rec.getShapeCount();
                            for (int j = 0; j < shpCount; ++j) {
                                Shape shp = rec.getShape(j);
                                for (int k = 0; k < pointCount && (isContain ? found : !found); ++k) {
                                    found = Shape.containsPoint(shp, xc[k], yc[k]);
                                }
                                if (found && isSingle) break;
                            }
                        }
                        if (found) {
                            if (this.applyFilters(rec)) {
                                resultRecs.addRecord(rec);
                                if (isSingle) {
                                    break;
                                }
                            }
                        } else {
                            this.dataStorage.skipAttribute(i);
                        }
                        rec = null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    this.dataStorage.closeDataStorage();
                }
            }
        }
        if (0 == resultRecs.size()) {
            resultRecs = null;
        }
        return resultRecs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordsArray findWithinShape(Shape shape, boolean isInside, boolean isSingle) {
        if (null == shape || 0 == shape.xCoords.length || 0 == shape.yCoords.length || this.isObjectType(-1)) {
            return null;
        }
        RecordsArray resultRecs = new RecordsArray(this.dataStorage);
        DataStorage dataStorage = this.dataStorage;
        synchronized (dataStorage) {
            block25: {
                this.dataStorage.openDataStorage(true);
                try {
                    FloatRectangle bounds = Shape.calculateExtent(shape);
                    int recCount = this.dataStorage.size();
                    if (0 >= recCount) break block25;
                    for (int i = 0; i < recCount; ++i) {
                        boolean found = isInside;
                        Record rec = this.newRecord(i);
                        if (this.dataStorage.readRecCoords(rec, bounds)) {
                            int shpCount = rec.getShapeCount();
                            block13: for (int j = 0; j < shpCount && (isInside ? found : !found); ++j) {
                                Shape shp = rec.getShape(j);
                                double[] xc = shp.xCoords;
                                double[] yc = shp.yCoords;
                                int pointCount = xc.length;
                                if (isInside || this.isObjectType(1)) {
                                    for (int k = 0; k < pointCount && (isInside ? found : !found); ++k) {
                                        found = Shape.containsPoint(shape, xc[k], yc[k]);
                                    }
                                    continue;
                                }
                                switch (this.dataStorage.getObjectType()) {
                                    case 3: {
                                        FloatPoint fp = new FloatPoint(xc[pointCount - 1], yc[pointCount - 1]);
                                        found = MapUtils.intersectShape(fp, new FloatPoint(xc[0], yc[0]), shape);
                                        if (found) continue block13;
                                        fp = null;
                                    }
                                    case 2: {
                                        FloatPoint fpBegin = new FloatPoint(xc[0], yc[0]);
                                        FloatPoint fpEnd = new FloatPoint(0.0, 0.0);
                                        found = Shape.containsPoint(shape, fpBegin.x, fpBegin.y);
                                        for (int k = 1; !found && k < pointCount; ++k) {
                                            fpEnd.setLocation(xc[k], yc[k]);
                                            found = MapUtils.intersectShape(fpBegin, fpEnd, shape);
                                            if (found) continue;
                                            fpBegin.setLocation(fpEnd.x, fpEnd.y);
                                        }
                                        fpEnd = null;
                                        fpBegin = null;
                                    }
                                }
                            }
                        } else {
                            boolean bl = found = !isInside;
                        }
                        if (found) {
                            if (this.applyFilters(rec)) {
                                resultRecs.addRecord(rec);
                                if (isSingle) {
                                    break;
                                }
                            }
                        } else {
                            this.dataStorage.skipAttribute(i);
                        }
                        rec = null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    this.dataStorage.closeDataStorage();
                }
            }
        }
        if (0 == resultRecs.size()) {
            resultRecs = null;
        }
        return resultRecs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordsArray findWithinCircle(FloatPoint center, double radius, boolean isInside, boolean isSingle) {
        if (null == center || this.isObjectType(-1)) {
            return null;
        }
        RecordsArray resultRecs = new RecordsArray(this.dataStorage);
        DataStorage dataStorage = this.dataStorage;
        synchronized (dataStorage) {
            this.dataStorage.openDataStorage(true);
            try {
                FloatRectangle bounds = new FloatRectangle(center.x - radius, center.y - radius, center.x + radius, center.y + radius);
                double radiusSQR = MapUtils.sqr(radius);
                int recCount = this.dataStorage.size();
                boolean found = false;
                for (int i = 0; i < recCount; ++i) {
                    found = isInside;
                    Record rec = this.newRecord(i);
                    if (this.dataStorage.readRecCoords(rec, bounds)) {
                        int shpCount = rec.getShapeCount();
                        block13: for (int j = 0; j < shpCount && (isInside ? found : !found); ++j) {
                            Shape shp = rec.getShape(j);
                            double[] xc = shp.xCoords;
                            double[] yc = shp.yCoords;
                            int pointCount = xc.length;
                            if (isInside || this.isObjectType(1)) {
                                for (int k = 0; k < pointCount && (isInside ? found : !found); ++k) {
                                    found = MapUtils.sqr(xc[k] - center.x) + MapUtils.sqr(yc[k] - center.y) <= radiusSQR;
                                }
                                continue;
                            }
                            switch (this.dataStorage.getObjectType()) {
                                case 3: {
                                    found = Shape.containsPoint(shp, center.x, center.y) || MapUtils.intersectCircle(new FloatPoint(xc[0], yc[0]), new FloatPoint(xc[pointCount - 1], yc[pointCount - 1]), center, radius);
                                    if (found) continue block13;
                                }
                                case 2: {
                                    FloatPoint fpBegin = new FloatPoint(xc[1] - center.x, yc[1] - center.y);
                                    FloatPoint fpEnd = new FloatPoint(0.0, 0.0);
                                    for (int k = 1; k < pointCount - 1 && !found; ++k) {
                                        fpEnd.setLocation(xc[k] - center.x, yc[k] - center.y);
                                        boolean bl = found = Shape.containsPoint(shp, center.x, center.y) || MapUtils.intersectCircle(fpBegin, fpEnd, radius);
                                        if (found) continue;
                                        fpBegin.setLocation(fpEnd.x, fpEnd.y);
                                    }
                                    fpEnd = null;
                                    fpBegin = null;
                                }
                            }
                        }
                    } else {
                        boolean bl = found = !isInside;
                    }
                    if (found) {
                        if (this.applyFilters(rec)) {
                            resultRecs.addRecord(rec);
                            if (isSingle) {
                                break;
                            }
                        }
                    } else {
                        this.dataStorage.skipAttribute(i);
                    }
                    rec = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.dataStorage.closeDataStorage();
            }
        }
        if (0 == resultRecs.size()) {
            resultRecs = null;
        }
        return resultRecs;
    }

    public String getId(Record rec) {
        return this.fi_id < 0 ? Integer.toString(rec.index) : rec.getField(this.fi_id).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Record findById(String id) {
        Record rec = null;
        if (!Strings.isNullOrBlank(id)) {
            if (this.fi_id < 0) {
                int index = Strings.strToInt(id, -1);
                rec = this.dataStorage.getRecord(index, 0);
            } else {
                DataStorage dataStorage = this.dataStorage;
                synchronized (dataStorage) {
                    this.dataStorage.openDataStorage(true);
                    try {
                        int count = this.dataStorage.size();
                        for (int i = 0; i < count; ++i) {
                            rec = this.newRecord(i);
                            this.dataStorage.readRecAttribute(rec);
                            String sId = rec.getField(this.fi_id).toString();
                            if (id.equals(sId)) {
                                this.dataStorage.readRecCoords(rec, null);
                                break;
                            }
                            this.dataStorage.skipSpatial(i);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    finally {
                        this.dataStorage.closeDataStorage();
                    }
                }
            }
        }
        return rec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordsArray findByIds(String ids) {
        if (Strings.isNullOrBlank(ids)) {
            return null;
        }
        RecordsArray recs = new RecordsArray(this.dataStorage);
        Record rec = null;
        Vector<String> recIds = new Vector<String>();
        StringTokenizer token = new StringTokenizer(ids, "\n,");
        while (token.hasMoreTokens()) {
            recIds.add(token.nextToken().trim());
        }
        if (this.fi_id < 0) {
            int count = recIds.size();
            for (int i = 0; i < count; ++i) {
                int index = Strings.strToInt((String)recIds.elementAt(i), -1);
                rec = this.dataStorage.getRecord(index, 0);
                if (rec == null) continue;
                recs.addRecord(rec);
            }
        } else {
            DataStorage dataStorage = this.dataStorage;
            synchronized (dataStorage) {
                this.dataStorage.openDataStorage(true);
                try {
                    int count = this.dataStorage.size();
                    for (int i = 0; i < count; ++i) {
                        rec = this.newRecord(i);
                        this.dataStorage.readRecAttribute(rec);
                        String sId = rec.getField(this.fi_id).toString();
                        if (recIds.contains(sId)) {
                            this.dataStorage.readRecCoords(rec, null);
                            recs.addRecord(rec);
                            continue;
                        }
                        this.dataStorage.skipSpatial(i);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    this.dataStorage.closeDataStorage();
                }
            }
        }
        if (recs.size() == 0) {
            recs = null;
        }
        return recs;
    }

    public void resolveMetadata() throws AlovMapException {
        String val;
        super.resolveMetadata();
        if (this.isObjectType(-1)) {
            this.dataStorage.setObjectType(this.metadata.getObjType());
        }
        if ((val = this.metadata.getVal(37)) != null) {
            try {
                this.dateType = Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                this.dateType = val.equalsIgnoreCase("UniqueDate") || val.equalsIgnoreCase("InstanceDate") ? 2 : (val.equalsIgnoreCase("UniqueRange") || val.equalsIgnoreCase("InstanceRange") ? 1 : 0);
            }
        }
        if (this.dateType == 2) {
            this.f_dateLow = this.metadata.getVal(52);
        } else if (this.dateType == 1) {
            this.f_dateLow = this.metadata.getVal(53);
            this.f_dateHigh = this.metadata.getVal(54);
        }
        if (this.localFilter == null) {
            this.localFilter = this.metadata.getVal(150);
        }
        if (this.linkSearch == null) {
            this.linkSearch = this.metadata.getVal(301);
        }
        if (this.linkInfo == null) {
            this.linkInfo = this.metadata.getVal(302);
        }
        if (this.linkTips == null) {
            this.linkTips = this.metadata.getVal(310);
        }
        this.f_id = this.metadata.getVal(49);
        this.f_xmin = this.metadata.getVal(70);
        this.f_ymin = this.metadata.getVal(72);
        this.f_xmax = this.metadata.getVal(71);
        this.f_ymax = this.metadata.getVal(73);
        this.f_geoblob = this.metadata.getVal(74);
        this.f_x = this.metadata.getVal(75);
        this.f_y = this.metadata.getVal(76);
        this.f_description = this.metadata.getVal(51);
        this.tableName = this.metadata.getVal(43);
        if (!Strings.isNullOrBlank(this.tableName) && this.tableName.toUpperCase().startsWith("SELECT ")) {
            this.selectSQL = this.tableName;
        }
        this.fi_description = this.getFieldIndex(this.f_description);
    }

    public void prepareLayer() {
        FilterTime filter;
        block10: {
            this.selectedSymbol.loadSymbolImages(this);
            Vector virtualFields = this.metadata.getList(309);
            int extCount = virtualFields == null ? 0 : virtualFields.size();
            Vector<FieldDef> virtualDefs = new Vector<FieldDef>();
            for (int i = 0; i < extCount; ++i) {
                String metaValue = virtualFields.elementAt(i).toString();
                int pos = metaValue.indexOf("=");
                if (pos <= 0) continue;
                String fieldName = metaValue.substring(0, pos).trim();
                String className = metaValue.substring(pos + 1).trim();
                if (fieldName.length() <= 0 || className.length() <= 0) continue;
                try {
                    RecordField vrf;
                    FieldDef def = new FieldDef();
                    def.name = fieldName;
                    def.field = vrf = (RecordField)Class.forName(className).newInstance();
                    vrf.init(this);
                    def.type = vrf.getFieldJdbcType();
                    virtualDefs.addElement(def);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Failed to initialize calculated field " + fieldName + " class " + className);
                }
            }
            extCount = virtualDefs.size();
            if (extCount > 0) {
                int fieldCount = this.getFieldCount();
                FieldDef[] defs = new FieldDef[fieldCount + extCount];
                if (this.dataStorage.getFields() != null) {
                    System.arraycopy(this.dataStorage.getFields(), 0, defs, 0, fieldCount);
                }
                for (int i = 0; i < extCount; ++i) {
                    FieldDef def;
                    defs[fieldCount + i] = def = (FieldDef)virtualDefs.elementAt(i);
                    def.index = fieldCount + i;
                }
                this.dataStorage.assignFields(defs);
            }
            try {
                if (this.localFilter != null) {
                    this.filters.put("SF", new FilterExpression(this.localFilter, this));
                }
            }
            catch (Exception e) {
                System.out.println(">>. " + e.getMessage());
                if (!(this.parentMap instanceof Carte)) break block10;
                Log.addMessage(305, this.parentMap.getName(), this, this.localFilter + ". " + e.getClass().getName() + ". " + e.getMessage());
            }
        }
        if (this.timeVarying && (this.dateType == 1 || this.dateType == 2) && (filter = new FilterTime(this)).isActive()) {
            this.filters.put("TF", filter);
            filter.setTimeInterval(this.parentMap.getTimeInterval());
        }
        super.prepareLayer();
    }

    public void afterDeserialization() {
        super.afterDeserialization();
    }
}

