/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Color;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import org.alov.data.DataProviderImg;
import org.alov.map.DisplayContext;
import org.alov.map.FloatPoint;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.MapUtils;
import org.alov.map.RecordsArray;
import org.alov.map.Renderer;
import org.alov.map.RendererImage;
import org.alov.map.Shape;
import org.alov.util.AlovMapException;
import org.alov.util.Strings;
import org.alov.util.Utils;

public class LayerRaster
extends Layer {
    public Point fixedPosition = null;
    public Color transparentColor = null;
    public int transparency = -1;
    public int imgWidth = 0;
    public int imgHeight = 0;
    public int resolutionMaxLevel = 0;
    public int resolutionLevel = -1;
    public String wmsLayers = null;
    public String wmsStyles = null;
    public String wmsExtraParams = null;
    private transient byte[] imageBytes = null;
    private transient Image imageRaster = null;
    protected Rectangle loadedRectangle;
    public String imageUrl = null;

    public LayerRaster() {
        this.setSelection(null);
    }

    public void paintRecords(Vector v, Renderer rend, boolean selected, DisplayContext dc, int step) {
        if (!selected) {
            ((RendererImage)rend).paintRecord(null, selected, dc);
        }
    }

    public RecordsArray paintRecords2(Renderer rend, DisplayContext dc, int step) {
        if (dc == null || dc.getProjection() == null || this.isEmpty()) {
            return null;
        }
        ((RendererImage)rend).paintRecord(null, false, dc);
        return null;
    }

    public boolean isEmpty() {
        return this.imageBytes == null && this.imageRaster == null;
    }

    public void resolveMetadata() throws AlovMapException {
        super.resolveMetadata();
        boolean worldfileDefined = false;
        this.url = this.connectionData.getProperty("url");
        int xScrn = Strings.strToInt(this.metadata.getVal(138), -1);
        int yScrn = Strings.strToInt(this.metadata.getVal(139), -1);
        if (xScrn != -1 && yScrn != -1) {
            this.fixedPosition = new Point(xScrn, yScrn);
        }
        try {
            if (this.metadata.getDouble(144) == 0.0) {
                throw new AlovMapException(301, "X pixel size is zero.");
            }
            if (this.metadata.getDouble(145) == 0.0) {
                throw new AlovMapException(301, "Y pixel size is zero");
            }
            worldfileDefined = true;
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.metadata.maxExtent.isZero() && !worldfileDefined) {
            throw new AlovMapException(301, this.getName() + ". Extent of raster image is not defined. You have to define either worldfile, or worldfile or extent metadata elements");
        }
        try {
            String s = this.metadata.getVal(146);
            if (s != null) {
                this.imgWidth = Integer.parseInt(s);
            }
            if ((s = this.metadata.getVal(147)) != null) {
                this.imgHeight = Integer.parseInt(s);
            }
            if ((s = this.metadata.getVal(148)) != null) {
                this.resolutionMaxLevel = Integer.parseInt(s);
            }
        }
        catch (Exception e) {
            throw new AlovMapException(301, this.getName());
        }
        this.calculateExtent();
        this.wmsLayers = this.metadata.getVal(166);
        this.wmsStyles = this.metadata.getVal(167);
        this.wmsExtraParams = this.metadata.getVal(311);
    }

    public void prepareLayer() {
        if (!this.isDataOnServer) {
            this.layerExtent = this.metadata.maxExtent;
            this.setLoadComplete(true);
        }
        super.prepareLayer();
    }

    public FloatRectangle getLayerExtent() {
        if (this.metadata.maxExtent.isZero()) {
            this.calculateExtent();
            this.layerExtent = this.metadata.maxExtent;
        }
        if (!this.isDataOnServer) {
            this.layerExtent = this.metadata.maxExtent;
        }
        return this.layerExtent;
    }

    private void calculateExtent() {
        double x = this.metadata.getDouble(142);
        double y = this.metadata.getDouble(143);
        double sx = this.metadata.getDouble(144);
        double sy = Math.abs(this.metadata.getDouble(145));
        if (sx != 0.0 && sy != 0.0) {
            Image img;
            if (this.imgWidth <= 0 && this.imgHeight <= 0 && (img = this.getImage()) != null) {
                this.imgWidth = img.getWidth(null);
                this.imgHeight = img.getHeight(null);
            }
            if (this.imgWidth > 0 && this.imgHeight > 0) {
                this.metadata.maxExtent = new FloatRectangle(x - sx / 2.0, y + sy / 2.0 - Math.abs((double)this.imgHeight * sy), x - sx / 2.0 + (double)this.imgWidth * sx, y + sy / 2.0);
            }
        }
    }

    public RecordsArray findWithinRect(FloatRectangle rect, boolean isSingle) {
        if (this.getLayerExtent() == null || rect == null) {
            return null;
        }
        if (this.layerExtent.intersects(rect) || rect.intersects(this.layerExtent)) {
            RecordsArray resultVect = new RecordsArray(this.dataStorage);
            resultVect.setNotEmpty();
            return resultVect;
        }
        return null;
    }

    public RecordsArray findWithinCircle(FloatPoint center, double radius, boolean isInside, boolean isSingle) {
        if (this.getLayerExtent() == null || center == null) {
            return null;
        }
        double r2 = MapUtils.sqr(radius);
        double dx1 = this.layerExtent.x - center.x;
        double dx2 = this.layerExtent.x2 - center.x;
        double dy1 = this.layerExtent.y - center.y;
        double dy2 = this.layerExtent.y2 - center.y;
        if (MapUtils.sqr(dx1) + MapUtils.sqr(dy1) <= r2 && MapUtils.sqr(dx2) + MapUtils.sqr(dy1) <= r2 && MapUtils.sqr(dx1) + MapUtils.sqr(dy2) <= r2 && MapUtils.sqr(dx2) + MapUtils.sqr(dy2) <= r2 || !isInside && (this.layerExtent.contain(center.x, center.y) || MapUtils.intersectCircle(new FloatPoint(dx1, dy1), new FloatPoint(dx2, dy1), radius) || MapUtils.intersectCircle(new FloatPoint(dx2, dy1), new FloatPoint(dx2, dy2), radius) || MapUtils.intersectCircle(new FloatPoint(dx2, dy2), new FloatPoint(dx1, dy2), radius) || MapUtils.intersectCircle(new FloatPoint(dx1, dy2), new FloatPoint(dx1, dy1), radius))) {
            RecordsArray resultVect = new RecordsArray(this.dataStorage);
            resultVect.setNotEmpty();
            return resultVect;
        }
        return null;
    }

    public RecordsArray findWithinShape(Shape shape, boolean isInside, boolean isSingle) {
        if (this.getLayerExtent() == null || shape == null) {
            return null;
        }
        FloatPoint fpBottomRight = new FloatPoint(this.layerExtent.x2, this.layerExtent.y);
        FloatPoint fpBottomLeft = new FloatPoint(this.layerExtent.x, this.layerExtent.y);
        FloatPoint fpTopRight = new FloatPoint(this.layerExtent.x2, this.layerExtent.y2);
        FloatPoint fpTopLeft = new FloatPoint(this.layerExtent.x, this.layerExtent.y2);
        boolean bottomRightInside = Shape.containsPoint(shape, fpBottomRight.x, fpBottomRight.y);
        boolean bottomLeftInside = Shape.containsPoint(shape, fpBottomLeft.x, fpBottomLeft.y);
        boolean topRightInside = Shape.containsPoint(shape, fpTopRight.x, fpTopRight.y);
        boolean topLeftInside = Shape.containsPoint(shape, fpTopLeft.x, fpTopLeft.y);
        if (isInside && bottomRightInside && bottomLeftInside && topRightInside && topLeftInside || !isInside && (bottomRightInside || bottomLeftInside || topRightInside || topLeftInside || MapUtils.intersectShape(fpBottomLeft, fpBottomRight, shape) || MapUtils.intersectShape(fpBottomRight, fpTopRight, shape) || MapUtils.intersectShape(fpTopRight, fpTopLeft, shape) || MapUtils.intersectShape(fpTopLeft, fpBottomLeft, shape))) {
            RecordsArray resultVect = new RecordsArray(this.dataStorage);
            resultVect.setNotEmpty();
            return resultVect;
        }
        return null;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        try {
            ((DataProviderImg)this.provider).loadRaster();
        }
        catch (AlovMapException e) {
            e.printStackTrace();
        }
    }

    public void applyRasterFilters(int alpha) {
        this.transparency = alpha;
        if (this.imageBytes != null) {
            this.imageRaster = null;
        }
    }

    public Image getImage() {
        return this.getImage(null);
    }

    public Image getImage(Rectangle interest) {
        Image img = null;
        try {
            long mm = Utils.getMemoryUsage();
            if (mm > 51200L && this.imageRaster != null && this.imageBytes != null) {
                this.imageRaster = null;
                System.gc();
            }
            if (this.imageRaster != null) {
                img = this.imageRaster;
            } else if (this.imageBytes != null) {
                img = MapUtils.createImageFromBytes(this.imageBytes);
                if (this.transparentColor != null || this.transparency >= 0 && this.transparency < 255) {
                    img = MapUtils.makeColorTransparent(img, this.transparentColor, 255 - this.transparency);
                }
                if (mm < 41200L) {
                    this.imageRaster = img;
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return img;
    }

    public byte[] getImageSrc() {
        return this.imageBytes;
    }

    public void setImage(byte[] bytes) {
        this.imageBytes = bytes;
        if (bytes != null) {
            this.imageRaster = null;
        }
    }

    public void setRaster(Image img) {
        this.imageBytes = null;
        this.imageRaster = img;
    }

    protected Image getImageRaster() {
        return this.imageRaster;
    }

    public void clear(boolean bComplete) {
        this.imageBytes = null;
        this.imageRaster = null;
        super.clear(bComplete);
    }

    public boolean isVisibleNow(DisplayContext dc) {
        boolean res = super.isVisibleNow(dc);
        if (!res && this.imageRaster != null && this.imageBytes != null) {
            this.imageRaster = null;
            System.gc();
        }
        return res;
    }

    public Renderer createDefaultRenderer() {
        return new RendererImage(this);
    }
}

