/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.io.Serializable;
import org.alov.map.FloatPoint;

public class FloatRectangle
implements Serializable {
    public double x;
    public double y;
    public double x2;
    public double y2;

    public FloatRectangle() {
    }

    public FloatRectangle(FloatRectangle rec) {
        this.setBounds(rec.x, rec.y, rec.x2, rec.y2);
    }

    public FloatRectangle(FloatPoint tl, FloatPoint br) {
        this.setBounds(tl.x, br.y, br.x, tl.y);
    }

    public FloatRectangle(double x1, double y1, double x2, double y2) {
        this.setBounds(x1, y1, x2, y2);
    }

    public FloatRectangle(boolean isvrat) {
        this.setBounds(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
    }

    public void setBounds(double x1, double y1, double x2, double y2) {
        this.x = x1;
        this.y = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.x2 == 0.0 && this.y2 == 0.0 || this.x > this.x2 || this.y > this.y2;
    }

    public boolean intersects(FloatRectangle r) {
        return !(r == null || r.x2 <= this.x || r.y2 <= this.y || r.x >= this.x2 || r.y >= this.y2);
    }

    public boolean contains(FloatRectangle r) {
        return !(r == null || r.x2 > this.x2 || r.x < this.x || r.y2 > this.y2 || r.y < this.y);
    }

    public boolean equals(FloatRectangle r) {
        return r != null && r.x2 == this.x2 && r.y2 == this.y2 && r.x == this.x && r.y == this.y;
    }

    public boolean contain(double xp, double yp) {
        return !(xp < this.x || yp < this.y || xp > this.x2 || yp > this.y2);
    }

    public FloatRectangle intersection(FloatRectangle r) {
        double x1 = Math.max(this.x, r.x);
        double x2 = Math.min(this.x2, r.x2);
        double y1 = Math.max(this.y, r.y);
        double y2 = Math.min(this.y2, r.y2);
        if (x2 - x1 < 0.0 || y2 - y1 < 0.0) {
            return null;
        }
        return new FloatRectangle(x1, y1, x2, y2);
    }

    public void union(FloatRectangle r) {
        if (r != null) {
            this.x = Math.min(this.x, r.x);
            this.x2 = Math.max(this.x2, r.x2);
            this.y = Math.min(this.y, r.y);
            this.y2 = Math.max(this.y2, r.y2);
        }
    }

    public void add(double newx, double newy) {
        this.x = Math.min(this.x, newx);
        this.x2 = Math.max(this.x2, newx);
        this.y = Math.min(this.y, newy);
        this.y2 = Math.max(this.y2, newy);
    }

    public FloatRectangle scale(double s) {
        double w = (this.x2 - this.x) * s / 2.0;
        double h = (this.y2 - this.y) * s / 2.0;
        double x0 = (this.x2 + this.x) / 2.0;
        double y0 = (this.y2 + this.y) / 2.0;
        return new FloatRectangle(x0 - w, y0 - h, x0 + w, y0 + h);
    }

    public FloatPoint getCentre() {
        return new FloatPoint((this.x + this.x2) / 2.0, (this.y + this.y2) / 2.0);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ") - (" + this.x2 + ", " + this.y2 + ")";
    }
}

