/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import org.alov.map.FlashMaker;
import org.alov.util.Log;

public class FlashMakerFactory {
    public static final String _ERR_PACK_NOT_PRESENT = "Package org.alov.flash is not present";
    public static final String _WARN_PACK_NOT_PRESENT = " To generate SWF animations you need a Flash-enabled version of the TMJava applet.\nAdd Flash class to JAR file or request applet with Flash class included.";
    private static FlashMakerFactory instance = null;
    private Class[] makers = new Class[0];

    private FlashMakerFactory() {
    }

    public static FlashMakerFactory getFactory() {
        if (instance == null) {
            instance = new FlashMakerFactory();
            try {
                instance.registerMaker(Class.forName("org.alov.flash.GraphicsFlashMaker"));
            }
            catch (ClassNotFoundException ex) {
                Log.log(2, "Standard flash package was not found");
            }
        }
        return instance;
    }

    public void registerMaker(Class makerClass) {
        if (makerClass != null) {
            Class[] temp = this.makers;
            this.makers = new Class[this.makers.length + 1];
            System.arraycopy(temp, 0, this.makers, 0, temp.length);
            this.makers[this.makers.length - 1] = makerClass;
        }
    }

    public int getMakerCount() {
        return this.makers.length;
    }

    public boolean isPackagePresent() {
        return this.getMakerCount() > 0;
    }

    public FlashMaker getMaker(int index) {
        FlashMaker result = null;
        if (index >= 0 && index < this.getMakerCount()) {
            try {
                result = (FlashMaker)this.makers[index].newInstance();
            }
            catch (InstantiationException ex) {
                Log.log(2, "Cannot instantiate flash maker.");
            }
            catch (IllegalAccessException ex) {
                Log.log(2, "Flash maker class or initializer is not accessible.");
            }
        }
        return result;
    }
}

