/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.alov.map.DataStorage;
import org.alov.map.FloatRectangle;
import org.alov.map.Record;
import org.alov.map.RecordsArray;
import org.alov.map.Shape;
import org.alov.util.ExDate;
import org.alov.util.Readers;
import org.alov.util.Writers;

public class DataStorageCompact
extends DataStorage {
    protected byte[] spatialData = null;
    protected int[] spatialIndex = null;
    protected byte[] attributeData = null;
    protected int[] attributeIndex = null;
    private ByteArrayInputStream bis = null;
    private DataInputStream is = null;
    private ByteArrayInputStream bisa = null;
    private DataInputStream isa = null;
    private ByteArrayOutputStream bos = null;
    private DataOutputStream os = null;
    private ByteArrayOutputStream bosa = null;
    private DataOutputStream osa = null;
    private RecordsArray tempIndexS = null;
    private RecordsArray tempIndexA = null;

    public void afterDeserialization() {
        super.afterDeserialization();
    }

    public int size() {
        return this.spatialIndex == null ? 0 : this.spatialIndex.length;
    }

    private void saveDataStorageIndex(int index) {
        if (this.tempIndexA == null) {
            this.spatialIndex[index] = this.os.size();
            if (this.osa != null) {
                this.attributeIndex[index] = this.osa.size();
            }
        } else {
            this.tempIndexS.add(this.os.size());
            this.tempIndexA.add(this.osa.size());
        }
    }

    private void saveDataStorageCoords(Record rec) throws IOException {
        if (this.getObjectType() == 1) {
            Shape shp = rec.getShape(0);
            this.os.writeFloat((float)shp.xCoords[0]);
            this.os.writeFloat((float)shp.yCoords[0]);
        } else {
            int len = rec.getShapeCount();
            Writers.writeInt4(this.os, len);
            for (int j = 0; j < len; ++j) {
                Shape shp = rec.getShape(j);
                int ptCount = shp.xCoords.length;
                this.os.write(shp.typeFill);
                Writers.writeInt4(this.os, ptCount);
                for (int k = 0; k < ptCount; ++k) {
                    this.os.writeFloat((float)shp.xCoords[k]);
                    this.os.writeFloat((float)shp.yCoords[k]);
                }
            }
        }
    }

    public void saveDataStorageRec(Record rec, boolean isBoth) throws IOException {
        this.saveDataStorageIndex(rec.index);
        this.saveDataStorageCoords(rec);
        if (isBoth) {
            for (int j = 0; j < this.fieldOriginalCount; ++j) {
                Writers.writeObject(this.osa, rec.getField(j), this.fieldDefs[j].type);
            }
        }
        rec = null;
    }

    public void openDataStorageSave(boolean isTempIndex) {
        this.bos = new ByteArrayOutputStream();
        this.os = new DataOutputStream(this.bos);
        this.bosa = new ByteArrayOutputStream();
        this.osa = new DataOutputStream(this.bosa);
        if (isTempIndex) {
            this.tempIndexS = new RecordsArray(null);
            this.tempIndexA = new RecordsArray(null);
        }
    }

    public void openDataStorageSaveCoordinates() {
        this.bos = new ByteArrayOutputStream();
        this.os = new DataOutputStream(this.bos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDataStorageSave() {
        try {
            if (this.bos != null) {
                this.spatialData = this.bos.toByteArray();
                this.bos.close();
            }
            if (this.bosa != null) {
                this.attributeData = this.bosa.toByteArray();
                this.bosa.close();
            }
            if (this.tempIndexA != null) {
                this.spatialIndex = this.tempIndexS.getArray();
                this.attributeIndex = this.tempIndexA.getArray();
                this.tempIndexS = null;
                this.tempIndexA = null;
            }
            if (this.os != null) {
                this.os.close();
            }
            if (this.osa != null) {
                this.osa.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.os = null;
            this.bos = null;
            this.osa = null;
            this.bosa = null;
        }
    }

    public void openDataStorage(boolean withAttributes) {
        if (this.spatialData != null && this.spatialData.length > 0) {
            this.bis = new ByteArrayInputStream(this.spatialData);
            this.is = new DataInputStream(this.bis);
            if (withAttributes) {
                this.bisa = new ByteArrayInputStream(this.attributeData);
                this.isa = new DataInputStream(this.bisa);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDataStorage() {
        try {
            if (this.is != null) {
                this.is.close();
            }
            if (this.bis != null) {
                this.bis.close();
            }
            if (this.isa != null) {
                this.isa.close();
            }
            if (this.bisa != null) {
                this.bisa.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.is = null;
            this.bis = null;
            this.isa = null;
            this.bisa = null;
        }
    }

    public void skipAttribute(int index) throws IOException {
        if (index < this.attributeIndex.length - 1) {
            this.isa.skipBytes(this.attributeIndex[index + 1] - this.attributeIndex[index]);
        }
    }

    protected void skipAttribute2(int index1, int index2) throws IOException {
        int skipB = this.attributeIndex[index1] - this.attributeIndex[index2];
        this.isa.skipBytes(skipB);
    }

    protected void skipSpatial(int index) throws IOException {
        if (index < this.spatialIndex.length - 1) {
            this.is.skipBytes(this.spatialIndex[index + 1] - this.spatialIndex[index]);
        }
    }

    protected void skipSpatial2(int index1, int index2) throws IOException {
        int skipB = this.spatialIndex[index1] - this.spatialIndex[index2];
        this.is.skipBytes(skipB);
    }

    public void readRecAttribute(Record rec) throws IOException {
        block10: for (int i = 0; i < this.fieldOriginalCount; ++i) {
            switch (this.fieldDefs[i].type) {
                case -7: 
                case -6: {
                    rec.setField(i, new Byte(this.isa.readByte()));
                    continue block10;
                }
                case 5: {
                    rec.setField(i, new Short(this.isa.readShort()));
                    continue block10;
                }
                case 4: {
                    rec.setField(i, new Integer(this.isa.readInt()));
                    continue block10;
                }
                case -5: {
                    rec.setField(i, new Long(this.isa.readLong()));
                    continue block10;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: {
                    rec.setField(i, new Float(this.isa.readFloat()));
                    continue block10;
                }
                case 8: {
                    rec.setField(i, new Double(this.isa.readDouble()));
                    continue block10;
                }
                case -1: 
                case 1: 
                case 12: {
                    String s = new String(this.isa.readUTF());
                    rec.setField(i, s);
                    continue block10;
                }
                case 91: 
                case 92: 
                case 93: {
                    rec.setField(i, new ExDate(this.isa.readDouble()));
                    continue block10;
                }
                default: {
                    rec.setField(i, "");
                }
            }
        }
    }

    public boolean readRecCoords(Record rec, FloatRectangle extent) throws IOException {
        boolean isOk = false;
        if (this.getObjectType() == 1) {
            float xp = this.is.readFloat();
            float yp = this.is.readFloat();
            boolean bl = isOk = extent == null || extent.isZero() || extent.contain(xp, yp);
            if (isOk) {
                Shape shp = rec.newShape(1);
                shp.setVertex(0, xp, yp);
            }
        } else {
            double maxX = Double.NEGATIVE_INFINITY;
            double maxY = Double.NEGATIVE_INFINITY;
            double minX = Double.POSITIVE_INFINITY;
            double minY = Double.POSITIVE_INFINITY;
            int shpCount = Readers.readInt(this.is);
            rec.initShapes(shpCount);
            for (int i = 0; i < shpCount; ++i) {
                Shape shp = new Shape();
                shp.typeFill = (byte)this.is.read();
                int pointCount = Readers.readInt(this.is);
                shp.xCoords = new double[pointCount];
                shp.yCoords = new double[pointCount];
                for (int j = 0; j < pointCount; ++j) {
                    float xp = this.is.readFloat();
                    float yp = this.is.readFloat();
                    if (maxX < (double)xp) {
                        maxX = xp;
                    }
                    if (minX > (double)xp) {
                        minX = xp;
                    }
                    if (maxY < (double)yp) {
                        maxY = yp;
                    }
                    if (minY > (double)yp) {
                        minY = yp;
                    }
                    shp.xCoords[j] = xp;
                    shp.yCoords[j] = yp;
                }
                rec.setShape(i, shp);
            }
            FloatRectangle recExt = new FloatRectangle(minX, minY, maxX, maxY);
            rec.setRecordExtent(recExt);
            isOk = extent == null || extent.intersects(recExt);
        }
        return isOk;
    }

    public Record newRecord(int index) {
        Record rec = new Record(this.fieldOriginalCount);
        rec.index = index;
        return rec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Record getARecord(int ind) {
        Record rec = null;
        try {
            this.bisa = new ByteArrayInputStream(this.attributeData);
            this.isa = new DataInputStream(this.bisa);
            try {
                this.isa.skipBytes(this.attributeIndex[ind]);
                rec = new Record(this.fieldOriginalCount);
                rec.index = ind;
                this.readRecAttribute(rec);
            }
            finally {
                if (this.isa != null) {
                    this.is.close();
                }
                if (this.bisa != null) {
                    this.bis.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.isa = null;
            this.bisa = null;
        }
        return rec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Record getRecord(int ind, int whatNeed) {
        Record rec = null;
        if (ind >= 0 && ind < this.size()) {
            DataStorageCompact dataStorageCompact = this;
            synchronized (dataStorageCompact) {
                try {
                    this.openDataStorage(whatNeed < 2);
                    if (whatNeed < 2) {
                        rec = new Record(this.fieldOriginalCount);
                        this.isa.skipBytes(this.attributeIndex[ind]);
                        this.readRecAttribute(rec);
                    } else {
                        rec = new Record();
                    }
                    rec.index = ind;
                    if (whatNeed != 1) {
                        this.is.skipBytes(this.spatialIndex[ind]);
                        this.readRecCoords(rec, null);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    this.closeDataStorage();
                }
            }
        }
        return rec;
    }

    public void clear() {
        this.spatialData = null;
        this.spatialIndex = null;
        this.attributeData = null;
        this.attributeIndex = null;
    }

    public DataStorage copy() {
        DataStorageCompact ds = new DataStorageCompact();
        ds.spatialData = this.spatialData;
        ds.spatialIndex = this.spatialIndex;
        ds.attributeData = this.attributeData;
        ds.attributeIndex = this.attributeIndex;
        ds.fieldOriginalCount = this.fieldOriginalCount;
        return ds;
    }

    public void deleteRecord(Record rec) {
        int recordSize = 0;
        int recordASize = 0;
        if (rec.index == this.spatialIndex.length - 1) {
            recordSize = this.spatialData.length - this.spatialIndex[rec.index];
            recordASize = this.attributeData.length - this.attributeIndex[rec.index];
        } else {
            recordSize = this.spatialIndex[rec.index + 1] - this.spatialIndex[rec.index];
            recordASize = this.attributeIndex[rec.index + 1] - this.attributeIndex[rec.index];
        }
        byte[] spatialDataNew = new byte[this.spatialData.length - recordSize];
        byte[] attributeDataNew = new byte[this.attributeData.length - recordASize];
        if (this.spatialIndex[rec.index] > 0) {
            System.arraycopy(this.spatialData, 0, spatialDataNew, 0, this.spatialIndex[rec.index]);
        }
        if (rec.index != this.spatialIndex.length - 1) {
            System.arraycopy(this.spatialData, this.spatialIndex[rec.index + 1], spatialDataNew, this.spatialIndex[rec.index], this.spatialData.length - this.spatialIndex[rec.index + 1]);
        }
        if (this.attributeIndex[rec.index] > 0) {
            System.arraycopy(this.attributeData, 0, attributeDataNew, 0, this.attributeIndex[rec.index]);
        }
        if (rec.index != this.attributeIndex.length - 1) {
            System.arraycopy(this.attributeData, this.attributeIndex[rec.index + 1], attributeDataNew, this.attributeIndex[rec.index], this.attributeData.length - this.attributeIndex[rec.index + 1]);
        }
        for (int i = rec.index + 1; i < this.spatialIndex.length; ++i) {
            this.spatialIndex[i] = this.spatialIndex[i] - recordSize;
            this.attributeIndex[i] = this.attributeIndex[i] - recordASize;
        }
        int[] spatialIndexNew = new int[this.spatialIndex.length - 1];
        int[] attributeIndexNew = new int[this.attributeIndex.length - 1];
        if (rec.index > 0) {
            System.arraycopy(this.spatialIndex, 0, spatialIndexNew, 0, rec.index);
            System.arraycopy(this.attributeIndex, 0, attributeIndexNew, 0, rec.index);
        }
        if (rec.index != this.attributeIndex.length - 1) {
            System.arraycopy(this.spatialIndex, rec.index + 1, spatialIndexNew, rec.index, this.spatialIndex.length - rec.index - 1);
            System.arraycopy(this.attributeIndex, rec.index + 1, attributeIndexNew, rec.index, this.attributeIndex.length - rec.index - 1);
        }
        this.clear();
        this.spatialData = spatialDataNew;
        this.spatialIndex = spatialIndexNew;
        this.attributeData = attributeDataNew;
        this.attributeIndex = attributeIndexNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeRecord(Record rec, int whatNeed) {
        int i;
        int delta;
        int oldDataSize;
        int recordStart;
        boolean isEditRecord;
        if (this.bos != null) {
            try {
                this.saveDataStorageRec(rec, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        byte[] newData = null;
        byte[] newAtrData = null;
        try {
            if (whatNeed != 1) {
                this.bos = new ByteArrayOutputStream();
                this.os = new DataOutputStream(this.bos);
                this.saveDataStorageCoords(rec);
                newData = this.bos.toByteArray();
                if (this.os != null) {
                    this.os.close();
                }
            }
            if (whatNeed != 2) {
                this.bosa = new ByteArrayOutputStream();
                this.osa = new DataOutputStream(this.bosa);
                for (int j = 0; j < this.fieldOriginalCount; ++j) {
                    Writers.writeObject(this.osa, rec.getField(j), this.fieldDefs[j].type);
                }
                newAtrData = this.bosa.toByteArray();
                if (this.osa != null) {
                    this.osa.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        finally {
            this.os = null;
            this.bos = null;
            this.osa = null;
            this.bosa = null;
        }
        if (newData != null) {
            boolean bl = isEditRecord = rec.index > -1;
            if (this.spatialIndex == null) {
                this.spatialIndex = new int[0];
                this.spatialData = new byte[0];
            }
            recordStart = isEditRecord ? this.spatialIndex[rec.index] : this.spatialData.length;
            oldDataSize = 0;
            if (rec.index == this.spatialIndex.length - 1) {
                oldDataSize = this.spatialData.length - recordStart;
            } else if (isEditRecord) {
                oldDataSize = this.spatialIndex[rec.index + 1] - recordStart;
            }
            delta = newData.length - oldDataSize;
            if (delta == 0) {
                System.arraycopy(newData, 0, this.spatialData, recordStart, newData.length);
            } else {
                byte[] spatialDataNew = new byte[this.spatialData.length + delta];
                if (recordStart > 0) {
                    System.arraycopy(this.spatialData, 0, spatialDataNew, 0, recordStart);
                }
                System.arraycopy(newData, 0, spatialDataNew, recordStart, newData.length);
                if (isEditRecord && rec.index != this.spatialIndex.length - 1) {
                    System.arraycopy(this.spatialData, this.spatialIndex[rec.index + 1], spatialDataNew, recordStart + newData.length, this.spatialData.length - this.spatialIndex[rec.index + 1]);
                }
                if (isEditRecord) {
                    for (i = rec.index + 1; i < this.spatialIndex.length; ++i) {
                        this.spatialIndex[i] = this.spatialIndex[i] + delta;
                    }
                } else {
                    int[] spatialIndexNew = new int[this.spatialIndex.length + 1];
                    System.arraycopy(this.spatialIndex, 0, spatialIndexNew, 0, this.spatialIndex.length);
                    spatialIndexNew[this.spatialIndex.length] = this.spatialData.length;
                    this.spatialIndex = null;
                    this.spatialIndex = spatialIndexNew;
                }
                this.spatialData = null;
                this.spatialData = spatialDataNew;
            }
        }
        if (newAtrData != null) {
            boolean bl = isEditRecord = rec.index > -1;
            if (this.attributeIndex == null) {
                this.attributeIndex = new int[0];
                this.attributeData = new byte[0];
            }
            recordStart = isEditRecord ? this.attributeIndex[rec.index] : this.attributeData.length;
            oldDataSize = 0;
            if (rec.index == this.attributeIndex.length - 1) {
                oldDataSize = this.attributeData.length - recordStart;
            } else if (isEditRecord) {
                oldDataSize = this.attributeIndex[rec.index + 1] - recordStart;
            }
            delta = newAtrData.length - oldDataSize;
            if (delta == 0) {
                System.arraycopy(newAtrData, 0, this.attributeData, recordStart, newAtrData.length);
            } else {
                byte[] attributeDataNew = new byte[this.attributeData.length + delta];
                if (recordStart > 0) {
                    System.arraycopy(this.attributeData, 0, attributeDataNew, 0, recordStart);
                }
                System.arraycopy(newAtrData, 0, attributeDataNew, recordStart, newAtrData.length);
                if (isEditRecord && rec.index != this.attributeIndex.length - 1) {
                    System.arraycopy(this.attributeData, this.attributeIndex[rec.index + 1], attributeDataNew, recordStart + newAtrData.length, this.attributeData.length - this.attributeIndex[rec.index + 1]);
                }
                if (isEditRecord) {
                    for (i = rec.index + 1; i < this.attributeIndex.length; ++i) {
                        this.attributeIndex[i] = this.attributeIndex[i] + delta;
                    }
                } else {
                    int[] attributeIndexNew = new int[this.attributeIndex.length + 1];
                    System.arraycopy(this.attributeIndex, 0, attributeIndexNew, 0, this.attributeIndex.length);
                    rec.index = this.attributeIndex.length;
                    attributeIndexNew[rec.index] = this.attributeData.length;
                    this.attributeIndex = null;
                    this.attributeIndex = attributeIndexNew;
                }
                this.attributeData = null;
                this.attributeData = attributeDataNew;
            }
        }
    }

    protected void unionStorages(DataStorage ds2) {
        DataStorageCompact dataStorage2 = (DataStorageCompact)ds2;
        if (this.spatialData == null) {
            this.spatialData = dataStorage2.spatialData;
            this.spatialIndex = dataStorage2.spatialIndex;
            this.attributeData = dataStorage2.attributeData;
            this.attributeIndex = dataStorage2.attributeIndex;
        } else {
            byte[] spatialDataNew = new byte[this.spatialData.length + dataStorage2.spatialData.length];
            byte[] attributeDataNew = new byte[this.attributeData.length + dataStorage2.attributeData.length];
            System.arraycopy(this.spatialData, 0, spatialDataNew, 0, this.spatialData.length);
            System.arraycopy(this.attributeData, 0, attributeDataNew, 0, this.attributeData.length);
            System.arraycopy(dataStorage2.spatialData, 0, spatialDataNew, this.spatialData.length, dataStorage2.spatialData.length);
            System.arraycopy(dataStorage2.attributeData, 0, attributeDataNew, this.attributeData.length, dataStorage2.attributeData.length);
            int count = dataStorage2.spatialIndex.length;
            int spShift = this.spatialData.length;
            int atShift = this.attributeData.length;
            for (int i = 0; i < count; ++i) {
                dataStorage2.spatialIndex[i] = dataStorage2.spatialIndex[i] + spShift;
                dataStorage2.attributeIndex[i] = dataStorage2.attributeIndex[i] + atShift;
            }
            int[] spatialIndexNew = new int[this.spatialIndex.length + dataStorage2.spatialIndex.length];
            int[] attributeIndexNew = new int[this.attributeIndex.length + dataStorage2.attributeIndex.length];
            System.arraycopy(this.spatialIndex, 0, spatialIndexNew, 0, this.spatialIndex.length);
            System.arraycopy(this.attributeIndex, 0, attributeIndexNew, 0, this.attributeIndex.length);
            System.arraycopy(dataStorage2.spatialIndex, 0, spatialIndexNew, this.spatialIndex.length, dataStorage2.spatialIndex.length);
            System.arraycopy(dataStorage2.attributeIndex, 0, attributeIndexNew, this.attributeIndex.length, dataStorage2.attributeIndex.length);
            this.clear();
            this.spatialData = spatialDataNew;
            this.spatialIndex = spatialIndexNew;
            this.attributeData = attributeDataNew;
            this.attributeIndex = attributeIndexNew;
        }
    }

    public void write(ByteArrayOutputStream bos) throws IOException {
        ObjectOutputStream objOut = new ObjectOutputStream(bos);
        objOut.writeObject(this.spatialData);
        objOut.writeObject(this.spatialIndex);
        objOut.writeObject(this.attributeData);
        objOut.writeObject(this.attributeIndex);
        objOut.close();
    }

    public void read(InputStream bis) throws Exception {
        ObjectInputStream objIn = new ObjectInputStream(bis);
        this.spatialData = (byte[])objIn.readObject();
        this.spatialIndex = (int[])objIn.readObject();
        this.attributeData = (byte[])objIn.readObject();
        this.attributeIndex = (int[])objIn.readObject();
        objIn.close();
    }
}

