/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.io.IOException;
import java.io.Serializable;
import org.alov.map.FieldDef;
import org.alov.map.FloatRectangle;
import org.alov.map.Record;

public abstract class DataStorage
implements Serializable {
    protected int fieldOriginalCount = 0;
    protected FieldDef[] fieldDefs = null;
    private int objectType = -1;
    public static final int _EDIT_ALL = 0;
    public static final int _EDIT_ATR = 1;
    public static final int _EDIT_CRD = 2;

    public void afterDeserialization() {
    }

    public abstract int size();

    public abstract void saveDataStorageRec(Record var1, boolean var2) throws IOException;

    public abstract void openDataStorageSave(boolean var1);

    public abstract void openDataStorageSaveCoordinates();

    public abstract void closeDataStorageSave();

    public abstract void openDataStorage(boolean var1);

    public abstract void closeDataStorage();

    public abstract void skipAttribute(int var1) throws IOException;

    protected abstract void skipAttribute2(int var1, int var2) throws IOException;

    protected abstract void skipSpatial(int var1) throws IOException;

    protected abstract void skipSpatial2(int var1, int var2) throws IOException;

    public abstract void readRecAttribute(Record var1) throws IOException;

    public abstract boolean readRecCoords(Record var1, FloatRectangle var2) throws IOException;

    public abstract Record getRecord(int var1, int var2);

    public abstract Record newRecord(int var1);

    public abstract void clear();

    public abstract DataStorage copy();

    public abstract void deleteRecord(Record var1);

    public abstract void changeRecord(Record var1, int var2);

    protected abstract void unionStorages(DataStorage var1);

    public FieldDef[] initFields(int count) {
        this.fieldOriginalCount = count;
        if (count > 0) {
            this.fieldDefs = new FieldDef[count];
        }
        return this.fieldDefs;
    }

    public FieldDef[] getFields() {
        return this.fieldDefs;
    }

    public void assignFields(FieldDef[] defs) {
        this.fieldDefs = defs;
    }

    public void setObjectType(int value) {
        this.objectType = value;
    }

    public int getObjectType() {
        return this.objectType;
    }
}

