/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.io.Serializable;
import org.alov.map.ColLine;
import org.alov.map.FloatRectangle;

class ComplexFigure
implements Serializable {
    ColLine[] lines;

    ComplexFigure() {
        this.lines = new ColLine[0];
    }

    ComplexFigure(ColLine[] lines) {
        this.lines = lines;
    }

    void combineRect(FloatRectangle rect) {
        int i = 0;
        int l = 0;
        int len = this.lines.length;
        ColLine[] tlines = new ColLine[this.lines.length + 2];
        ColLine prev = null;
        while (i < len && this.lines[i].y <= rect.y) {
            tlines[l++] = prev = this.lines[i++];
        }
        if (prev == null) {
            tlines[l++] = new ColLine(rect.x, rect.x2, rect.y);
        } else if (rect.y != prev.y) {
            tlines[l] = new ColLine(prev, rect.y);
            tlines[l++].addSegment(rect.x, rect.x2);
        } else {
            prev.addSegment(rect.x, rect.x2);
        }
        while (i < len && this.lines[i].y < rect.y2) {
            int n = l++;
            prev = this.lines[i++];
            ColLine colLine = new ColLine(prev, prev.y);
            tlines[n] = colLine;
            colLine.addSegment(rect.x, rect.x2);
        }
        if (prev != null) {
            if (i < len) {
                if (this.lines[i].y == rect.y2) {
                    int n = l++;
                    ColLine colLine = this.lines[i++];
                    tlines[n] = colLine;
                    colLine.addSegment(rect.x, rect.x2);
                } else {
                    tlines[l++] = new ColLine(prev, rect.y2);
                }
                while (i < len) {
                    tlines[l++] = this.lines[i++];
                }
            } else {
                tlines[l++] = new ColLine(rect.y2);
            }
        } else {
            tlines[l++] = new ColLine(rect.y2);
            while (i < len) {
                tlines[l++] = this.lines[i++];
            }
        }
        this.lines = new ColLine[l];
        System.arraycopy(tlines, 0, this.lines, 0, l);
    }

    ComplexFigure rectSubtract(FloatRectangle rect) {
        int i = 0;
        int l = 0;
        int len = this.lines.length;
        ColLine[] tlines = new ColLine[this.lines.length + 2];
        ColLine prev = null;
        tlines[l++] = new ColLine(rect.x, rect.x2, rect.y);
        while (i < len && this.lines[i].y <= rect.y) {
            prev = this.lines[i++];
        }
        if (prev != null) {
            tlines[l - 1].subtractLine(prev);
        }
        while (i < len && this.lines[i].y < rect.y2) {
            int n = l++;
            ColLine colLine = new ColLine(rect.x, rect.x2, this.lines[i].y);
            tlines[n] = colLine;
            colLine.subtractLine(this.lines[i++]);
        }
        tlines[l++] = new ColLine(rect.y2);
        ColLine[] tlines2 = new ColLine[l];
        System.arraycopy(tlines, 0, tlines2, 0, l);
        return new ComplexFigure(tlines2);
    }

    FloatRectangle getExtent() {
        int len = this.lines.length;
        if (len == 0) {
            return null;
        }
        double y1 = this.lines[0].y;
        double y2 = this.lines[len - 1].y;
        boolean first = true;
        double x1 = 0.0;
        double x2 = 0.0;
        for (int i = 0; i < len; ++i) {
            double[] txs = this.lines[i].xs;
            int len2 = txs.length - 1;
            if (len2 < 0) continue;
            if (first) {
                x1 = txs[0];
                x2 = txs[len2];
                first = false;
                continue;
            }
            if (x1 > txs[0]) {
                x1 = txs[0];
            }
            if (!(x2 < txs[len2])) continue;
            x2 = txs[len2];
        }
        if (first) {
            return null;
        }
        return new FloatRectangle(x1, y1, x2, y2);
    }
}

