/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.CarteListener;
import org.alov.map.DisplayContext;
import org.alov.map.DisplayContextImpl;
import org.alov.map.Domain;
import org.alov.map.FloatPoint;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.LayerRaster;
import org.alov.map.LayerVector;
import org.alov.map.Lock;
import org.alov.map.MapUtils;
import org.alov.map.Project;
import org.alov.map.Projection;
import org.alov.map.Proxy;
import org.alov.map.ProxyRequest;
import org.alov.map.Record;
import org.alov.map.RecordsArray;
import org.alov.map.Renderer;
import org.alov.map.SLD_Loader;
import org.alov.map.StatusListener;
import org.alov.map.Utils2D;
import org.alov.util.Log;
import org.alov.util.SimpleTimer;
import org.alov.util.Strings;
import org.alov.util.TimeInterval;
import org.alov.util.TimerListener;
import org.alov.util.Utils;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

public class Carte
extends Canvas
implements Runnable,
ImageObserver,
DisplayContext,
CarteHostListener,
ActionListener,
StatusListener,
TimerListener {
    private Properties parameters = new Properties();
    public static final byte TOOL_NONE = 0;
    public static final byte TOOL_CENTER = 1;
    public static final byte TOOL_ZOOMIN = 2;
    public static final byte TOOL_ZOOMOUT = 3;
    public static final byte TOOL_PAN = 4;
    public static final byte TOOL_SELECT = 5;
    public static final byte TOOL_WEBLINK = 6;
    public static final byte TOOL_RECT_SRCH = 7;
    public static final byte TOOL_RECT = 8;
    public static final byte TOOL_SELPOINT = 9;
    private static final int MAX_RECENT_EXTENTS = 20;
    public static final int SEARCH_EXACT = 1;
    public static final int SEARCH_LIKE = 2;
    public static final int SEARCH_QUERY = 3;
    public static final int SEARCH_WHERE = 4;
    public Proxy proxy = null;
    private Carte mainMap = null;
    CarteHost host = null;
    public Vector mapListeners = new Vector();
    public Vector statusListeners = new Vector();
    public boolean supressAttributeFrame = false;
    public boolean isMultiLayerSelectionMode = true;
    public boolean isShowAttributeAfterSelection = false;
    private int defaultAttributeReqType = 31;
    public Properties stringResources = null;
    private Image backImage = null;
    public Graphics drawTo = null;
    private boolean repaintStaticNeeded = false;
    private boolean repaintNeeded = false;
    private Lock paintLock = new Lock();
    private Integer pntCounter = new Integer(0);
    private boolean dontRedraw = false;
    private byte currentTool = 0;
    private byte alterTool = 0;
    private Point mouseDownPoint = null;
    private Point currentPoint = null;
    Vector usedSpaces = new Vector();
    String sDependent_Maps = null;
    long ext_changing = 0L;
    protected Projection projection = null;
    private FloatRectangle lastExtent = null;
    protected FloatRectangle loadedExtent;
    private FloatRectangle lastSelectExt = null;
    private TimeInterval timeInterval = null;
    private PopupMenu pmSelection = new PopupMenu();
    private boolean moveBeyondProject = false;
    private Vector recentExtents = new Vector();
    private int undoIndex = 0;
    private ProxyRequest request = new ProxyRequest();
    private Layer activeLayer = null;
    private String thematicMap = null;
    private Vector SLD_styles = null;
    private String SLD_url = null;
    private Thread serviceThread;
    private boolean sthRunning = false;
    private boolean stopped = true;
    private boolean isKilled = false;
    protected boolean isFirstRequest = true;
    private boolean isKeyMap = false;
    private Project project;
    private FloatRectangle lastRectSelection = null;
    private FloatPoint lastPointSelection = null;
    private Hashtable customCursors = null;
    private SimpleTimer animationTimer;
    private String sPreviousTipsURL = "";
    private static final Font waitFont = new Font("SansSerif", 1, 14);
    private boolean logExtent = false;
    private int gcEach_10_paints = 0;
    private final String _MSG_SWITCH = "Switch on layers to view map";
    private final String _MSG_WAITPLS = "Wait please...";
    private static final String BTN_CENTER = "btn_center";
    private static final String BTN_ZOOMOUT = "btn_zoomout";
    private static final String BTN_ZOOMIN = "btn_zoomin";
    private static final String BTN_PAN = "btn_pan";
    private static final String BTN_SELECT = "btn_select";
    private static final String BTN_WEBLINK = "btn_weblink";
    private static final String BTN_RECT = "btn_rect";
    private static final String BTN_SELRECT = "btn_selrect";
    private static final String BTN_SELPOINT = "btn_selpoint";

    public Carte() {
        this.setBackground(Color.white);
        this.enableEvents(49L);
        this.add(this.pmSelection);
        this.pmSelection.addActionListener(this);
    }

    public void start() {
        this.stopped = false;
        this.startServiceThread();
    }

    public void setTimeInterval(TimeInterval time) {
        if (this.project == null) {
            return;
        }
        int count = this.project.getLayerCount();
        if (count == 0) {
            return;
        }
        this.timeInterval = time;
        for (int i = 0; i < count; ++i) {
            Layer lyr = this.project.getLayerByIndex(i);
            lyr.setTimeInterval(time);
        }
        this.extentChanged();
        this.broadcastMessage(108, time);
        this.updateMap();
    }

    public void extentChanged() {
        if (this.projection != null && !this.stopped) {
            this.lastExtent = this.project.maxExtent.isZero() ? new FloatRectangle(0.0, 0.0, 0.0, 0.0) : this.getExtent();
            this.request.setSpatialExtent(this.lastExtent, null);
            this.startServiceThread();
        }
    }

    public void downloadLayer(String layerId) {
        if (this.projection != null && !this.stopped) {
            this.lastExtent = this.project.maxExtent.isZero() ? new FloatRectangle(0.0, 0.0, 0.0, 0.0) : this.getExtent();
            this.request.setSpatialExtent(this.lastExtent, layerId);
            this.startServiceThread();
        }
    }

    private synchronized void startServiceThread() {
        if (!this.sthRunning && !this.isKilled) {
            try {
                this.sthRunning = true;
                this.serviceThread = new Thread(this);
                this.serviceThread.setPriority(5);
                this.serviceThread.start();
            }
            catch (Exception e) {
                this.sthRunning = false;
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        if (this.proxy != null) {
            if (!this.isProjectLoaded()) {
                this.proxy.loadProject();
                boolean isSuccess = this.isProjectLoaded();
                if (isSuccess && this.project.startLayer == null) {
                    this.project.startLayer = ((Layer)this.project.layers.elementAt((int)0)).id;
                }
                int count4 = this.statusListeners.size();
                for (int i = 0; i < count4; ++i) {
                    ((StatusListener)this.statusListeners.elementAt(i)).afterProjectLoaded(isSuccess);
                }
                this.host.refreshLayout();
                if (isSuccess) {
                    if (!Strings.isNullOrBlank(this.SLD_url) && this.SLD_styles != null) {
                        if (MapUtils.isSLD_Enabled()) {
                            try {
                                SLD_Loader.setStyleForProject(this.project, this.getRealPath(this.SLD_url), this.SLD_styles);
                                this.project.sortRenderersByLevels();
                            }
                            catch (Exception e) {
                                Log.addMessage(312, this.getName(), null, e.getMessage());
                            }
                        } else {
                            Log.addMessage(312, this.getName(), null, "SLD loader is not found");
                        }
                    }
                    this.setBackground(this.project.mapBackground);
                    int count = this.project.getLayerCount();
                    for (int i = 0; i < count; ++i) {
                        this.project.getLayerByIndex(i).setParentMap(this);
                    }
                    this.moveBeyondProject = this.project.moveBeyondProject;
                    this.projection = new Projection();
                    this.loadedExtent = null;
                    this.stopped = false;
                    if (this.project.maxExtent.isZero()) {
                        this.extentChanged();
                    } else {
                        this.isFirstRequest = false;
                        this.loadedExtent = new FloatRectangle(this.project.maxExtent);
                        this.zoomToDomain(this.project.startExtentName);
                    }
                    this.setActiveLayer(this.project.getLayerById(this.project.startLayer));
                    this.setThematicMap(this.project.startTheme);
                    this.updateMap();
                } else {
                    this.sthRunning = false;
                    return;
                }
            }
            while (!this.request.isClear()) {
                ProxyRequest req2;
                ProxyRequest count4 = this.request;
                synchronized (count4) {
                    req2 = this.request.copy();
                    this.request.clear();
                }
                try {
                    this.proxy.handleRequest(req2);
                    if (this.animationTimer != null || this.project.rendererDynamicCount <= 0 || this.project.animationDelay <= 0) continue;
                    this.animationTimer = new SimpleTimer(this.project.animationDelay, this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.sthRunning = false;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project prj) {
        this.project = prj;
    }

    public final boolean isProjectLoaded() {
        return this.project != null && this.project.isLoaded;
    }

    public void setBounds(int x, int y, int width, int height) {
        this.repaintStaticNeeded = true;
        super.setBounds(x, y, width, height);
    }

    public void repaintMap() {
        this.updateMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMap() {
        Graphics g = this.getGraphics();
        if (g != null) {
            this.repaintStaticNeeded = true;
            try {
                this.paint(g);
            }
            finally {
                g.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMap(boolean onlyDynamicRenderers) {
        Graphics g = this.getGraphics();
        if (g != null) {
            try {
                this.paintMap(g, onlyDynamicRenderers);
            }
            finally {
                g.dispose();
            }
        }
    }

    private void paintRendererLevel(Vector level, DisplayContext dc, Hashtable keyRecords, Hashtable layerRecords, Hashtable layerSelection, int cntr) {
        Layer l;
        Renderer rend;
        int j;
        Vector emptyVector = new Vector();
        int rendCount = level.size();
        Vector<Renderer> visibleRends = new Vector<Renderer>(rendCount);
        for (j = 0; j < rendCount; ++j) {
            try {
                rend = (Renderer)level.elementAt(j);
            }
            catch (Exception e) {
                return;
            }
            l = rend.getLayer();
            if (!rend.enabled || (this.isKeyMap || !l.isVisibleNow(dc)) && (!this.isKeyMap || !l.isKeyMap) || !rend.isRendererVisible(dc)) continue;
            RecordsArray recsArray = null;
            if (!this.isKeyMap) {
                recsArray = (RecordsArray)layerRecords.get(l);
            }
            if (recsArray == null) {
                recsArray = l.paintRecords2(rend, dc, cntr);
                if (recsArray != null) {
                    layerRecords.put(l, recsArray);
                }
            } else if (l instanceof LayerVector) {
                ((LayerVector)l).paintRecords3(recsArray, rend, false, dc, cntr);
            }
            if (this.isStopPaint(cntr)) {
                return;
            }
            if (this.activeLayer == null || !this.activeLayer.id.equals(l.id)) continue;
            visibleRends.addElement(rend);
        }
        if (!this.isKeyMap) {
            rendCount = visibleRends.size();
            for (j = 0; j < rendCount; ++j) {
                rend = (Renderer)visibleRends.elementAt(j);
                l = rend.getLayer();
                if (!(l instanceof LayerVector)) continue;
                ((LayerVector)l).paintRecords3(l.getSelection(), rend, true, dc, cntr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintMap(Graphics g, boolean onlyDynamic) {
        if (!this.isProjectLoaded()) {
            return;
        }
        Lock lock = this.paintLock;
        synchronized (lock) {
            this.repaintNeeded = true;
            boolean bl = this.repaintStaticNeeded = this.repaintStaticNeeded && !onlyDynamic;
            if (this.dontRedraw) {
                return;
            }
            if (!this.paintLock.tryLock()) {
                return;
            }
        }
        try {
            do {
                this.repaintNeeded = false;
                boolean tempRepaintStatic = this.repaintStaticNeeded;
                this.repaintStaticNeeded = false;
                int count = this.project.getLayerCount();
                Dimension d = this.getSize();
                int w = d.width;
                int h = d.height;
                if (w < 1) break;
                if (h < 1) {
                    break;
                }
                DisplayContextImpl dc = new DisplayContextImpl(this, null, this.projection, this.getLastExtent());
                this.usedSpaces.removeAllElements();
                Vector levels = this.project.renderers;
                int levelCount = levels.size();
                int dynamicLevelCount = this.project.rendererDynamicCount;
                Hashtable layerRecords = new Hashtable();
                Hashtable layerSelection = new Hashtable();
                Hashtable keyRecords = new Hashtable();
                Integer n = this.pntCounter;
                synchronized (n) {
                    this.pntCounter = new Integer(this.pntCounter + 1);
                }
                int cntr = this.pntCounter;
                if (this.backImage == null || tempRepaintStatic) {
                    this.backImage = this.createImage(w, h);
                    dc.graphics = this.drawTo = this.backImage.getGraphics();
                    this.lastExtent = this.getExtent();
                    this.drawTo.setColor(this.getBackground());
                    this.drawTo.fillRect(0, 0, w, h);
                    for (int i = 0; i < levelCount - dynamicLevelCount && i < levels.size(); ++i) {
                        Vector level = (Vector)levels.elementAt(i);
                        this.paintRendererLevel(level, dc, keyRecords, layerRecords, layerSelection, cntr);
                    }
                    if (this.isKeyMap && this.mainMap != null) {
                        FloatRectangle ext = this.mainMap.getLastExtent();
                        if (ext != null) {
                            Point topleft = this.mapToScreen(new FloatPoint(ext.x, ext.y2));
                            Point botright = this.mapToScreen(new FloatPoint(ext.x2, ext.y));
                            if (botright.y - topleft.y < 6) {
                                h = 6;
                                topleft.y -= 2;
                            } else {
                                h = botright.y - topleft.y;
                            }
                            if (botright.x - topleft.x < 6) {
                                w = 6;
                                topleft.x -= 2;
                            } else {
                                w = botright.x - topleft.x;
                            }
                            this.drawTo.setColor(this.project.keyMapOutline);
                            this.drawTo.drawRect(topleft.x, topleft.y, w, h);
                        }
                    } else if (this.lastRectSelection != null) {
                        Point pt1 = this.mapToScreen(new FloatPoint(this.lastRectSelection.x, this.lastRectSelection.y));
                        Point pt2 = this.mapToScreen(new FloatPoint(this.lastRectSelection.x2, this.lastRectSelection.y2));
                        this.drawTo.setColor(Color.red);
                        this.drawTo.drawRect(pt1.x, pt2.y, pt2.x - pt1.x, pt1.y - pt2.y);
                    } else if (this.lastPointSelection != null) {
                        Point pt1 = this.mapToScreen(this.lastPointSelection);
                        this.drawTo.setColor(Color.red);
                        this.drawTo.drawOval(pt1.x - 3, pt1.y - 3, 6, 6);
                    }
                    this.drawTo.dispose();
                }
                Image doubleBuffer = this.createImage(d.width, d.height);
                this.drawTo = doubleBuffer.getGraphics();
                if (this.backImage != null) {
                    this.drawTo.drawImage(this.backImage, 0, 0, null);
                }
                dc.graphics = this.drawTo;
                for (int i = levelCount - dynamicLevelCount; i < levelCount; ++i) {
                    Vector level = (Vector)levels.elementAt(i);
                    this.paintRendererLevel(level, dc, keyRecords, layerRecords, layerSelection, cntr);
                }
                this.drawTo.dispose();
                g.drawImage(doubleBuffer, 0, 0, null);
                doubleBuffer.flush();
            } while (this.repaintNeeded);
        }
        finally {
            this.paintLock.unlock();
        }
        if (this.gcEach_10_paints > 10) {
            System.gc();
            this.gcEach_10_paints = 0;
            Utils.showMemoryUsage();
        }
        ++this.gcEach_10_paints;
    }

    public void paint(Graphics g) {
        Dimension size = this.getSize();
        Rectangle region = new Rectangle(0, 0, size.width, size.height);
        if (size.width > 0 && size.height > 0) {
            boolean empty = true;
            boolean allInvis = true;
            int count = this.project != null ? this.project.getLayerCount() : 0;
            for (int i = 0; i < count; ++i) {
                Layer l = this.project.getLayerByIndex(i);
                if (l.isVisible()) {
                    allInvis = false;
                }
                if (l.isEmpty()) continue;
                empty = false;
                break;
            }
            if (empty) {
                if (!this.isKeyMap) {
                    String tpm_wait_please = this.getResource(allInvis ? "Switch on layers to view map" : "Wait please...");
                    g.setColor(Color.white);
                    g.fillRect(0, 0, size.width, size.height);
                    g.setFont(waitFont);
                    g.setColor(Color.black);
                    g.drawString(tpm_wait_please, size.width / 2 - g.getFontMetrics().stringWidth(tpm_wait_please) / 2, size.height / 2 + 12);
                }
            } else {
                this.paintMap(g, false);
            }
            if (g != null && !this.isKeyMap && !this.isKilled) {
                int count2 = this.mapListeners.size();
                for (int i = 0; i < count2; ++i) {
                    ((CarteListener)this.mapListeners.elementAt(i)).afterMapDraw(g);
                }
                g.setFont(MapUtils.defaultPlainFont);
                String s = "TMJava v2.2.25";
                int fw = size.width - g.getFontMetrics().stringWidth(s);
                g.setColor(Color.white);
                g.drawString(s, fw + 1, size.height - 5);
                g.setColor(Color.black);
                g.drawString(s, fw, size.height - 6);
            }
        }
    }

    public FloatPoint screenToMap(Point coord) {
        if (this.projection == null || this.projection.zoom <= 0.0) {
            return null;
        }
        return new FloatPoint((double)coord.x / this.projection.zoom - this.projection.shift.x, -((double)coord.y / this.projection.zoom - this.projection.shift.y));
    }

    public Point mapToScreen(FloatPoint coord) {
        if (this.projection == null) {
            return null;
        }
        return new Point((int)((coord.x + this.projection.shift.x) * this.projection.zoom), (int)((-coord.y + this.projection.shift.y) * this.projection.zoom));
    }

    public Point mapToScreen_(double x, double y) {
        if (this.projection == null) {
            return null;
        }
        return new Point((int)((x + this.projection.shift.x) * this.projection.zoom), (int)((-y + this.projection.shift.y) * this.projection.zoom));
    }

    public void zoomToLayer(Layer lyr) {
        if (lyr != null) {
            FloatRectangle ext;
            FloatRectangle floatRectangle = ext = lyr.isLoadComplete() && lyr.getLayerExtent() != null ? lyr.getLayerExtent() : lyr.metadata.maxExtent;
            if (ext != null && !ext.isZero()) {
                this.zoomToExtent(ext);
                this.broadcastMessage(100, lyr.getName());
                this.updateMap();
            }
        }
    }

    public Layer getLayer(String layerName) {
        Layer lyr = this.project.getLayerById(layerName);
        if (lyr == null) {
            lyr = this.project.getLayerByName(layerName);
        }
        return lyr;
    }

    public void setExtent(FloatRectangle ext, FloatPoint center) {
        this.setExtent(ext, center, null);
        this.storeExtent();
    }

    private void setExtent(FloatRectangle ext, FloatPoint center, FloatPoint shift) {
        boolean isExtentChanged = this.calcProjection(ext, center, shift);
        this.extentChanged();
        if (isExtentChanged) {
            this.broadcastMessage(109, new Float(this.getDistance(this.getExtent())));
        }
        if (this.logExtent) {
            try {
                FileOutputStream fos = new FileOutputStream("logext.tmj");
                ext = this.getExtent();
                fos.write((ext.x + "\r\n" + ext.y + "\r\n" + ext.x2 + "\r\n" + ext.y2 + "\r\n").getBytes());
                fos.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!this.isKeyMap && !Strings.isNullOrBlank(this.sDependent_Maps)) {
            StringTokenizer st = new StringTokenizer(this.sDependent_Maps, " ,;");
            ++this.ext_changing;
            while (st.hasMoreTokens()) {
                Carte dependent_map = this.host.getMapByName(st.nextToken());
                if (dependent_map == null) continue;
                dependent_map.setExtentDependent(this.getExtent(), this.ext_changing);
            }
        }
    }

    void setExtentDependent(FloatRectangle ext, long uniq_id) {
        if (this.ext_changing != uniq_id) {
            this.setExtent(ext, null);
            this.updateMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean calcProjection(FloatRectangle ext, FloatPoint center, FloatPoint shift) {
        double h2;
        double w2;
        double prevZoom;
        double maxz;
        double minz;
        double pz;
        double py;
        double px;
        if (this.projection != null) {
            px = this.projection.shift.x;
            py = this.projection.shift.y;
            pz = this.projection.zoom;
            minz = this.projection.minzoom;
            maxz = this.projection.maxzoom;
            prevZoom = pz;
        } else {
            px = 0.0;
            py = 0.0;
            pz = 1.0;
            minz = 1.0;
            maxz = 1.0;
            prevZoom = -1.0;
        }
        Dimension d = this.getSize();
        int nw = d.width;
        int nh = d.height;
        boolean calcX = true;
        boolean calcY = true;
        if (shift != null) {
            if (this.projection == null) {
                return false;
            }
            px = shift.x;
            py = -shift.y;
            ext = new FloatRectangle(-px, py - (double)nh / pz, (double)nw / pz - px, py);
        } else if (ext == null) {
            if (this.projection == null || center == null) {
                return false;
            }
            w2 = (double)nw / pz / 2.0;
            h2 = (double)nh / pz / 2.0;
            ext = new FloatRectangle(center.x - w2, center.y - h2, center.x + w2, center.y + h2);
        } else {
            if (this.project.maxExtent == null || this.project.maxExtent.isZero()) {
                if (this.loadedExtent == null) {
                    return false;
                }
                this.project.maxExtent = new FloatRectangle(this.loadedExtent);
            }
            if (this.project.MapUnits == -1) {
                int n = this.project.MapUnits = Math.abs(this.project.maxExtent.x2) < 361.0 && Math.abs(this.project.maxExtent.x) < 361.0 && Math.abs(this.project.maxExtent.y) < 140.0 && Math.abs(this.project.maxExtent.y2) < 140.0 ? 0 : 1;
            }
            if (this.project.zmax < 0.0) {
                w2 = Math.abs(this.project.maxExtent.x2 - this.project.maxExtent.x);
                h2 = Math.abs(this.project.maxExtent.y2 - this.project.maxExtent.y);
                this.project.zmax = h2 > w2 && w2 > 0.0 ? this.getDistance(this.project.maxExtent.scale(h2 / w2)) : this.getDistance(this.project.maxExtent);
            }
            if (this.project.zmin < 1.0E-4) {
                this.project.zmin = this.getDistance(this.project.maxExtent) / 600.0;
            }
            w2 = Math.abs(ext.x2 - ext.x);
            h2 = Math.abs(ext.y2 - ext.y);
            double z1 = MapUtils.toMapUnits(this.project.zmax, ext, this.project.MapUnits, this.project.ZoomUnits);
            double z2 = MapUtils.toMapUnits(this.project.zmin, ext, this.project.MapUnits, this.project.ZoomUnits);
            minz = (double)nw / z2;
            maxz = (double)nw / z1;
            if (this.project.zmax > 0.0 && w2 > z1) {
                pz = maxz;
            } else if (this.project.zmin > 0.0 && w2 < z2) {
                pz = minz;
            } else {
                z1 = w2 > Math.abs(this.project.maxExtent.x2 - this.project.maxExtent.x) ? Math.abs(this.project.maxExtent.x2 - this.project.maxExtent.x) : w2;
                z2 = h2 > Math.abs(this.project.maxExtent.y2 - this.project.maxExtent.y) ? Math.abs(this.project.maxExtent.y2 - this.project.maxExtent.y) : h2;
                z1 = (double)nw / z1;
                z2 = (double)nh / z2;
                double d2 = pz = z1 > z2 ? z2 : z1;
            }
            if (center != null) {
                ext.x = center.x - (w2 /= 2.0);
                ext.y = center.y - (h2 /= 2.0);
                ext.x2 = center.x + w2;
                ext.y2 = center.y + h2;
            }
        }
        if (!this.moveBeyondProject && !this.project.maxExtent.isZero()) {
            double x1 = this.project.maxExtent.x;
            double y1 = this.project.maxExtent.y;
            double x2 = this.project.maxExtent.x2;
            double y2 = this.project.maxExtent.y2;
            double w = x2 - x1;
            double h = y2 - y1;
            w2 = ext.x2 - ext.x;
            h2 = ext.y2 - ext.y;
            if (w < w2) {
                ext.x = (x1 + x2 - w2) / 2.0;
                ext.x2 = ext.x + w2;
            } else if (ext.x < x1) {
                ext.x = x1;
                ext.x2 = x1 + w2;
            } else if (ext.x2 > x2) {
                ext.x2 = x2;
                ext.x = x2 - w2;
            } else {
                calcX = false;
            }
            if (h < h2) {
                ext.y = (y1 + y2 - h2) / 2.0;
                ext.y2 = ext.y + h2;
            } else if (ext.y < y1) {
                ext.y = y1;
                ext.y2 = y1 + h2;
            } else if (ext.y2 > y2) {
                ext.y2 = y2;
                ext.y = y2 - h2;
            } else {
                calcY = false;
            }
        }
        if (shift == null || calcX) {
            px = ((double)nw / pz - (ext.x2 - ext.x)) / 2.0 - ext.x;
        }
        if (shift == null || calcY) {
            py = ext.y2 + ((double)nh / pz - (ext.y2 - ext.y)) / 2.0;
        }
        if (this.projection == null) {
            this.projection = new Projection();
        }
        Projection projection = this.projection;
        synchronized (projection) {
            this.projection.zoom = pz;
            this.projection.shift.x = px;
            this.projection.shift.y = py;
            this.projection.minzoom = minz;
            this.projection.maxzoom = maxz;
        }
        return pz != prevZoom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExtent(FloatRectangle r) {
        if (r != null) {
            if (this.loadedExtent == null || this.loadedExtent.isZero()) {
                this.loadedExtent = r;
            } else {
                FloatRectangle floatRectangle = this.loadedExtent;
                synchronized (floatRectangle) {
                    this.loadedExtent.union(r);
                }
            }
        }
    }

    private void drawSelectRect(Graphics g) {
        int y2;
        int y1;
        int x2;
        int x1;
        if (this.mouseDownPoint.x > this.currentPoint.x) {
            x1 = this.currentPoint.x;
            x2 = this.mouseDownPoint.x;
        } else {
            x2 = this.currentPoint.x;
            x1 = this.mouseDownPoint.x;
        }
        if (this.mouseDownPoint.y > this.currentPoint.y) {
            y1 = this.currentPoint.y;
            y2 = this.mouseDownPoint.y;
        } else {
            y2 = this.currentPoint.y;
            y1 = this.mouseDownPoint.y;
        }
        g.drawRect(x1, y1, x2 - x1 + 1, y2 - y1 + 1);
    }

    public void zoomToExtent(FloatRectangle ext) {
        if (ext == null || ext.isZero()) {
            this.zoomToFullExtent();
        } else {
            this.setExtent(ext, null);
        }
    }

    public synchronized void zoomToFullExtent() {
        if (this.loadedExtent != null) {
            this.setExtent(this.loadedExtent, null);
        }
    }

    public Layer getActiveLayer() {
        return this.activeLayer;
    }

    public void setActiveLayer(Layer lyr) {
        if (!(lyr == null || this.activeLayer == lyr && lyr.isPassResolved())) {
            this.clearSelection();
            this.activeLayer = lyr;
            String sName = this.activeLayer == null ? "" : this.activeLayer.getName();
            this.broadcastMessage(107, sName);
        }
    }

    public void clearSelection() {
        int count = this.project.getLayerCount();
        for (int i = 0; i < count; ++i) {
            this.project.getLayerByIndex(i).setSelection(null);
        }
    }

    public void setThematicMap(String nameTheme) {
        if (nameTheme == null || this.project == null || this.project.themes == null) {
            return;
        }
        String t = (String)this.project.themes.get(nameTheme);
        if (t != null) {
            this.thematicMap = t;
            this.extentChanged();
            Layer lyr = this.project.getLayerById((String)this.project.themesLayer.get(nameTheme));
            this.setActiveLayer(lyr);
        } else if (this.thematicMap == null && this.project.themesNames != null) {
            this.thematicMap = (String)this.project.themes.get(this.project.themesNames);
        }
        if (this.thematicMap != null) {
            this.broadcastMessage(106, nameTheme);
        }
    }

    public void zoomToDomain(String name) {
        if (name == null || this.project == null || this.project.domains == null) {
            return;
        }
        try {
            Domain domain = (Domain)this.project.domains.get(name);
            this.zoomToExtent(domain.ext);
            Layer lyr = this.project.getLayerById(domain.layerId);
            this.setActiveLayer(lyr);
            this.broadcastMessage(102, name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public byte getTool() {
        return this.currentTool;
    }

    public void setTool(byte tool) {
        this.currentTool = tool;
        this.setCursor(tool);
        this.broadcastMessage(112, new Byte(tool));
    }

    public static String getToolName(byte tool) {
        String s = null;
        switch (tool) {
            case 1: {
                s = BTN_CENTER;
                break;
            }
            case 2: {
                s = BTN_ZOOMIN;
                break;
            }
            case 3: {
                s = BTN_ZOOMOUT;
                break;
            }
            case 4: {
                s = BTN_PAN;
                break;
            }
            case 5: {
                s = BTN_SELECT;
                break;
            }
            case 6: {
                s = BTN_WEBLINK;
                break;
            }
            case 7: {
                s = BTN_RECT;
                break;
            }
            case 8: {
                s = BTN_SELRECT;
                break;
            }
            case 9: {
                s = BTN_SELPOINT;
            }
        }
        return s;
    }

    public static byte getToolCode(String buttonName) {
        int tool = 0;
        if (buttonName.equalsIgnoreCase(BTN_CENTER)) {
            tool = 1;
        } else if (buttonName.equalsIgnoreCase(BTN_ZOOMIN)) {
            tool = 2;
        } else if (buttonName.equalsIgnoreCase(BTN_ZOOMOUT)) {
            tool = 3;
        } else if (buttonName.equalsIgnoreCase(BTN_PAN)) {
            tool = 4;
        } else if (buttonName.equalsIgnoreCase(BTN_SELECT)) {
            tool = 5;
        } else if (buttonName.equalsIgnoreCase(BTN_WEBLINK)) {
            tool = 6;
        } else if (buttonName.equalsIgnoreCase(BTN_RECT)) {
            tool = 7;
        } else if (buttonName.equalsIgnoreCase(BTN_SELRECT)) {
            tool = 8;
        } else if (buttonName.equalsIgnoreCase(BTN_SELPOINT)) {
            tool = 9;
        }
        return (byte)tool;
    }

    void setCursor(int tool) {
        Cursor cr;
        if (this.customCursors != null && (cr = (Cursor)this.customCursors.get(String.valueOf(tool))) != null) {
            this.setCursor(cr);
            return;
        }
        switch (tool) {
            case 2: 
            case 3: {
                this.setCursor(Cursor.getPredefinedCursor(1));
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                this.setCursor(Cursor.getPredefinedCursor(12));
                break;
            }
            case 4: {
                this.setCursor(Cursor.getPredefinedCursor(13));
                break;
            }
            default: {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        int id = e.getID();
        switch (id) {
            case 501: {
                this.mousePressed(e);
                break;
            }
            case 502: {
                this.mouseReleased(e);
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        int id = e.getID();
        switch (id) {
            case 503: {
                this.mouseMoved(e);
                break;
            }
            case 506: {
                this.mouseDragged(e);
            }
        }
    }

    protected void processComponentEvent(ComponentEvent e) {
        int id = e.getID();
        switch (id) {
            case 101: {
                this.componentResized(e);
            }
        }
    }

    public void centerAt(double x, double y) {
        if (this.project != null && this.projection != null && this.project.maxExtent != null) {
            double eMax = Math.abs(this.project.maxExtent.x2 - this.project.maxExtent.x);
            double eMin = eMax / 10.0;
            FloatRectangle rect = new FloatRectangle(x - eMin, y - eMin, x + eMin, y + eMin);
            this.setExtent(rect, null);
            this.updateMap();
        }
    }

    public void selectObject(Layer lyr, Record rec) {
        if (rec != null) {
            RecordsArray recs = new RecordsArray(lyr.dataStorage);
            recs.addRecord(rec);
            this.selectObjects(lyr, recs);
        }
    }

    public void selectObjectByExpr(Layer lyr, String expression) {
        if (lyr instanceof LayerVector) {
            try {
                RecordsArray recs = ((LayerVector)lyr).findByExpression(expression);
                if (MapUtils.isNotEmptyRecs(recs)) {
                    System.out.print(".");
                    this.selectObjects(lyr, recs);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void selectObjects(Layer layer, RecordsArray recs) {
        if (layer instanceof LayerVector && MapUtils.isNotEmptyRecs(recs)) {
            int code;
            LayerVector lyr = (LayerVector)layer;
            int selectionSize = recs.size();
            lyr.setSelection(recs);
            FloatRectangle rect = recs.getExtent();
            Record rec = recs.getRecord(0);
            if (rect.x2 == rect.x) {
                FloatRectangle rect2 = this.getLastExtent();
                double xr = Math.abs(rect2.x2 - rect2.x) / 100.0;
                rect.x2 += xr;
                rect.x -= xr;
            }
            if (lyr.zoom_for_select == 0.0f) {
                this.setExtent(null, new FloatPoint(rect.x + (rect.x2 - rect.x) / 2.0, rect.y + (rect.y2 - rect.y) / 2.0));
            } else if (lyr.zoom_for_select > 0.0f && lyr.zoom_for_select <= 1.0f) {
                this.setExtent(this.project.maxExtent.scale(lyr.zoom_for_select), new FloatPoint(rect.x + (rect.x2 - rect.x) / 2.0, rect.y + (rect.y2 - rect.y) / 2.0));
            } else {
                if (lyr.zoom_for_select > 1.0f) {
                    double defZoom = MapUtils.toMapUnits(lyr.zoom_for_select, rect, this.project.MapUnits, this.project.ZoomUnits);
                    rect = rect.scale((defZoom + defZoom / 100.0) / Math.abs(rect.x2 - rect.x));
                } else {
                    double eFig;
                    double eMax;
                    double eMin = MapUtils.toMapUnits(this.project.zmin, rect, this.project.MapUnits, this.project.ZoomUnits);
                    eMin = eMin < (eMax = Math.abs(this.project.maxExtent.x2 - this.project.maxExtent.x)) / 10.0 ? eMax / 10.0 : (eMin *= 3.0);
                    if (selectionSize == 1 && lyr.isObjectType(1)) {
                        FloatRectangle ext = rec.getRecordExtent();
                        FloatPoint centre = ext.getCentre();
                        rect = new FloatRectangle(centre.x - eMin, centre.y - eMin, centre.x + eMin, centre.y + eMin);
                    } else {
                        rect = rect.scale(2.0);
                    }
                    double eLayMax = eMax;
                    if (lyr.withinZoom) {
                        double eLayMin;
                        if (lyr.zmin > 0.0f && eMin < (eLayMin = MapUtils.toMapUnits(lyr.zmin, rect, this.project.MapUnits, this.project.ZoomUnits))) {
                            eMin = eLayMin;
                        }
                        if (lyr.zmax > 0.0f) {
                            eLayMax = MapUtils.toMapUnits(lyr.zmax, rect, this.project.MapUnits, this.project.ZoomUnits);
                        }
                    }
                    if ((eFig = Math.abs(rect.x2 - rect.x)) > eLayMax) {
                        rect = rect.scale(eLayMax / eFig);
                    }
                    if (eFig < eMin) {
                        rect = rect.scale((eMin + eMin / 100.0) / eFig);
                    }
                }
                rect.y += (rect.y2 - rect.y) / 2.0;
                rect.y2 = rect.y;
                this.setExtent(rect, null);
            }
            String sName = " [" + lyr.getName() + ']';
            if (selectionSize == 1) {
                sName = (lyr.fi_description >= 0 && lyr.fi_description < lyr.getFieldCount() ? lyr.getFieldString(rec, lyr.fi_description) : lyr.getId(rec)) + sName;
                code = 103;
            } else {
                sName = selectionSize + sName;
                code = 104;
            }
            this.activeLayer = lyr;
            this.broadcastMessage(code, sName);
            this.updateMap();
        }
    }

    public void selectObjectsById(String layerName, String ids) {
        try {
            Layer lyr = this.project.getLayerByName(layerName);
            if (lyr == null && (lyr = this.project.getLayerById(layerName)) == null) {
                lyr = this.project.getLayerByDsId(layerName);
            }
            if (lyr != null && lyr instanceof LayerVector) {
                RecordsArray recs = ((LayerVector)lyr).findByIds(ids);
                if (MapUtils.isNotEmptyRecs(recs)) {
                    this.selectObjects(lyr, recs);
                } else {
                    recs = null;
                    this.request.setQuery(2, lyr.id, ids);
                    this.startServiceThread();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public FloatRectangle getFullExtent() {
        return new FloatRectangle(this.loadedExtent);
    }

    synchronized void storeExtent() {
        int i;
        for (i = 0; i < this.undoIndex; ++i) {
            this.recentExtents.removeElementAt(0);
        }
        this.recentExtents.insertElementAt(this.getExtent(), 0);
        i = this.recentExtents.size();
        if (i > 20) {
            this.recentExtents.removeElementAt(i - 1);
        }
        this.undoIndex = 0;
    }

    public void undoExtent() {
        if (this.doUndoExtent()) {
            this.updateMap();
        }
    }

    public void redoExtent() {
        if (this.doRedoExtent()) {
            this.updateMap();
        }
    }

    synchronized boolean doUndoExtent() {
        if (this.undoIndex < this.recentExtents.size() - 1) {
            this.setExtent((FloatRectangle)this.recentExtents.elementAt(++this.undoIndex), null, null);
            return true;
        }
        return false;
    }

    synchronized boolean doRedoExtent() {
        if (this.undoIndex > 0) {
            this.setExtent((FloatRectangle)this.recentExtents.elementAt(--this.undoIndex), null, null);
            return true;
        }
        return false;
    }

    public void showAttribForSelection(String layerId, int reqType, FloatRectangle ext) {
        Layer lyr;
        if (!this.isProjectLoaded()) {
            return;
        }
        Layer layer = lyr = layerId == null ? this.getActiveLayer() : this.project.getLayerById(layerId);
        if (lyr != null && MapUtils.isNotEmptyRecs(lyr.getSelection())) {
            this.request.clear();
            this.request.setSpatialExtent(ext, null);
            this.request.setQuery(reqType, lyr.id, null);
            if (!this.stopped) {
                this.startServiceThread();
            }
        }
    }

    public void executeRequest(int message) {
        if (!this.stopped) {
            this.request.setQuery(33, null, String.valueOf(message));
            this.startServiceThread();
        }
    }

    public void searchAttribute(String layerId, String sQuery, int searchType) {
        if ((searchType == 1 || searchType == 2 || searchType == 3 || searchType == 4) && sQuery != null && sQuery.length() > 0 && this.isProjectLoaded()) {
            if (layerId == null) {
                layerId = this.activeLayer.id;
            }
            Layer lyr = this.project.getLayerById(layerId);
            if (searchType == 2 && sQuery != null && !lyr.isGeocoding) {
                sQuery = '%' + sQuery + '%';
            }
            int requestId = searchType == 3 ? 34 : (searchType == 4 ? 35 : 32);
            this.request.clear();
            this.request.setQuery(requestId, layerId, sQuery);
            if (!this.stopped) {
                this.startServiceThread();
            }
        }
    }

    public void searchRectangle(FloatRectangle ext) {
        if (this.activeLayer != null) {
            this.request.clear();
            this.request.setSpatialExtent(ext, null);
            this.request.setQuery(31, this.activeLayer.id, null);
            if (!this.stopped) {
                this.startServiceThread();
            }
        }
    }

    public CarteHost getCarteHost() {
        return this.host;
    }

    public void showURL(String sURL) {
        if (sURL != null && sURL.length() > 0) {
            this.host.showURL(sURL, "");
        }
    }

    public FloatRectangle getExtent() {
        if (this.projection == null) {
            return null;
        }
        FloatRectangle ext = new FloatRectangle();
        FloatPoint pt = this.screenToMap(new Point(0, 0));
        if (pt == null) {
            return null;
        }
        ext.x = pt.x;
        ext.y2 = pt.y;
        Dimension d = this.getSize();
        pt = this.screenToMap(new Point(d.width - 1, d.height - 1));
        ext.x2 = pt.x;
        ext.y = pt.y;
        return ext;
    }

    public void requestSelection(FloatRectangle selRect) {
        this.pmSelection.removeAll();
        String lyrId = null;
        int layerCount = this.project.getLayerCount();
        int selectionSize = 0;
        for (int i = 0; i < layerCount; ++i) {
            Layer lyr = this.project.getLayerByIndex(i);
            RecordsArray selection = lyr.getSelection();
            int n = selectionSize = selection == null || lyr instanceof LayerRaster && lyr.linkMain == null ? 0 : selection.size();
            if (selectionSize <= 0) continue;
            MenuItem mi = new MenuItem(lyr.getName() + " [" + selectionSize + ']', null);
            mi.setActionCommand(lyr.id);
            this.pmSelection.add(mi);
            lyrId = lyr.id;
        }
        if (this.pmSelection.getItemCount() > 1) {
            Point pos = null != selRect ? this.mapToScreen(new FloatPoint(selRect.x2, selRect.y)) : new Point(this.getBounds().width / 2, this.getBounds().height / 2);
            this.pmSelection.show(this, pos.x, pos.y);
        } else if (this.pmSelection.getItemCount() == 1) {
            this.showAttribForSelection(lyrId, this.defaultAttributeReqType, selRect);
        }
    }

    void mouseMoved(MouseEvent e) {
        if (this.isKilled) {
            return;
        }
        int count = this.mapListeners.size();
        for (int i = 0; i < count; ++i) {
            ((CarteListener)this.mapListeners.elementAt(i)).mouseMapMoved(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void mouseDragged(MouseEvent e) {
        if (this.loadedExtent == null || this.projection == null) {
            return;
        }
        Graphics g = this.getGraphics();
        if (g == null) return;
        try {
            switch (this.currentTool) {
                case 4: {
                    if (this.mouseDownPoint == null) return;
                    Point pt = e.getPoint();
                    int dx = pt.x - this.mouseDownPoint.x;
                    int dy = pt.y - this.mouseDownPoint.y;
                    Dimension d = this.getSize();
                    int w = d.width;
                    int h = d.height;
                    g.setColor(this.getBackground());
                    if (dx > 0) {
                        g.fillRect(0, 0, dx, h);
                    } else if (dx < 0) {
                        g.fillRect(w + dx, 0, -dx, h);
                    }
                    if (dy > 0) {
                        g.fillRect(0, 0, w, dy);
                    } else if (dy < 0) {
                        g.fillRect(0, h + dy, w, -dy);
                    }
                    g.drawImage(this.backImage, dx, dy, null);
                    return;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    if (this.mouseDownPoint == null) return;
                    g.setColor(Color.black);
                    g.setXORMode(Color.white);
                    this.drawSelectRect(g);
                    this.currentPoint = e.getPoint();
                    this.drawSelectRect(g);
                    g.setXORMode(Color.black);
                    return;
                }
                default: {
                    int count = this.mapListeners.size();
                    for (int i = 0; i < count; ++i) {
                        ((CarteListener)this.mapListeners.elementAt(i)).mouseMapMoved(e);
                    }
                    return;
                }
            }
        }
        finally {
            g.dispose();
            g = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mousePressed(MouseEvent e) {
        this.lastSelectExt = null;
        if (this.projection == null || this.isKilled) {
            return;
        }
        if (this.loadedExtent == null) {
            this.dontRedraw = false;
            return;
        }
        if (this.getTool() < 50) {
            int m = e.getModifiers();
            this.alterTool = this.getTool();
            if ((m & 4) != 0 || (m & 8) != 0) {
                if ((m & 1) != 0) {
                    this.setTool((byte)3);
                } else {
                    this.setTool((byte)4);
                }
            } else if ((m & 0x10) != 0) {
                if ((m & 1) != 0) {
                    this.setTool((byte)2);
                } else if ((m & 2) != 0) {
                    this.setTool((byte)6);
                }
            }
        }
        int count = this.mapListeners.size();
        for (int i = 0; i < count; ++i) {
            ((CarteListener)this.mapListeners.elementAt(i)).mouseMapPressed(e);
        }
        this.mouseDownPoint = e.getPoint();
        this.currentPoint = new Point(this.mouseDownPoint);
        switch (this.currentTool) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.lastPointSelection = null;
                this.lastRectSelection = null;
            }
            case 2: {
                this.dontRedraw = true;
                Graphics g = this.getGraphics();
                if (g == null) break;
                try {
                    g.setXORMode(Color.white);
                    this.drawSelectRect(g);
                    g.setXORMode(Color.black);
                    break;
                }
                finally {
                    g.dispose();
                }
            }
            case 4: {
                if (this.backImage == null) {
                    Dimension d = this.getSize();
                    this.backImage = this.createImage(d.width, d.height);
                    Graphics g = this.backImage.getGraphics();
                    try {
                        this.paint(g);
                    }
                    finally {
                        g.dispose();
                    }
                }
                this.dontRedraw = true;
                break;
            }
            case 1: {
                FloatPoint mapPt = this.screenToMap(e.getPoint());
                this.setExtent(null, mapPt);
                this.updateMap();
                break;
            }
            case 3: {
                FloatPoint mapPt = this.screenToMap(e.getPoint());
                this.setExtent(this.getExtent().scale(2.0), mapPt);
                this.updateMap();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mouseReleased(MouseEvent e) {
        if (this.projection == null || this.isKilled) {
            return;
        }
        FloatRectangle selRect = null;
        this.dontRedraw = false;
        if (this.loadedExtent != null && this.mouseDownPoint != null) {
            double y2;
            double y1;
            double x2;
            double x1;
            boolean small;
            selRect = new FloatRectangle();
            this.currentPoint = e.getPoint();
            if (this.currentTool == 9 || Math.abs(this.mouseDownPoint.x - this.currentPoint.x) < 6 && Math.abs(this.mouseDownPoint.y - this.currentPoint.y) < 6) {
                small = true;
                this.currentPoint = new Point(this.currentPoint.x + 3, this.currentPoint.y + 3);
                this.mouseDownPoint = new Point(this.currentPoint.x - 3, this.currentPoint.y - 3);
            } else {
                small = false;
            }
            FloatPoint pt1 = this.screenToMap(this.mouseDownPoint);
            FloatPoint pt2 = this.screenToMap(this.currentPoint);
            if (pt1.x < pt2.x) {
                x1 = pt1.x;
                x2 = pt2.x;
            } else {
                x1 = pt2.x;
                x2 = pt1.x;
            }
            if (pt1.y < pt2.y) {
                y1 = pt1.y;
                y2 = pt2.y;
            } else {
                y1 = pt2.y;
                y2 = pt1.y;
            }
            selRect.x = x1;
            selRect.y = y1;
            selRect.x2 = x2;
            selRect.y2 = y2;
            if (this.currentTool == 4) {
                Point pt = e.getPoint();
                int dx = pt.x - this.mouseDownPoint.x;
                int dy = pt.y - this.mouseDownPoint.y;
                if (dx != 0 || dy != 0) {
                    FloatPoint mapPt = this.screenToMap(new Point(-dx, -dy));
                    mapPt.x = -mapPt.x;
                    mapPt.y = -mapPt.y;
                    this.setExtent(null, null, mapPt);
                    this.storeExtent();
                    this.updateMap();
                }
            } else if (this.currentTool != 3 && this.currentTool != 1 && this.currentTool < 50) {
                Graphics g = this.getGraphics();
                if (g != null) {
                    try {
                        g.setColor(Color.black);
                        g.setXORMode(Color.white);
                        this.drawSelectRect(g);
                        g.setXORMode(Color.black);
                    }
                    finally {
                        g.dispose();
                    }
                }
                switch (this.currentTool) {
                    case 8: 
                    case 9: {
                        if (small || this.currentTool == 9) {
                            this.lastPointSelection = this.screenToMap(e.getPoint());
                            this.lastRectSelection = null;
                            break;
                        }
                        this.lastRectSelection = selRect;
                        this.lastPointSelection = null;
                        this.updateMap();
                        break;
                    }
                    case 2: {
                        if (!small) {
                            this.setExtent(selRect, null);
                        } else {
                            FloatPoint mapPt = this.screenToMap(this.mouseDownPoint);
                            this.setExtent(this.getExtent().scale(0.5), mapPt);
                        }
                        this.updateMap();
                        break;
                    }
                    case 7: {
                        this.searchRectangle(selRect);
                        break;
                    }
                    case 5: 
                    case 6: {
                        selRect = selRect.intersection(this.getExtent());
                        int m = e.getModifiers();
                        if ((m & 2) == 0) {
                            this.clearSelection();
                        }
                        Layer selLayer = null;
                        int selectionSize = 0;
                        int selectionSizeActive = 0;
                        int iLayerSelected = 0;
                        String selLayerID = null;
                        int count = this.project.getLayerCount();
                        this.lastSelectExt = selRect;
                        for (int i = 0; i < count; ++i) {
                            selLayer = this.project.getLayerByIndex(i);
                            if (!selLayer.isVisibleNow(this) || !selLayer.canSearch || !selLayer.canSelectByMouse) continue;
                            RecordsArray v2 = selLayer.findWithinRect(selRect, false);
                            selLayer.setSelection(v2);
                            if (!MapUtils.isNotEmptyRecs(v2)) continue;
                            selectionSize = v2.size();
                            ++iLayerSelected;
                            selLayerID = selLayer.id;
                            if (this.activeLayer != selLayer) continue;
                            selectionSizeActive = selectionSize;
                        }
                        int code = 14;
                        String sName = "";
                        if (selectionSizeActive > 0) {
                            sName = " [" + this.activeLayer.getName() + ']';
                            if (selectionSizeActive == 1) {
                                Record recSel = this.activeLayer.getSelection().getRecord(0);
                                sName = sName + this.activeLayer.getFieldString(recSel, this.activeLayer.fi_description);
                                code = 103;
                            } else {
                                code = 104;
                                sName = selectionSizeActive + sName;
                            }
                        }
                        this.broadcastMessage(code, sName);
                        this.updateMap();
                        if (this.currentTool == 5 && this.isShowAttributeAfterSelection) {
                            this.showAttribForSelection(null, 30, selRect);
                            break;
                        }
                        if (this.currentTool != 6) break;
                        if (this.isMultiLayerSelectionMode && iLayerSelected == 1) {
                            this.showAttribForSelection(selLayerID, this.defaultAttributeReqType, selRect);
                            break;
                        }
                        if (!this.isMultiLayerSelectionMode && selectionSizeActive > 0) {
                            this.showAttribForSelection(this.activeLayer.id, this.defaultAttributeReqType, selRect);
                            break;
                        }
                        if (!this.isMultiLayerSelectionMode) break;
                        this.requestSelection(selRect);
                    }
                }
            }
        }
        if (this.currentTool < 50) {
            this.setTool(this.alterTool);
        }
        if (this.isKeyMap && selRect != null && this.mainMap != null) {
            Point topleft = this.mapToScreen(new FloatPoint(selRect.x, selRect.y2));
            Point botright = this.mapToScreen(new FloatPoint(selRect.x2, selRect.y));
            if (topleft != null && botright != null) {
                if (botright.y - topleft.y < 6 || botright.x - topleft.x < 6) {
                    FloatPoint mapPt = new FloatPoint(selRect.x, selRect.y2);
                    this.mainMap.setExtent(this.mainMap.getExtent(), mapPt);
                } else {
                    this.mainMap.setExtent(selRect, null);
                }
                this.mainMap.updateMap();
            }
        }
        int count = this.mapListeners.size();
        for (int i = 0; i < count; ++i) {
            ((CarteListener)this.mapListeners.elementAt(i)).mouseMapReleased(selRect, e);
        }
        this.mouseDownPoint = null;
        this.currentPoint = null;
    }

    public String getResource(String key) {
        String s = this.getResource_(key);
        return Strings.isNullOrBlank(s) ? key : s;
    }

    public String getResource_(String key) {
        if (this.stringResources == null || key == null) {
            return "";
        }
        String s = this.stringResources.getProperty(key.toLowerCase());
        return s == null ? "" : s;
    }

    void componentResized(ComponentEvent e) {
        if (this.projection == null) {
            return;
        }
        if (this.lastExtent != null) {
            this.setExtent(this.lastExtent, null);
        } else {
            this.extentChanged();
        }
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return (infoflags & 0x20) == 0;
    }

    public String getThematicMapName() {
        if (this.project != null) {
            Enumeration e2 = this.project.themes.keys();
            Enumeration e = this.project.themes.elements();
            while (e.hasMoreElements()) {
                String s = (String)e2.nextElement();
                if (!((String)e.nextElement()).equals(this.thematicMap)) continue;
                return s;
            }
        }
        return "";
    }

    public Graphics getDrawToGraphics() {
        return this.drawTo;
    }

    public String getThematicMap() {
        return this.thematicMap;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setProjection(Projection p) {
        this.projection = p;
    }

    public FloatRectangle getLastExtent() {
        return this.lastExtent;
    }

    public Vector getUsedSpaces() {
        return this.usedSpaces;
    }

    public double getDistance(FloatRectangle ext) {
        if (ext == null) {
            ext = this.getExtent();
        }
        return MapUtils.getDistance(ext, this.project.MapUnits, this.project.ZoomUnits);
    }

    public Component getComponent() {
        return this;
    }

    public String getRealPath(String url) {
        return MapUtils.getRealPath(url);
    }

    public void broadcastMessage(int code, Object message) {
        if (this.isKilled) {
            return;
        }
        int count = this.statusListeners.size();
        for (int i = 0; i < count; ++i) {
            ((StatusListener)this.statusListeners.elementAt(i)).notifyStatus(code, message);
        }
    }

    public TimeInterval getTimeInterval() {
        return this.timeInterval;
    }

    public boolean isStopPaint(int step) {
        return this.isKilled || this.pntCounter > step;
    }

    public String getParameter(String key, String def) {
        String val = this.parameters.getProperty(key, null);
        if (val == null) {
            val = this.host.getParameter(key, null);
            if (val != null) {
                ((Hashtable)this.parameters).put(key, val);
                return val;
            }
            return def;
        }
        return val;
    }

    public String getSRS() {
        return this.project.geoProjection;
    }

    public void actionPerformed(ActionEvent e) {
        String sLayerId = e.getActionCommand();
        if (!Strings.isNullOrBlank(sLayerId)) {
            this.showAttribForSelection(sLayerId, this.defaultAttributeReqType, this.lastSelectExt);
        }
    }

    public void setParameters(CarteHost host, XmlElement layout) {
        Vector v = layout.getElementsByTagName("param");
        for (int i = 0; i < v.size(); ++i) {
            String val;
            XmlElement elParam = (XmlElement)v.elementAt(i);
            String nme = elParam.getAttributeValue("name");
            if (Strings.isNullOrBlank(nme) || Strings.isNullOrBlank(val = host.getParameter(nme, elParam.getAttributeValue("value")))) continue;
            ((Hashtable)this.parameters).put(nme, val);
        }
        this.host = host;
        this.SLD_url = this.getParameter("sld", null);
        if (!Strings.isNullOrBlank(this.SLD_url) && MapUtils.isSLD_Enabled()) {
            this.SLD_styles = SLD_Loader.getStylesTable(this.getParameter("sld_layers", null), this.getParameter("sld_styles", null));
        } else {
            this.SLD_url = null;
        }
        this.isKeyMap = XmlUtils.getBoolean("keymap", layout, false) || "keymap".equalsIgnoreCase(XmlUtils.getString("type", layout, null));
        this.isMultiLayerSelectionMode = XmlUtils.getBoolean("multiselect", layout, true);
        this.isShowAttributeAfterSelection = XmlUtils.getBoolean("showinfo", layout, false);
        this.defaultAttributeReqType = this.isShowAttributeAfterSelection ? 30 : 31;
        this.sDependent_Maps = XmlUtils.getString("dependent", layout, null);
        if (!this.isKeyMap) {
            if (MapUtils.isApplication) {
                this.logExtent = this.getParameter("logext", "no").equalsIgnoreCase("yes");
            }
            if (Utils2D.have2d()) {
                Vector nodes = layout.getElementsByTagName("cursor");
                int count = nodes.size();
                for (int i = 0; i < count; ++i) {
                    XmlElement el = (XmlElement)nodes.elementAt(i);
                    String toolId = XmlUtils.getString("tool", el, null);
                    if (toolId == null) continue;
                    String sFile = XmlUtils.getString("image", el, null);
                    Image img = null;
                    try {
                        img = MapUtils.loadImage2(null, sFile);
                        Cursor cr = Utils2D.createCursor(img, toolId);
                        if (cr == null) continue;
                        if (this.customCursors == null) {
                            this.customCursors = new Hashtable();
                        }
                        this.customCursors.put(toolId, cr);
                        continue;
                    }
                    catch (Exception e) {
                        Log.addMessage(306, this.getName(), null, "Can't load raster image " + sFile);
                    }
                }
            }
            this.proxy.setupProxy(this);
            MapUtils.isTipsActive = XmlUtils.getBoolean("tips", layout, false);
            byte startTool = 6;
            String sTool = XmlUtils.getString("starttool", layout, "");
            try {
                startTool = Byte.parseByte(sTool);
            }
            catch (Exception e) {
                startTool = Carte.getToolCode(sTool);
            }
            if (startTool == 0) {
                startTool = 6;
            }
            this.setTool(startTool);
        } else {
            this.setVisible(false);
            this.mainMap = host.getMapByName(layout);
            this.mainMap.statusListeners.addElement(this);
        }
    }

    public void stop() {
        if (this.animationTimer != null) {
            this.animationTimer.stop();
        }
        this.stopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openProject(String projectURL) {
        if (this.isKilled) {
            return;
        }
        this.isKilled = true;
        try {
            try {
                while (this.sthRunning) {
                    Thread.sleep(300L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.project != null) {
                this.project.kill();
                this.project = null;
                System.gc();
            }
            this.isFirstRequest = true;
            this.projection = null;
            this.lastExtent = null;
            this.loadedExtent = null;
            ((Hashtable)this.parameters).put("pid", projectURL);
            this.proxy.setupProxy(this);
        }
        finally {
            this.isKilled = false;
        }
        this.start();
    }

    public void kill() {
        this.isKilled = true;
        try {
            while (this.sthRunning) {
                Thread.sleep(300L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.project != null) {
            this.project.kill();
            this.project = null;
        }
        Log.kill();
        this.mapListeners = null;
        this.statusListeners = null;
        if (this.stringResources != null) {
            ((Hashtable)this.stringResources).clear();
        }
        this.stringResources = null;
        this.proxy = null;
    }

    public void afterProjectLoaded(boolean bSuccess) {
        if (this.mainMap != null && this.mainMap.isProjectLoaded() && this.mainMap.getProject().hasKeyMap) {
            this.setVisible(true);
            this.setProject(this.mainMap.getProject());
            this.setBackground(this.project.keyMapBackground);
            this.moveBeyondProject = false;
            this.projection = new Projection();
            if (this.project.keyMapTheme != null) {
                this.thematicMap = this.project.keyMapTheme;
            } else {
                this.setThematicMap(this.project.startTheme);
            }
            this.stopped = false;
            this.setTool((byte)8);
        } else {
            this.setVisible(false);
        }
    }

    public void notifyStatus(int code, Object obj) {
        if (!this.isKilled && this.isProjectLoaded() && code == 11 && obj == null) {
            this.loadedExtent = new FloatRectangle(this.project.maxExtent);
            this.zoomToFullExtent();
            this.updateMap();
        }
    }

    public void timerTick() {
        this.updateMap(true);
    }

    public void setLoadedExtent(FloatRectangle rect) {
        this.lastExtent = null;
        this.loadedExtent = rect;
        this.projection = new Projection();
    }
}

