/*
 * Decompiled with CFR 0.152.
 */
package org.alov.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.alov.data.Dbf;
import org.alov.util.Strings;

class MifHeader {
    private static final String COLUMNS = "COLUMNS ";
    private static final String DATA = "DATA";
    private static final String CHAR = "CHAR(";
    private static final String SMALLINT = "SMALLINT";
    private static final String INTEGER = "INTEGER";
    private static final String FLOAT = "FLOAT";
    private static final String DECIMAL = "DECIMAL(";
    private static final String DATE = "DATE";
    private static final String LOGICAL = "LOGICAL";
    InputStream source;
    InputStream istreamMid = null;
    int fieldCountMid = -1;
    char[] fieldsType;
    String[] fieldNames;
    int[] fieldLens;
    int[] fieldNumDec;
    Dbf dbf = null;
    BufferedReader reader;
    BufferedReader readerMid = null;
    int type = -1;
    int objectNumber = 0;
    int fi_id = -1;

    MifHeader(InputStream source, InputStream istreamMid, Dbf dbf, int fi_id) {
        this.source = source;
        this.istreamMid = istreamMid;
        this.dbf = dbf;
        this.fi_id = fi_id;
        InputStreamReader isReader = new InputStreamReader(source);
        this.reader = new BufferedReader(isReader, 2048);
        if (istreamMid != null) {
            isReader = new InputStreamReader(istreamMid);
            this.readerMid = new BufferedReader(isReader, 2048);
            try {
                this.setFieldCountMid();
                this.setFieldTypesMid();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void setFieldCountMid() throws IOException {
        String lineStr;
        while (this.fieldCountMid < 0 && (lineStr = this.reader.readLine()) != null) {
            StringBuffer line = new StringBuffer(lineStr.toUpperCase());
            Strings.deleteSpaces(line);
            lineStr = line.toString();
            if (!lineStr.startsWith(COLUMNS)) continue;
            try {
                this.fieldCountMid = Integer.parseInt(lineStr.substring(COLUMNS.length()).trim());
            }
            catch (Exception e) {
                this.fieldCountMid = 0;
            }
        }
    }

    private void setFieldTypesMid() throws IOException {
        String lineStr;
        this.fieldsType = new char[this.fieldCountMid];
        this.fieldNames = new String[this.fieldCountMid];
        this.fieldLens = new int[this.fieldCountMid];
        this.fieldNumDec = new int[this.fieldCountMid];
        int i = 0;
        while ((lineStr = this.reader.readLine()) != null) {
            StringBuffer line = new StringBuffer(lineStr.toUpperCase());
            Strings.deleteSpaces(line);
            lineStr = line.toString();
            if (lineStr.startsWith(DATA)) break;
            boolean b = false;
            int ispace = lineStr.indexOf(32);
            String stype = lineStr.substring(ispace + 1).trim();
            this.fieldNames[i] = lineStr.substring(0, ispace).trim();
            this.fieldsType[i] = 67;
            int ibracket = stype.indexOf(40);
            if (ibracket != -1) {
                String slen = stype.substring(ibracket + 1, stype.length() - 1).trim();
                stype = stype.substring(0, ibracket).trim();
                int icomma = slen.indexOf(44);
                if (icomma != -1) {
                    this.fieldLens[i] = Strings.strToInt(slen.substring(0, icomma).trim(), -1);
                    this.fieldNumDec[i] = Strings.strToInt(slen.substring(icomma + 1, slen.length()).trim(), -1);
                } else {
                    this.fieldLens[i] = Strings.strToInt(slen, -1);
                    this.fieldNumDec[i] = -1;
                }
            }
            if (stype.indexOf(INTEGER) > 0 || stype.indexOf(SMALLINT) > 0) {
                this.fieldsType[i] = 73;
            } else if (stype.indexOf(FLOAT) > 0 || stype.indexOf(DECIMAL) > 0) {
                this.fieldsType[i] = 68;
            }
            ++i;
        }
    }
}

