/*
 * Decompiled with CFR 0.152.
 */
package org.alov.data;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.alov.data.Csv;
import org.alov.data.DataProvider;
import org.alov.data.Dbf;
import org.alov.data.Gml;
import org.alov.data.Mif;
import org.alov.data.SQLConst;
import org.alov.data.Shp;
import org.alov.map.FieldDef;
import org.alov.map.Layer;
import org.alov.map.LayerVector;
import org.alov.map.LayerZoomify;
import org.alov.map.MapUtils;
import org.alov.map.Meta;
import org.alov.map.Record;
import org.alov.map.Shape;
import org.alov.map.StreamCounter;
import org.alov.util.AlovMapException;
import org.alov.util.Strings;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

public class DataProviderFile
extends DataProvider {
    transient Dbf dbf = null;
    public boolean fixHoles = true;

    public DataProviderFile(Layer lyr) {
        super(lyr);
    }

    private static void readZip(byte[] bytes, ZipInputStream zip) throws IOException {
        int read;
        int pos = 0;
        for (int toRead = bytes.length; toRead > 0; toRead -= read) {
            read = zip.read(bytes, pos, toRead);
            pos += read;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String loadComplete() throws AlovMapException {
        try {
            IOException e142;
            BufferedInputStream dBaseBufIs;
            ByteArrayInputStream dBaseIs2;
            block102: {
                if (this.layer.connectionData == null) throw new AlovMapException(105, this.layer.getName());
                String baseUrl = this.layer.connectionData.getProperty("url");
                if (baseUrl == null) {
                    throw new AlovMapException(105, this.layer.getName());
                }
                String xmlUrl = null;
                if (this.layer.metadata.isNotLoaded) {
                    try {
                        xmlUrl = Strings.changeSuffix(baseUrl, ".tmm");
                        StreamCounter sc = this.openURL(xmlUrl);
                        xmlUrl = sc.url;
                        this.layer.metadata.loadMetadata(sc);
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                if (!this.layer.metadata.isNotLoaded) {
                    String s = this.layer.metadata.getVal(43);
                    if (this.layer instanceof LayerZoomify && s == null) {
                        s = this.layer.metadata.getVal(123);
                    }
                    if (s != null && xmlUrl != null) {
                        baseUrl = Strings.getAbsPath(Strings.extractDir(xmlUrl), s);
                    }
                    if (this.layer instanceof LayerZoomify && s == null && xmlUrl != null) {
                        baseUrl = Strings.getAbsPath(Strings.extractDir(xmlUrl), "ImageProperties.xml");
                    }
                }
                if (!Strings.checkSuffix(baseUrl, ".zip")) {
                    String sType = this.layer.metadata.getStr(34);
                    if (sType.equalsIgnoreCase("shapefile")) {
                        baseUrl = Strings.changeSuffix(baseUrl, ".shp");
                    } else if (sType.equalsIgnoreCase("mifmid")) {
                        baseUrl = Strings.changeSuffix(baseUrl, ".mif");
                    } else if (sType.equalsIgnoreCase("dbase")) {
                        baseUrl = Strings.changeSuffix(baseUrl, ".dbf");
                    } else if (sType.equalsIgnoreCase("csv")) {
                        baseUrl = Strings.changeSuffix(baseUrl, ".csv");
                    } else if (sType.equalsIgnoreCase("txt")) {
                        baseUrl = Strings.changeSuffix(baseUrl, ".txt");
                    } else if (sType.equalsIgnoreCase("gml")) {
                        baseUrl = Strings.changeSuffix(baseUrl, ".gml");
                    }
                }
                if (Strings.checkSuffix(baseUrl, ".tmm") || Strings.checkSuffix(baseUrl, "")) {
                    baseUrl = Strings.changeSuffix(baseUrl, ".shp");
                }
                if (this.layer instanceof LayerZoomify && !Strings.checkSuffix(baseUrl, ".dbf")) {
                    if (!baseUrl.endsWith("ImageProperties.xml")) throw new AlovMapException(314, "Can't load Zoomify file " + baseUrl);
                    this.loadZoomify(baseUrl);
                    return "";
                }
                StreamCounter input = null;
                byte[] xmlBytes = null;
                byte[] dbfBytes = null;
                byte[] midBytes = null;
                byte[] shpBytes = null;
                byte[] mifBytes = null;
                byte[] csvBytes = null;
                Object bytes = null;
                StreamCounter is = null;
                InputStream dBaseIs = null;
                dBaseIs2 = null;
                dBaseBufIs = null;
                try {
                    ByteArrayInputStream bis;
                    ZipInputStream zip;
                    try {
                        boolean isLocalFile = baseUrl.startsWith("file:/");
                        input = this.openURL(baseUrl);
                    }
                    catch (Exception e3) {
                        throw new AlovMapException(308, "Can't load file " + baseUrl);
                    }
                    if (input != null) {
                        try {
                            Meta meta = this.layer.metadata;
                            String encoding = null;
                            if (Strings.checkSuffix(baseUrl, ".zip")) {
                                ZipEntry entry;
                                zip = new ZipInputStream(input);
                                do {
                                    entry = zip.getNextEntry();
                                    byte[] data = null;
                                    if (entry == null) continue;
                                    String name = entry.getName();
                                    int size = (int)entry.getSize();
                                    if (dbfBytes == null && Strings.checkSuffix(name, ".dbf")) {
                                        data = dbfBytes = new byte[size];
                                    } else if (midBytes == null && Strings.checkSuffix(name, ".mid")) {
                                        midBytes = new byte[size];
                                        data = midBytes;
                                    } else if (xmlBytes == null && (Strings.checkSuffix(name, ".xml") || Strings.checkSuffix(name, ".tmm"))) {
                                        xmlBytes = new byte[size];
                                        data = xmlBytes;
                                    } else if (shpBytes == null && mifBytes == null) {
                                        if (Strings.checkSuffix(name, ".shp")) {
                                            shpBytes = new byte[size];
                                            data = shpBytes;
                                        } else if (Strings.checkSuffix(name, ".mif")) {
                                            mifBytes = new byte[size];
                                            data = mifBytes;
                                        } else if (Strings.checkSuffix(name, ".csv") || Strings.checkSuffix(name, ".txt")) {
                                            csvBytes = new byte[size];
                                            data = csvBytes;
                                        }
                                    }
                                    if (data != null) {
                                        DataProviderFile.readZip(data, zip);
                                    }
                                    if (((shpBytes != null || mifBytes != null) && dbfBytes != null || mifBytes != null && midBytes != null) && xmlBytes != null) break;
                                } while (entry != null);
                                zip.close();
                                if (xmlBytes != null && meta.isNotLoaded) {
                                    bis = new ByteArrayInputStream(xmlBytes);
                                    try {
                                        meta.loadMetadata(bis);
                                    }
                                    catch (AlovMapException e4) {
                                        throw new AlovMapException(e4.getCode(), e4.getMessage());
                                    }
                                    catch (Exception e5) {
                                        // empty catch block
                                    }
                                    bis.close();
                                }
                                ((LayerVector)this.layer).resolveMetadata();
                                encoding = meta.getStr(305);
                                if (dbfBytes != null) {
                                    bis = new ByteArrayInputStream(dbfBytes);
                                    this.dbf = new Dbf(bis, encoding);
                                    bis.close();
                                    this.resolveFields();
                                }
                                if (shpBytes != null) {
                                    bis = new ByteArrayInputStream(shpBytes);
                                    Shp.loadFromStream(bis, this.dbf, (LayerVector)this.layer, this.fixHoles);
                                    bis.close();
                                } else if (mifBytes != null) {
                                    if (!MapUtils.isMIF_Enabled()) throw new AlovMapException(111, "MIF loader is not found.");
                                    bis = new ByteArrayInputStream(mifBytes);
                                    if (this.dbf != null) {
                                        Mif.loadFromStream(bis, null, this.dbf, (LayerVector)this.layer);
                                    } else if (midBytes != null) {
                                        ByteArrayInputStream bisMid = new ByteArrayInputStream(midBytes);
                                        Mif.loadFromStream(bis, bisMid, null, (LayerVector)this.layer);
                                        bisMid.close();
                                        bisMid = null;
                                    }
                                    bis.close();
                                } else if (this.dbf != null) {
                                    this.dbf.loadToLayer((LayerVector)this.layer);
                                } else if (csvBytes != null) {
                                    bis = new ByteArrayInputStream(csvBytes);
                                    Csv.loadFromStream(bis, (LayerVector)this.layer, encoding);
                                    bis.close();
                                }
                            } else {
                                if (this.layer.metadata.isNotLoaded) {
                                    xmlUrl = Strings.changeSuffix(baseUrl, ".xml");
                                    try {
                                        meta.loadMetadata(this.openURL(xmlUrl));
                                    }
                                    catch (AlovMapException e6) {
                                        throw new AlovMapException(e6.getCode(), e6.getMessage());
                                    }
                                    catch (Exception e7) {
                                        // empty catch block
                                    }
                                }
                                ((LayerVector)this.layer).resolveMetadata();
                                encoding = meta.getStr(305);
                                if (Strings.checkSuffix(baseUrl, ".gml")) {
                                    try {
                                        Class<?> gml = Class.forName("org.alov.data.Gml");
                                        is = this.openURL(baseUrl);
                                        Gml.loadToLayer(input, (LayerVector)this.layer);
                                        this.resolveGmlFields();
                                    }
                                    catch (ClassNotFoundException e8) {
                                        throw new AlovMapException(111, "GML loader is not found.");
                                    }
                                    catch (Exception e9) {
                                        throw new AlovMapException(310, Gml.err_message);
                                    }
                                }
                                if (Strings.checkSuffix(baseUrl, ".csv") || Strings.checkSuffix(baseUrl, ".txt")) {
                                    is = this.openURL(baseUrl);
                                    Csv.loadFromStream(is, (LayerVector)this.layer, encoding);
                                } else {
                                    boolean isExistDbfFile;
                                    String dbfUrl;
                                    block101: {
                                        dbfUrl = Strings.changeSuffix(baseUrl, ".dbf");
                                        is = null;
                                        isExistDbfFile = true;
                                        try {
                                            dBaseIs = this.openURL(dbfUrl);
                                        }
                                        catch (Exception e10) {
                                            isExistDbfFile = false;
                                            if (!Strings.checkSuffix(baseUrl, ".shp")) break block101;
                                            throw new AlovMapException(308, "Can't load file " + dbfUrl);
                                        }
                                    }
                                    if (!isExistDbfFile && Strings.checkSuffix(baseUrl, ".mif")) {
                                        String midUrl = Strings.changeSuffix(baseUrl, ".mid");
                                        try {
                                            is = this.openURL(midUrl);
                                        }
                                        catch (Exception e11) {
                                            throw new AlovMapException(308, "Can't load file " + dbfUrl + " or " + midUrl);
                                        }
                                    }
                                    if (dBaseIs != null && isExistDbfFile) {
                                        this.dbf = new Dbf(dBaseIs, encoding, true);
                                        this.resolveFields();
                                    }
                                    if (Strings.checkSuffix(baseUrl, ".shp")) {
                                        Shp.loadFromStream(input, this.dbf, (LayerVector)this.layer, this.fixHoles);
                                    } else if (Strings.checkSuffix(baseUrl, ".mif")) {
                                        if (isExistDbfFile) {
                                            Mif.loadFromStream(input, null, this.dbf, (LayerVector)this.layer);
                                        } else if (is != null) {
                                            Mif.loadFromStream(input, is, null, (LayerVector)this.layer);
                                        }
                                    } else {
                                        if (!Strings.checkSuffix(baseUrl, ".dbf")) throw new AlovMapException(110, baseUrl);
                                        this.dbf.loadToLayer((LayerVector)this.layer);
                                    }
                                }
                            }
                            try {
                                ((InputStream)input).close();
                            }
                            catch (Exception e12) {}
                        }
                        catch (IOException e13) {
                            e13.printStackTrace();
                            throw new AlovMapException(309, "Can't load file " + baseUrl);
                        }
                    }
                    this.layer.setLoadComplete(true);
                    Object var26_43 = null;
                    input = null;
                    bis = null;
                    Object shp = null;
                    if (this.dbf != null) {
                        this.dbf.clear();
                    }
                    this.dbf = null;
                    xmlBytes = null;
                    dbfBytes = null;
                    midBytes = null;
                    shpBytes = null;
                    mifBytes = null;
                    csvBytes = null;
                    bytes = null;
                    zip = null;
                    is = null;
                    if (dBaseIs == null) break block102;
                }
                catch (Throwable throwable) {
                    IOException e142;
                    Object var26_44 = null;
                    input = null;
                    Object bis = null;
                    Object shp = null;
                    if (this.dbf != null) {
                        this.dbf.clear();
                    }
                    this.dbf = null;
                    xmlBytes = null;
                    dbfBytes = null;
                    midBytes = null;
                    shpBytes = null;
                    mifBytes = null;
                    csvBytes = null;
                    bytes = null;
                    Object zip = null;
                    is = null;
                    if (dBaseIs != null) {
                        try {
                            dBaseIs.close();
                        }
                        catch (IOException e142) {
                            // empty catch block
                        }
                        dBaseIs = null;
                    }
                    if (dBaseBufIs != null) {
                        try {
                            dBaseBufIs.close();
                        }
                        catch (IOException e142) {
                            // empty catch block
                        }
                        dBaseBufIs = null;
                    }
                    if (dBaseIs2 == null) throw throwable;
                    try {
                        dBaseIs2.close();
                    }
                    catch (IOException e142) {
                        // empty catch block
                    }
                    dBaseIs2 = null;
                    throw throwable;
                }
                try {
                    dBaseIs.close();
                }
                catch (IOException e142) {
                    // empty catch block
                }
                dBaseIs = null;
            }
            if (dBaseBufIs != null) {
                try {
                    dBaseBufIs.close();
                }
                catch (IOException e142) {
                    // empty catch block
                }
                dBaseBufIs = null;
            }
            if (dBaseIs2 == null) return "";
            try {
                dBaseIs2.close();
                return "";
            }
            catch (IOException e142) {
                // empty catch block
            }
            return "";
        }
        catch (Error err) {
            this.layer.clear(false);
            if (!(err instanceof OutOfMemoryError)) return "";
            throw new AlovMapException(313, "Not enough memory");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadZoomify(String zoomifyXml) throws AlovMapException {
        StreamCounter input = null;
        boolean xmlLoaded = false;
        int numImages = -1;
        int numTiles = -1;
        double largeW = -1.0;
        double largeH = -1.0;
        double tileSize = -1.0;
        String imgFormat = ".jpg";
        boolean isGrouped = true;
        double imageGeoX = 0.0;
        double imageGeoY = 0.0;
        double imageGeoX2 = 0.0;
        double imageGeoY2 = 0.0;
        double imageGeoW = 0.0;
        double imageGeoH = 0.0;
        try {
            String sUrl = zoomifyXml;
            input = this.openURL(sUrl);
            XmlElement root = XmlUtils.parseStream(input, null);
            ((InputStream)input).close();
            if (root != null) {
                numImages = Integer.parseInt(root.getAttributeValue("NUMIMAGES"));
                numTiles = Integer.parseInt(root.getAttributeValue("NUMTILES"));
                largeW = Integer.parseInt(root.getAttributeValue("WIDTH"));
                largeH = Integer.parseInt(root.getAttributeValue("HEIGHT"));
                tileSize = Integer.parseInt(root.getAttributeValue("TILESIZE"));
                imgFormat = root.getAttributeValue("FORMAT");
                isGrouped = !"no".equalsIgnoreCase(root.getAttributeValue("GROUPED"));
                xmlLoaded = true;
            }
        }
        catch (Exception e) {
            throw new AlovMapException(308, "Can't load file " + zoomifyXml);
        }
        if (!xmlLoaded) {
            return null;
        }
        if (Strings.isNullOrBlank(imgFormat)) {
            imgFormat = ".jpg";
        }
        try {
            imageGeoX = Double.valueOf(this.layer.metadata.getVal(142));
            imageGeoY = Double.valueOf(this.layer.metadata.getVal(143));
            imageGeoW = Double.valueOf(this.layer.metadata.getVal(144));
            imageGeoH = -Double.valueOf(this.layer.metadata.getVal(145)).doubleValue();
            imageGeoX -= imageGeoW / 2.0;
            imageGeoY += imageGeoH / 2.0;
            imageGeoX2 = imageGeoX + (imageGeoW *= largeW);
            imageGeoY2 = imageGeoY - (imageGeoH *= largeH);
        }
        catch (Exception e) {
            throw new AlovMapException(301, "Missed or wrong image registration parameters");
        }
        if (imageGeoW == 0.0) {
            throw new AlovMapException(301, "X pixel size is zero");
        }
        if (imageGeoW == 0.0) {
            throw new AlovMapException(301, "Y pixel size is zero");
        }
        double levelTileSize = tileSize;
        int imageInDirCount = 0;
        int iDirCount = 0;
        int levelCount = 1;
        while (levelTileSize < largeW || levelTileSize < largeH) {
            levelTileSize *= 2.0;
            ++levelCount;
        }
        String tileGroupPath = Strings.extractDir(zoomifyXml) + (isGrouped ? "TileGroup" : "");
        FieldDef fieldLevel = new FieldDef();
        fieldLevel.index = 0;
        fieldLevel.name = "level";
        fieldLevel.type = 4;
        FieldDef fieldImage = new FieldDef();
        fieldImage.index = 1;
        fieldImage.name = "image";
        fieldImage.type = 12;
        this.layer.dataStorage.initFields(2);
        this.layer.dataStorage.assignFields(new FieldDef[]{fieldLevel, fieldImage});
        this.layer.dataStorage.setObjectType(3);
        int recordCount = 0;
        int realLevelCount = 0;
        this.layer.dataStorage.openDataStorageSave(true);
        try {
            for (int levelIndex = 0; levelIndex < levelCount; ++levelIndex) {
                int tilesCX = (int)(Math.ceil(largeW / levelTileSize) + 0.01);
                int tilesCY = (int)(Math.ceil(largeH / levelTileSize) + 0.01);
                double tileGeoW = imageGeoW * (levelTileSize / largeW);
                double tileGeoH = imageGeoH * (levelTileSize / largeH);
                double tileGeoY = imageGeoY;
                int y = 0;
                while (y < tilesCY) {
                    double tileGeoRealH = tileGeoH;
                    if (tileGeoY - tileGeoRealH < imageGeoY2) {
                        tileGeoRealH = tileGeoY - imageGeoY2;
                    }
                    double tileGeoX = imageGeoX;
                    int x = 0;
                    while (x < tilesCX) {
                        double tileGeoRealW = tileGeoW;
                        if (tileGeoX + tileGeoRealW > imageGeoX2) {
                            tileGeoRealW = imageGeoX2 - tileGeoX;
                        }
                        Record rec = this.layer.newRecord(recordCount);
                        Shape shp = rec.newShape(4);
                        shp.xCoords = new double[]{tileGeoX, tileGeoX + tileGeoRealW, tileGeoX + tileGeoRealW, tileGeoX};
                        shp.yCoords = new double[]{tileGeoY, tileGeoY, tileGeoY - tileGeoRealH, tileGeoY - tileGeoRealH};
                        String fileName = tileGroupPath;
                        if (isGrouped) {
                            fileName = tileGroupPath + iDirCount;
                        }
                        fileName = fileName + "/" + levelIndex + "-" + x + "-" + y + imgFormat;
                        rec.setFieldValues(new Object[]{new Integer(levelIndex), fileName});
                        ++recordCount;
                        this.layer.addRecord(rec);
                        if (++imageInDirCount > 255 && isGrouped) {
                            imageInDirCount = 0;
                            ++iDirCount;
                        }
                        ++x;
                        tileGeoX += tileGeoW;
                    }
                    ++y;
                    tileGeoY -= tileGeoH;
                }
                ++realLevelCount;
                levelTileSize /= 2.0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.layer.dataStorage.closeDataStorageSave();
        }
        LayerZoomify lz = (LayerZoomify)this.layer;
        lz.setDimensions(imageGeoW, imageGeoH, largeW, largeH, tileSize, realLevelCount);
        this.layer.dataStorage.setObjectType(3);
        this.layer.setLoadComplete(true);
        this.layer.metadata.isNotLoaded = false;
        this.layer.metadata.loadFailed = false;
        this.layer.prepareLayer();
        this.layer.setLoadComplete(true);
        return null;
    }

    private void resolveGmlFields() {
        int i;
        if (Gml.f_names == null) {
            return;
        }
        int fieldCount = Gml.f_names.length;
        String fieldsVisible = this.layer.metadata.getVal(307, MapUtils.language);
        if (!Strings.isNullOrBlank(fieldsVisible)) {
            fieldsVisible = fieldsVisible + ',';
        }
        Vector<FieldDef> fields = new Vector<FieldDef>();
        for (i = 0; i < fieldCount; ++i) {
            if (Strings.isNullOrBlank(Gml.f_names[i])) continue;
            FieldDef fieldDef = new FieldDef();
            fieldDef.type = 12;
            fieldDef.index = fields.size();
            fieldDef.name = Gml.f_names[i];
            fieldDef.label = this.layer.metadata.getFieldAlias(fieldDef.name, MapUtils.language);
            fieldDef.visible = Strings.isNullOrBlank(fieldsVisible) || fieldsVisible.indexOf(',' + fieldDef.name.toUpperCase() + ',') >= 0;
            fields.addElement(fieldDef);
        }
        fieldCount = fields.size();
        this.layer.dataStorage.initFields(fieldCount);
        for (i = 0; i < fieldCount; ++i) {
            this.layer.setFieldDef(i, (FieldDef)fields.elementAt(i));
        }
        LayerVector lyr = (LayerVector)this.layer;
        lyr.fi_description = lyr.getFieldIndex(lyr.f_description);
        lyr.fi_id = lyr.getFieldIndex(lyr.f_id);
        if (lyr.fi_id >= 0) {
            lyr.f_id_istext = SQLConst.isText(lyr.getFieldDef((int)lyr.fi_id).type);
        }
        this.layer.prepareLayer();
    }

    private void resolveFields() {
        int i;
        String fieldsEditable;
        int fieldCount = this.dbf == null ? 0 : this.dbf.getNumFields();
        String fieldsVisible = this.layer.metadata.getVal(307, MapUtils.language);
        if (!Strings.isNullOrBlank(fieldsVisible)) {
            fieldsVisible = ',' + fieldsVisible + ',';
        }
        if (!Strings.isNullOrBlank(fieldsEditable = this.layer.metadata.getVal(312, MapUtils.language))) {
            fieldsEditable = ',' + fieldsEditable.toUpperCase() + ',';
        }
        Vector<FieldDef> fields = new Vector<FieldDef>();
        for (i = 0; i < fieldCount; ++i) {
            int type;
            char ctype = this.dbf.getFieldType(i);
            switch (ctype) {
                case 'C': 
                case 'D': 
                case 'L': {
                    type = 1;
                    break;
                }
                case 'I': {
                    type = 4;
                    break;
                }
                case 'F': 
                case 'N': {
                    type = 8;
                    break;
                }
                default: {
                    type = 0;
                }
            }
            if (!SQLConst.isAllowedType(type)) continue;
            FieldDef fieldDef = new FieldDef();
            fieldDef.type = type;
            fieldDef.index = fields.size();
            fieldDef.name = this.dbf.getFieldName(i).toString();
            fieldDef.label = this.layer.metadata.getFieldAlias(fieldDef.name, MapUtils.language);
            fieldDef.visible = Strings.isNullOrBlank(fieldsVisible) || fieldsVisible.indexOf(',' + fieldDef.name.toUpperCase() + ',') >= 0;
            fieldDef.editable = !Strings.isNullOrBlank(fieldsEditable) && fieldsEditable.indexOf(',' + fieldDef.name.toUpperCase() + ',') >= 0;
            fieldDef.fieldlen = this.dbf.fielddef[i].fieldlen;
            fieldDef.fieldnumdec = this.dbf.fielddef[i].fieldnumdec;
            fields.addElement(fieldDef);
        }
        fieldCount = fields.size();
        this.layer.dataStorage.initFields(fieldCount);
        for (i = 0; i < fieldCount; ++i) {
            this.layer.setFieldDef(i, (FieldDef)fields.elementAt(i));
        }
        LayerVector lyr = (LayerVector)this.layer;
        lyr.fi_description = lyr.getFieldIndex(lyr.f_description);
        lyr.fi_id = lyr.getFieldIndex(lyr.f_id);
        if (lyr.fi_id >= 0) {
            lyr.f_id_istext = SQLConst.isText(lyr.getFieldDef((int)lyr.fi_id).type);
        }
        this.layer.prepareLayer();
    }
}

