/*
 * Decompiled with CFR 0.152.
 */
package org.alov.addon;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import org.alov.map.Carte;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.CarteListener;
import org.alov.map.FloatPoint;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.LoaderTM3;
import org.alov.map.MapUtils;
import org.alov.map.Projection;
import org.alov.map.Shape;
import org.alov.map.StatusListener;
import org.alov.map.Symbol;
import org.alov.util.Log;
import org.alov.util.Strings;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;
import org.alov.viewer.FrameAlign;
import org.alov.viewer.ImageButton;

public class SpatialSearch
extends FrameAlign
implements ActionListener,
CarteListener,
CarteHostListener,
StatusListener {
    private static byte TOOL_SEARCH_IN_FIGURE = (byte)52;
    private static final double EPS = 0.001;
    private static final String BTN_CFG = "config_button";
    private static final String BTN_ACTIVATE = "activate_button";
    private static final String SEARCH_BY_LAYER = "searchbylayer";
    private static final String SEARCH_IN = "searchin";
    private static final String SI_POINT = "point";
    private static final String SI_CIRCLE = "circle";
    private static final String SI_POLYGON = "polygon";
    private static final String SI_RECT = "rect";
    private static final String SEARCH_INSIDE = "inside";
    private static final String SEARCH = "search";
    private static final String SRH_ALL = "all";
    private static final String SRH_ACTIVE = "active";
    private static final String SEARCH_IN_LAYER = "searchinlayer";
    private static final String BTN_CLOSE = "btn_close";
    private static final String CBX_POINT = "cbx_point";
    private static final String CBX_CIRCLE = "cbx_circle";
    private static final String CBX_RECT = "cbx_rect";
    private static final String CBX_POLYGON = "cbx_polygon";
    private static final String CBX_LINE = "cbx_line";
    private static final String CBX_PLG_LAYER = "cbx_plglayer";
    private static final String CHC_PLG_LAYER = "chc_plglayer";
    private static final String CBX_INSIDE = "cbx_inside";
    private static final String CBX_INTERSECT = "cbx_intersect";
    private static final String CBX_ACTIVELAYER = "cbx_activelayer";
    private static final String CBX_SELECTEDLAYER = "cbx_selectedlayer";
    private static final String CHC_SELECTEDLAYER = "chc_selectedlayer";
    private static final String CBX_ALLLAYERS = "cbx_alllayers";
    private static final int ST_CIRCLE_ID = 0;
    private static final int ST_POLYGON_ID = 1;
    private static final int ST_LINE_ID = 2;
    private static final int ST_LAYER_ID = 3;
    private static final int ST_POINT_ID = 4;
    private static final int ST_RECT_ID = 5;
    private static final int LA_ACTIVE_LAYER = 0;
    private static final int LA_SELECTED_LAYER = 1;
    private static final int LA_ALL_LAYER = 2;
    private static final int LA_PREDEFINED_LAYER = 3;
    private Carte carte = null;
    private CarteHost carteHost = null;
    private CheckboxGroup cbgSelType = null;
    private CheckboxGroup cbgLocType = null;
    private CheckboxGroup cbgLayers = null;
    private String configButtonName = null;
    private String activateButtonName = null;
    private ImageButton btnActivate = null;
    private Choice chcPlgLayers = null;
    private Choice chcLayers = null;
    private WindowEventHandler wind_handler = null;
    private boolean boundsAreSet = false;
    private byte currentTool = 0;
    private boolean drawInProgress = false;
    private boolean remainSelection = true;
    private boolean performSearch = false;
    private boolean errorLoad = false;
    private int selType = 0;
    private Vector coords = new Vector();
    FloatPoint fpFirst = null;
    FloatPoint fpLast = new FloatPoint(0.0, 0.0);
    private final int DELTA_PNT = 2;
    private int lookAt = 0;
    private String searchInLayerID = null;
    private String searchByLayerID = null;
    private boolean searchInside = true;
    private boolean mouseDown = false;
    private Symbol symbol = new Symbol(Color.blue, Color.red, true, true, 10);

    public void show() {
        if (this.errorLoad || this.drawInProgress) {
            return;
        }
        if (this.chcLayers != null) {
            int iLayersCount = this.carte.getProject().getLayerCount();
            this.chcLayers.removeAll();
            if (null != this.chcPlgLayers) {
                this.chcPlgLayers.removeAll();
            }
            for (int i = 0; i < iLayersCount; ++i) {
                Layer layer = this.carte.getProject().getLayerByIndex(i);
                if (null == layer || !layer.isVisibleNow(this.carte) || !layer.canSearch) continue;
                this.chcLayers.addItem(layer.getName() + " [" + layer.id + "]");
                if (!layer.isObjectType(3) || null == this.chcPlgLayers) continue;
                this.chcPlgLayers.addItem(layer.getName() + " [" + layer.id + "]");
            }
        }
        if (!this.boundsAreSet) {
            int height;
            int width;
            this.boundsAreSet = true;
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            if (this.bounds != null) {
                width = this.bounds.width;
                height = this.bounds.height;
            } else {
                width = 570;
                height = 120;
            }
            this.setBounds((screenSize.width - width) / 2, 50, width, height);
            this.setResizable(false);
        }
        super.show();
        this.requestFocus();
    }

    public void hide() {
        String cbxName;
        Checkbox cb;
        this.clearSelection();
        super.hide();
        if (null != this.cbgSelType) {
            cb = this.cbgSelType.getSelectedCheckbox();
            if (cb != null && (cbxName = cb.getName()) != null) {
                if (cbxName.equalsIgnoreCase(CBX_POINT)) {
                    this.selType = 4;
                }
                if (cbxName.equalsIgnoreCase(CBX_CIRCLE)) {
                    this.selType = 0;
                }
                if (cbxName.equalsIgnoreCase(CBX_POLYGON)) {
                    this.selType = 1;
                }
                if (cbxName.equalsIgnoreCase(CBX_LINE)) {
                    this.selType = 2;
                }
                if (cbxName.equalsIgnoreCase(CBX_PLG_LAYER)) {
                    this.selType = 3;
                }
                if (cbxName.equalsIgnoreCase(CBX_RECT)) {
                    this.selType = 5;
                }
            }
        } else {
            this.selType = 0;
        }
        if (3 == this.selType) {
            this.searchByLayerID = this.chcPlgLayers.getSelectedItem();
            if (this.searchByLayerID != null) {
                this.searchByLayerID = this.searchByLayerID.substring(this.searchByLayerID.indexOf(91) + 1, this.searchByLayerID.indexOf(93));
            }
        }
        if (null != this.cbgLayers && (cb = this.cbgLayers.getSelectedCheckbox()) != null && (cbxName = cb.getName()) != null) {
            if (cbxName.equalsIgnoreCase(CBX_ACTIVELAYER)) {
                this.lookAt = 0;
            } else if (cbxName.equalsIgnoreCase(CBX_SELECTEDLAYER)) {
                this.lookAt = 1;
            } else if (cbxName.equalsIgnoreCase(CBX_ALLLAYERS)) {
                this.lookAt = 2;
            }
        }
        if (null != this.cbgLocType && (cb = this.cbgLocType.getSelectedCheckbox()) != null && (cbxName = cb.getName()) != null) {
            this.searchInside = cbxName.equalsIgnoreCase(CBX_INSIDE);
        }
        this.mouseDown = false;
    }

    private void clearSelection() {
        this.fpFirst = null;
        this.fpLast.setLocation(0.0, 0.0);
        this.coords.removeAllElements();
        this.drawInProgress = false;
        if (null != this.carte) {
            this.carte.updateMap();
        }
    }

    public void setSelectionType(int newSelType) {
        if (!this.drawInProgress) {
            this.selType = newSelType;
            this.setSelectedCheckBox_();
            this.clearSelection();
        }
    }

    public int getSelectionType() {
        return this.selType;
    }

    public void setEnabled(boolean enabledState) {
        if (null != this.carte) {
            if (enabledState) {
                this.carte.setTool(TOOL_SEARCH_IN_FIGURE);
            } else {
                this.carte.setTool((byte)0);
            }
            this.clearSelection();
        }
    }

    public double getCircleRadius() {
        if (this.drawInProgress || this.fpFirst == null) {
            return 0.0;
        }
        return Math.sqrt(MapUtils.sqr(this.fpLast.x - this.fpFirst.x) + MapUtils.sqr(this.fpLast.y - this.fpFirst.y));
    }

    public FloatPoint getCircleCenter() {
        return this.drawInProgress ? null : this.fpFirst;
    }

    public int getVertexCount() {
        return this.drawInProgress ? 0 : this.coords.size();
    }

    public FloatPoint getVertex(int i) {
        return this.drawInProgress || i >= this.coords.size() ? null : (FloatPoint)this.coords.elementAt(i);
    }

    public FloatPoint getDigitisePoint() {
        return this.drawInProgress ? null : this.fpFirst;
    }

    public FloatRectangle getDigitiseRect() {
        return this.drawInProgress || null == this.fpFirst || null == this.fpLast ? null : new FloatRectangle(this.fpFirst.x, this.fpFirst.y, this.fpLast.x, this.fpLast.y);
    }

    private void updateSelection() {
        if (!this.drawInProgress) {
            boolean searchResult;
            boolean wrongPolygon = this.selType == 1 && this.coords.size() < 3;
            boolean bl = searchResult = this.performSearch && !wrongPolygon && this.search();
            if (!this.remainSelection || wrongPolygon) {
                this.clearSelection();
            } else {
                this.carte.updateMap();
            }
            if (searchResult) {
                this.carte.requestSelection(null);
            }
        }
    }

    private void drawPoint(Graphics g) {
        if (!this.drawInProgress && this.fpFirst != null) {
            Projection prj = this.carte.getProjection();
            Shape.drawPoint(g, this.symbol, (int)((this.fpFirst.x + prj.shift.x) * prj.zoom), (int)((-this.fpFirst.y + prj.shift.y) * prj.zoom));
        }
    }

    private void drawSelCircle(Graphics g) {
        int radius;
        if (null != g && null != this.carte && null != this.fpLast && null != this.fpFirst && (radius = new Long(Math.round(this.carte.getProjection().zoom * Math.sqrt(MapUtils.sqr(this.fpLast.x - this.fpFirst.x) + MapUtils.sqr(this.fpLast.y - this.fpFirst.y)))).intValue()) > 0) {
            Point center = this.carte.mapToScreen(this.fpFirst);
            g.drawLine(center.x - 2, center.y - 2, center.x + 2, center.y + 2);
            g.drawLine(center.x - 2, center.y + 2, center.x + 2, center.y - 2);
            g.drawOval(center.x - radius, center.y - radius, 2 * radius, 2 * radius);
            if (!this.drawInProgress) {
                g.drawOval(center.x - --radius, center.y - radius, 2 * radius, 2 * radius);
            }
        }
    }

    private void drawSelPolygon(Graphics g) {
        int count = this.coords.size();
        if (0 < count) {
            Point pntFirst = this.carte.mapToScreen((FloatPoint)this.coords.lastElement());
            Point pntLast = null;
            if (2 == count) {
                count = 1;
            }
            for (int i = 0; i < count; ++i) {
                pntLast = this.carte.mapToScreen((FloatPoint)this.coords.elementAt(i));
                if (this.drawInProgress) {
                    g.drawLine(pntFirst.x, pntFirst.y, pntLast.x, pntLast.y);
                } else {
                    Shape.drawBoldLine(g, pntFirst.x, pntFirst.y, pntLast.x, pntLast.y);
                }
                pntFirst = pntLast;
            }
        }
    }

    private void drawRect(Graphics g) {
        if (null != g && null != this.carte && null != this.fpLast && null != this.fpFirst) {
            int tmp;
            Point pntFirst = this.carte.mapToScreen(this.fpFirst);
            Point pntLast = this.carte.mapToScreen(this.fpLast);
            if (pntLast.x < pntFirst.x) {
                tmp = pntFirst.x;
                pntFirst.x = pntLast.x;
                pntLast.x = tmp;
            }
            if (pntLast.y < pntFirst.y) {
                tmp = pntFirst.y;
                pntFirst.y = pntLast.y;
                pntLast.y = tmp;
            }
            g.drawRect(pntFirst.x, pntFirst.y, pntLast.x - pntFirst.x, pntLast.y - pntFirst.y);
            if (!this.drawInProgress) {
                g.drawRect(pntFirst.x + 1, pntFirst.y + 1, pntLast.x - pntFirst.x - 2, pntLast.y - pntFirst.y - 2);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean searchInLayer(Layer layer) {
        block9: {
            if (null == layer) break block9;
            foundObjects = null;
            switch (this.selType) {
                case 4: {
                    break;
                }
                case 0: {
                    if (this.fpFirst == null) break;
                    radius = Math.sqrt(MapUtils.sqr(this.fpLast.x - this.fpFirst.x) + MapUtils.sqr(this.fpLast.y - this.fpFirst.y));
                    System.out.println("FIND WITHIN CIRCLE");
                    foundObjects = layer.findWithinCircle(this.fpFirst, radius, this.searchInside, false);
                    if (!MapUtils.isNotEmptyRecs(foundObjects)) break;
                    System.out.println(foundObjects.size());
                    break;
                }
                case 2: {
                    break;
                }
                case 1: 
                case 3: {
                    shp = null;
                    if (1 != this.selType) ** GOTO lbl28
                    shp = new Shape();
                    vertCounts = this.coords.size();
                    shp.xCoords = new double[vertCounts];
                    shp.yCoords = new double[vertCounts];
                    for (i = 0; i < vertCounts; ++i) {
                        fp = (FloatPoint)this.coords.elementAt(i);
                        shp.setVertex(i, fp.x, fp.y);
                    }
                    ** GOTO lbl41
lbl28:
                    // 1 sources

                    plgLayer = this.carte.getProject().getLayerById(this.searchByLayerID);
                    if (null == plgLayer) {
                        return false;
                    }
                    records = plgLayer.findWithinCircle(this.fpFirst, 0.0, false, true);
                    if (!MapUtils.isNotEmptyRecs(records)) ** GOTO lbl40
                    rec = records.getRecord(0);
                    shapeCount = rec.getShapeCount();
                    for (i = 0; i < shapeCount; ++i) {
                        if (!Shape.containsPoint(rec.getShape(i), this.fpFirst.x, this.fpFirst.y)) continue;
                        shp = rec.getShape(i);
                        ** GOTO lbl41
                    }
                    ** GOTO lbl41
lbl40:
                    // 1 sources

                    return false;
lbl41:
                    // 3 sources

                    foundObjects = layer.findWithinShape(shp, this.searchInside, false);
                }
            }
            layer.setSelection(foundObjects);
            return null != foundObjects;
        }
        return false;
    }

    private boolean search() {
        boolean result = false;
        Layer layer = null;
        switch (this.lookAt) {
            case 0: {
                layer = this.carte.getActiveLayer();
                result = this.searchInLayer(layer);
                break;
            }
            case 1: {
                String layerID = this.chcLayers.getSelectedItem();
                layerID = layerID.substring(layerID.indexOf(91) + 1, layerID.indexOf(93));
                layer = this.carte.getProject().getLayerById(layerID);
                result = this.searchInLayer(layer);
                break;
            }
            case 2: {
                int layersCount = this.carte.getProject().getLayerCount();
                for (int i = 0; i < layersCount; ++i) {
                    layer = this.carte.getProject().getLayerByIndex(i);
                    if (null == layer || !layer.isVisibleNow(this.carte) || !layer.canSearch) continue;
                    result |= this.searchInLayer(layer);
                }
                break;
            }
            case 3: {
                layer = this.carte.getProject().getLayerById(this.searchInLayerID);
                result = this.searchInLayer(layer);
            }
        }
        return result;
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        String sName = ((Component)o).getName();
        if (sName.equalsIgnoreCase(this.configButtonName)) {
            this.show();
        } else if (sName.equalsIgnoreCase(this.activateButtonName)) {
            this.setEnabled(true);
        } else if (sName.equalsIgnoreCase(BTN_CLOSE) && null != this.wind_handler) {
            this.wind_handler.closeWindow();
        }
    }

    public void mouseMapPressed(MouseEvent e) {
        if (TOOL_SEARCH_IN_FIGURE == this.carte.getTool() && (e.getModifiers() & 0x10) != 0) {
            this.mouseDown = true;
            Point mousePos = e.getPoint();
            FloatPoint mapPos = this.carte.screenToMap(mousePos);
            Graphics g = this.carte.getGraphics();
            if (null == g) {
                return;
            }
            g.setColor(Color.black);
            g.setXORMode(Color.white);
            if (this.drawInProgress) {
                switch (this.selType) {
                    case 4: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 1: {
                        boolean bl = this.drawInProgress = e.getClickCount() <= 1;
                        if (this.drawInProgress) {
                            this.drawSelPolygon(g);
                            this.coords.setElementAt(mapPos, this.coords.size() - 1);
                            this.coords.addElement(mapPos);
                            this.drawSelPolygon(g);
                            break;
                        }
                        this.coords.removeElement(this.coords.lastElement());
                    }
                }
            } else {
                if (this.remainSelection) {
                    this.clearSelection();
                }
                switch (this.selType) {
                    case 4: {
                        this.fpFirst = new FloatPoint(0.0, 0.0);
                        Point pt1 = e.getPoint();
                        Point pt2 = this.carte.mapToScreen(this.fpFirst);
                        if (Math.abs(pt1.x - pt2.x) < 2 && Math.abs(pt1.y - pt2.y) < 2) {
                            this.carte.updateMap();
                            this.drawInProgress = true;
                            return;
                        }
                        this.fpFirst = this.carte.screenToMap(pt1);
                        this.drawPoint(g);
                        break;
                    }
                    case 0: {
                        this.drawSelCircle(g);
                        this.fpFirst = mapPos;
                        this.fpLast.setLocation(this.fpFirst.x, this.fpFirst.y);
                        this.drawInProgress = true;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 1: {
                        this.drawInProgress = true;
                        this.coords.addElement(mapPos);
                        this.coords.addElement(mapPos);
                        this.drawSelPolygon(g);
                        break;
                    }
                    case 3: {
                        this.fpFirst = mapPos;
                        break;
                    }
                    case 5: {
                        this.drawRect(g);
                        this.fpFirst = mapPos;
                        this.fpLast.setLocation(this.fpFirst.x, this.fpFirst.y);
                        this.drawInProgress = true;
                    }
                }
            }
            g.setXORMode(Color.black);
            this.updateSelection();
        }
    }

    public void mouseMapReleased(FloatRectangle selRect, MouseEvent e) {
        Graphics g = this.carte.getGraphics();
        if (null == g) {
            return;
        }
        switch (this.selType) {
            case 4: {
                this.drawInProgress = false;
                break;
            }
            case 0: {
                if (!this.mouseDown) break;
                this.drawInProgress = false;
                g.setColor(Color.black);
                g.setXORMode(Color.white);
                this.drawSelCircle(g);
                this.fpLast = this.carte.screenToMap(e.getPoint());
                this.drawSelCircle(g);
                this.updateSelection();
                break;
            }
            case 5: {
                if (!this.mouseDown) break;
                g.setColor(Color.black);
                g.setXORMode(Color.white);
                this.drawRect(g);
                this.fpLast = this.carte.screenToMap(e.getPoint());
                this.drawInProgress = false;
                this.drawRect(g);
            }
        }
        this.mouseDown = false;
    }

    public void mouseMapMoved(MouseEvent e) {
        if (TOOL_SEARCH_IN_FIGURE == this.carte.getTool() && this.drawInProgress) {
            Graphics g = this.carte.getGraphics();
            if (null == g) {
                return;
            }
            g.setColor(Color.black);
            g.setXORMode(Color.white);
            switch (this.selType) {
                case 4: {
                    break;
                }
                case 0: {
                    if (!this.mouseDown) break;
                    FloatPoint fpNew = this.carte.screenToMap(e.getPoint());
                    if (0.001 < Math.abs(fpNew.x - this.fpLast.x) || 0.001 < Math.abs(fpNew.y - this.fpLast.y)) {
                        this.drawSelCircle(g);
                        this.fpLast = fpNew;
                        this.drawSelCircle(g);
                        break;
                    }
                    this.fpLast = fpNew;
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    if (this.coords.isEmpty() || this.mouseDown) break;
                    this.drawSelPolygon(g);
                    this.coords.setElementAt(this.carte.screenToMap(e.getPoint()), this.coords.size() - 1);
                    this.drawSelPolygon(g);
                    break;
                }
                case 5: {
                    if (!this.mouseDown) break;
                    FloatPoint fpNew = this.carte.screenToMap(e.getPoint());
                    if (0.001 < Math.abs(fpNew.x - this.fpLast.x) || 0.001 < Math.abs(fpNew.y - this.fpLast.y)) {
                        this.drawRect(g);
                        this.fpLast = fpNew;
                        this.drawRect(g);
                        break;
                    }
                    this.fpLast = fpNew;
                }
            }
            g.setXORMode(Color.black);
        }
    }

    public void afterMapDraw(Graphics g) {
        if (TOOL_SEARCH_IN_FIGURE == this.carte.getTool() && this.drawInProgress || this.remainSelection) {
            g.setColor(Color.black);
            if (this.drawInProgress) {
                g.setXORMode(Color.white);
            }
            switch (this.selType) {
                case 4: {
                    this.drawPoint(g);
                    break;
                }
                case 0: {
                    this.drawSelCircle(g);
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    this.drawSelPolygon(g);
                    break;
                }
                case 5: {
                    this.drawRect(g);
                }
            }
            if (this.drawInProgress) {
                g.setXORMode(Color.black);
            }
        }
    }

    public void setParameters(CarteHost host, XmlElement layout) {
        this.carteHost = host;
        if (null != this.carteHost && null != layout) {
            this.carte = host.getMapByName(layout);
            if (this.carte == null) {
                return;
            }
            this.carte.statusListeners.addElement(this);
        }
        this.configButtonName = XmlUtils.getString(BTN_CFG, layout, "btn_search_configure");
        this.activateButtonName = XmlUtils.getString(BTN_ACTIVATE, layout, "btn_search_select");
        this.remainSelection = XmlUtils.getBoolean("remainselection", layout, true);
        this.performSearch = XmlUtils.getBoolean("allowsearch", layout, true);
        String value = XmlUtils.getString(SEARCH_IN, layout, null);
        if (!Strings.isNullOrBlank(value)) {
            if (value.equalsIgnoreCase(SI_CIRCLE)) {
                this.selType = 0;
            } else if (value.equalsIgnoreCase(SI_POLYGON)) {
                this.selType = 1;
            } else if (value.equalsIgnoreCase(SI_POINT)) {
                this.selType = 4;
            }
        }
        this.searchByLayerID = XmlUtils.getString(SEARCH_BY_LAYER, layout, null);
        if (!Strings.isNullOrBlank(this.searchByLayerID)) {
            this.selType = 3;
        }
        if (!Strings.isNullOrBlank(value = XmlUtils.getString(SEARCH, layout, null))) {
            if (value.equalsIgnoreCase(SRH_ACTIVE)) {
                this.lookAt = 0;
            } else if (value.equalsIgnoreCase(SRH_ALL)) {
                this.lookAt = 2;
            }
        }
        this.searchInLayerID = XmlUtils.getString(SEARCH_IN_LAYER, layout, null);
        if (!Strings.isNullOrBlank(this.searchInLayerID)) {
            this.lookAt = 3;
        }
        this.searchInside = XmlUtils.getBoolean(SEARCH_INSIDE, layout, false);
        this.symbol.style = 3;
        LoaderTM3.loadSymbol(this.symbol, null, layout.getFirstElementByName("Symbol"), false, true);
    }

    public void stop() {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void notifyStatus(int code, Object obj) {
        Component c;
        if (!this.remainSelection && (this.coords.size() > 0 || this.fpFirst != null && this.fpFirst.x != 0.0 || this.fpLast.y != 0.0)) {
            this.clearSelection();
        }
        if (code == 112 && this.carte.getTool() == TOOL_SEARCH_IN_FIGURE && (c = this.carteHost.findComponent(this.activateButtonName)) != null) {
            ((ImageButton)c).setDown(true);
        }
    }

    public void afterProjectLoaded(boolean bSuccess) {
        if (bSuccess) {
            Checkbox cbx;
            if (null != this.configButtonName) {
                MapUtils.addActionListener(this, (Container)((Object)this.carteHost), this.configButtonName);
            }
            if (null != this.activateButtonName) {
                MapUtils.addActionListener(this, (Container)((Object)this.carteHost), this.activateButtonName);
            }
            this.btnActivate = (ImageButton)MapUtils.findComp((Container)((Object)this.carteHost), this.activateButtonName);
            boolean bl = this.errorLoad = null == this.btnActivate;
            if (this.errorLoad) {
                Log.addMessage(311, this.carte.getName(), null, "The button with name activate_button is not found in the layout for SpatialSearch " + this.getName());
                this.carte.broadcastMessage(-1, null);
                return;
            }
            MapUtils.addActionListener(this, this, BTN_CLOSE);
            this.wind_handler = new WindowEventHandler();
            this.addWindowListener(this.wind_handler);
            this.carte.mapListeners.addElement(this);
            this.setTitle(null);
            this.cbgSelType = new CheckboxGroup();
            if (null != this.cbgSelType) {
                cbx = (Checkbox)MapUtils.findComp(this, CBX_POINT);
                if (null != cbx) {
                    cbx.setCheckboxGroup(this.cbgSelType);
                }
                if (null != (cbx = (Checkbox)MapUtils.findComp(this, CBX_CIRCLE))) {
                    cbx.setCheckboxGroup(this.cbgSelType);
                }
                if (null != (cbx = (Checkbox)MapUtils.findComp(this, CBX_POLYGON))) {
                    cbx.setCheckboxGroup(this.cbgSelType);
                }
                if (null != (cbx = (Checkbox)MapUtils.findComp(this, CBX_LINE))) {
                    cbx.setCheckboxGroup(this.cbgSelType);
                }
                if (null != (cbx = (Checkbox)MapUtils.findComp(this, CBX_PLG_LAYER))) {
                    cbx.setCheckboxGroup(this.cbgSelType);
                }
                if (null != (cbx = (Checkbox)MapUtils.findComp(this, CBX_RECT))) {
                    cbx.setCheckboxGroup(this.cbgSelType);
                }
                this.chcPlgLayers = (Choice)MapUtils.findComp(this, CHC_PLG_LAYER);
            }
            this.setSelectedCheckBox_();
            this.cbgLocType = new CheckboxGroup();
            if (null != this.cbgLocType) {
                cbx = (Checkbox)MapUtils.findComp(this, CBX_INSIDE);
                if (null != cbx) {
                    cbx.setCheckboxGroup(this.cbgLocType);
                    this.cbgLocType.setSelectedCheckbox(cbx);
                }
                if (null != (cbx = (Checkbox)MapUtils.findComp(this, CBX_INTERSECT))) {
                    cbx.setCheckboxGroup(this.cbgLocType);
                }
            }
            this.cbgLayers = new CheckboxGroup();
            if (null != this.cbgLayers) {
                cbx = (Checkbox)MapUtils.findComp(this, CBX_ACTIVELAYER);
                if (null != cbx) {
                    cbx.setCheckboxGroup(this.cbgLayers);
                    this.cbgLayers.setSelectedCheckbox(cbx);
                }
                if (null != (cbx = (Checkbox)MapUtils.findComp(this, CBX_SELECTEDLAYER))) {
                    cbx.setCheckboxGroup(this.cbgLayers);
                }
                if (null != (cbx = (Checkbox)MapUtils.findComp(this, CBX_ALLLAYERS))) {
                    cbx.setCheckboxGroup(this.cbgLayers);
                }
            }
            this.chcLayers = (Choice)MapUtils.findComp(this, CHC_SELECTEDLAYER);
        }
    }

    private void setSelectedCheckBox_() {
        if (null != this.cbgSelType) {
            String sName = null;
            switch (this.selType) {
                case 4: {
                    sName = CBX_POINT;
                    break;
                }
                case 0: {
                    sName = CBX_CIRCLE;
                    break;
                }
                case 2: {
                    sName = CBX_LINE;
                    break;
                }
                case 1: {
                    sName = CBX_POLYGON;
                    break;
                }
                case 3: {
                    sName = CBX_PLG_LAYER;
                    break;
                }
                case 5: {
                    sName = CBX_RECT;
                }
            }
            Checkbox cbx = (Checkbox)MapUtils.findComp(this, sName);
            if (null != cbx) {
                this.cbgSelType.setSelectedCheckbox(cbx);
            }
        }
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        public void closeWindow() {
            SpatialSearch.this.hide();
        }

        public void windowClosing(WindowEvent evt) {
            this.closeWindow();
        }
    }
}

