/*
 * Decompiled with CFR 0.152.
 */
package org.alov.addon;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;
import org.alov.map.Carte;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.MapUtils;
import org.alov.map.Project;
import org.alov.map.StatusListener;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

public class ScaleBar
extends Panel
implements CarteHostListener,
StatusListener {
    private Carte map = null;
    private final String _TEST_STR = "999999";
    private boolean metric = true;
    private static final int TP_NOTEXT = 0;
    private static final int TP_ONSIDES = 1;
    private static final int TP_TOP = 2;
    private static final int TP_BOTTOM = 3;
    private int textPosition = 3;
    private int border = 2;
    private int barThickness = 8;
    private boolean barFullLength = false;
    private Color color1 = Color.white;
    private Color color2 = Color.black;
    private double barExtent;
    private double roundBarExtent;
    private String unitsString;
    private double pixelsPerTic;
    private double unitsPerTic;
    private int ticCount;

    public void setMap(Carte carte) {
        this.map = carte;
        this.updateBar();
    }

    public void updateBar() {
        this.repaint();
    }

    private double getBarExtent() {
        if (this.map == null || !this.map.isProjectLoaded()) {
            return 0.0;
        }
        Dimension dim = this.map.getSize();
        double mapControlWidth = dim.width;
        if (mapControlWidth < 1.0 || !this.map.isProjectLoaded()) {
            return 0.0;
        }
        Project project = this.map.getProject();
        double mapWidth = MapUtils.getDistance(this.map.getExtent(), project.MapUnits, 1);
        mapWidth = this.metric ? (mapWidth *= 100.0) : mapWidth * 100.0 / (double)2.54f;
        dim = this.getSize();
        return (double)dim.width / mapControlWidth * mapWidth;
    }

    private void calculateProperties() {
        int k;
        this.barExtent = this.getBarExtent();
        int i = String.valueOf(Math.round(this.barExtent)).length();
        this.unitsString = i > 5 ? this.map.getResource("km") : (i > 2 ? this.map.getResource("m") : this.map.getResource("cm"));
        switch (i) {
            case 9: {
                k = 3;
                break;
            }
            case 8: {
                k = 2;
                break;
            }
            case 7: {
                k = 1;
                break;
            }
            case 6: {
                k = 0;
                break;
            }
            case 5: {
                k = 2;
                break;
            }
            case 4: {
                k = 1;
                break;
            }
            case 3: {
                k = 0;
                break;
            }
            case 2: {
                k = 1;
                break;
            }
            default: {
                k = i > 9 ? 4 : 0;
            }
        }
        double d = this.barExtent / Math.pow(10.0, i - 1);
        this.roundBarExtent = Math.floor(d) * Math.pow(10.0, i - 1);
        i = (int)Math.floor(Math.floor(d) * Math.pow(10.0, k));
        k = i == 1 || i == 10 || i == 100 || i == 1000 || i == 10000 ? 10 : (i > 10000 ? (int)Math.floor((double)i / 10000.0) : (i > 1000 ? (int)Math.floor((double)i / 1000.0) : (i > 100 ? (int)Math.floor((double)i / 100.0) : (i > 10 ? (int)Math.floor((double)i / 10.0) : i))));
        Dimension dim = this.getSize();
        this.pixelsPerTic = Math.floor((double)dim.width * this.roundBarExtent / this.barExtent / (double)k);
        this.unitsPerTic = (double)i / (double)k;
        this.ticCount = k;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.map == null || !this.map.isProjectLoaded()) {
            return;
        }
        Dimension mapDim = this.map.getSize();
        if (mapDim.width < 50) {
            return;
        }
        FontMetrics fm = g.getFontMetrics();
        int maxFontWidth = fm.stringWidth("999999");
        Dimension myDim = this.getSize();
        int width = myDim.width;
        int height = myDim.height;
        int barWidth = this.textPosition == 1 ? width - 2 * maxFontWidth : width;
        this.calculateProperties();
        if (this.ticCount < 1) {
            return;
        }
        int ymin = 0;
        int ymax = 0;
        int yfont = 0;
        switch (this.textPosition) {
            case 0: 
            case 1: {
                ymin = (height - 2 * this.border) / 2 - this.barThickness / 2;
                ymax = ymin + this.barThickness;
                yfont = (height - 2 * this.border) / 2 - fm.getHeight() / 2;
                break;
            }
            case 2: {
                ymin = this.border + fm.getHeight();
                ymax = ymin + this.barThickness;
                yfont = this.border;
                break;
            }
            case 3: {
                ymin = this.border;
                ymax = ymin + this.barThickness;
                yfont = ymax + 1;
            }
        }
        int offset = this.barFullLength ? this.border : this.border + (int)Math.round(((double)width - (double)this.ticCount * this.pixelsPerTic) / 2.0);
        for (int i = 0; this.barFullLength || i < this.ticCount; ++i) {
            if (i & true) {
                g.setColor(this.color1);
            } else {
                g.setColor(this.color2);
            }
            int xmin = offset + (int)((double)i * this.pixelsPerTic);
            int xmax = offset + (int)((double)(i + 1) * this.pixelsPerTic);
            if (xmax > width - offset) {
                xmax = width - offset;
            }
            if (this.barThickness == 1) {
                g.drawLine(xmin, ymin, xmax, ymax);
                continue;
            }
            g.fillRect(xmin, ymin, xmax - xmin, ymax - ymin);
            g.setColor(this.color2);
            g.drawRect(xmin, ymin, xmax - xmin, ymax - ymin);
            if (xmax < width - offset) continue;
            break;
        }
        if (this.textPosition != 0) {
            yfont += fm.getHeight();
            String s = String.valueOf((int)Math.floor(this.unitsPerTic * (double)this.ticCount)) + " " + this.unitsString;
            g.setColor(this.getForeground());
            if (this.textPosition == 1) {
                g.drawString("0", offset - fm.charWidth('0'), yfont);
                g.drawString(s, width - offset + 1, yfont);
            } else {
                g.drawString("0", offset + 1, yfont);
                g.drawString(s, (int)((double)offset + this.pixelsPerTic * (double)this.ticCount - (double)fm.stringWidth(s) - 1.0), yfont);
            }
        }
    }

    public void setParameters(CarteHost host, XmlElement layout) {
        this.textPosition = XmlUtils.getInt("style", layout, 3);
        this.barThickness = XmlUtils.getInt("size", layout, this.barThickness);
        this.color1 = XmlUtils.getColor("color1", layout, this.color1);
        this.color2 = XmlUtils.getColor("color2", layout, this.color2);
        this.map = host.getMapByName(layout);
        this.map.statusListeners.addElement(this);
    }

    public void stop() {
    }

    public void afterProjectLoaded(boolean bSuccess) {
    }

    public void notifyStatus(int code, Object obj) {
        if (code == 109) {
            this.updateBar();
        }
    }
}

